/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.s3.service.local;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.tnb.aws.s3.service.Minio;
import software.tnb.aws.s3.service.local.MinioContainer;
import software.tnb.aws.s3.validation.S3Validation;
import software.tnb.common.deployment.Deployable;

@AutoService(value={Minio.class})
public class LocalMinio
extends Minio
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMinio.class);
    private MinioContainer container;

    public void deploy() {
        LOG.info("Starting Minio container");
        this.container = new MinioContainer(this.image(), 9000, this.containerEnvironment());
        this.container.start();
        LOG.info("Minio container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping Minio container");
            this.container.stop();
        }
    }

    public void openResources() {
        this.validation = new S3Validation(this.client(S3Client.class));
    }

    public void closeResources() {
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        this.undeploy();
    }

    @Override
    public String hostname() {
        return String.format("http://%s:%d", this.container.getHost(), this.container.getMappedPort(9000));
    }

    @Override
    protected String clientHostname() {
        return this.hostname();
    }

    public Map<String, String> containerEnvironment() {
        return Map.of("MINIO_ROOT_USER", this.account().accountId(), "MINIO_ROOT_PASSWORD", this.account().secretKey());
    }
}

