/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.s3.service.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.Closeable;
import java.util.LinkedList;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.s3.S3Client;
import software.tnb.aws.s3.service.Minio;
import software.tnb.aws.s3.validation.S3Validation;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.IOUtils;

@AutoService(value={Minio.class})
public class OpenshiftMinio
extends Minio
implements OpenshiftDeployable,
WithName,
WithInClusterHostname,
WithExternalHostname {
    private PortForward portForward;

    public void create() {
        LinkedList<ContainerPort> ports = new LinkedList<ContainerPort>();
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("api")).withContainerPort(Integer.valueOf(9000))).withProtocol("TCP")).build());
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("ui")).withContainerPort(Integer.valueOf(9001))).withProtocol("TCP")).build());
        OpenshiftClient.get().apps().deployments().createOrReplace((Object[])new Deployment[]{((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().editOrNewSelector().addToMatchLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endSelector()).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewVolume().withName("data")).withNewEmptyDir().endEmptyDir()).endVolume()).addNewContainer().withName(this.name())).withImage(this.image())).withPorts(ports)).withEnv(new EnvVar[]{new EnvVar("MINIO_ROOT_USER", this.account().accountId(), null), new EnvVar("MINIO_ROOT_PASSWORD", this.account().secretKey(), null)})).withArgs(new String[]{"server", "/data", "--console-address", ":9001"})).endContainer()).endSpec()).endTemplate()).endSpec()).build()});
        ServiceSpecBuilder serviceSpecBuilder = (ServiceSpecBuilder)new ServiceSpecBuilder().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
        serviceSpecBuilder.addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(this.name())).withPort(Integer.valueOf(9000))).withTargetPort(new IntOrString(Integer.valueOf(9000)))).build()});
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpecLike(serviceSpecBuilder.build()).endSpec()).build()});
    }

    public void undeploy() {
        ((Resource)OpenshiftClient.get().routes().withName(this.name())).delete();
        ((ServiceResource)OpenshiftClient.get().services().withName(this.name())).delete();
        ((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).delete();
        ((Resource)OpenshiftClient.get().persistentVolumeClaims().withName(this.name())).delete();
    }

    public void openResources() {
        this.portForward = (PortForward)((ServiceResource)OpenshiftClient.get().services().withName(this.name())).portForward(9000, 9000);
        this.validation = new S3Validation(this.client(S3Client.class));
    }

    public void closeResources() {
        IOUtils.closeQuietly((Closeable)this.portForward);
    }

    public boolean isReady() {
        return (Boolean)ResourceFunctions.areExactlyNPodsReady((int)1).apply(OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())) != false && OpenshiftClient.get().getLogs(OpenshiftClient.get().getAnyPod(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).contains("1 Online, 0 Offline.");
    }

    public boolean isDeployed() {
        Deployment deployment = (Deployment)((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).get();
        return deployment != null && !deployment.isMarkedForDeletion();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        this.closeResources();
        this.undeploy();
    }

    public String name() {
        return "minio";
    }

    public String externalHostname() {
        return "localhost";
    }

    @Override
    public String hostname() {
        return String.format("http://%s:%d", this.inClusterHostname(), 9000);
    }

    @Override
    protected String clientHostname() {
        return String.format("http://%s:%d", this.externalHostname(), 9000);
    }
}

