/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.s3.validation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.tnb.common.service.Validation;

public class S3Validation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(S3Validation.class);
    private final S3Client client;

    public S3Validation(S3Client client) {
        this.client = client;
    }

    public void createS3Bucket(String name) {
        LOG.debug("Creating S3 bucket {}", (Object)name);
        this.client.createBucket(b -> b.bucket(name));
        this.waitForBucket(name);
    }

    public void waitForBucket(String name) {
        LOG.debug("Waiting for S3 bucket to be ready {}", (Object)name);
        this.client.waiter().waitUntilBucketExists(builder -> builder.bucket(name));
    }

    public void deleteS3Bucket(String name) {
        if (this.bucketExists(name)) {
            this.deleteS3BucketContent(name);
            LOG.debug("Deleting S3 bucket {}", (Object)name);
            this.client.deleteBucket(b -> b.bucket(name));
        }
    }

    public void deleteS3BucketContent(String name) {
        LOG.debug("Deleting all content of S3 bucket {}", (Object)name);
        this.client.listObjectsV2(b -> b.bucket(name)).contents().forEach(c -> this.client.deleteObject(b -> b.bucket(name).key(c.key())));
    }

    public List<String> listKeysInBucket(String bucketName) {
        return this.client.listObjects(b -> b.bucket(bucketName)).contents().stream().map(S3Object::key).collect(Collectors.toList());
    }

    public boolean bucketExists(String bucketName) {
        return this.client.listBuckets().buckets().stream().anyMatch(b -> bucketName.equals(b.name()));
    }

    public String readFileFromBucket(String bucketName, String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.client.getObject(b -> b.bucket(bucketName).key(key)).transferTo((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to transfer object contents", e);
        }
        return outputStream.toString();
    }

    public void createFile(String bucketName, String key, String content) {
        this.createFromBody(bucketName, key, RequestBody.fromString((String)content));
    }

    public void createFile(String bucketName, Path file) {
        this.createFile(bucketName, file.getFileName().toString(), file);
    }

    public void createFile(String bucketName, String key, Path file) {
        this.createFromBody(bucketName, key, RequestBody.fromFile((Path)file));
    }

    public void createFolder(String bucketName, String key) {
        this.createFromBody(bucketName, (String)(key.endsWith("/") ? key : key + "/"), RequestBody.empty());
    }

    private void createFromBody(String bucketName, String key, RequestBody body) {
        PutObjectRequest objectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(key).build();
        this.client.putObject(objectRequest, body);
    }
}

