/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.sns.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.sns.SnsClient;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.sns.account.SNSAccount;
import software.tnb.aws.sns.validation.SNSValidation;
import software.tnb.aws.sqs.service.SQS;
import software.tnb.aws.sqs.validation.SQSValidation;
import software.tnb.common.account.Accounts;
import software.tnb.common.service.ServiceFactory;

@AutoService(value={SNS.class})
public class SNS
extends AWSService<SNSAccount, SnsClient, SNSValidation> {
    private final SQS sqs = (SQS)ServiceFactory.create(SQS.class);

    public SNSAccount account() {
        if (this.account == null) {
            LOG.debug("Creating new SNS account");
            this.account = (AWSAccount)Accounts.get(SNSAccount.class);
            ((SNSAccount)this.account).setTopicUrlPrefix(String.format("https://sns.%s.amazonaws.com/%s/", ((SNSAccount)this.account).region(), ((SNSAccount)this.account).accountId()));
            ((SNSAccount)this.account).setTopicArnPrefix(String.format("arn:aws:sns:%s:%s:", ((SNSAccount)this.account).region(), ((SNSAccount)this.account).accountId()));
        }
        return (SNSAccount)this.account;
    }

    public SQSValidation getSQSValidation() {
        return (SQSValidation)this.sqs.validation();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        this.sqs.afterAll(extensionContext);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.sqs.beforeAll(extensionContext);
        LOG.debug("Creating new SNS validation");
        this.validation = new SNSValidation((SnsClient)this.client(SnsClient.class), this.account(), this.sqs);
    }
}

