/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.sns.validation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.tnb.aws.sns.account.SNSAccount;
import software.tnb.aws.sqs.service.SQS;
import software.tnb.aws.sqs.validation.SQSValidation;
import software.tnb.common.service.Validation;
import software.tnb.common.utils.WaitUtils;

public class SNSValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(SNSValidation.class);
    private final SnsClient client;
    private final SNSAccount account;
    private final SQS sqs;

    public SNSValidation(SnsClient client, SNSAccount account, SQS sqs) {
        this.client = client;
        this.account = account;
        this.sqs = sqs;
    }

    public void createTopic(String topic) {
        LOG.debug("Creating SNS topic {}", (Object)topic);
        CreateTopicResponse createTopicResonse = this.client.createTopic(b -> b.name(topic));
        WaitUtils.waitFor(() -> this.topicExists(createTopicResonse.topicArn()), (String)("Waiting until the topic " + topic + " is created"));
    }

    public void createTopicWithConsumer(String topic, String queue) {
        this.createTopic(topic);
        ((SQSValidation)this.sqs.validation()).createQueue(queue);
        ((SQSValidation)this.sqs.validation()).setPermissiveAccessPolicy(queue);
        this.createSQSSubscription(topic, queue);
    }

    public void deleteTopic(String topic) {
        LOG.debug("Deleting SNS topic {}", (Object)topic);
        this.client.deleteTopic(b -> b.topicArn(this.account.topicArnPrefix() + topic));
    }

    public void deleteTopicWithConsumer(String topic, String queue) {
        this.deleteTopic(topic);
        ((SQSValidation)this.sqs.validation()).deleteQueue(queue);
    }

    public void createSQSSubscription(String topic, String queue) {
        this.client.subscribe(builder -> builder.topicArn(this.account.topicArnPrefix() + topic).protocol("sqs").endpoint(this.sqs.account().queueArnPrefix() + queue));
    }

    public boolean topicExists(String topicArn) {
        return this.client.listTopics().topics().stream().anyMatch(topic -> topic.topicArn().equals(topicArn));
    }
}

