/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.api;

import software.tnb.jira.validation.generated.ApiCallback;
import software.tnb.jira.validation.generated.ApiClient;
import software.tnb.jira.validation.generated.ApiException;
import software.tnb.jira.validation.generated.ApiResponse;
import software.tnb.jira.validation.generated.Configuration;
import software.tnb.jira.validation.generated.Pair;
import software.tnb.jira.validation.generated.ProgressRequestBody;
import software.tnb.jira.validation.generated.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import software.tnb.jira.validation.generated.model.BulkCustomFieldOptionCreateRequest;
import software.tnb.jira.validation.generated.model.BulkCustomFieldOptionUpdateRequest;
import software.tnb.jira.validation.generated.model.CustomFieldCreatedContextOptionsList;
import software.tnb.jira.validation.generated.model.CustomFieldOption;
import software.tnb.jira.validation.generated.model.CustomFieldUpdatedContextOptionsList;
import software.tnb.jira.validation.generated.model.OrderOfCustomFieldOptions;
import software.tnb.jira.validation.generated.model.PageBeanCustomFieldContextOption;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.core.GenericType;

public class IssueCustomFieldOptionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IssueCustomFieldOptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IssueCustomFieldOptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createCustomFieldOption
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionCreateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCustomFieldOptionCall(String fieldId, Long contextId, BulkCustomFieldOptionCreateRequest bulkCustomFieldOptionCreateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = bulkCustomFieldOptionCreateRequest;

        // create path and map variables
        String localVarPath = "/rest/api/3/field/{fieldId}/context/{contextId}/option"
            .replace("{" + "fieldId" + "}", localVarApiClient.escapeString(fieldId.toString()))
            .replace("{" + "contextId" + "}", localVarApiClient.escapeString(contextId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCustomFieldOptionValidateBeforeCall(String fieldId, Long contextId, BulkCustomFieldOptionCreateRequest bulkCustomFieldOptionCreateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'fieldId' is set
        if (fieldId == null) {
            throw new ApiException("Missing the required parameter 'fieldId' when calling createCustomFieldOption(Async)");
        }

        // verify the required parameter 'contextId' is set
        if (contextId == null) {
            throw new ApiException("Missing the required parameter 'contextId' when calling createCustomFieldOption(Async)");
        }

        // verify the required parameter 'bulkCustomFieldOptionCreateRequest' is set
        if (bulkCustomFieldOptionCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'bulkCustomFieldOptionCreateRequest' when calling createCustomFieldOption(Async)");
        }

        return createCustomFieldOptionCall(fieldId, contextId, bulkCustomFieldOptionCreateRequest, _callback);

    }

    /**
     * Create custom field options (context)
     * Creates options and, where the custom select field is of the type Select List (cascading), cascading options for a custom select field. The options are added to a context of the field.  The maximum number of options that can be created per request is 1000 and each field can have a maximum of 10000 options.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionCreateRequest  (required)
     * @return CustomFieldCreatedContextOptionsList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public CustomFieldCreatedContextOptionsList createCustomFieldOption(String fieldId, Long contextId, BulkCustomFieldOptionCreateRequest bulkCustomFieldOptionCreateRequest) throws ApiException {
        ApiResponse<CustomFieldCreatedContextOptionsList> localVarResp = createCustomFieldOptionWithHttpInfo(fieldId, contextId, bulkCustomFieldOptionCreateRequest);
        return localVarResp.getData();
    }

    /**
     * Create custom field options (context)
     * Creates options and, where the custom select field is of the type Select List (cascading), cascading options for a custom select field. The options are added to a context of the field.  The maximum number of options that can be created per request is 1000 and each field can have a maximum of 10000 options.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionCreateRequest  (required)
     * @return ApiResponse&lt;CustomFieldCreatedContextOptionsList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomFieldCreatedContextOptionsList> createCustomFieldOptionWithHttpInfo(String fieldId, Long contextId, BulkCustomFieldOptionCreateRequest bulkCustomFieldOptionCreateRequest) throws ApiException {
        okhttp3.Call localVarCall = createCustomFieldOptionValidateBeforeCall(fieldId, contextId, bulkCustomFieldOptionCreateRequest, null);
        Type localVarReturnType = new TypeToken<CustomFieldCreatedContextOptionsList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create custom field options (context) (asynchronously)
     * Creates options and, where the custom select field is of the type Select List (cascading), cascading options for a custom select field. The options are added to a context of the field.  The maximum number of options that can be created per request is 1000 and each field can have a maximum of 10000 options.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionCreateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCustomFieldOptionAsync(String fieldId, Long contextId, BulkCustomFieldOptionCreateRequest bulkCustomFieldOptionCreateRequest, final ApiCallback<CustomFieldCreatedContextOptionsList> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCustomFieldOptionValidateBeforeCall(fieldId, contextId, bulkCustomFieldOptionCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<CustomFieldCreatedContextOptionsList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteCustomFieldOption
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context from which an option should be deleted. (required)
     * @param optionId The ID of the option to delete. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the option is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or the option is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCustomFieldOptionCall(String fieldId, Long contextId, Long optionId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/field/{fieldId}/context/{contextId}/option/{optionId}"
            .replace("{" + "fieldId" + "}", localVarApiClient.escapeString(fieldId.toString()))
            .replace("{" + "contextId" + "}", localVarApiClient.escapeString(contextId.toString()))
            .replace("{" + "optionId" + "}", localVarApiClient.escapeString(optionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCustomFieldOptionValidateBeforeCall(String fieldId, Long contextId, Long optionId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'fieldId' is set
        if (fieldId == null) {
            throw new ApiException("Missing the required parameter 'fieldId' when calling deleteCustomFieldOption(Async)");
        }

        // verify the required parameter 'contextId' is set
        if (contextId == null) {
            throw new ApiException("Missing the required parameter 'contextId' when calling deleteCustomFieldOption(Async)");
        }

        // verify the required parameter 'optionId' is set
        if (optionId == null) {
            throw new ApiException("Missing the required parameter 'optionId' when calling deleteCustomFieldOption(Async)");
        }

        return deleteCustomFieldOptionCall(fieldId, contextId, optionId, _callback);

    }

    /**
     * Delete custom field options (context)
     * Deletes a custom field option.  Options with cascading options cannot be deleted without deleting the cascading options first.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context from which an option should be deleted. (required)
     * @param optionId The ID of the option to delete. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the option is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or the option is not found. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteCustomFieldOption(String fieldId, Long contextId, Long optionId) throws ApiException {
        deleteCustomFieldOptionWithHttpInfo(fieldId, contextId, optionId);
    }

    /**
     * Delete custom field options (context)
     * Deletes a custom field option.  Options with cascading options cannot be deleted without deleting the cascading options first.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context from which an option should be deleted. (required)
     * @param optionId The ID of the option to delete. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the option is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or the option is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteCustomFieldOptionWithHttpInfo(String fieldId, Long contextId, Long optionId) throws ApiException {
        okhttp3.Call localVarCall = deleteCustomFieldOptionValidateBeforeCall(fieldId, contextId, optionId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete custom field options (context) (asynchronously)
     * Deletes a custom field option.  Options with cascading options cannot be deleted without deleting the cascading options first.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context from which an option should be deleted. (required)
     * @param optionId The ID of the option to delete. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the option is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or the option is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCustomFieldOptionAsync(String fieldId, Long contextId, Long optionId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCustomFieldOptionValidateBeforeCall(fieldId, contextId, optionId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCustomFieldOption
     * @param id The ID of the custom field option. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if:   *  the custom field option is not found.  *  the user does not have permission to view the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCustomFieldOptionCall(String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/customFieldOption/{id}"
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCustomFieldOptionValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCustomFieldOption(Async)");
        }

        return getCustomFieldOptionCall(id, _callback);

    }

    /**
     * Get custom field option
     * Returns a custom field option. For example, an option in a select list.  Note that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** The custom field option is returned as follows:   *  if the user has the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  if the user has the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for at least one project the custom field is used in, and the field is visible in at least one layout the user has permission to view.
     * @param id The ID of the custom field option. (required)
     * @return CustomFieldOption
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if:   *  the custom field option is not found.  *  the user does not have permission to view the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public CustomFieldOption getCustomFieldOption(String id) throws ApiException {
        ApiResponse<CustomFieldOption> localVarResp = getCustomFieldOptionWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get custom field option
     * Returns a custom field option. For example, an option in a select list.  Note that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** The custom field option is returned as follows:   *  if the user has the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  if the user has the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for at least one project the custom field is used in, and the field is visible in at least one layout the user has permission to view.
     * @param id The ID of the custom field option. (required)
     * @return ApiResponse&lt;CustomFieldOption&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if:   *  the custom field option is not found.  *  the user does not have permission to view the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomFieldOption> getCustomFieldOptionWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getCustomFieldOptionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<CustomFieldOption>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get custom field option (asynchronously)
     * Returns a custom field option. For example, an option in a select list.  Note that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** The custom field option is returned as follows:   *  if the user has the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  if the user has the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for at least one project the custom field is used in, and the field is visible in at least one layout the user has permission to view.
     * @param id The ID of the custom field option. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if:   *  the custom field option is not found.  *  the user does not have permission to view the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCustomFieldOptionAsync(String id, final ApiCallback<CustomFieldOption> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCustomFieldOptionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<CustomFieldOption>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOptionsForContext
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param optionId The ID of the option. (optional)
     * @param onlyOptions Whether only options are returned. (optional, default to false)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 100)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsForContextCall(String fieldId, Long contextId, Long optionId, Boolean onlyOptions, Long startAt, Integer maxResults, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/field/{fieldId}/context/{contextId}/option"
            .replace("{" + "fieldId" + "}", localVarApiClient.escapeString(fieldId.toString()))
            .replace("{" + "contextId" + "}", localVarApiClient.escapeString(contextId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (optionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("optionId", optionId));
        }

        if (onlyOptions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("onlyOptions", onlyOptions));
        }

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsForContextValidateBeforeCall(String fieldId, Long contextId, Long optionId, Boolean onlyOptions, Long startAt, Integer maxResults, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'fieldId' is set
        if (fieldId == null) {
            throw new ApiException("Missing the required parameter 'fieldId' when calling getOptionsForContext(Async)");
        }

        // verify the required parameter 'contextId' is set
        if (contextId == null) {
            throw new ApiException("Missing the required parameter 'contextId' when calling getOptionsForContext(Async)");
        }

        return getOptionsForContextCall(fieldId, contextId, optionId, onlyOptions, startAt, maxResults, _callback);

    }

    /**
     * Get custom field options (context)
     * Returns a [paginated](#pagination) list of all custom field option for a context. Options are returned first then cascading options, in the order they display in Jira.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param optionId The ID of the option. (optional)
     * @param onlyOptions Whether only options are returned. (optional, default to false)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 100)
     * @return PageBeanCustomFieldContextOption
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanCustomFieldContextOption getOptionsForContext(String fieldId, Long contextId, Long optionId, Boolean onlyOptions, Long startAt, Integer maxResults) throws ApiException {
        ApiResponse<PageBeanCustomFieldContextOption> localVarResp = getOptionsForContextWithHttpInfo(fieldId, contextId, optionId, onlyOptions, startAt, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get custom field options (context)
     * Returns a [paginated](#pagination) list of all custom field option for a context. Options are returned first then cascading options, in the order they display in Jira.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param optionId The ID of the option. (optional)
     * @param onlyOptions Whether only options are returned. (optional, default to false)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 100)
     * @return ApiResponse&lt;PageBeanCustomFieldContextOption&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanCustomFieldContextOption> getOptionsForContextWithHttpInfo(String fieldId, Long contextId, Long optionId, Boolean onlyOptions, Long startAt, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getOptionsForContextValidateBeforeCall(fieldId, contextId, optionId, onlyOptions, startAt, maxResults, null);
        Type localVarReturnType = new TypeToken<PageBeanCustomFieldContextOption>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get custom field options (context) (asynchronously)
     * Returns a [paginated](#pagination) list of all custom field option for a context. Options are returned first then cascading options, in the order they display in Jira.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param optionId The ID of the option. (optional)
     * @param onlyOptions Whether only options are returned. (optional, default to false)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 100)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the custom field is not found or the context doesn&#39;t match the custom field. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsForContextAsync(String fieldId, Long contextId, Long optionId, Boolean onlyOptions, Long startAt, Integer maxResults, final ApiCallback<PageBeanCustomFieldContextOption> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOptionsForContextValidateBeforeCall(fieldId, contextId, optionId, onlyOptions, startAt, maxResults, _callback);
        Type localVarReturnType = new TypeToken<PageBeanCustomFieldContextOption>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for reorderCustomFieldOptions
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param orderOfCustomFieldOptions  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if options are reordered. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or one or more of the options is not found.. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call reorderCustomFieldOptionsCall(String fieldId, Long contextId, OrderOfCustomFieldOptions orderOfCustomFieldOptions, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = orderOfCustomFieldOptions;

        // create path and map variables
        String localVarPath = "/rest/api/3/field/{fieldId}/context/{contextId}/option/move"
            .replace("{" + "fieldId" + "}", localVarApiClient.escapeString(fieldId.toString()))
            .replace("{" + "contextId" + "}", localVarApiClient.escapeString(contextId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call reorderCustomFieldOptionsValidateBeforeCall(String fieldId, Long contextId, OrderOfCustomFieldOptions orderOfCustomFieldOptions, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'fieldId' is set
        if (fieldId == null) {
            throw new ApiException("Missing the required parameter 'fieldId' when calling reorderCustomFieldOptions(Async)");
        }

        // verify the required parameter 'contextId' is set
        if (contextId == null) {
            throw new ApiException("Missing the required parameter 'contextId' when calling reorderCustomFieldOptions(Async)");
        }

        // verify the required parameter 'orderOfCustomFieldOptions' is set
        if (orderOfCustomFieldOptions == null) {
            throw new ApiException("Missing the required parameter 'orderOfCustomFieldOptions' when calling reorderCustomFieldOptions(Async)");
        }

        return reorderCustomFieldOptionsCall(fieldId, contextId, orderOfCustomFieldOptions, _callback);

    }

    /**
     * Reorder custom field options (context)
     * Changes the order of custom field options or cascading options in a context.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param orderOfCustomFieldOptions  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if options are reordered. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or one or more of the options is not found.. </td><td>  -  </td></tr>
     </table>
     */
    public Object reorderCustomFieldOptions(String fieldId, Long contextId, OrderOfCustomFieldOptions orderOfCustomFieldOptions) throws ApiException {
        ApiResponse<Object> localVarResp = reorderCustomFieldOptionsWithHttpInfo(fieldId, contextId, orderOfCustomFieldOptions);
        return localVarResp.getData();
    }

    /**
     * Reorder custom field options (context)
     * Changes the order of custom field options or cascading options in a context.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param orderOfCustomFieldOptions  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if options are reordered. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or one or more of the options is not found.. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> reorderCustomFieldOptionsWithHttpInfo(String fieldId, Long contextId, OrderOfCustomFieldOptions orderOfCustomFieldOptions) throws ApiException {
        okhttp3.Call localVarCall = reorderCustomFieldOptionsValidateBeforeCall(fieldId, contextId, orderOfCustomFieldOptions, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Reorder custom field options (context) (asynchronously)
     * Changes the order of custom field options or cascading options in a context.  This operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param orderOfCustomFieldOptions  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if options are reordered. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, the context, or one or more of the options is not found.. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call reorderCustomFieldOptionsAsync(String fieldId, Long contextId, OrderOfCustomFieldOptions orderOfCustomFieldOptions, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = reorderCustomFieldOptionsValidateBeforeCall(fieldId, contextId, orderOfCustomFieldOptions, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateCustomFieldOption
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionUpdateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, context, or one or more options is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCustomFieldOptionCall(String fieldId, Long contextId, BulkCustomFieldOptionUpdateRequest bulkCustomFieldOptionUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = bulkCustomFieldOptionUpdateRequest;

        // create path and map variables
        String localVarPath = "/rest/api/3/field/{fieldId}/context/{contextId}/option"
            .replace("{" + "fieldId" + "}", localVarApiClient.escapeString(fieldId.toString()))
            .replace("{" + "contextId" + "}", localVarApiClient.escapeString(contextId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateCustomFieldOptionValidateBeforeCall(String fieldId, Long contextId, BulkCustomFieldOptionUpdateRequest bulkCustomFieldOptionUpdateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'fieldId' is set
        if (fieldId == null) {
            throw new ApiException("Missing the required parameter 'fieldId' when calling updateCustomFieldOption(Async)");
        }

        // verify the required parameter 'contextId' is set
        if (contextId == null) {
            throw new ApiException("Missing the required parameter 'contextId' when calling updateCustomFieldOption(Async)");
        }

        // verify the required parameter 'bulkCustomFieldOptionUpdateRequest' is set
        if (bulkCustomFieldOptionUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'bulkCustomFieldOptionUpdateRequest' when calling updateCustomFieldOption(Async)");
        }

        return updateCustomFieldOptionCall(fieldId, contextId, bulkCustomFieldOptionUpdateRequest, _callback);

    }

    /**
     * Update custom field options (context)
     * Updates the options of a custom field.  If any of the options are not found, no options are updated. Options where the values in the request match the current values aren&#39;t updated and aren&#39;t reported in the response.  Note that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionUpdateRequest  (required)
     * @return CustomFieldUpdatedContextOptionsList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, context, or one or more options is not found. </td><td>  -  </td></tr>
     </table>
     */
    public CustomFieldUpdatedContextOptionsList updateCustomFieldOption(String fieldId, Long contextId, BulkCustomFieldOptionUpdateRequest bulkCustomFieldOptionUpdateRequest) throws ApiException {
        ApiResponse<CustomFieldUpdatedContextOptionsList> localVarResp = updateCustomFieldOptionWithHttpInfo(fieldId, contextId, bulkCustomFieldOptionUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update custom field options (context)
     * Updates the options of a custom field.  If any of the options are not found, no options are updated. Options where the values in the request match the current values aren&#39;t updated and aren&#39;t reported in the response.  Note that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionUpdateRequest  (required)
     * @return ApiResponse&lt;CustomFieldUpdatedContextOptionsList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, context, or one or more options is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomFieldUpdatedContextOptionsList> updateCustomFieldOptionWithHttpInfo(String fieldId, Long contextId, BulkCustomFieldOptionUpdateRequest bulkCustomFieldOptionUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateCustomFieldOptionValidateBeforeCall(fieldId, contextId, bulkCustomFieldOptionUpdateRequest, null);
        Type localVarReturnType = new TypeToken<CustomFieldUpdatedContextOptionsList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update custom field options (context) (asynchronously)
     * Updates the options of a custom field.  If any of the options are not found, no options are updated. Options where the values in the request match the current values aren&#39;t updated and aren&#39;t reported in the response.  Note that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param fieldId The ID of the custom field. (required)
     * @param contextId The ID of the context. (required)
     * @param bulkCustomFieldOptionUpdateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the field, context, or one or more options is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCustomFieldOptionAsync(String fieldId, Long contextId, BulkCustomFieldOptionUpdateRequest bulkCustomFieldOptionUpdateRequest, final ApiCallback<CustomFieldUpdatedContextOptionsList> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateCustomFieldOptionValidateBeforeCall(fieldId, contextId, bulkCustomFieldOptionUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<CustomFieldUpdatedContextOptionsList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
