/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.api;

import software.tnb.jira.validation.generated.ApiCallback;
import software.tnb.jira.validation.generated.ApiClient;
import software.tnb.jira.validation.generated.ApiException;
import software.tnb.jira.validation.generated.ApiResponse;
import software.tnb.jira.validation.generated.Configuration;
import software.tnb.jira.validation.generated.Pair;
import software.tnb.jira.validation.generated.ProgressRequestBody;
import software.tnb.jira.validation.generated.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import software.tnb.jira.validation.generated.model.IssueTypeIds;
import software.tnb.jira.validation.generated.model.IssueTypeScreenSchemeDetails;
import software.tnb.jira.validation.generated.model.IssueTypeScreenSchemeId;
import software.tnb.jira.validation.generated.model.IssueTypeScreenSchemeMappingDetails;
import software.tnb.jira.validation.generated.model.IssueTypeScreenSchemeProjectAssociation;
import software.tnb.jira.validation.generated.model.IssueTypeScreenSchemeUpdateDetails;
import software.tnb.jira.validation.generated.model.PageBeanIssueTypeScreenScheme;
import software.tnb.jira.validation.generated.model.PageBeanIssueTypeScreenSchemeItem;
import software.tnb.jira.validation.generated.model.PageBeanIssueTypeScreenSchemesProjects;
import software.tnb.jira.validation.generated.model.PageBeanProjectDetails;
import java.util.Set;
import software.tnb.jira.validation.generated.model.UpdateDefaultScreenScheme;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.core.GenericType;

public class IssueTypeScreenSchemesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IssueTypeScreenSchemesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IssueTypeScreenSchemesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for appendMappingsForIssueTypeScreenScheme
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeMappingDetails  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme, issue type, or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call appendMappingsForIssueTypeScreenSchemeCall(String issueTypeScreenSchemeId, IssueTypeScreenSchemeMappingDetails issueTypeScreenSchemeMappingDetails, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = issueTypeScreenSchemeMappingDetails;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping"
            .replace("{" + "issueTypeScreenSchemeId" + "}", localVarApiClient.escapeString(issueTypeScreenSchemeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call appendMappingsForIssueTypeScreenSchemeValidateBeforeCall(String issueTypeScreenSchemeId, IssueTypeScreenSchemeMappingDetails issueTypeScreenSchemeMappingDetails, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeId' is set
        if (issueTypeScreenSchemeId == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeId' when calling appendMappingsForIssueTypeScreenScheme(Async)");
        }

        // verify the required parameter 'issueTypeScreenSchemeMappingDetails' is set
        if (issueTypeScreenSchemeMappingDetails == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeMappingDetails' when calling appendMappingsForIssueTypeScreenScheme(Async)");
        }

        return appendMappingsForIssueTypeScreenSchemeCall(issueTypeScreenSchemeId, issueTypeScreenSchemeMappingDetails, _callback);

    }

    /**
     * Append mappings to issue type screen scheme
     * Appends issue type to screen scheme mappings to an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeMappingDetails  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme, issue type, or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public Object appendMappingsForIssueTypeScreenScheme(String issueTypeScreenSchemeId, IssueTypeScreenSchemeMappingDetails issueTypeScreenSchemeMappingDetails) throws ApiException {
        ApiResponse<Object> localVarResp = appendMappingsForIssueTypeScreenSchemeWithHttpInfo(issueTypeScreenSchemeId, issueTypeScreenSchemeMappingDetails);
        return localVarResp.getData();
    }

    /**
     * Append mappings to issue type screen scheme
     * Appends issue type to screen scheme mappings to an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeMappingDetails  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme, issue type, or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> appendMappingsForIssueTypeScreenSchemeWithHttpInfo(String issueTypeScreenSchemeId, IssueTypeScreenSchemeMappingDetails issueTypeScreenSchemeMappingDetails) throws ApiException {
        okhttp3.Call localVarCall = appendMappingsForIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, issueTypeScreenSchemeMappingDetails, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Append mappings to issue type screen scheme (asynchronously)
     * Appends issue type to screen scheme mappings to an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeMappingDetails  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme, issue type, or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call appendMappingsForIssueTypeScreenSchemeAsync(String issueTypeScreenSchemeId, IssueTypeScreenSchemeMappingDetails issueTypeScreenSchemeMappingDetails, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = appendMappingsForIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, issueTypeScreenSchemeMappingDetails, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for assignIssueTypeScreenSchemeToProject
     * @param issueTypeScreenSchemeProjectAssociation  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if:   *  project is not found.  *  issue type screen scheme is not found.  *  the project is not a classic project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the project are missing. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call assignIssueTypeScreenSchemeToProjectCall(IssueTypeScreenSchemeProjectAssociation issueTypeScreenSchemeProjectAssociation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = issueTypeScreenSchemeProjectAssociation;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/project";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call assignIssueTypeScreenSchemeToProjectValidateBeforeCall(IssueTypeScreenSchemeProjectAssociation issueTypeScreenSchemeProjectAssociation, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeProjectAssociation' is set
        if (issueTypeScreenSchemeProjectAssociation == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeProjectAssociation' when calling assignIssueTypeScreenSchemeToProject(Async)");
        }

        return assignIssueTypeScreenSchemeToProjectCall(issueTypeScreenSchemeProjectAssociation, _callback);

    }

    /**
     * Assign issue type screen scheme to project
     * Assigns an issue type screen scheme to a project.  Issue type screen schemes can only be assigned to classic projects.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeProjectAssociation  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if:   *  project is not found.  *  issue type screen scheme is not found.  *  the project is not a classic project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the project are missing. </td><td>  -  </td></tr>
     </table>
     */
    public Object assignIssueTypeScreenSchemeToProject(IssueTypeScreenSchemeProjectAssociation issueTypeScreenSchemeProjectAssociation) throws ApiException {
        ApiResponse<Object> localVarResp = assignIssueTypeScreenSchemeToProjectWithHttpInfo(issueTypeScreenSchemeProjectAssociation);
        return localVarResp.getData();
    }

    /**
     * Assign issue type screen scheme to project
     * Assigns an issue type screen scheme to a project.  Issue type screen schemes can only be assigned to classic projects.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeProjectAssociation  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if:   *  project is not found.  *  issue type screen scheme is not found.  *  the project is not a classic project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the project are missing. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> assignIssueTypeScreenSchemeToProjectWithHttpInfo(IssueTypeScreenSchemeProjectAssociation issueTypeScreenSchemeProjectAssociation) throws ApiException {
        okhttp3.Call localVarCall = assignIssueTypeScreenSchemeToProjectValidateBeforeCall(issueTypeScreenSchemeProjectAssociation, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Assign issue type screen scheme to project (asynchronously)
     * Assigns an issue type screen scheme to a project.  Issue type screen schemes can only be assigned to classic projects.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeProjectAssociation  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if:   *  project is not found.  *  issue type screen scheme is not found.  *  the project is not a classic project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the project are missing. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call assignIssueTypeScreenSchemeToProjectAsync(IssueTypeScreenSchemeProjectAssociation issueTypeScreenSchemeProjectAssociation, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = assignIssueTypeScreenSchemeToProjectValidateBeforeCall(issueTypeScreenSchemeProjectAssociation, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createIssueTypeScreenScheme
     * @param issueTypeScreenSchemeDetails An issue type screen scheme bean. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createIssueTypeScreenSchemeCall(IssueTypeScreenSchemeDetails issueTypeScreenSchemeDetails, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = issueTypeScreenSchemeDetails;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createIssueTypeScreenSchemeValidateBeforeCall(IssueTypeScreenSchemeDetails issueTypeScreenSchemeDetails, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeDetails' is set
        if (issueTypeScreenSchemeDetails == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeDetails' when calling createIssueTypeScreenScheme(Async)");
        }

        return createIssueTypeScreenSchemeCall(issueTypeScreenSchemeDetails, _callback);

    }

    /**
     * Create issue type screen scheme
     * Creates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeDetails An issue type screen scheme bean. (required)
     * @return IssueTypeScreenSchemeId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public IssueTypeScreenSchemeId createIssueTypeScreenScheme(IssueTypeScreenSchemeDetails issueTypeScreenSchemeDetails) throws ApiException {
        ApiResponse<IssueTypeScreenSchemeId> localVarResp = createIssueTypeScreenSchemeWithHttpInfo(issueTypeScreenSchemeDetails);
        return localVarResp.getData();
    }

    /**
     * Create issue type screen scheme
     * Creates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeDetails An issue type screen scheme bean. (required)
     * @return ApiResponse&lt;IssueTypeScreenSchemeId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IssueTypeScreenSchemeId> createIssueTypeScreenSchemeWithHttpInfo(IssueTypeScreenSchemeDetails issueTypeScreenSchemeDetails) throws ApiException {
        okhttp3.Call localVarCall = createIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeDetails, null);
        Type localVarReturnType = new TypeToken<IssueTypeScreenSchemeId>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create issue type screen scheme (asynchronously)
     * Creates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeDetails An issue type screen scheme bean. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type or screen scheme is not found. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createIssueTypeScreenSchemeAsync(IssueTypeScreenSchemeDetails issueTypeScreenSchemeDetails, final ApiCallback<IssueTypeScreenSchemeId> _callback) throws ApiException {

        okhttp3.Call localVarCall = createIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeDetails, _callback);
        Type localVarReturnType = new TypeToken<IssueTypeScreenSchemeId>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteIssueTypeScreenScheme
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the issue type screen scheme is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteIssueTypeScreenSchemeCall(String issueTypeScreenSchemeId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}"
            .replace("{" + "issueTypeScreenSchemeId" + "}", localVarApiClient.escapeString(issueTypeScreenSchemeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteIssueTypeScreenSchemeValidateBeforeCall(String issueTypeScreenSchemeId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeId' is set
        if (issueTypeScreenSchemeId == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeId' when calling deleteIssueTypeScreenScheme(Async)");
        }

        return deleteIssueTypeScreenSchemeCall(issueTypeScreenSchemeId, _callback);

    }

    /**
     * Delete issue type screen scheme
     * Deletes an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the issue type screen scheme is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public Object deleteIssueTypeScreenScheme(String issueTypeScreenSchemeId) throws ApiException {
        ApiResponse<Object> localVarResp = deleteIssueTypeScreenSchemeWithHttpInfo(issueTypeScreenSchemeId);
        return localVarResp.getData();
    }

    /**
     * Delete issue type screen scheme
     * Deletes an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the issue type screen scheme is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> deleteIssueTypeScreenSchemeWithHttpInfo(String issueTypeScreenSchemeId) throws ApiException {
        okhttp3.Call localVarCall = deleteIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete issue type screen scheme (asynchronously)
     * Deletes an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the issue type screen scheme is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteIssueTypeScreenSchemeAsync(String issueTypeScreenSchemeId, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getIssueTypeScreenSchemeMappings
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param issueTypeScreenSchemeId The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: &#x60;issueTypeScreenSchemeId&#x3D;10000&amp;issueTypeScreenSchemeId&#x3D;10001&#x60;. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIssueTypeScreenSchemeMappingsCall(Long startAt, Integer maxResults, Set<Long> issueTypeScreenSchemeId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/mapping";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (issueTypeScreenSchemeId != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "issueTypeScreenSchemeId", issueTypeScreenSchemeId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIssueTypeScreenSchemeMappingsValidateBeforeCall(Long startAt, Integer maxResults, Set<Long> issueTypeScreenSchemeId, final ApiCallback _callback) throws ApiException {
        return getIssueTypeScreenSchemeMappingsCall(startAt, maxResults, issueTypeScreenSchemeId, _callback);

    }

    /**
     * Get issue type screen scheme items
     * Returns a [paginated](#pagination) list of issue type screen scheme items.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param issueTypeScreenSchemeId The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: &#x60;issueTypeScreenSchemeId&#x3D;10000&amp;issueTypeScreenSchemeId&#x3D;10001&#x60;. (optional)
     * @return PageBeanIssueTypeScreenSchemeItem
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanIssueTypeScreenSchemeItem getIssueTypeScreenSchemeMappings(Long startAt, Integer maxResults, Set<Long> issueTypeScreenSchemeId) throws ApiException {
        ApiResponse<PageBeanIssueTypeScreenSchemeItem> localVarResp = getIssueTypeScreenSchemeMappingsWithHttpInfo(startAt, maxResults, issueTypeScreenSchemeId);
        return localVarResp.getData();
    }

    /**
     * Get issue type screen scheme items
     * Returns a [paginated](#pagination) list of issue type screen scheme items.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param issueTypeScreenSchemeId The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: &#x60;issueTypeScreenSchemeId&#x3D;10000&amp;issueTypeScreenSchemeId&#x3D;10001&#x60;. (optional)
     * @return ApiResponse&lt;PageBeanIssueTypeScreenSchemeItem&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanIssueTypeScreenSchemeItem> getIssueTypeScreenSchemeMappingsWithHttpInfo(Long startAt, Integer maxResults, Set<Long> issueTypeScreenSchemeId) throws ApiException {
        okhttp3.Call localVarCall = getIssueTypeScreenSchemeMappingsValidateBeforeCall(startAt, maxResults, issueTypeScreenSchemeId, null);
        Type localVarReturnType = new TypeToken<PageBeanIssueTypeScreenSchemeItem>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get issue type screen scheme items (asynchronously)
     * Returns a [paginated](#pagination) list of issue type screen scheme items.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param issueTypeScreenSchemeId The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: &#x60;issueTypeScreenSchemeId&#x3D;10000&amp;issueTypeScreenSchemeId&#x3D;10001&#x60;. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIssueTypeScreenSchemeMappingsAsync(Long startAt, Integer maxResults, Set<Long> issueTypeScreenSchemeId, final ApiCallback<PageBeanIssueTypeScreenSchemeItem> _callback) throws ApiException {

        okhttp3.Call localVarCall = getIssueTypeScreenSchemeMappingsValidateBeforeCall(startAt, maxResults, issueTypeScreenSchemeId, _callback);
        Type localVarReturnType = new TypeToken<PageBeanIssueTypeScreenSchemeItem>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getIssueTypeScreenSchemeProjectAssociations
     * @param projectId The list of project IDs. To include multiple projects, separate IDs with ampersand: &#x60;projectId&#x3D;10000&amp;projectId&#x3D;10001&#x60;. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIssueTypeScreenSchemeProjectAssociationsCall(Set<Long> projectId, Long startAt, Integer maxResults, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/project";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (projectId != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "projectId", projectId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIssueTypeScreenSchemeProjectAssociationsValidateBeforeCall(Set<Long> projectId, Long startAt, Integer maxResults, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getIssueTypeScreenSchemeProjectAssociations(Async)");
        }

        return getIssueTypeScreenSchemeProjectAssociationsCall(projectId, startAt, maxResults, _callback);

    }

    /**
     * Get issue type screen schemes for projects
     * Returns a [paginated](#pagination) list of issue type screen schemes and, for each issue type screen scheme, a list of the projects that use it.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param projectId The list of project IDs. To include multiple projects, separate IDs with ampersand: &#x60;projectId&#x3D;10000&amp;projectId&#x3D;10001&#x60;. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @return PageBeanIssueTypeScreenSchemesProjects
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanIssueTypeScreenSchemesProjects getIssueTypeScreenSchemeProjectAssociations(Set<Long> projectId, Long startAt, Integer maxResults) throws ApiException {
        ApiResponse<PageBeanIssueTypeScreenSchemesProjects> localVarResp = getIssueTypeScreenSchemeProjectAssociationsWithHttpInfo(projectId, startAt, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get issue type screen schemes for projects
     * Returns a [paginated](#pagination) list of issue type screen schemes and, for each issue type screen scheme, a list of the projects that use it.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param projectId The list of project IDs. To include multiple projects, separate IDs with ampersand: &#x60;projectId&#x3D;10000&amp;projectId&#x3D;10001&#x60;. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @return ApiResponse&lt;PageBeanIssueTypeScreenSchemesProjects&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanIssueTypeScreenSchemesProjects> getIssueTypeScreenSchemeProjectAssociationsWithHttpInfo(Set<Long> projectId, Long startAt, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getIssueTypeScreenSchemeProjectAssociationsValidateBeforeCall(projectId, startAt, maxResults, null);
        Type localVarReturnType = new TypeToken<PageBeanIssueTypeScreenSchemesProjects>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get issue type screen schemes for projects (asynchronously)
     * Returns a [paginated](#pagination) list of issue type screen schemes and, for each issue type screen scheme, a list of the projects that use it.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param projectId The list of project IDs. To include multiple projects, separate IDs with ampersand: &#x60;projectId&#x3D;10000&amp;projectId&#x3D;10001&#x60;. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIssueTypeScreenSchemeProjectAssociationsAsync(Set<Long> projectId, Long startAt, Integer maxResults, final ApiCallback<PageBeanIssueTypeScreenSchemesProjects> _callback) throws ApiException {

        okhttp3.Call localVarCall = getIssueTypeScreenSchemeProjectAssociationsValidateBeforeCall(projectId, startAt, maxResults, _callback);
        Type localVarReturnType = new TypeToken<PageBeanIssueTypeScreenSchemesProjects>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getIssueTypeScreenSchemes
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param id The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, &#x60;id&#x3D;10000&amp;id&#x3D;10001&#x60;. (optional)
     * @param queryString String used to perform a case-insensitive partial match with issue type screen scheme name. (optional, default to )
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by issue type screen scheme name.  *  &#x60;id&#x60; Sorts by issue type screen scheme ID. (optional, default to id)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;projects&#x60; that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to. (optional, default to )
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIssueTypeScreenSchemesCall(Long startAt, Integer maxResults, Set<Long> id, String queryString, String orderBy, String expand, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (id != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "id", id));
        }

        if (queryString != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("queryString", queryString));
        }

        if (orderBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderBy", orderBy));
        }

        if (expand != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expand", expand));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIssueTypeScreenSchemesValidateBeforeCall(Long startAt, Integer maxResults, Set<Long> id, String queryString, String orderBy, String expand, final ApiCallback _callback) throws ApiException {
        return getIssueTypeScreenSchemesCall(startAt, maxResults, id, queryString, orderBy, expand, _callback);

    }

    /**
     * Get issue type screen schemes
     * Returns a [paginated](#pagination) list of issue type screen schemes.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param id The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, &#x60;id&#x3D;10000&amp;id&#x3D;10001&#x60;. (optional)
     * @param queryString String used to perform a case-insensitive partial match with issue type screen scheme name. (optional, default to )
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by issue type screen scheme name.  *  &#x60;id&#x60; Sorts by issue type screen scheme ID. (optional, default to id)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;projects&#x60; that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to. (optional, default to )
     * @return PageBeanIssueTypeScreenScheme
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanIssueTypeScreenScheme getIssueTypeScreenSchemes(Long startAt, Integer maxResults, Set<Long> id, String queryString, String orderBy, String expand) throws ApiException {
        ApiResponse<PageBeanIssueTypeScreenScheme> localVarResp = getIssueTypeScreenSchemesWithHttpInfo(startAt, maxResults, id, queryString, orderBy, expand);
        return localVarResp.getData();
    }

    /**
     * Get issue type screen schemes
     * Returns a [paginated](#pagination) list of issue type screen schemes.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param id The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, &#x60;id&#x3D;10000&amp;id&#x3D;10001&#x60;. (optional)
     * @param queryString String used to perform a case-insensitive partial match with issue type screen scheme name. (optional, default to )
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by issue type screen scheme name.  *  &#x60;id&#x60; Sorts by issue type screen scheme ID. (optional, default to id)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;projects&#x60; that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to. (optional, default to )
     * @return ApiResponse&lt;PageBeanIssueTypeScreenScheme&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanIssueTypeScreenScheme> getIssueTypeScreenSchemesWithHttpInfo(Long startAt, Integer maxResults, Set<Long> id, String queryString, String orderBy, String expand) throws ApiException {
        okhttp3.Call localVarCall = getIssueTypeScreenSchemesValidateBeforeCall(startAt, maxResults, id, queryString, orderBy, expand, null);
        Type localVarReturnType = new TypeToken<PageBeanIssueTypeScreenScheme>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get issue type screen schemes (asynchronously)
     * Returns a [paginated](#pagination) list of issue type screen schemes.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param id The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, &#x60;id&#x3D;10000&amp;id&#x3D;10001&#x60;. (optional)
     * @param queryString String used to perform a case-insensitive partial match with issue type screen scheme name. (optional, default to )
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by issue type screen scheme name.  *  &#x60;id&#x60; Sorts by issue type screen scheme ID. (optional, default to id)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;projects&#x60; that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to. (optional, default to )
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIssueTypeScreenSchemesAsync(Long startAt, Integer maxResults, Set<Long> id, String queryString, String orderBy, String expand, final ApiCallback<PageBeanIssueTypeScreenScheme> _callback) throws ApiException {

        okhttp3.Call localVarCall = getIssueTypeScreenSchemesValidateBeforeCall(startAt, maxResults, id, queryString, orderBy, expand, _callback);
        Type localVarReturnType = new TypeToken<PageBeanIssueTypeScreenScheme>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProjectsForIssueTypeScreenScheme
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param query  (optional, default to )
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProjectsForIssueTypeScreenSchemeCall(Long issueTypeScreenSchemeId, Long startAt, Integer maxResults, String query, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/project"
            .replace("{" + "issueTypeScreenSchemeId" + "}", localVarApiClient.escapeString(issueTypeScreenSchemeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (query != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("query", query));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProjectsForIssueTypeScreenSchemeValidateBeforeCall(Long issueTypeScreenSchemeId, Long startAt, Integer maxResults, String query, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeId' is set
        if (issueTypeScreenSchemeId == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeId' when calling getProjectsForIssueTypeScreenScheme(Async)");
        }

        return getProjectsForIssueTypeScreenSchemeCall(issueTypeScreenSchemeId, startAt, maxResults, query, _callback);

    }

    /**
     * Get issue type screen scheme projects
     * Returns a [paginated](#pagination) list of projects associated with an issue type screen scheme.  Only company-managed projects associated with an issue type screen scheme are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param query  (optional, default to )
     * @return PageBeanProjectDetails
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanProjectDetails getProjectsForIssueTypeScreenScheme(Long issueTypeScreenSchemeId, Long startAt, Integer maxResults, String query) throws ApiException {
        ApiResponse<PageBeanProjectDetails> localVarResp = getProjectsForIssueTypeScreenSchemeWithHttpInfo(issueTypeScreenSchemeId, startAt, maxResults, query);
        return localVarResp.getData();
    }

    /**
     * Get issue type screen scheme projects
     * Returns a [paginated](#pagination) list of projects associated with an issue type screen scheme.  Only company-managed projects associated with an issue type screen scheme are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param query  (optional, default to )
     * @return ApiResponse&lt;PageBeanProjectDetails&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanProjectDetails> getProjectsForIssueTypeScreenSchemeWithHttpInfo(Long issueTypeScreenSchemeId, Long startAt, Integer maxResults, String query) throws ApiException {
        okhttp3.Call localVarCall = getProjectsForIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, startAt, maxResults, query, null);
        Type localVarReturnType = new TypeToken<PageBeanProjectDetails>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get issue type screen scheme projects (asynchronously)
     * Returns a [paginated](#pagination) list of projects associated with an issue type screen scheme.  Only company-managed projects associated with an issue type screen scheme are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param query  (optional, default to )
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProjectsForIssueTypeScreenSchemeAsync(Long issueTypeScreenSchemeId, Long startAt, Integer maxResults, String query, final ApiCallback<PageBeanProjectDetails> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProjectsForIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, startAt, maxResults, query, _callback);
        Type localVarReturnType = new TypeToken<PageBeanProjectDetails>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for removeMappingsFromIssueTypeScreenScheme
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeIds  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the screen scheme mappings are removed from the issue type screen scheme. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or one or more issue type mappings are not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeMappingsFromIssueTypeScreenSchemeCall(String issueTypeScreenSchemeId, IssueTypeIds issueTypeIds, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = issueTypeIds;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/remove"
            .replace("{" + "issueTypeScreenSchemeId" + "}", localVarApiClient.escapeString(issueTypeScreenSchemeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call removeMappingsFromIssueTypeScreenSchemeValidateBeforeCall(String issueTypeScreenSchemeId, IssueTypeIds issueTypeIds, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeId' is set
        if (issueTypeScreenSchemeId == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeId' when calling removeMappingsFromIssueTypeScreenScheme(Async)");
        }

        // verify the required parameter 'issueTypeIds' is set
        if (issueTypeIds == null) {
            throw new ApiException("Missing the required parameter 'issueTypeIds' when calling removeMappingsFromIssueTypeScreenScheme(Async)");
        }

        return removeMappingsFromIssueTypeScreenSchemeCall(issueTypeScreenSchemeId, issueTypeIds, _callback);

    }

    /**
     * Remove mappings from issue type screen scheme
     * Removes issue type to screen scheme mappings from an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeIds  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the screen scheme mappings are removed from the issue type screen scheme. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or one or more issue type mappings are not found. </td><td>  -  </td></tr>
     </table>
     */
    public Object removeMappingsFromIssueTypeScreenScheme(String issueTypeScreenSchemeId, IssueTypeIds issueTypeIds) throws ApiException {
        ApiResponse<Object> localVarResp = removeMappingsFromIssueTypeScreenSchemeWithHttpInfo(issueTypeScreenSchemeId, issueTypeIds);
        return localVarResp.getData();
    }

    /**
     * Remove mappings from issue type screen scheme
     * Removes issue type to screen scheme mappings from an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeIds  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the screen scheme mappings are removed from the issue type screen scheme. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or one or more issue type mappings are not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> removeMappingsFromIssueTypeScreenSchemeWithHttpInfo(String issueTypeScreenSchemeId, IssueTypeIds issueTypeIds) throws ApiException {
        okhttp3.Call localVarCall = removeMappingsFromIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, issueTypeIds, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Remove mappings from issue type screen scheme (asynchronously)
     * Removes issue type to screen scheme mappings from an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeIds  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the screen scheme mappings are removed from the issue type screen scheme. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or one or more issue type mappings are not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeMappingsFromIssueTypeScreenSchemeAsync(String issueTypeScreenSchemeId, IssueTypeIds issueTypeIds, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = removeMappingsFromIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, issueTypeIds, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateDefaultScreenScheme
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param updateDefaultScreenScheme  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the screen screen is not found, or the screen scheme isn&#39;t used in classic projects. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDefaultScreenSchemeCall(String issueTypeScreenSchemeId, UpdateDefaultScreenScheme updateDefaultScreenScheme, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateDefaultScreenScheme;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/default"
            .replace("{" + "issueTypeScreenSchemeId" + "}", localVarApiClient.escapeString(issueTypeScreenSchemeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateDefaultScreenSchemeValidateBeforeCall(String issueTypeScreenSchemeId, UpdateDefaultScreenScheme updateDefaultScreenScheme, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeId' is set
        if (issueTypeScreenSchemeId == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeId' when calling updateDefaultScreenScheme(Async)");
        }

        // verify the required parameter 'updateDefaultScreenScheme' is set
        if (updateDefaultScreenScheme == null) {
            throw new ApiException("Missing the required parameter 'updateDefaultScreenScheme' when calling updateDefaultScreenScheme(Async)");
        }

        return updateDefaultScreenSchemeCall(issueTypeScreenSchemeId, updateDefaultScreenScheme, _callback);

    }

    /**
     * Update issue type screen scheme default screen scheme
     * Updates the default screen scheme of an issue type screen scheme. The default screen scheme is used for all unmapped issue types.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param updateDefaultScreenScheme  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the screen screen is not found, or the screen scheme isn&#39;t used in classic projects. </td><td>  -  </td></tr>
     </table>
     */
    public Object updateDefaultScreenScheme(String issueTypeScreenSchemeId, UpdateDefaultScreenScheme updateDefaultScreenScheme) throws ApiException {
        ApiResponse<Object> localVarResp = updateDefaultScreenSchemeWithHttpInfo(issueTypeScreenSchemeId, updateDefaultScreenScheme);
        return localVarResp.getData();
    }

    /**
     * Update issue type screen scheme default screen scheme
     * Updates the default screen scheme of an issue type screen scheme. The default screen scheme is used for all unmapped issue types.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param updateDefaultScreenScheme  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the screen screen is not found, or the screen scheme isn&#39;t used in classic projects. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> updateDefaultScreenSchemeWithHttpInfo(String issueTypeScreenSchemeId, UpdateDefaultScreenScheme updateDefaultScreenScheme) throws ApiException {
        okhttp3.Call localVarCall = updateDefaultScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, updateDefaultScreenScheme, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update issue type screen scheme default screen scheme (asynchronously)
     * Updates the default screen scheme of an issue type screen scheme. The default screen scheme is used for all unmapped issue types.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param updateDefaultScreenScheme  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme or the screen screen is not found, or the screen scheme isn&#39;t used in classic projects. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDefaultScreenSchemeAsync(String issueTypeScreenSchemeId, UpdateDefaultScreenScheme updateDefaultScreenScheme, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateDefaultScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, updateDefaultScreenScheme, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateIssueTypeScreenScheme
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeUpdateDetails The issue type screen scheme update details. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateIssueTypeScreenSchemeCall(String issueTypeScreenSchemeId, IssueTypeScreenSchemeUpdateDetails issueTypeScreenSchemeUpdateDetails, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = issueTypeScreenSchemeUpdateDetails;

        // create path and map variables
        String localVarPath = "/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}"
            .replace("{" + "issueTypeScreenSchemeId" + "}", localVarApiClient.escapeString(issueTypeScreenSchemeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateIssueTypeScreenSchemeValidateBeforeCall(String issueTypeScreenSchemeId, IssueTypeScreenSchemeUpdateDetails issueTypeScreenSchemeUpdateDetails, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'issueTypeScreenSchemeId' is set
        if (issueTypeScreenSchemeId == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeId' when calling updateIssueTypeScreenScheme(Async)");
        }

        // verify the required parameter 'issueTypeScreenSchemeUpdateDetails' is set
        if (issueTypeScreenSchemeUpdateDetails == null) {
            throw new ApiException("Missing the required parameter 'issueTypeScreenSchemeUpdateDetails' when calling updateIssueTypeScreenScheme(Async)");
        }

        return updateIssueTypeScreenSchemeCall(issueTypeScreenSchemeId, issueTypeScreenSchemeUpdateDetails, _callback);

    }

    /**
     * Update issue type screen scheme
     * Updates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeUpdateDetails The issue type screen scheme update details. (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public Object updateIssueTypeScreenScheme(String issueTypeScreenSchemeId, IssueTypeScreenSchemeUpdateDetails issueTypeScreenSchemeUpdateDetails) throws ApiException {
        ApiResponse<Object> localVarResp = updateIssueTypeScreenSchemeWithHttpInfo(issueTypeScreenSchemeId, issueTypeScreenSchemeUpdateDetails);
        return localVarResp.getData();
    }

    /**
     * Update issue type screen scheme
     * Updates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeUpdateDetails The issue type screen scheme update details. (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> updateIssueTypeScreenSchemeWithHttpInfo(String issueTypeScreenSchemeId, IssueTypeScreenSchemeUpdateDetails issueTypeScreenSchemeUpdateDetails) throws ApiException {
        okhttp3.Call localVarCall = updateIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, issueTypeScreenSchemeUpdateDetails, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update issue type screen scheme (asynchronously)
     * Updates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param issueTypeScreenSchemeId The ID of the issue type screen scheme. (required)
     * @param issueTypeScreenSchemeUpdateDetails The issue type screen scheme update details. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the issue type screen scheme is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateIssueTypeScreenSchemeAsync(String issueTypeScreenSchemeId, IssueTypeScreenSchemeUpdateDetails issueTypeScreenSchemeUpdateDetails, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateIssueTypeScreenSchemeValidateBeforeCall(issueTypeScreenSchemeId, issueTypeScreenSchemeUpdateDetails, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
