/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.api;

import software.tnb.jira.validation.generated.ApiCallback;
import software.tnb.jira.validation.generated.ApiClient;
import software.tnb.jira.validation.generated.ApiException;
import software.tnb.jira.validation.generated.ApiResponse;
import software.tnb.jira.validation.generated.Configuration;
import software.tnb.jira.validation.generated.Pair;
import software.tnb.jira.validation.generated.ProgressRequestBody;
import software.tnb.jira.validation.generated.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import software.tnb.jira.validation.generated.model.AddFieldBean;
import software.tnb.jira.validation.generated.model.MoveFieldBean;
import software.tnb.jira.validation.generated.model.ScreenableField;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.core.GenericType;

public class ScreenTabFieldsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ScreenTabFieldsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScreenTabFieldsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for addScreenTabField
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param addFieldBean  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addScreenTabFieldCall(Long screenId, Long tabId, AddFieldBean addFieldBean, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = addFieldBean;

        // create path and map variables
        String localVarPath = "/rest/api/3/screens/{screenId}/tabs/{tabId}/fields"
            .replace("{" + "screenId" + "}", localVarApiClient.escapeString(screenId.toString()))
            .replace("{" + "tabId" + "}", localVarApiClient.escapeString(tabId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addScreenTabFieldValidateBeforeCall(Long screenId, Long tabId, AddFieldBean addFieldBean, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'screenId' is set
        if (screenId == null) {
            throw new ApiException("Missing the required parameter 'screenId' when calling addScreenTabField(Async)");
        }

        // verify the required parameter 'tabId' is set
        if (tabId == null) {
            throw new ApiException("Missing the required parameter 'tabId' when calling addScreenTabField(Async)");
        }

        // verify the required parameter 'addFieldBean' is set
        if (addFieldBean == null) {
            throw new ApiException("Missing the required parameter 'addFieldBean' when calling addScreenTabField(Async)");
        }

        return addScreenTabFieldCall(screenId, tabId, addFieldBean, _callback);

    }

    /**
     * Add screen tab field
     * Adds a field to a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param addFieldBean  (required)
     * @return ScreenableField
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ScreenableField addScreenTabField(Long screenId, Long tabId, AddFieldBean addFieldBean) throws ApiException {
        ApiResponse<ScreenableField> localVarResp = addScreenTabFieldWithHttpInfo(screenId, tabId, addFieldBean);
        return localVarResp.getData();
    }

    /**
     * Add screen tab field
     * Adds a field to a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param addFieldBean  (required)
     * @return ApiResponse&lt;ScreenableField&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ScreenableField> addScreenTabFieldWithHttpInfo(Long screenId, Long tabId, AddFieldBean addFieldBean) throws ApiException {
        okhttp3.Call localVarCall = addScreenTabFieldValidateBeforeCall(screenId, tabId, addFieldBean, null);
        Type localVarReturnType = new TypeToken<ScreenableField>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add screen tab field (asynchronously)
     * Adds a field to a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param addFieldBean  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addScreenTabFieldAsync(Long screenId, Long tabId, AddFieldBean addFieldBean, final ApiCallback<ScreenableField> _callback) throws ApiException {

        okhttp3.Call localVarCall = addScreenTabFieldValidateBeforeCall(screenId, tabId, addFieldBean, _callback);
        Type localVarReturnType = new TypeToken<ScreenableField>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllScreenTabFields
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param projectKey The key of the project. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen or screen tab is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllScreenTabFieldsCall(Long screenId, Long tabId, String projectKey, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/screens/{screenId}/tabs/{tabId}/fields"
            .replace("{" + "screenId" + "}", localVarApiClient.escapeString(screenId.toString()))
            .replace("{" + "tabId" + "}", localVarApiClient.escapeString(tabId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (projectKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("projectKey", projectKey));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllScreenTabFieldsValidateBeforeCall(Long screenId, Long tabId, String projectKey, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'screenId' is set
        if (screenId == null) {
            throw new ApiException("Missing the required parameter 'screenId' when calling getAllScreenTabFields(Async)");
        }

        // verify the required parameter 'tabId' is set
        if (tabId == null) {
            throw new ApiException("Missing the required parameter 'tabId' when calling getAllScreenTabFields(Async)");
        }

        return getAllScreenTabFieldsCall(screenId, tabId, projectKey, _callback);

    }

    /**
     * Get all screen tab fields
     * Returns all fields for a screen tab.  **[Permissions](#permissions) required:**   *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) when the project key is specified, providing that the screen is associated with the project through a Screen Scheme and Issue Type Screen Scheme.
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param projectKey The key of the project. (optional)
     * @return List&lt;ScreenableField&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen or screen tab is not found. </td><td>  -  </td></tr>
     </table>
     */
    public List<ScreenableField> getAllScreenTabFields(Long screenId, Long tabId, String projectKey) throws ApiException {
        ApiResponse<List<ScreenableField>> localVarResp = getAllScreenTabFieldsWithHttpInfo(screenId, tabId, projectKey);
        return localVarResp.getData();
    }

    /**
     * Get all screen tab fields
     * Returns all fields for a screen tab.  **[Permissions](#permissions) required:**   *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) when the project key is specified, providing that the screen is associated with the project through a Screen Scheme and Issue Type Screen Scheme.
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param projectKey The key of the project. (optional)
     * @return ApiResponse&lt;List&lt;ScreenableField&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen or screen tab is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ScreenableField>> getAllScreenTabFieldsWithHttpInfo(Long screenId, Long tabId, String projectKey) throws ApiException {
        okhttp3.Call localVarCall = getAllScreenTabFieldsValidateBeforeCall(screenId, tabId, projectKey, null);
        Type localVarReturnType = new TypeToken<List<ScreenableField>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all screen tab fields (asynchronously)
     * Returns all fields for a screen tab.  **[Permissions](#permissions) required:**   *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) when the project key is specified, providing that the screen is associated with the project through a Screen Scheme and Issue Type Screen Scheme.
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param projectKey The key of the project. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen or screen tab is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllScreenTabFieldsAsync(Long screenId, Long tabId, String projectKey, final ApiCallback<List<ScreenableField>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllScreenTabFieldsValidateBeforeCall(screenId, tabId, projectKey, _callback);
        Type localVarReturnType = new TypeToken<List<ScreenableField>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for moveScreenTabField
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @param moveFieldBean  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found or the field can&#39;t be moved to the requested position. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call moveScreenTabFieldCall(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = moveFieldBean;

        // create path and map variables
        String localVarPath = "/rest/api/3/screens/{screenId}/tabs/{tabId}/fields/{id}/move"
            .replace("{" + "screenId" + "}", localVarApiClient.escapeString(screenId.toString()))
            .replace("{" + "tabId" + "}", localVarApiClient.escapeString(tabId.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call moveScreenTabFieldValidateBeforeCall(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'screenId' is set
        if (screenId == null) {
            throw new ApiException("Missing the required parameter 'screenId' when calling moveScreenTabField(Async)");
        }

        // verify the required parameter 'tabId' is set
        if (tabId == null) {
            throw new ApiException("Missing the required parameter 'tabId' when calling moveScreenTabField(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling moveScreenTabField(Async)");
        }

        // verify the required parameter 'moveFieldBean' is set
        if (moveFieldBean == null) {
            throw new ApiException("Missing the required parameter 'moveFieldBean' when calling moveScreenTabField(Async)");
        }

        return moveScreenTabFieldCall(screenId, tabId, id, moveFieldBean, _callback);

    }

    /**
     * Move screen tab field
     * Moves a screen tab field.  If &#x60;after&#x60; and &#x60;position&#x60; are provided in the request, &#x60;position&#x60; is ignored.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @param moveFieldBean  (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found or the field can&#39;t be moved to the requested position. </td><td>  -  </td></tr>
     </table>
     */
    public Object moveScreenTabField(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean) throws ApiException {
        ApiResponse<Object> localVarResp = moveScreenTabFieldWithHttpInfo(screenId, tabId, id, moveFieldBean);
        return localVarResp.getData();
    }

    /**
     * Move screen tab field
     * Moves a screen tab field.  If &#x60;after&#x60; and &#x60;position&#x60; are provided in the request, &#x60;position&#x60; is ignored.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @param moveFieldBean  (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found or the field can&#39;t be moved to the requested position. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> moveScreenTabFieldWithHttpInfo(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean) throws ApiException {
        okhttp3.Call localVarCall = moveScreenTabFieldValidateBeforeCall(screenId, tabId, id, moveFieldBean, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Move screen tab field (asynchronously)
     * Moves a screen tab field.  If &#x60;after&#x60; and &#x60;position&#x60; are provided in the request, &#x60;position&#x60; is ignored.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @param moveFieldBean  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found or the field can&#39;t be moved to the requested position. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call moveScreenTabFieldAsync(Long screenId, Long tabId, String id, MoveFieldBean moveFieldBean, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = moveScreenTabFieldValidateBeforeCall(screenId, tabId, id, moveFieldBean, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for removeScreenTabField
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeScreenTabFieldCall(Long screenId, Long tabId, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/screens/{screenId}/tabs/{tabId}/fields/{id}"
            .replace("{" + "screenId" + "}", localVarApiClient.escapeString(screenId.toString()))
            .replace("{" + "tabId" + "}", localVarApiClient.escapeString(tabId.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call removeScreenTabFieldValidateBeforeCall(Long screenId, Long tabId, String id, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'screenId' is set
        if (screenId == null) {
            throw new ApiException("Missing the required parameter 'screenId' when calling removeScreenTabField(Async)");
        }

        // verify the required parameter 'tabId' is set
        if (tabId == null) {
            throw new ApiException("Missing the required parameter 'tabId' when calling removeScreenTabField(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling removeScreenTabField(Async)");
        }

        return removeScreenTabFieldCall(screenId, tabId, id, _callback);

    }

    /**
     * Remove screen tab field
     * Removes a field from a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public void removeScreenTabField(Long screenId, Long tabId, String id) throws ApiException {
        removeScreenTabFieldWithHttpInfo(screenId, tabId, id);
    }

    /**
     * Remove screen tab field
     * Removes a field from a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> removeScreenTabFieldWithHttpInfo(Long screenId, Long tabId, String id) throws ApiException {
        okhttp3.Call localVarCall = removeScreenTabFieldValidateBeforeCall(screenId, tabId, id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Remove screen tab field (asynchronously)
     * Removes a field from a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param screenId The ID of the screen. (required)
     * @param tabId The ID of the screen tab. (required)
     * @param id The ID of the field. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the screen, screen tab, or field is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeScreenTabFieldAsync(Long screenId, Long tabId, String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = removeScreenTabFieldValidateBeforeCall(screenId, tabId, id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
