/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.api;

import software.tnb.jira.validation.generated.ApiCallback;
import software.tnb.jira.validation.generated.ApiClient;
import software.tnb.jira.validation.generated.ApiException;
import software.tnb.jira.validation.generated.ApiResponse;
import software.tnb.jira.validation.generated.Configuration;
import software.tnb.jira.validation.generated.Pair;
import software.tnb.jira.validation.generated.ProgressRequestBody;
import software.tnb.jira.validation.generated.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import software.tnb.jira.validation.generated.model.WorkflowTransitionProperty;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.core.GenericType;

public class WorkflowTransitionPropertiesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowTransitionPropertiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowTransitionPropertiesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createWorkflowTransitionProperty
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being added, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited. (optional, default to live)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if a workflow property with the same key is present on the transition. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWorkflowTransitionPropertyCall(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/transitions/{transitionId}/properties"
            .replace("{" + "transitionId" + "}", localVarApiClient.escapeString(transitionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (workflowName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowName", workflowName));
        }

        if (workflowMode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowMode", workflowMode));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createWorkflowTransitionPropertyValidateBeforeCall(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transitionId' is set
        if (transitionId == null) {
            throw new ApiException("Missing the required parameter 'transitionId' when calling createWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling createWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'workflowName' is set
        if (workflowName == null) {
            throw new ApiException("Missing the required parameter 'workflowName' when calling createWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling createWorkflowTransitionProperty(Async)");
        }

        return createWorkflowTransitionPropertyCall(transitionId, key, workflowName, requestBody, workflowMode, _callback);

    }

    /**
     * Create workflow transition property
     * Adds a property to a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being added, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited. (optional, default to live)
     * @return WorkflowTransitionProperty
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if a workflow property with the same key is present on the transition. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public WorkflowTransitionProperty createWorkflowTransitionProperty(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode) throws ApiException {
        ApiResponse<WorkflowTransitionProperty> localVarResp = createWorkflowTransitionPropertyWithHttpInfo(transitionId, key, workflowName, requestBody, workflowMode);
        return localVarResp.getData();
    }

    /**
     * Create workflow transition property
     * Adds a property to a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being added, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited. (optional, default to live)
     * @return ApiResponse&lt;WorkflowTransitionProperty&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if a workflow property with the same key is present on the transition. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WorkflowTransitionProperty> createWorkflowTransitionPropertyWithHttpInfo(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode) throws ApiException {
        okhttp3.Call localVarCall = createWorkflowTransitionPropertyValidateBeforeCall(transitionId, key, workflowName, requestBody, workflowMode, null);
        Type localVarReturnType = new TypeToken<WorkflowTransitionProperty>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create workflow transition property (asynchronously)
     * Adds a property to a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being added, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited. (optional, default to live)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if a workflow property with the same key is present on the transition. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWorkflowTransitionPropertyAsync(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode, final ApiCallback<WorkflowTransitionProperty> _callback) throws ApiException {

        okhttp3.Call localVarCall = createWorkflowTransitionPropertyValidateBeforeCall(transitionId, key, workflowName, requestBody, workflowMode, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTransitionProperty>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteWorkflowTransitionProperty
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The name of the transition property to delete, also known as the name of the property. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, trying to delete a property that cannot be found. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteWorkflowTransitionPropertyCall(Long transitionId, String key, String workflowName, String workflowMode, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/transitions/{transitionId}/properties"
            .replace("{" + "transitionId" + "}", localVarApiClient.escapeString(transitionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (workflowName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowName", workflowName));
        }

        if (workflowMode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowMode", workflowMode));
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteWorkflowTransitionPropertyValidateBeforeCall(Long transitionId, String key, String workflowName, String workflowMode, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transitionId' is set
        if (transitionId == null) {
            throw new ApiException("Missing the required parameter 'transitionId' when calling deleteWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'workflowName' is set
        if (workflowName == null) {
            throw new ApiException("Missing the required parameter 'workflowName' when calling deleteWorkflowTransitionProperty(Async)");
        }

        return deleteWorkflowTransitionPropertyCall(transitionId, key, workflowName, workflowMode, _callback);

    }

    /**
     * Delete workflow transition property
     * Deletes a property from a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The name of the transition property to delete, also known as the name of the property. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, trying to delete a property that cannot be found. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteWorkflowTransitionProperty(Long transitionId, String key, String workflowName, String workflowMode) throws ApiException {
        deleteWorkflowTransitionPropertyWithHttpInfo(transitionId, key, workflowName, workflowMode);
    }

    /**
     * Delete workflow transition property
     * Deletes a property from a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The name of the transition property to delete, also known as the name of the property. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, trying to delete a property that cannot be found. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteWorkflowTransitionPropertyWithHttpInfo(Long transitionId, String key, String workflowName, String workflowMode) throws ApiException {
        okhttp3.Call localVarCall = deleteWorkflowTransitionPropertyValidateBeforeCall(transitionId, key, workflowName, workflowMode, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete workflow transition property (asynchronously)
     * Deletes a property from a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The name of the transition property to delete, also known as the name of the property. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, trying to delete a property that cannot be found. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteWorkflowTransitionPropertyAsync(Long transitionId, String key, String workflowName, String workflowMode, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteWorkflowTransitionPropertyValidateBeforeCall(transitionId, key, workflowName, workflowMode, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWorkflowTransitionProperties
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param includeReservedKeys Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*. (optional, default to false)
     * @param key The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned. (optional)
     * @param workflowMode The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows. (optional, default to live)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have admin permission </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition or property is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWorkflowTransitionPropertiesCall(Long transitionId, String workflowName, Boolean includeReservedKeys, String key, String workflowMode, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/transitions/{transitionId}/properties"
            .replace("{" + "transitionId" + "}", localVarApiClient.escapeString(transitionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (includeReservedKeys != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeReservedKeys", includeReservedKeys));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (workflowName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowName", workflowName));
        }

        if (workflowMode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowMode", workflowMode));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWorkflowTransitionPropertiesValidateBeforeCall(Long transitionId, String workflowName, Boolean includeReservedKeys, String key, String workflowMode, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transitionId' is set
        if (transitionId == null) {
            throw new ApiException("Missing the required parameter 'transitionId' when calling getWorkflowTransitionProperties(Async)");
        }

        // verify the required parameter 'workflowName' is set
        if (workflowName == null) {
            throw new ApiException("Missing the required parameter 'workflowName' when calling getWorkflowTransitionProperties(Async)");
        }

        return getWorkflowTransitionPropertiesCall(transitionId, workflowName, includeReservedKeys, key, workflowMode, _callback);

    }

    /**
     * Get workflow transition properties
     * Returns the properties on a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param includeReservedKeys Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*. (optional, default to false)
     * @param key The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned. (optional)
     * @param workflowMode The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows. (optional, default to live)
     * @return WorkflowTransitionProperty
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have admin permission </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition or property is not found. </td><td>  -  </td></tr>
     </table>
     */
    public WorkflowTransitionProperty getWorkflowTransitionProperties(Long transitionId, String workflowName, Boolean includeReservedKeys, String key, String workflowMode) throws ApiException {
        ApiResponse<WorkflowTransitionProperty> localVarResp = getWorkflowTransitionPropertiesWithHttpInfo(transitionId, workflowName, includeReservedKeys, key, workflowMode);
        return localVarResp.getData();
    }

    /**
     * Get workflow transition properties
     * Returns the properties on a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param includeReservedKeys Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*. (optional, default to false)
     * @param key The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned. (optional)
     * @param workflowMode The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows. (optional, default to live)
     * @return ApiResponse&lt;WorkflowTransitionProperty&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have admin permission </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition or property is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WorkflowTransitionProperty> getWorkflowTransitionPropertiesWithHttpInfo(Long transitionId, String workflowName, Boolean includeReservedKeys, String key, String workflowMode) throws ApiException {
        okhttp3.Call localVarCall = getWorkflowTransitionPropertiesValidateBeforeCall(transitionId, workflowName, includeReservedKeys, key, workflowMode, null);
        Type localVarReturnType = new TypeToken<WorkflowTransitionProperty>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get workflow transition properties (asynchronously)
     * Returns the properties on a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param includeReservedKeys Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*. (optional, default to false)
     * @param key The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned. (optional)
     * @param workflowMode The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows. (optional, default to live)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have admin permission </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition or property is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWorkflowTransitionPropertiesAsync(Long transitionId, String workflowName, Boolean includeReservedKeys, String key, String workflowMode, final ApiCallback<WorkflowTransitionProperty> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWorkflowTransitionPropertiesValidateBeforeCall(transitionId, workflowName, includeReservedKeys, key, workflowMode, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTransitionProperty>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateWorkflowTransitionProperty
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being updated, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, attempting to update a property with its current value. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateWorkflowTransitionPropertyCall(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/transitions/{transitionId}/properties"
            .replace("{" + "transitionId" + "}", localVarApiClient.escapeString(transitionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (workflowName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowName", workflowName));
        }

        if (workflowMode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowMode", workflowMode));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateWorkflowTransitionPropertyValidateBeforeCall(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transitionId' is set
        if (transitionId == null) {
            throw new ApiException("Missing the required parameter 'transitionId' when calling updateWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'workflowName' is set
        if (workflowName == null) {
            throw new ApiException("Missing the required parameter 'workflowName' when calling updateWorkflowTransitionProperty(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling updateWorkflowTransitionProperty(Async)");
        }

        return updateWorkflowTransitionPropertyCall(transitionId, key, workflowName, requestBody, workflowMode, _callback);

    }

    /**
     * Update workflow transition property
     * Updates a workflow transition by changing the property value. Trying to update a property that does not exist results in a new property being added to the transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being updated, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @return WorkflowTransitionProperty
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, attempting to update a property with its current value. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public WorkflowTransitionProperty updateWorkflowTransitionProperty(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode) throws ApiException {
        ApiResponse<WorkflowTransitionProperty> localVarResp = updateWorkflowTransitionPropertyWithHttpInfo(transitionId, key, workflowName, requestBody, workflowMode);
        return localVarResp.getData();
    }

    /**
     * Update workflow transition property
     * Updates a workflow transition by changing the property value. Trying to update a property that does not exist results in a new property being added to the transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being updated, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @return ApiResponse&lt;WorkflowTransitionProperty&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, attempting to update a property with its current value. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WorkflowTransitionProperty> updateWorkflowTransitionPropertyWithHttpInfo(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode) throws ApiException {
        okhttp3.Call localVarCall = updateWorkflowTransitionPropertyValidateBeforeCall(transitionId, key, workflowName, requestBody, workflowMode, null);
        Type localVarReturnType = new TypeToken<WorkflowTransitionProperty>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update workflow transition property (asynchronously)
     * Updates a workflow transition by changing the property value. Trying to update a property that does not exist results in a new property being added to the transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param transitionId The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
     * @param key The key of the property being updated, also known as the name of the property. Set this to the same value as the &#x60;key&#x60; defined in the request body. (required)
     * @param workflowName The name of the workflow that the transition belongs to. (required)
     * @param requestBody  (required)
     * @param workflowMode The workflow status. Set to &#x60;live&#x60; for inactive workflows or &#x60;draft&#x60; for draft workflows. Active workflows cannot be edited. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 response </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Returned if no changes were made by the request. For example, attempting to update a property with its current value. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow transition is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateWorkflowTransitionPropertyAsync(Long transitionId, String key, String workflowName, Map<String, Object> requestBody, String workflowMode, final ApiCallback<WorkflowTransitionProperty> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateWorkflowTransitionPropertyValidateBeforeCall(transitionId, key, workflowName, requestBody, workflowMode, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTransitionProperty>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
