/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.api;

import software.tnb.jira.validation.generated.ApiCallback;
import software.tnb.jira.validation.generated.ApiClient;
import software.tnb.jira.validation.generated.ApiException;
import software.tnb.jira.validation.generated.ApiResponse;
import software.tnb.jira.validation.generated.Configuration;
import software.tnb.jira.validation.generated.Pair;
import software.tnb.jira.validation.generated.ProgressRequestBody;
import software.tnb.jira.validation.generated.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import software.tnb.jira.validation.generated.model.ErrorCollection;
import software.tnb.jira.validation.generated.model.PageBeanWorkflowTransitionRules;
import java.util.Set;
import software.tnb.jira.validation.generated.model.WorkflowTransitionRulesUpdate;
import software.tnb.jira.validation.generated.model.WorkflowTransitionRulesUpdateErrors;
import software.tnb.jira.validation.generated.model.WorkflowsWithTransitionRulesDetails;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.core.GenericType;

public class WorkflowTransitionRulesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowTransitionRulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowTransitionRulesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for deleteWorkflowTransitionRuleConfigurations
     * @param workflowsWithTransitionRulesDetails  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteWorkflowTransitionRuleConfigurationsCall(WorkflowsWithTransitionRulesDetails workflowsWithTransitionRulesDetails, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = workflowsWithTransitionRulesDetails;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/rule/config/delete";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteWorkflowTransitionRuleConfigurationsValidateBeforeCall(WorkflowsWithTransitionRulesDetails workflowsWithTransitionRulesDetails, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'workflowsWithTransitionRulesDetails' is set
        if (workflowsWithTransitionRulesDetails == null) {
            throw new ApiException("Missing the required parameter 'workflowsWithTransitionRulesDetails' when calling deleteWorkflowTransitionRuleConfigurations(Async)");
        }

        return deleteWorkflowTransitionRuleConfigurationsCall(workflowsWithTransitionRulesDetails, _callback);

    }

    /**
     * Delete workflow transition rule configurations
     * Deletes workflow transition rules from one or more workflows. These rule types are supported:   *  [post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/)  *  [conditions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-condition/)  *  [validators](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-validator/)  Only rules created by the calling Connect app can be deleted.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param workflowsWithTransitionRulesDetails  (required)
     * @return WorkflowTransitionRulesUpdateErrors
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public WorkflowTransitionRulesUpdateErrors deleteWorkflowTransitionRuleConfigurations(WorkflowsWithTransitionRulesDetails workflowsWithTransitionRulesDetails) throws ApiException {
        ApiResponse<WorkflowTransitionRulesUpdateErrors> localVarResp = deleteWorkflowTransitionRuleConfigurationsWithHttpInfo(workflowsWithTransitionRulesDetails);
        return localVarResp.getData();
    }

    /**
     * Delete workflow transition rule configurations
     * Deletes workflow transition rules from one or more workflows. These rule types are supported:   *  [post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/)  *  [conditions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-condition/)  *  [validators](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-validator/)  Only rules created by the calling Connect app can be deleted.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param workflowsWithTransitionRulesDetails  (required)
     * @return ApiResponse&lt;WorkflowTransitionRulesUpdateErrors&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WorkflowTransitionRulesUpdateErrors> deleteWorkflowTransitionRuleConfigurationsWithHttpInfo(WorkflowsWithTransitionRulesDetails workflowsWithTransitionRulesDetails) throws ApiException {
        okhttp3.Call localVarCall = deleteWorkflowTransitionRuleConfigurationsValidateBeforeCall(workflowsWithTransitionRulesDetails, null);
        Type localVarReturnType = new TypeToken<WorkflowTransitionRulesUpdateErrors>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete workflow transition rule configurations (asynchronously)
     * Deletes workflow transition rules from one or more workflows. These rule types are supported:   *  [post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/)  *  [conditions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-condition/)  *  [validators](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-validator/)  Only rules created by the calling Connect app can be deleted.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param workflowsWithTransitionRulesDetails  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteWorkflowTransitionRuleConfigurationsAsync(WorkflowsWithTransitionRulesDetails workflowsWithTransitionRulesDetails, final ApiCallback<WorkflowTransitionRulesUpdateErrors> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteWorkflowTransitionRuleConfigurationsValidateBeforeCall(workflowsWithTransitionRulesDetails, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTransitionRulesUpdateErrors>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWorkflowTransitionRuleConfigurations
     * @param types The types of the transition rules to return. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 10)
     * @param keys The transition rule class keys, as defined in the Connect app descriptor, of the transition rules to return. (optional)
     * @param workflowNames EXPERIMENTAL: The list of workflow names to filter by. (optional)
     * @param withTags EXPERIMENTAL: The list of &#x60;tags&#x60; to filter by. (optional)
     * @param draft EXPERIMENTAL: Whether draft or published workflows are returned. If not provided, both workflow types are returned. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;transition&#x60;, which, for each rule, returns information about the transition the rule is assigned to. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the any transition rule type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWorkflowTransitionRuleConfigurationsCall(Set<String> types, Long startAt, Integer maxResults, Set<String> keys, Set<String> workflowNames, Set<String> withTags, Boolean draft, String expand, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/rule/config";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (types != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "types", types));
        }

        if (keys != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "keys", keys));
        }

        if (workflowNames != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "workflowNames", workflowNames));
        }

        if (withTags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "withTags", withTags));
        }

        if (draft != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("draft", draft));
        }

        if (expand != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expand", expand));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWorkflowTransitionRuleConfigurationsValidateBeforeCall(Set<String> types, Long startAt, Integer maxResults, Set<String> keys, Set<String> workflowNames, Set<String> withTags, Boolean draft, String expand, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'types' is set
        if (types == null) {
            throw new ApiException("Missing the required parameter 'types' when calling getWorkflowTransitionRuleConfigurations(Async)");
        }

        return getWorkflowTransitionRuleConfigurationsCall(types, startAt, maxResults, keys, workflowNames, withTags, draft, expand, _callback);

    }

    /**
     * Get workflow transition rule configurations
     * Returns a [paginated](#pagination) list of workflows with transition rules. The workflows can be filtered to return only those containing workflow transition rules:   *  of one or more transition rule types, such as [workflow post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/).  *  matching one or more transition rule keys.  Only workflows containing transition rules created by the calling Connect app are returned. However, if a workflow is returned all transition rules that match the filters are returned for that workflow.  Due to server-side optimizations, workflows with an empty list of rules may be returned; these workflows can be ignored.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param types The types of the transition rules to return. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 10)
     * @param keys The transition rule class keys, as defined in the Connect app descriptor, of the transition rules to return. (optional)
     * @param workflowNames EXPERIMENTAL: The list of workflow names to filter by. (optional)
     * @param withTags EXPERIMENTAL: The list of &#x60;tags&#x60; to filter by. (optional)
     * @param draft EXPERIMENTAL: Whether draft or published workflows are returned. If not provided, both workflow types are returned. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;transition&#x60;, which, for each rule, returns information about the transition the rule is assigned to. (optional)
     * @return PageBeanWorkflowTransitionRules
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the any transition rule type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanWorkflowTransitionRules getWorkflowTransitionRuleConfigurations(Set<String> types, Long startAt, Integer maxResults, Set<String> keys, Set<String> workflowNames, Set<String> withTags, Boolean draft, String expand) throws ApiException {
        ApiResponse<PageBeanWorkflowTransitionRules> localVarResp = getWorkflowTransitionRuleConfigurationsWithHttpInfo(types, startAt, maxResults, keys, workflowNames, withTags, draft, expand);
        return localVarResp.getData();
    }

    /**
     * Get workflow transition rule configurations
     * Returns a [paginated](#pagination) list of workflows with transition rules. The workflows can be filtered to return only those containing workflow transition rules:   *  of one or more transition rule types, such as [workflow post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/).  *  matching one or more transition rule keys.  Only workflows containing transition rules created by the calling Connect app are returned. However, if a workflow is returned all transition rules that match the filters are returned for that workflow.  Due to server-side optimizations, workflows with an empty list of rules may be returned; these workflows can be ignored.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param types The types of the transition rules to return. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 10)
     * @param keys The transition rule class keys, as defined in the Connect app descriptor, of the transition rules to return. (optional)
     * @param workflowNames EXPERIMENTAL: The list of workflow names to filter by. (optional)
     * @param withTags EXPERIMENTAL: The list of &#x60;tags&#x60; to filter by. (optional)
     * @param draft EXPERIMENTAL: Whether draft or published workflows are returned. If not provided, both workflow types are returned. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;transition&#x60;, which, for each rule, returns information about the transition the rule is assigned to. (optional)
     * @return ApiResponse&lt;PageBeanWorkflowTransitionRules&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the any transition rule type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanWorkflowTransitionRules> getWorkflowTransitionRuleConfigurationsWithHttpInfo(Set<String> types, Long startAt, Integer maxResults, Set<String> keys, Set<String> workflowNames, Set<String> withTags, Boolean draft, String expand) throws ApiException {
        okhttp3.Call localVarCall = getWorkflowTransitionRuleConfigurationsValidateBeforeCall(types, startAt, maxResults, keys, workflowNames, withTags, draft, expand, null);
        Type localVarReturnType = new TypeToken<PageBeanWorkflowTransitionRules>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get workflow transition rule configurations (asynchronously)
     * Returns a [paginated](#pagination) list of workflows with transition rules. The workflows can be filtered to return only those containing workflow transition rules:   *  of one or more transition rule types, such as [workflow post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/).  *  matching one or more transition rule keys.  Only workflows containing transition rules created by the calling Connect app are returned. However, if a workflow is returned all transition rules that match the filters are returned for that workflow.  Due to server-side optimizations, workflows with an empty list of rules may be returned; these workflows can be ignored.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param types The types of the transition rules to return. (required)
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 10)
     * @param keys The transition rule class keys, as defined in the Connect app descriptor, of the transition rules to return. (optional)
     * @param workflowNames EXPERIMENTAL: The list of workflow names to filter by. (optional)
     * @param withTags EXPERIMENTAL: The list of &#x60;tags&#x60; to filter by. (optional)
     * @param draft EXPERIMENTAL: Whether draft or published workflows are returned. If not provided, both workflow types are returned. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts &#x60;transition&#x60;, which, for each rule, returns information about the transition the rule is assigned to. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the any transition rule type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWorkflowTransitionRuleConfigurationsAsync(Set<String> types, Long startAt, Integer maxResults, Set<String> keys, Set<String> workflowNames, Set<String> withTags, Boolean draft, String expand, final ApiCallback<PageBeanWorkflowTransitionRules> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWorkflowTransitionRuleConfigurationsValidateBeforeCall(types, startAt, maxResults, keys, workflowNames, withTags, draft, expand, _callback);
        Type localVarReturnType = new TypeToken<PageBeanWorkflowTransitionRules>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateWorkflowTransitionRuleConfigurations
     * @param workflowTransitionRulesUpdate  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateWorkflowTransitionRuleConfigurationsCall(WorkflowTransitionRulesUpdate workflowTransitionRulesUpdate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = workflowTransitionRulesUpdate;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/rule/config";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateWorkflowTransitionRuleConfigurationsValidateBeforeCall(WorkflowTransitionRulesUpdate workflowTransitionRulesUpdate, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'workflowTransitionRulesUpdate' is set
        if (workflowTransitionRulesUpdate == null) {
            throw new ApiException("Missing the required parameter 'workflowTransitionRulesUpdate' when calling updateWorkflowTransitionRuleConfigurations(Async)");
        }

        return updateWorkflowTransitionRuleConfigurationsCall(workflowTransitionRulesUpdate, _callback);

    }

    /**
     * Update workflow transition rule configurations
     * Updates configuration of workflow transition rules. The following rule types are supported:   *  [post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/)  *  [conditions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-condition/)  *  [validators](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-validator/)  Only rules created by the calling Connect app can be updated.  To assist with app migration, this operation can be used to:   *  Disable a rule.  *  Add a &#x60;tag&#x60;. Use this to filter rules in the [Get workflow transition rule configurations](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflow-transition-rules/#api-rest-api-3-workflow-rule-config-get).  Rules are enabled if the &#x60;disabled&#x60; parameter is not provided.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param workflowTransitionRulesUpdate  (required)
     * @return WorkflowTransitionRulesUpdateErrors
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public WorkflowTransitionRulesUpdateErrors updateWorkflowTransitionRuleConfigurations(WorkflowTransitionRulesUpdate workflowTransitionRulesUpdate) throws ApiException {
        ApiResponse<WorkflowTransitionRulesUpdateErrors> localVarResp = updateWorkflowTransitionRuleConfigurationsWithHttpInfo(workflowTransitionRulesUpdate);
        return localVarResp.getData();
    }

    /**
     * Update workflow transition rule configurations
     * Updates configuration of workflow transition rules. The following rule types are supported:   *  [post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/)  *  [conditions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-condition/)  *  [validators](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-validator/)  Only rules created by the calling Connect app can be updated.  To assist with app migration, this operation can be used to:   *  Disable a rule.  *  Add a &#x60;tag&#x60;. Use this to filter rules in the [Get workflow transition rule configurations](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflow-transition-rules/#api-rest-api-3-workflow-rule-config-get).  Rules are enabled if the &#x60;disabled&#x60; parameter is not provided.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param workflowTransitionRulesUpdate  (required)
     * @return ApiResponse&lt;WorkflowTransitionRulesUpdateErrors&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WorkflowTransitionRulesUpdateErrors> updateWorkflowTransitionRuleConfigurationsWithHttpInfo(WorkflowTransitionRulesUpdate workflowTransitionRulesUpdate) throws ApiException {
        okhttp3.Call localVarCall = updateWorkflowTransitionRuleConfigurationsValidateBeforeCall(workflowTransitionRulesUpdate, null);
        Type localVarReturnType = new TypeToken<WorkflowTransitionRulesUpdateErrors>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update workflow transition rule configurations (asynchronously)
     * Updates configuration of workflow transition rules. The following rule types are supported:   *  [post functions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-post-function/)  *  [conditions](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-condition/)  *  [validators](https://developer.atlassian.com/cloud/jira/platform/modules/workflow-validator/)  Only rules created by the calling Connect app can be updated.  To assist with app migration, this operation can be used to:   *  Disable a rule.  *  Add a &#x60;tag&#x60;. Use this to filter rules in the [Get workflow transition rule configurations](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflow-transition-rules/#api-rest-api-3-workflow-rule-config-get).  Rules are enabled if the &#x60;disabled&#x60; parameter is not provided.  **[Permissions](#permissions) required:** Only Connect apps can use this operation.
     * @param workflowTransitionRulesUpdate  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is invalid. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the caller is not a Connect app. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateWorkflowTransitionRuleConfigurationsAsync(WorkflowTransitionRulesUpdate workflowTransitionRulesUpdate, final ApiCallback<WorkflowTransitionRulesUpdateErrors> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateWorkflowTransitionRuleConfigurationsValidateBeforeCall(workflowTransitionRulesUpdate, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTransitionRulesUpdateErrors>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
