/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.api;

import software.tnb.jira.validation.generated.ApiCallback;
import software.tnb.jira.validation.generated.ApiClient;
import software.tnb.jira.validation.generated.ApiException;
import software.tnb.jira.validation.generated.ApiResponse;
import software.tnb.jira.validation.generated.Configuration;
import software.tnb.jira.validation.generated.Pair;
import software.tnb.jira.validation.generated.ProgressRequestBody;
import software.tnb.jira.validation.generated.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import software.tnb.jira.validation.generated.model.CreateWorkflowDetails;
import software.tnb.jira.validation.generated.model.DeprecatedWorkflow;
import software.tnb.jira.validation.generated.model.ErrorCollection;
import software.tnb.jira.validation.generated.model.PageBeanWorkflow;
import java.util.Set;
import software.tnb.jira.validation.generated.model.WorkflowIDs;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jakarta.ws.rs.core.GenericType;

public class WorkflowsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createWorkflow
     * @param createWorkflowDetails The workflow details. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the workflow is created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if one or more statuses is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWorkflowCall(CreateWorkflowDetails createWorkflowDetails, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createWorkflowDetails;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createWorkflowValidateBeforeCall(CreateWorkflowDetails createWorkflowDetails, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createWorkflowDetails' is set
        if (createWorkflowDetails == null) {
            throw new ApiException("Missing the required parameter 'createWorkflowDetails' when calling createWorkflow(Async)");
        }

        return createWorkflowCall(createWorkflowDetails, _callback);

    }

    /**
     * Create workflow
     * Creates a workflow. You can define transition rules using the shapes detailed in the following sections. If no transitional rules are specified the default system transition rules are used.  #### Conditions ####  Conditions enable workflow rules that govern whether a transition can execute.  ##### Always false condition #####  A condition that always fails.      {        \&quot;type\&quot;: \&quot;AlwaysFalseCondition\&quot;      }  ##### Block transition until approval #####  A condition that blocks issue transition if there is a pending approval.      {        \&quot;type\&quot;: \&quot;BlockInProgressApprovalCondition\&quot;      }  ##### Compare number custom field condition #####  A condition that allows transition if a comparison between a number custom field and a value is true.      {        \&quot;type\&quot;: \&quot;CompareNumberCFCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;comparator\&quot;: \&quot;&#x3D;\&quot;,          \&quot;fieldId\&quot;: \&quot;customfield_10029\&quot;,          \&quot;fieldValue\&quot;: 2        }      }   *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&#x3D;&#x60;, &#x60;&gt;&#x60;, and &#x60;&lt;&#x60;.  *  &#x60;fieldId&#x60; The custom numeric field ID. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:float&#x60;      *  &#x60;com.pyxis.greenhopper.jira:jsw-story-points&#x60;  *  &#x60;fieldValue&#x60; The value for comparison.  ##### Hide from user condition #####  A condition that hides a transition from users. The transition can only be triggered from a workflow function or REST API operation.      {        \&quot;type\&quot;: \&quot;RemoteOnlyCondition\&quot;      }  ##### Only assignee condition #####  A condition that allows only the assignee to execute a transition.      {        \&quot;type\&quot;: \&quot;AllowOnlyAssignee\&quot;      }  ##### Only Bamboo notifications workflow condition #####  A condition that makes the transition available only to Bamboo build notifications.      {        \&quot;type\&quot;: \&quot;OnlyBambooNotificationsCondition\&quot;      }  ##### Only reporter condition #####  A condition that allows only the reporter to execute a transition.      {        \&quot;type\&quot;: \&quot;AllowOnlyReporter\&quot;      }  ##### Permission condition #####  A condition that allows only users with a permission to execute a transition.      {        \&quot;type\&quot;: \&quot;PermissionCondition\&quot;,        \&quot;configuration\&quot;: {            \&quot;permissionKey\&quot;: \&quot;BROWSE_PROJECTS\&quot;        }      }   *  &#x60;permissionKey&#x60; The permission required to perform the transition. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  ##### Previous status condition #####  A condition that allows a transition based on whether an issue has or has not transitioned through a status.      {        \&quot;type\&quot;: \&quot;PreviousStatusCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;ignoreLoopTransitions\&quot;: true,          \&quot;includeCurrentStatus\&quot;: true,          \&quot;mostRecentStatusOnly\&quot;: true,          \&quot;reverseCondition\&quot;: true,          \&quot;previousStatus\&quot;: {            \&quot;id\&quot;: \&quot;5\&quot;          }        }      }  By default this condition allows the transition if the status, as defined by its ID in the &#x60;previousStatus&#x60; object, matches any previous issue status, unless:   *  &#x60;ignoreLoopTransitions&#x60; is &#x60;true&#x60;, then loop transitions (from and to the same status) are ignored.  *  &#x60;includeCurrentStatus&#x60; is &#x60;true&#x60;, then the current issue status is also checked.  *  &#x60;mostRecentStatusOnly&#x60; is &#x60;true&#x60;, then only the issue&#39;s preceding status (the one immediately before the current status) is checked.  *  &#x60;reverseCondition&#x60; is &#x60;true&#x60;, then the status must not be present.  ##### Separation of duties condition #####  A condition that prevents a user to perform the transition, if the user has already performed a transition on the issue.      {        \&quot;type\&quot;: \&quot;SeparationOfDutiesCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fromStatus\&quot;: {            \&quot;id\&quot;: \&quot;5\&quot;          },          \&quot;toStatus\&quot;: {            \&quot;id\&quot;: \&quot;6\&quot;          }        }      }   *  &#x60;fromStatus&#x60; OPTIONAL. An object containing the ID of the source status of the transition that is blocked. If omitted any transition to &#x60;toStatus&#x60; is blocked.  *  &#x60;toStatus&#x60; An object containing the ID of the target status of the transition that is blocked.  ##### Subtask blocking condition #####  A condition that blocks transition on a parent issue if any of its subtasks are in any of one or more statuses.      {        \&quot;type\&quot;: \&quot;SubTaskBlockingCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;statuses\&quot;: [            {              \&quot;id\&quot;: \&quot;1\&quot;            },            {              \&quot;id\&quot;: \&quot;3\&quot;            }          ]        }      }   *  &#x60;statuses&#x60; A list of objects containing status IDs.  ##### User is in any group condition #####  A condition that allows users belonging to any group from a list of groups to execute a transition.      {        \&quot;type\&quot;: \&quot;UserInAnyGroupCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;groups\&quot;: [            \&quot;administrators\&quot;,            \&quot;atlassian-addons-admin\&quot;          ]        }      }   *  &#x60;groups&#x60; A list of group names.  ##### User is in any project role condition #####  A condition that allows only users with at least one project roles from a list of project roles to execute a transition.      {        \&quot;type\&quot;: \&quot;InAnyProjectRoleCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRoles\&quot;: [            {              \&quot;id\&quot;: \&quot;10002\&quot;            },            {              \&quot;id\&quot;: \&quot;10003\&quot;            },            {              \&quot;id\&quot;: \&quot;10012\&quot;            },            {              \&quot;id\&quot;: \&quot;10013\&quot;            }          ]        }      }   *  &#x60;projectRoles&#x60; A list of objects containing project role IDs.  ##### User is in custom field condition #####  A condition that allows only users listed in a given custom field to execute the transition.      {        \&quot;type\&quot;: \&quot;UserIsInCustomFieldCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;allowUserInField\&quot;: false,          \&quot;fieldId\&quot;: \&quot;customfield_10010\&quot;        }      }   *  &#x60;allowUserInField&#x60; If &#x60;true&#x60; only a user who is listed in &#x60;fieldId&#x60; can perform the transition, otherwise, only a user who is not listed in &#x60;fieldId&#x60; can perform the transition.  *  &#x60;fieldId&#x60; The ID of the field containing the list of users.  ##### User is in group condition #####  A condition that allows users belonging to a group to execute a transition.      {        \&quot;type\&quot;: \&quot;UserInGroupCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;group\&quot;: \&quot;administrators\&quot;        }      }   *  &#x60;group&#x60; The name of the group.  ##### User is in group custom field condition #####  A condition that allows users belonging to a group specified in a custom field to execute a transition.      {        \&quot;type\&quot;: \&quot;InGroupCFCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;customfield_10012\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:grouppicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:select&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multiselect&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes&#x60;      *  &#x60;com.pyxis.greenhopper.jira:gh-epic-status&#x60;  ##### User is in project role condition #####  A condition that allows users with a project role to execute a transition.      {        \&quot;type\&quot;: \&quot;InProjectRoleCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRole\&quot;: {            \&quot;id\&quot;: \&quot;10002\&quot;          }        }      }   *  &#x60;projectRole&#x60; An object containing the ID of a project role.  ##### Value field condition #####  A conditions that allows a transition to execute if the value of a field is equal to a constant value or simply set.      {        \&quot;type\&quot;: \&quot;ValueFieldCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;,          \&quot;fieldValue\&quot;: \&quot;qm:6e1ecee6-8e64-4db6-8c85-916bb3275f51:54b56885-2bd2-4381-8239-78263442520f\&quot;,          \&quot;comparisonType\&quot;: \&quot;NUMBER\&quot;,          \&quot;comparator\&quot;: \&quot;&#x3D;\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of a field used in the comparison.  *  &#x60;fieldValue&#x60; The expected value of the field.  *  &#x60;comparisonType&#x60; The type of the comparison. Allowed values: &#x60;STRING&#x60;, &#x60;NUMBER&#x60;, &#x60;DATE&#x60;, &#x60;DATE_WITHOUT_TIME&#x60;, or &#x60;OPTIONID&#x60;.  *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&gt;&#x60;, &#x60;&gt;&#x3D;&#x60;, &#x60;&#x3D;&#x60;, &#x60;&lt;&#x3D;&#x60;, &#x60;&lt;&#x60;, &#x60;!&#x3D;&#x60;.  **Notes:**   *  If you choose the comparison type &#x60;STRING&#x60;, only &#x60;&#x3D;&#x60; and &#x60;!&#x3D;&#x60; are valid options.  *  You may leave &#x60;fieldValue&#x60; empty when comparison type is &#x60;!&#x3D;&#x60; to indicate that a value is required in the field.  *  For date fields without time format values as &#x60;yyyy-MM-dd&#x60;, and for those with time as &#x60;yyyy-MM-dd HH:mm&#x60;. For example, for July 16 2021 use &#x60;2021-07-16&#x60;, for 8:05 AM use &#x60;2021-07-16 08:05&#x60;, and for 4 PM: &#x60;2021-07-16 16:00&#x60;.  #### Validators ####  Validators check that any input made to the transition is valid before the transition is performed.  ##### Date field validator #####  A validator that compares two dates.      {        \&quot;type\&quot;: \&quot;DateFieldValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;comparator\&quot;: \&quot;&gt;\&quot;,            \&quot;date1\&quot;: \&quot;updated\&quot;,            \&quot;date2\&quot;: \&quot;created\&quot;,            \&quot;expression\&quot;: \&quot;1d\&quot;,            \&quot;includeTime\&quot;: true          }      }   *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&gt;&#x60;, &#x60;&gt;&#x3D;&#x60;, &#x60;&#x3D;&#x60;, &#x60;&lt;&#x3D;&#x60;, &#x60;&lt;&#x60;, or &#x60;!&#x3D;&#x60;.  *  &#x60;date1&#x60; The date field to validate. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;date2&#x60; The second date field. Required, if &#x60;expression&#x60; is not passed. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;expression&#x60; An expression specifying an offset. Required, if &#x60;date2&#x60; is not passed. Offsets are built with a number, with &#x60;-&#x60; as prefix for the past, and one of these time units: &#x60;d&#x60; for day, &#x60;w&#x60; for week, &#x60;m&#x60; for month, or &#x60;y&#x60; for year. For example, -2d means two days into the past and 1w means one week into the future. The &#x60;now&#x60; keyword enables a comparison with the current date.  *  &#x60;includeTime&#x60; If &#x60;true&#x60;, then the time part of the data is included for the comparison. If the field doesn&#39;t have a time part, 00:00:00 is used.  ##### Windows date validator #####  A validator that checks that a date falls on or after a reference date and before or on the reference date plus a number of days.      {        \&quot;type\&quot;: \&quot;WindowsDateValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;date1\&quot;: \&quot;customfield_10009\&quot;,            \&quot;date2\&quot;: \&quot;created\&quot;,            \&quot;windowsDays\&quot;: 5          }      }   *  &#x60;date1&#x60; The date field to validate. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;date2&#x60; The reference date. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;windowsDays&#x60; A positive integer indicating a number of days.  ##### Field required validator #####  A validator that checks fields are not empty. By default, if a field is not included in the current context it&#39;s ignored and not validated.      {          \&quot;type\&quot;: \&quot;FieldRequiredValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;ignoreContext\&quot;: true,              \&quot;errorMessage\&quot;: \&quot;Hey\&quot;,              \&quot;fieldIds\&quot;: [                  \&quot;versions\&quot;,                  \&quot;customfield_10037\&quot;,                  \&quot;customfield_10003\&quot;              ]          }      }   *  &#x60;ignoreContext&#x60; If &#x60;true&#x60;, then the context is ignored and all the fields are validated.  *  &#x60;errorMessage&#x60; OPTIONAL. The error message displayed when one or more fields are empty. A default error message is shown if an error message is not provided.  *  &#x60;fieldIds&#x60; The list of fields to validate.  ##### Field changed validator #####  A validator that checks that a field value is changed. However, this validation can be ignored for users from a list of groups.      {          \&quot;type\&quot;: \&quot;FieldChangedValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;fieldId\&quot;: \&quot;comment\&quot;,              \&quot;errorMessage\&quot;: \&quot;Hey\&quot;,              \&quot;exemptedGroups\&quot;: [                  \&quot;administrators\&quot;,                  \&quot;atlassian-addons-admin\&quot;              ]          }      }   *  &#x60;fieldId&#x60; The ID of a field.  *  &#x60;errorMessage&#x60; OPTIONAL. The error message displayed if the field is not changed. A default error message is shown if the error message is not provided.  *  &#x60;exemptedGroups&#x60; OPTIONAL. The list of groups.  ##### Field has single value validator #####  A validator that checks that a multi-select field has only one value. Optionally, the validation can ignore values copied from subtasks.      {          \&quot;type\&quot;: \&quot;FieldHasSingleValueValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;fieldId\&quot;: \&quot;attachment,              \&quot;excludeSubtasks\&quot;: true          }      }   *  &#x60;fieldId&#x60; The ID of a field.  *  &#x60;excludeSubtasks&#x60; If &#x60;true&#x60;, then values copied from subtasks are ignored.  ##### Parent status validator #####  A validator that checks the status of the parent issue of a subtask. Ìf the issue is not a subtask, no validation is performed.      {          \&quot;type\&quot;: \&quot;ParentStatusValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;parentStatuses\&quot;: [                  {                    \&quot;id\&quot;:\&quot;1\&quot;                  },                  {                    \&quot;id\&quot;:\&quot;2\&quot;                  }              ]          }      }   *  &#x60;parentStatus&#x60; The list of required parent issue statuses.  ##### Permission validator #####  A validator that checks the user has a permission.      {        \&quot;type\&quot;: \&quot;PermissionValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;permissionKey\&quot;: \&quot;ADMINISTER_PROJECTS\&quot;        }      }   *  &#x60;permissionKey&#x60; The permission required to perform the transition. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  ##### Previous status validator #####  A validator that checks if the issue has held a status.      {        \&quot;type\&quot;: \&quot;PreviousStatusValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;mostRecentStatusOnly\&quot;: false,            \&quot;previousStatus\&quot;: {                \&quot;id\&quot;: \&quot;15\&quot;            }        }      }   *  &#x60;mostRecentStatusOnly&#x60; If &#x60;true&#x60;, then only the issue&#39;s preceding status (the one immediately before the current status) is checked.  *  &#x60;previousStatus&#x60; An object containing the ID of an issue status.  ##### Regular expression validator #####  A validator that checks the content of a field against a regular expression.      {        \&quot;type\&quot;: \&quot;RegexpFieldValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;regExp\&quot;: \&quot;[0-9]\&quot;,            \&quot;fieldId\&quot;: \&quot;customfield_10029\&quot;        }      }   *  &#x60;regExp&#x60;A regular expression.  *  &#x60;fieldId&#x60; The ID of a field. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:select&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multiselect&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:textarea&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:textfield&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:url&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:float&#x60;      *  &#x60;com.pyxis.greenhopper.jira:jsw-story-points&#x60;      *  &#x60;com.pyxis.greenhopper.jira:gh-epic-status&#x60;      *  &#x60;description&#x60;      *  &#x60;summary&#x60;  ##### User permission validator #####  A validator that checks if a user has a permission. Obsolete. You may encounter this validator when getting transition rules and can pass it when updating or creating rules, for example, when you want to duplicate the rules from a workflow on a new workflow.      {          \&quot;type\&quot;: \&quot;UserPermissionValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;permissionKey\&quot;: \&quot;BROWSE_PROJECTS\&quot;,              \&quot;nullAllowed\&quot;: false,              \&quot;username\&quot;: \&quot;TestUser\&quot;          }      }   *  &#x60;permissionKey&#x60; The permission to be validated. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  *  &#x60;nullAllowed&#x60; If &#x60;true&#x60;, allows the transition when &#x60;username&#x60; is empty.  *  &#x60;username&#x60; The username to validate against the &#x60;permissionKey&#x60;.  #### Post functions ####  Post functions carry out any additional processing required after a Jira workflow transition is executed.  ##### Fire issue event function #####  A post function that fires an event that is processed by the listeners.      {        \&quot;type\&quot;: \&quot;FireIssueEventFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;event\&quot;: {            \&quot;id\&quot;:\&quot;1\&quot;          }        }      }  **Note:** If provided, this post function overrides the default &#x60;FireIssueEventFunction&#x60;. Can be included once in a transition.   *  &#x60;event&#x60; An object containing the ID of the issue event.  ##### Update issue status #####  A post function that sets issue status to the linked status of the destination workflow status.      {        \&quot;type\&quot;: \&quot;UpdateIssueStatusFunction\&quot;      }  **Note:** This post function is a default function in global and directed transitions. It can only be added to the initial transition and can only be added once.  ##### Create comment #####  A post function that adds a comment entered during the transition to an issue.      {        \&quot;type\&quot;: \&quot;CreateCommentFunction\&quot;      }  **Note:** This post function is a default function in global and directed transitions. It can only be added to the initial transition and can only be added once.  ##### Store issue #####  A post function that stores updates to an issue.      {        \&quot;type\&quot;: \&quot;IssueStoreFunction\&quot;      }  **Note:** This post function can only be added to the initial transition and can only be added once.  ##### Assign to current user function #####  A post function that assigns the issue to the current user if the current user has the &#x60;ASSIGNABLE_USER&#x60; permission.      {          \&quot;type\&quot;: \&quot;AssignToCurrentUserFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Assign to lead function #####  A post function that assigns the issue to the project or component lead developer.      {          \&quot;type\&quot;: \&quot;AssignToLeadFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Assign to reporter function #####  A post function that assigns the issue to the reporter.      {          \&quot;type\&quot;: \&quot;AssignToReporterFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Clear field value function #####  A post function that clears the value from a field.      {        \&quot;type\&quot;: \&quot;ClearFieldValuePostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field.  ##### Copy value from other field function #####  A post function that copies the value of one field to another, either within an issue or from parent to subtask.      {        \&quot;type\&quot;: \&quot;CopyValueFromOtherFieldPostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;sourceFieldId\&quot;: \&quot;assignee\&quot;,          \&quot;destinationFieldId\&quot;: \&quot;creator\&quot;,          \&quot;copyType\&quot;: \&quot;same\&quot;        }      }   *  &#x60;sourceFieldId&#x60; The ID of the source field.  *  &#x60;destinationFieldId&#x60; The ID of the destination field.  *  &#x60;copyType&#x60; Use &#x60;same&#x60; to copy the value from a field inside the issue, or &#x60;parent&#x60; to copy the value from the parent issue.  ##### Create Crucible review workflow function #####  A post function that creates a Crucible review for all unreviewed code for the issue.      {          \&quot;type\&quot;: \&quot;CreateCrucibleReviewWorkflowFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Set issue security level based on user&#39;s project role function #####  A post function that sets the issue&#39;s security level if the current user has a project role.      {        \&quot;type\&quot;: \&quot;SetIssueSecurityFromRoleFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRole\&quot;: {              \&quot;id\&quot;:\&quot;10002\&quot;          },          \&quot;issueSecurityLevel\&quot;: {              \&quot;id\&quot;:\&quot;10000\&quot;          }        }      }   *  &#x60;projectRole&#x60; An object containing the ID of the project role.  *  &#x60;issueSecurityLevel&#x60; OPTIONAL. The object containing the ID of the security level. If not passed, then the security level is set to &#x60;none&#x60;.  ##### Trigger a webhook function #####  A post function that triggers a webhook.      {        \&quot;type\&quot;: \&quot;TriggerWebhookFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;webhook\&quot;: {            \&quot;id\&quot;: \&quot;1\&quot;          }        }      }   *  &#x60;webhook&#x60; An object containing the ID of the webhook listener to trigger.  ##### Update issue custom field function #####  A post function that updates the content of an issue custom field.      {        \&quot;type\&quot;: \&quot;UpdateIssueCustomFieldPostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;mode\&quot;: \&quot;append\&quot;,          \&quot;fieldId\&quot;: \&quot;customfield_10003\&quot;,          \&quot;fieldValue\&quot;: \&quot;yikes\&quot;        }      }   *  &#x60;mode&#x60; Use &#x60;replace&#x60; to override the field content with &#x60;fieldValue&#x60; or &#x60;append&#x60; to add &#x60;fieldValue&#x60; to the end of the field content.  *  &#x60;fieldId&#x60; The ID of the field.  *  &#x60;fieldValue&#x60; The update content.  ##### Update issue field function #####  A post function that updates a simple issue field.      {        \&quot;type\&quot;: \&quot;UpdateIssueFieldFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;,          \&quot;fieldValue\&quot;: \&quot;5f0c277e70b8a90025a00776\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field. Allowed field types:           *  &#x60;assignee&#x60;      *  &#x60;description&#x60;      *  &#x60;environment&#x60;      *  &#x60;priority&#x60;      *  &#x60;resolution&#x60;      *  &#x60;summary&#x60;      *  &#x60;timeoriginalestimate&#x60;      *  &#x60;timeestimate&#x60;      *  &#x60;timespent&#x60;  *  &#x60;fieldValue&#x60; The update value.  *  If the &#x60;fieldId&#x60; is &#x60;assignee&#x60;, the &#x60;fieldValue&#x60; should be one of these values:           *  an account ID.      *  &#x60;automatic&#x60;.      *  a blank string, which sets the value to &#x60;unassigned&#x60;.  #### Connect rules ####  Connect rules are conditions, validators, and post functions of a transition that are registered by Connect apps. To create a rule registered by the app, the app must be enabled and the rule&#39;s module must exist.      {        \&quot;type\&quot;: \&quot;appKey__moduleKey\&quot;,        \&quot;configuration\&quot;: {          \&quot;value\&quot;:\&quot;{\\\&quot;isValid\\\&quot;:\\\&quot;true\\\&quot;}\&quot;        }      }   *  &#x60;type&#x60; A Connect rule key in a form of &#x60;appKey__moduleKey&#x60;.  *  &#x60;value&#x60; The stringified JSON configuration of a Connect rule.  #### Forge rules ####  Forge transition rules are not yet supported.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param createWorkflowDetails The workflow details. (required)
     * @return WorkflowIDs
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the workflow is created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if one or more statuses is not found. </td><td>  -  </td></tr>
     </table>
     */
    public WorkflowIDs createWorkflow(CreateWorkflowDetails createWorkflowDetails) throws ApiException {
        ApiResponse<WorkflowIDs> localVarResp = createWorkflowWithHttpInfo(createWorkflowDetails);
        return localVarResp.getData();
    }

    /**
     * Create workflow
     * Creates a workflow. You can define transition rules using the shapes detailed in the following sections. If no transitional rules are specified the default system transition rules are used.  #### Conditions ####  Conditions enable workflow rules that govern whether a transition can execute.  ##### Always false condition #####  A condition that always fails.      {        \&quot;type\&quot;: \&quot;AlwaysFalseCondition\&quot;      }  ##### Block transition until approval #####  A condition that blocks issue transition if there is a pending approval.      {        \&quot;type\&quot;: \&quot;BlockInProgressApprovalCondition\&quot;      }  ##### Compare number custom field condition #####  A condition that allows transition if a comparison between a number custom field and a value is true.      {        \&quot;type\&quot;: \&quot;CompareNumberCFCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;comparator\&quot;: \&quot;&#x3D;\&quot;,          \&quot;fieldId\&quot;: \&quot;customfield_10029\&quot;,          \&quot;fieldValue\&quot;: 2        }      }   *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&#x3D;&#x60;, &#x60;&gt;&#x60;, and &#x60;&lt;&#x60;.  *  &#x60;fieldId&#x60; The custom numeric field ID. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:float&#x60;      *  &#x60;com.pyxis.greenhopper.jira:jsw-story-points&#x60;  *  &#x60;fieldValue&#x60; The value for comparison.  ##### Hide from user condition #####  A condition that hides a transition from users. The transition can only be triggered from a workflow function or REST API operation.      {        \&quot;type\&quot;: \&quot;RemoteOnlyCondition\&quot;      }  ##### Only assignee condition #####  A condition that allows only the assignee to execute a transition.      {        \&quot;type\&quot;: \&quot;AllowOnlyAssignee\&quot;      }  ##### Only Bamboo notifications workflow condition #####  A condition that makes the transition available only to Bamboo build notifications.      {        \&quot;type\&quot;: \&quot;OnlyBambooNotificationsCondition\&quot;      }  ##### Only reporter condition #####  A condition that allows only the reporter to execute a transition.      {        \&quot;type\&quot;: \&quot;AllowOnlyReporter\&quot;      }  ##### Permission condition #####  A condition that allows only users with a permission to execute a transition.      {        \&quot;type\&quot;: \&quot;PermissionCondition\&quot;,        \&quot;configuration\&quot;: {            \&quot;permissionKey\&quot;: \&quot;BROWSE_PROJECTS\&quot;        }      }   *  &#x60;permissionKey&#x60; The permission required to perform the transition. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  ##### Previous status condition #####  A condition that allows a transition based on whether an issue has or has not transitioned through a status.      {        \&quot;type\&quot;: \&quot;PreviousStatusCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;ignoreLoopTransitions\&quot;: true,          \&quot;includeCurrentStatus\&quot;: true,          \&quot;mostRecentStatusOnly\&quot;: true,          \&quot;reverseCondition\&quot;: true,          \&quot;previousStatus\&quot;: {            \&quot;id\&quot;: \&quot;5\&quot;          }        }      }  By default this condition allows the transition if the status, as defined by its ID in the &#x60;previousStatus&#x60; object, matches any previous issue status, unless:   *  &#x60;ignoreLoopTransitions&#x60; is &#x60;true&#x60;, then loop transitions (from and to the same status) are ignored.  *  &#x60;includeCurrentStatus&#x60; is &#x60;true&#x60;, then the current issue status is also checked.  *  &#x60;mostRecentStatusOnly&#x60; is &#x60;true&#x60;, then only the issue&#39;s preceding status (the one immediately before the current status) is checked.  *  &#x60;reverseCondition&#x60; is &#x60;true&#x60;, then the status must not be present.  ##### Separation of duties condition #####  A condition that prevents a user to perform the transition, if the user has already performed a transition on the issue.      {        \&quot;type\&quot;: \&quot;SeparationOfDutiesCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fromStatus\&quot;: {            \&quot;id\&quot;: \&quot;5\&quot;          },          \&quot;toStatus\&quot;: {            \&quot;id\&quot;: \&quot;6\&quot;          }        }      }   *  &#x60;fromStatus&#x60; OPTIONAL. An object containing the ID of the source status of the transition that is blocked. If omitted any transition to &#x60;toStatus&#x60; is blocked.  *  &#x60;toStatus&#x60; An object containing the ID of the target status of the transition that is blocked.  ##### Subtask blocking condition #####  A condition that blocks transition on a parent issue if any of its subtasks are in any of one or more statuses.      {        \&quot;type\&quot;: \&quot;SubTaskBlockingCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;statuses\&quot;: [            {              \&quot;id\&quot;: \&quot;1\&quot;            },            {              \&quot;id\&quot;: \&quot;3\&quot;            }          ]        }      }   *  &#x60;statuses&#x60; A list of objects containing status IDs.  ##### User is in any group condition #####  A condition that allows users belonging to any group from a list of groups to execute a transition.      {        \&quot;type\&quot;: \&quot;UserInAnyGroupCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;groups\&quot;: [            \&quot;administrators\&quot;,            \&quot;atlassian-addons-admin\&quot;          ]        }      }   *  &#x60;groups&#x60; A list of group names.  ##### User is in any project role condition #####  A condition that allows only users with at least one project roles from a list of project roles to execute a transition.      {        \&quot;type\&quot;: \&quot;InAnyProjectRoleCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRoles\&quot;: [            {              \&quot;id\&quot;: \&quot;10002\&quot;            },            {              \&quot;id\&quot;: \&quot;10003\&quot;            },            {              \&quot;id\&quot;: \&quot;10012\&quot;            },            {              \&quot;id\&quot;: \&quot;10013\&quot;            }          ]        }      }   *  &#x60;projectRoles&#x60; A list of objects containing project role IDs.  ##### User is in custom field condition #####  A condition that allows only users listed in a given custom field to execute the transition.      {        \&quot;type\&quot;: \&quot;UserIsInCustomFieldCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;allowUserInField\&quot;: false,          \&quot;fieldId\&quot;: \&quot;customfield_10010\&quot;        }      }   *  &#x60;allowUserInField&#x60; If &#x60;true&#x60; only a user who is listed in &#x60;fieldId&#x60; can perform the transition, otherwise, only a user who is not listed in &#x60;fieldId&#x60; can perform the transition.  *  &#x60;fieldId&#x60; The ID of the field containing the list of users.  ##### User is in group condition #####  A condition that allows users belonging to a group to execute a transition.      {        \&quot;type\&quot;: \&quot;UserInGroupCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;group\&quot;: \&quot;administrators\&quot;        }      }   *  &#x60;group&#x60; The name of the group.  ##### User is in group custom field condition #####  A condition that allows users belonging to a group specified in a custom field to execute a transition.      {        \&quot;type\&quot;: \&quot;InGroupCFCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;customfield_10012\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:grouppicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:select&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multiselect&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes&#x60;      *  &#x60;com.pyxis.greenhopper.jira:gh-epic-status&#x60;  ##### User is in project role condition #####  A condition that allows users with a project role to execute a transition.      {        \&quot;type\&quot;: \&quot;InProjectRoleCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRole\&quot;: {            \&quot;id\&quot;: \&quot;10002\&quot;          }        }      }   *  &#x60;projectRole&#x60; An object containing the ID of a project role.  ##### Value field condition #####  A conditions that allows a transition to execute if the value of a field is equal to a constant value or simply set.      {        \&quot;type\&quot;: \&quot;ValueFieldCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;,          \&quot;fieldValue\&quot;: \&quot;qm:6e1ecee6-8e64-4db6-8c85-916bb3275f51:54b56885-2bd2-4381-8239-78263442520f\&quot;,          \&quot;comparisonType\&quot;: \&quot;NUMBER\&quot;,          \&quot;comparator\&quot;: \&quot;&#x3D;\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of a field used in the comparison.  *  &#x60;fieldValue&#x60; The expected value of the field.  *  &#x60;comparisonType&#x60; The type of the comparison. Allowed values: &#x60;STRING&#x60;, &#x60;NUMBER&#x60;, &#x60;DATE&#x60;, &#x60;DATE_WITHOUT_TIME&#x60;, or &#x60;OPTIONID&#x60;.  *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&gt;&#x60;, &#x60;&gt;&#x3D;&#x60;, &#x60;&#x3D;&#x60;, &#x60;&lt;&#x3D;&#x60;, &#x60;&lt;&#x60;, &#x60;!&#x3D;&#x60;.  **Notes:**   *  If you choose the comparison type &#x60;STRING&#x60;, only &#x60;&#x3D;&#x60; and &#x60;!&#x3D;&#x60; are valid options.  *  You may leave &#x60;fieldValue&#x60; empty when comparison type is &#x60;!&#x3D;&#x60; to indicate that a value is required in the field.  *  For date fields without time format values as &#x60;yyyy-MM-dd&#x60;, and for those with time as &#x60;yyyy-MM-dd HH:mm&#x60;. For example, for July 16 2021 use &#x60;2021-07-16&#x60;, for 8:05 AM use &#x60;2021-07-16 08:05&#x60;, and for 4 PM: &#x60;2021-07-16 16:00&#x60;.  #### Validators ####  Validators check that any input made to the transition is valid before the transition is performed.  ##### Date field validator #####  A validator that compares two dates.      {        \&quot;type\&quot;: \&quot;DateFieldValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;comparator\&quot;: \&quot;&gt;\&quot;,            \&quot;date1\&quot;: \&quot;updated\&quot;,            \&quot;date2\&quot;: \&quot;created\&quot;,            \&quot;expression\&quot;: \&quot;1d\&quot;,            \&quot;includeTime\&quot;: true          }      }   *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&gt;&#x60;, &#x60;&gt;&#x3D;&#x60;, &#x60;&#x3D;&#x60;, &#x60;&lt;&#x3D;&#x60;, &#x60;&lt;&#x60;, or &#x60;!&#x3D;&#x60;.  *  &#x60;date1&#x60; The date field to validate. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;date2&#x60; The second date field. Required, if &#x60;expression&#x60; is not passed. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;expression&#x60; An expression specifying an offset. Required, if &#x60;date2&#x60; is not passed. Offsets are built with a number, with &#x60;-&#x60; as prefix for the past, and one of these time units: &#x60;d&#x60; for day, &#x60;w&#x60; for week, &#x60;m&#x60; for month, or &#x60;y&#x60; for year. For example, -2d means two days into the past and 1w means one week into the future. The &#x60;now&#x60; keyword enables a comparison with the current date.  *  &#x60;includeTime&#x60; If &#x60;true&#x60;, then the time part of the data is included for the comparison. If the field doesn&#39;t have a time part, 00:00:00 is used.  ##### Windows date validator #####  A validator that checks that a date falls on or after a reference date and before or on the reference date plus a number of days.      {        \&quot;type\&quot;: \&quot;WindowsDateValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;date1\&quot;: \&quot;customfield_10009\&quot;,            \&quot;date2\&quot;: \&quot;created\&quot;,            \&quot;windowsDays\&quot;: 5          }      }   *  &#x60;date1&#x60; The date field to validate. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;date2&#x60; The reference date. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;windowsDays&#x60; A positive integer indicating a number of days.  ##### Field required validator #####  A validator that checks fields are not empty. By default, if a field is not included in the current context it&#39;s ignored and not validated.      {          \&quot;type\&quot;: \&quot;FieldRequiredValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;ignoreContext\&quot;: true,              \&quot;errorMessage\&quot;: \&quot;Hey\&quot;,              \&quot;fieldIds\&quot;: [                  \&quot;versions\&quot;,                  \&quot;customfield_10037\&quot;,                  \&quot;customfield_10003\&quot;              ]          }      }   *  &#x60;ignoreContext&#x60; If &#x60;true&#x60;, then the context is ignored and all the fields are validated.  *  &#x60;errorMessage&#x60; OPTIONAL. The error message displayed when one or more fields are empty. A default error message is shown if an error message is not provided.  *  &#x60;fieldIds&#x60; The list of fields to validate.  ##### Field changed validator #####  A validator that checks that a field value is changed. However, this validation can be ignored for users from a list of groups.      {          \&quot;type\&quot;: \&quot;FieldChangedValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;fieldId\&quot;: \&quot;comment\&quot;,              \&quot;errorMessage\&quot;: \&quot;Hey\&quot;,              \&quot;exemptedGroups\&quot;: [                  \&quot;administrators\&quot;,                  \&quot;atlassian-addons-admin\&quot;              ]          }      }   *  &#x60;fieldId&#x60; The ID of a field.  *  &#x60;errorMessage&#x60; OPTIONAL. The error message displayed if the field is not changed. A default error message is shown if the error message is not provided.  *  &#x60;exemptedGroups&#x60; OPTIONAL. The list of groups.  ##### Field has single value validator #####  A validator that checks that a multi-select field has only one value. Optionally, the validation can ignore values copied from subtasks.      {          \&quot;type\&quot;: \&quot;FieldHasSingleValueValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;fieldId\&quot;: \&quot;attachment,              \&quot;excludeSubtasks\&quot;: true          }      }   *  &#x60;fieldId&#x60; The ID of a field.  *  &#x60;excludeSubtasks&#x60; If &#x60;true&#x60;, then values copied from subtasks are ignored.  ##### Parent status validator #####  A validator that checks the status of the parent issue of a subtask. Ìf the issue is not a subtask, no validation is performed.      {          \&quot;type\&quot;: \&quot;ParentStatusValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;parentStatuses\&quot;: [                  {                    \&quot;id\&quot;:\&quot;1\&quot;                  },                  {                    \&quot;id\&quot;:\&quot;2\&quot;                  }              ]          }      }   *  &#x60;parentStatus&#x60; The list of required parent issue statuses.  ##### Permission validator #####  A validator that checks the user has a permission.      {        \&quot;type\&quot;: \&quot;PermissionValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;permissionKey\&quot;: \&quot;ADMINISTER_PROJECTS\&quot;        }      }   *  &#x60;permissionKey&#x60; The permission required to perform the transition. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  ##### Previous status validator #####  A validator that checks if the issue has held a status.      {        \&quot;type\&quot;: \&quot;PreviousStatusValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;mostRecentStatusOnly\&quot;: false,            \&quot;previousStatus\&quot;: {                \&quot;id\&quot;: \&quot;15\&quot;            }        }      }   *  &#x60;mostRecentStatusOnly&#x60; If &#x60;true&#x60;, then only the issue&#39;s preceding status (the one immediately before the current status) is checked.  *  &#x60;previousStatus&#x60; An object containing the ID of an issue status.  ##### Regular expression validator #####  A validator that checks the content of a field against a regular expression.      {        \&quot;type\&quot;: \&quot;RegexpFieldValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;regExp\&quot;: \&quot;[0-9]\&quot;,            \&quot;fieldId\&quot;: \&quot;customfield_10029\&quot;        }      }   *  &#x60;regExp&#x60;A regular expression.  *  &#x60;fieldId&#x60; The ID of a field. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:select&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multiselect&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:textarea&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:textfield&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:url&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:float&#x60;      *  &#x60;com.pyxis.greenhopper.jira:jsw-story-points&#x60;      *  &#x60;com.pyxis.greenhopper.jira:gh-epic-status&#x60;      *  &#x60;description&#x60;      *  &#x60;summary&#x60;  ##### User permission validator #####  A validator that checks if a user has a permission. Obsolete. You may encounter this validator when getting transition rules and can pass it when updating or creating rules, for example, when you want to duplicate the rules from a workflow on a new workflow.      {          \&quot;type\&quot;: \&quot;UserPermissionValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;permissionKey\&quot;: \&quot;BROWSE_PROJECTS\&quot;,              \&quot;nullAllowed\&quot;: false,              \&quot;username\&quot;: \&quot;TestUser\&quot;          }      }   *  &#x60;permissionKey&#x60; The permission to be validated. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  *  &#x60;nullAllowed&#x60; If &#x60;true&#x60;, allows the transition when &#x60;username&#x60; is empty.  *  &#x60;username&#x60; The username to validate against the &#x60;permissionKey&#x60;.  #### Post functions ####  Post functions carry out any additional processing required after a Jira workflow transition is executed.  ##### Fire issue event function #####  A post function that fires an event that is processed by the listeners.      {        \&quot;type\&quot;: \&quot;FireIssueEventFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;event\&quot;: {            \&quot;id\&quot;:\&quot;1\&quot;          }        }      }  **Note:** If provided, this post function overrides the default &#x60;FireIssueEventFunction&#x60;. Can be included once in a transition.   *  &#x60;event&#x60; An object containing the ID of the issue event.  ##### Update issue status #####  A post function that sets issue status to the linked status of the destination workflow status.      {        \&quot;type\&quot;: \&quot;UpdateIssueStatusFunction\&quot;      }  **Note:** This post function is a default function in global and directed transitions. It can only be added to the initial transition and can only be added once.  ##### Create comment #####  A post function that adds a comment entered during the transition to an issue.      {        \&quot;type\&quot;: \&quot;CreateCommentFunction\&quot;      }  **Note:** This post function is a default function in global and directed transitions. It can only be added to the initial transition and can only be added once.  ##### Store issue #####  A post function that stores updates to an issue.      {        \&quot;type\&quot;: \&quot;IssueStoreFunction\&quot;      }  **Note:** This post function can only be added to the initial transition and can only be added once.  ##### Assign to current user function #####  A post function that assigns the issue to the current user if the current user has the &#x60;ASSIGNABLE_USER&#x60; permission.      {          \&quot;type\&quot;: \&quot;AssignToCurrentUserFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Assign to lead function #####  A post function that assigns the issue to the project or component lead developer.      {          \&quot;type\&quot;: \&quot;AssignToLeadFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Assign to reporter function #####  A post function that assigns the issue to the reporter.      {          \&quot;type\&quot;: \&quot;AssignToReporterFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Clear field value function #####  A post function that clears the value from a field.      {        \&quot;type\&quot;: \&quot;ClearFieldValuePostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field.  ##### Copy value from other field function #####  A post function that copies the value of one field to another, either within an issue or from parent to subtask.      {        \&quot;type\&quot;: \&quot;CopyValueFromOtherFieldPostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;sourceFieldId\&quot;: \&quot;assignee\&quot;,          \&quot;destinationFieldId\&quot;: \&quot;creator\&quot;,          \&quot;copyType\&quot;: \&quot;same\&quot;        }      }   *  &#x60;sourceFieldId&#x60; The ID of the source field.  *  &#x60;destinationFieldId&#x60; The ID of the destination field.  *  &#x60;copyType&#x60; Use &#x60;same&#x60; to copy the value from a field inside the issue, or &#x60;parent&#x60; to copy the value from the parent issue.  ##### Create Crucible review workflow function #####  A post function that creates a Crucible review for all unreviewed code for the issue.      {          \&quot;type\&quot;: \&quot;CreateCrucibleReviewWorkflowFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Set issue security level based on user&#39;s project role function #####  A post function that sets the issue&#39;s security level if the current user has a project role.      {        \&quot;type\&quot;: \&quot;SetIssueSecurityFromRoleFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRole\&quot;: {              \&quot;id\&quot;:\&quot;10002\&quot;          },          \&quot;issueSecurityLevel\&quot;: {              \&quot;id\&quot;:\&quot;10000\&quot;          }        }      }   *  &#x60;projectRole&#x60; An object containing the ID of the project role.  *  &#x60;issueSecurityLevel&#x60; OPTIONAL. The object containing the ID of the security level. If not passed, then the security level is set to &#x60;none&#x60;.  ##### Trigger a webhook function #####  A post function that triggers a webhook.      {        \&quot;type\&quot;: \&quot;TriggerWebhookFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;webhook\&quot;: {            \&quot;id\&quot;: \&quot;1\&quot;          }        }      }   *  &#x60;webhook&#x60; An object containing the ID of the webhook listener to trigger.  ##### Update issue custom field function #####  A post function that updates the content of an issue custom field.      {        \&quot;type\&quot;: \&quot;UpdateIssueCustomFieldPostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;mode\&quot;: \&quot;append\&quot;,          \&quot;fieldId\&quot;: \&quot;customfield_10003\&quot;,          \&quot;fieldValue\&quot;: \&quot;yikes\&quot;        }      }   *  &#x60;mode&#x60; Use &#x60;replace&#x60; to override the field content with &#x60;fieldValue&#x60; or &#x60;append&#x60; to add &#x60;fieldValue&#x60; to the end of the field content.  *  &#x60;fieldId&#x60; The ID of the field.  *  &#x60;fieldValue&#x60; The update content.  ##### Update issue field function #####  A post function that updates a simple issue field.      {        \&quot;type\&quot;: \&quot;UpdateIssueFieldFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;,          \&quot;fieldValue\&quot;: \&quot;5f0c277e70b8a90025a00776\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field. Allowed field types:           *  &#x60;assignee&#x60;      *  &#x60;description&#x60;      *  &#x60;environment&#x60;      *  &#x60;priority&#x60;      *  &#x60;resolution&#x60;      *  &#x60;summary&#x60;      *  &#x60;timeoriginalestimate&#x60;      *  &#x60;timeestimate&#x60;      *  &#x60;timespent&#x60;  *  &#x60;fieldValue&#x60; The update value.  *  If the &#x60;fieldId&#x60; is &#x60;assignee&#x60;, the &#x60;fieldValue&#x60; should be one of these values:           *  an account ID.      *  &#x60;automatic&#x60;.      *  a blank string, which sets the value to &#x60;unassigned&#x60;.  #### Connect rules ####  Connect rules are conditions, validators, and post functions of a transition that are registered by Connect apps. To create a rule registered by the app, the app must be enabled and the rule&#39;s module must exist.      {        \&quot;type\&quot;: \&quot;appKey__moduleKey\&quot;,        \&quot;configuration\&quot;: {          \&quot;value\&quot;:\&quot;{\\\&quot;isValid\\\&quot;:\\\&quot;true\\\&quot;}\&quot;        }      }   *  &#x60;type&#x60; A Connect rule key in a form of &#x60;appKey__moduleKey&#x60;.  *  &#x60;value&#x60; The stringified JSON configuration of a Connect rule.  #### Forge rules ####  Forge transition rules are not yet supported.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param createWorkflowDetails The workflow details. (required)
     * @return ApiResponse&lt;WorkflowIDs&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the workflow is created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if one or more statuses is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WorkflowIDs> createWorkflowWithHttpInfo(CreateWorkflowDetails createWorkflowDetails) throws ApiException {
        okhttp3.Call localVarCall = createWorkflowValidateBeforeCall(createWorkflowDetails, null);
        Type localVarReturnType = new TypeToken<WorkflowIDs>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create workflow (asynchronously)
     * Creates a workflow. You can define transition rules using the shapes detailed in the following sections. If no transitional rules are specified the default system transition rules are used.  #### Conditions ####  Conditions enable workflow rules that govern whether a transition can execute.  ##### Always false condition #####  A condition that always fails.      {        \&quot;type\&quot;: \&quot;AlwaysFalseCondition\&quot;      }  ##### Block transition until approval #####  A condition that blocks issue transition if there is a pending approval.      {        \&quot;type\&quot;: \&quot;BlockInProgressApprovalCondition\&quot;      }  ##### Compare number custom field condition #####  A condition that allows transition if a comparison between a number custom field and a value is true.      {        \&quot;type\&quot;: \&quot;CompareNumberCFCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;comparator\&quot;: \&quot;&#x3D;\&quot;,          \&quot;fieldId\&quot;: \&quot;customfield_10029\&quot;,          \&quot;fieldValue\&quot;: 2        }      }   *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&#x3D;&#x60;, &#x60;&gt;&#x60;, and &#x60;&lt;&#x60;.  *  &#x60;fieldId&#x60; The custom numeric field ID. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:float&#x60;      *  &#x60;com.pyxis.greenhopper.jira:jsw-story-points&#x60;  *  &#x60;fieldValue&#x60; The value for comparison.  ##### Hide from user condition #####  A condition that hides a transition from users. The transition can only be triggered from a workflow function or REST API operation.      {        \&quot;type\&quot;: \&quot;RemoteOnlyCondition\&quot;      }  ##### Only assignee condition #####  A condition that allows only the assignee to execute a transition.      {        \&quot;type\&quot;: \&quot;AllowOnlyAssignee\&quot;      }  ##### Only Bamboo notifications workflow condition #####  A condition that makes the transition available only to Bamboo build notifications.      {        \&quot;type\&quot;: \&quot;OnlyBambooNotificationsCondition\&quot;      }  ##### Only reporter condition #####  A condition that allows only the reporter to execute a transition.      {        \&quot;type\&quot;: \&quot;AllowOnlyReporter\&quot;      }  ##### Permission condition #####  A condition that allows only users with a permission to execute a transition.      {        \&quot;type\&quot;: \&quot;PermissionCondition\&quot;,        \&quot;configuration\&quot;: {            \&quot;permissionKey\&quot;: \&quot;BROWSE_PROJECTS\&quot;        }      }   *  &#x60;permissionKey&#x60; The permission required to perform the transition. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  ##### Previous status condition #####  A condition that allows a transition based on whether an issue has or has not transitioned through a status.      {        \&quot;type\&quot;: \&quot;PreviousStatusCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;ignoreLoopTransitions\&quot;: true,          \&quot;includeCurrentStatus\&quot;: true,          \&quot;mostRecentStatusOnly\&quot;: true,          \&quot;reverseCondition\&quot;: true,          \&quot;previousStatus\&quot;: {            \&quot;id\&quot;: \&quot;5\&quot;          }        }      }  By default this condition allows the transition if the status, as defined by its ID in the &#x60;previousStatus&#x60; object, matches any previous issue status, unless:   *  &#x60;ignoreLoopTransitions&#x60; is &#x60;true&#x60;, then loop transitions (from and to the same status) are ignored.  *  &#x60;includeCurrentStatus&#x60; is &#x60;true&#x60;, then the current issue status is also checked.  *  &#x60;mostRecentStatusOnly&#x60; is &#x60;true&#x60;, then only the issue&#39;s preceding status (the one immediately before the current status) is checked.  *  &#x60;reverseCondition&#x60; is &#x60;true&#x60;, then the status must not be present.  ##### Separation of duties condition #####  A condition that prevents a user to perform the transition, if the user has already performed a transition on the issue.      {        \&quot;type\&quot;: \&quot;SeparationOfDutiesCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fromStatus\&quot;: {            \&quot;id\&quot;: \&quot;5\&quot;          },          \&quot;toStatus\&quot;: {            \&quot;id\&quot;: \&quot;6\&quot;          }        }      }   *  &#x60;fromStatus&#x60; OPTIONAL. An object containing the ID of the source status of the transition that is blocked. If omitted any transition to &#x60;toStatus&#x60; is blocked.  *  &#x60;toStatus&#x60; An object containing the ID of the target status of the transition that is blocked.  ##### Subtask blocking condition #####  A condition that blocks transition on a parent issue if any of its subtasks are in any of one or more statuses.      {        \&quot;type\&quot;: \&quot;SubTaskBlockingCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;statuses\&quot;: [            {              \&quot;id\&quot;: \&quot;1\&quot;            },            {              \&quot;id\&quot;: \&quot;3\&quot;            }          ]        }      }   *  &#x60;statuses&#x60; A list of objects containing status IDs.  ##### User is in any group condition #####  A condition that allows users belonging to any group from a list of groups to execute a transition.      {        \&quot;type\&quot;: \&quot;UserInAnyGroupCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;groups\&quot;: [            \&quot;administrators\&quot;,            \&quot;atlassian-addons-admin\&quot;          ]        }      }   *  &#x60;groups&#x60; A list of group names.  ##### User is in any project role condition #####  A condition that allows only users with at least one project roles from a list of project roles to execute a transition.      {        \&quot;type\&quot;: \&quot;InAnyProjectRoleCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRoles\&quot;: [            {              \&quot;id\&quot;: \&quot;10002\&quot;            },            {              \&quot;id\&quot;: \&quot;10003\&quot;            },            {              \&quot;id\&quot;: \&quot;10012\&quot;            },            {              \&quot;id\&quot;: \&quot;10013\&quot;            }          ]        }      }   *  &#x60;projectRoles&#x60; A list of objects containing project role IDs.  ##### User is in custom field condition #####  A condition that allows only users listed in a given custom field to execute the transition.      {        \&quot;type\&quot;: \&quot;UserIsInCustomFieldCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;allowUserInField\&quot;: false,          \&quot;fieldId\&quot;: \&quot;customfield_10010\&quot;        }      }   *  &#x60;allowUserInField&#x60; If &#x60;true&#x60; only a user who is listed in &#x60;fieldId&#x60; can perform the transition, otherwise, only a user who is not listed in &#x60;fieldId&#x60; can perform the transition.  *  &#x60;fieldId&#x60; The ID of the field containing the list of users.  ##### User is in group condition #####  A condition that allows users belonging to a group to execute a transition.      {        \&quot;type\&quot;: \&quot;UserInGroupCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;group\&quot;: \&quot;administrators\&quot;        }      }   *  &#x60;group&#x60; The name of the group.  ##### User is in group custom field condition #####  A condition that allows users belonging to a group specified in a custom field to execute a transition.      {        \&quot;type\&quot;: \&quot;InGroupCFCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;customfield_10012\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:grouppicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:select&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multiselect&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes&#x60;      *  &#x60;com.pyxis.greenhopper.jira:gh-epic-status&#x60;  ##### User is in project role condition #####  A condition that allows users with a project role to execute a transition.      {        \&quot;type\&quot;: \&quot;InProjectRoleCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRole\&quot;: {            \&quot;id\&quot;: \&quot;10002\&quot;          }        }      }   *  &#x60;projectRole&#x60; An object containing the ID of a project role.  ##### Value field condition #####  A conditions that allows a transition to execute if the value of a field is equal to a constant value or simply set.      {        \&quot;type\&quot;: \&quot;ValueFieldCondition\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;,          \&quot;fieldValue\&quot;: \&quot;qm:6e1ecee6-8e64-4db6-8c85-916bb3275f51:54b56885-2bd2-4381-8239-78263442520f\&quot;,          \&quot;comparisonType\&quot;: \&quot;NUMBER\&quot;,          \&quot;comparator\&quot;: \&quot;&#x3D;\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of a field used in the comparison.  *  &#x60;fieldValue&#x60; The expected value of the field.  *  &#x60;comparisonType&#x60; The type of the comparison. Allowed values: &#x60;STRING&#x60;, &#x60;NUMBER&#x60;, &#x60;DATE&#x60;, &#x60;DATE_WITHOUT_TIME&#x60;, or &#x60;OPTIONID&#x60;.  *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&gt;&#x60;, &#x60;&gt;&#x3D;&#x60;, &#x60;&#x3D;&#x60;, &#x60;&lt;&#x3D;&#x60;, &#x60;&lt;&#x60;, &#x60;!&#x3D;&#x60;.  **Notes:**   *  If you choose the comparison type &#x60;STRING&#x60;, only &#x60;&#x3D;&#x60; and &#x60;!&#x3D;&#x60; are valid options.  *  You may leave &#x60;fieldValue&#x60; empty when comparison type is &#x60;!&#x3D;&#x60; to indicate that a value is required in the field.  *  For date fields without time format values as &#x60;yyyy-MM-dd&#x60;, and for those with time as &#x60;yyyy-MM-dd HH:mm&#x60;. For example, for July 16 2021 use &#x60;2021-07-16&#x60;, for 8:05 AM use &#x60;2021-07-16 08:05&#x60;, and for 4 PM: &#x60;2021-07-16 16:00&#x60;.  #### Validators ####  Validators check that any input made to the transition is valid before the transition is performed.  ##### Date field validator #####  A validator that compares two dates.      {        \&quot;type\&quot;: \&quot;DateFieldValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;comparator\&quot;: \&quot;&gt;\&quot;,            \&quot;date1\&quot;: \&quot;updated\&quot;,            \&quot;date2\&quot;: \&quot;created\&quot;,            \&quot;expression\&quot;: \&quot;1d\&quot;,            \&quot;includeTime\&quot;: true          }      }   *  &#x60;comparator&#x60; One of the supported comparator: &#x60;&gt;&#x60;, &#x60;&gt;&#x3D;&#x60;, &#x60;&#x3D;&#x60;, &#x60;&lt;&#x3D;&#x60;, &#x60;&lt;&#x60;, or &#x60;!&#x3D;&#x60;.  *  &#x60;date1&#x60; The date field to validate. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;date2&#x60; The second date field. Required, if &#x60;expression&#x60; is not passed. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;expression&#x60; An expression specifying an offset. Required, if &#x60;date2&#x60; is not passed. Offsets are built with a number, with &#x60;-&#x60; as prefix for the past, and one of these time units: &#x60;d&#x60; for day, &#x60;w&#x60; for week, &#x60;m&#x60; for month, or &#x60;y&#x60; for year. For example, -2d means two days into the past and 1w means one week into the future. The &#x60;now&#x60; keyword enables a comparison with the current date.  *  &#x60;includeTime&#x60; If &#x60;true&#x60;, then the time part of the data is included for the comparison. If the field doesn&#39;t have a time part, 00:00:00 is used.  ##### Windows date validator #####  A validator that checks that a date falls on or after a reference date and before or on the reference date plus a number of days.      {        \&quot;type\&quot;: \&quot;WindowsDateValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;date1\&quot;: \&quot;customfield_10009\&quot;,            \&quot;date2\&quot;: \&quot;created\&quot;,            \&quot;windowsDays\&quot;: 5          }      }   *  &#x60;date1&#x60; The date field to validate. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;date2&#x60; The reference date. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datepicker&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:datetime&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-end&#x60;      *  &#x60;com.atlassian.jpo:jpo-custom-field-baseline-start&#x60;      *  &#x60;duedate&#x60;      *  &#x60;created&#x60;      *  &#x60;updated&#x60;      *  &#x60;resolutiondate&#x60;  *  &#x60;windowsDays&#x60; A positive integer indicating a number of days.  ##### Field required validator #####  A validator that checks fields are not empty. By default, if a field is not included in the current context it&#39;s ignored and not validated.      {          \&quot;type\&quot;: \&quot;FieldRequiredValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;ignoreContext\&quot;: true,              \&quot;errorMessage\&quot;: \&quot;Hey\&quot;,              \&quot;fieldIds\&quot;: [                  \&quot;versions\&quot;,                  \&quot;customfield_10037\&quot;,                  \&quot;customfield_10003\&quot;              ]          }      }   *  &#x60;ignoreContext&#x60; If &#x60;true&#x60;, then the context is ignored and all the fields are validated.  *  &#x60;errorMessage&#x60; OPTIONAL. The error message displayed when one or more fields are empty. A default error message is shown if an error message is not provided.  *  &#x60;fieldIds&#x60; The list of fields to validate.  ##### Field changed validator #####  A validator that checks that a field value is changed. However, this validation can be ignored for users from a list of groups.      {          \&quot;type\&quot;: \&quot;FieldChangedValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;fieldId\&quot;: \&quot;comment\&quot;,              \&quot;errorMessage\&quot;: \&quot;Hey\&quot;,              \&quot;exemptedGroups\&quot;: [                  \&quot;administrators\&quot;,                  \&quot;atlassian-addons-admin\&quot;              ]          }      }   *  &#x60;fieldId&#x60; The ID of a field.  *  &#x60;errorMessage&#x60; OPTIONAL. The error message displayed if the field is not changed. A default error message is shown if the error message is not provided.  *  &#x60;exemptedGroups&#x60; OPTIONAL. The list of groups.  ##### Field has single value validator #####  A validator that checks that a multi-select field has only one value. Optionally, the validation can ignore values copied from subtasks.      {          \&quot;type\&quot;: \&quot;FieldHasSingleValueValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;fieldId\&quot;: \&quot;attachment,              \&quot;excludeSubtasks\&quot;: true          }      }   *  &#x60;fieldId&#x60; The ID of a field.  *  &#x60;excludeSubtasks&#x60; If &#x60;true&#x60;, then values copied from subtasks are ignored.  ##### Parent status validator #####  A validator that checks the status of the parent issue of a subtask. Ìf the issue is not a subtask, no validation is performed.      {          \&quot;type\&quot;: \&quot;ParentStatusValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;parentStatuses\&quot;: [                  {                    \&quot;id\&quot;:\&quot;1\&quot;                  },                  {                    \&quot;id\&quot;:\&quot;2\&quot;                  }              ]          }      }   *  &#x60;parentStatus&#x60; The list of required parent issue statuses.  ##### Permission validator #####  A validator that checks the user has a permission.      {        \&quot;type\&quot;: \&quot;PermissionValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;permissionKey\&quot;: \&quot;ADMINISTER_PROJECTS\&quot;        }      }   *  &#x60;permissionKey&#x60; The permission required to perform the transition. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  ##### Previous status validator #####  A validator that checks if the issue has held a status.      {        \&quot;type\&quot;: \&quot;PreviousStatusValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;mostRecentStatusOnly\&quot;: false,            \&quot;previousStatus\&quot;: {                \&quot;id\&quot;: \&quot;15\&quot;            }        }      }   *  &#x60;mostRecentStatusOnly&#x60; If &#x60;true&#x60;, then only the issue&#39;s preceding status (the one immediately before the current status) is checked.  *  &#x60;previousStatus&#x60; An object containing the ID of an issue status.  ##### Regular expression validator #####  A validator that checks the content of a field against a regular expression.      {        \&quot;type\&quot;: \&quot;RegexpFieldValidator\&quot;,        \&quot;configuration\&quot;: {            \&quot;regExp\&quot;: \&quot;[0-9]\&quot;,            \&quot;fieldId\&quot;: \&quot;customfield_10029\&quot;        }      }   *  &#x60;regExp&#x60;A regular expression.  *  &#x60;fieldId&#x60; The ID of a field. Allowed field types:           *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:select&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multiselect&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:textarea&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:textfield&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:url&#x60;      *  &#x60;com.atlassian.jira.plugin.system.customfieldtypes:float&#x60;      *  &#x60;com.pyxis.greenhopper.jira:jsw-story-points&#x60;      *  &#x60;com.pyxis.greenhopper.jira:gh-epic-status&#x60;      *  &#x60;description&#x60;      *  &#x60;summary&#x60;  ##### User permission validator #####  A validator that checks if a user has a permission. Obsolete. You may encounter this validator when getting transition rules and can pass it when updating or creating rules, for example, when you want to duplicate the rules from a workflow on a new workflow.      {          \&quot;type\&quot;: \&quot;UserPermissionValidator\&quot;,          \&quot;configuration\&quot;: {              \&quot;permissionKey\&quot;: \&quot;BROWSE_PROJECTS\&quot;,              \&quot;nullAllowed\&quot;: false,              \&quot;username\&quot;: \&quot;TestUser\&quot;          }      }   *  &#x60;permissionKey&#x60; The permission to be validated. Allowed values: [built-in](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-permission-schemes/#built-in-permissions) or app defined permissions.  *  &#x60;nullAllowed&#x60; If &#x60;true&#x60;, allows the transition when &#x60;username&#x60; is empty.  *  &#x60;username&#x60; The username to validate against the &#x60;permissionKey&#x60;.  #### Post functions ####  Post functions carry out any additional processing required after a Jira workflow transition is executed.  ##### Fire issue event function #####  A post function that fires an event that is processed by the listeners.      {        \&quot;type\&quot;: \&quot;FireIssueEventFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;event\&quot;: {            \&quot;id\&quot;:\&quot;1\&quot;          }        }      }  **Note:** If provided, this post function overrides the default &#x60;FireIssueEventFunction&#x60;. Can be included once in a transition.   *  &#x60;event&#x60; An object containing the ID of the issue event.  ##### Update issue status #####  A post function that sets issue status to the linked status of the destination workflow status.      {        \&quot;type\&quot;: \&quot;UpdateIssueStatusFunction\&quot;      }  **Note:** This post function is a default function in global and directed transitions. It can only be added to the initial transition and can only be added once.  ##### Create comment #####  A post function that adds a comment entered during the transition to an issue.      {        \&quot;type\&quot;: \&quot;CreateCommentFunction\&quot;      }  **Note:** This post function is a default function in global and directed transitions. It can only be added to the initial transition and can only be added once.  ##### Store issue #####  A post function that stores updates to an issue.      {        \&quot;type\&quot;: \&quot;IssueStoreFunction\&quot;      }  **Note:** This post function can only be added to the initial transition and can only be added once.  ##### Assign to current user function #####  A post function that assigns the issue to the current user if the current user has the &#x60;ASSIGNABLE_USER&#x60; permission.      {          \&quot;type\&quot;: \&quot;AssignToCurrentUserFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Assign to lead function #####  A post function that assigns the issue to the project or component lead developer.      {          \&quot;type\&quot;: \&quot;AssignToLeadFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Assign to reporter function #####  A post function that assigns the issue to the reporter.      {          \&quot;type\&quot;: \&quot;AssignToReporterFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Clear field value function #####  A post function that clears the value from a field.      {        \&quot;type\&quot;: \&quot;ClearFieldValuePostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field.  ##### Copy value from other field function #####  A post function that copies the value of one field to another, either within an issue or from parent to subtask.      {        \&quot;type\&quot;: \&quot;CopyValueFromOtherFieldPostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;sourceFieldId\&quot;: \&quot;assignee\&quot;,          \&quot;destinationFieldId\&quot;: \&quot;creator\&quot;,          \&quot;copyType\&quot;: \&quot;same\&quot;        }      }   *  &#x60;sourceFieldId&#x60; The ID of the source field.  *  &#x60;destinationFieldId&#x60; The ID of the destination field.  *  &#x60;copyType&#x60; Use &#x60;same&#x60; to copy the value from a field inside the issue, or &#x60;parent&#x60; to copy the value from the parent issue.  ##### Create Crucible review workflow function #####  A post function that creates a Crucible review for all unreviewed code for the issue.      {          \&quot;type\&quot;: \&quot;CreateCrucibleReviewWorkflowFunction\&quot;      }  **Note:** This post function can be included once in a transition.  ##### Set issue security level based on user&#39;s project role function #####  A post function that sets the issue&#39;s security level if the current user has a project role.      {        \&quot;type\&quot;: \&quot;SetIssueSecurityFromRoleFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;projectRole\&quot;: {              \&quot;id\&quot;:\&quot;10002\&quot;          },          \&quot;issueSecurityLevel\&quot;: {              \&quot;id\&quot;:\&quot;10000\&quot;          }        }      }   *  &#x60;projectRole&#x60; An object containing the ID of the project role.  *  &#x60;issueSecurityLevel&#x60; OPTIONAL. The object containing the ID of the security level. If not passed, then the security level is set to &#x60;none&#x60;.  ##### Trigger a webhook function #####  A post function that triggers a webhook.      {        \&quot;type\&quot;: \&quot;TriggerWebhookFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;webhook\&quot;: {            \&quot;id\&quot;: \&quot;1\&quot;          }        }      }   *  &#x60;webhook&#x60; An object containing the ID of the webhook listener to trigger.  ##### Update issue custom field function #####  A post function that updates the content of an issue custom field.      {        \&quot;type\&quot;: \&quot;UpdateIssueCustomFieldPostFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;mode\&quot;: \&quot;append\&quot;,          \&quot;fieldId\&quot;: \&quot;customfield_10003\&quot;,          \&quot;fieldValue\&quot;: \&quot;yikes\&quot;        }      }   *  &#x60;mode&#x60; Use &#x60;replace&#x60; to override the field content with &#x60;fieldValue&#x60; or &#x60;append&#x60; to add &#x60;fieldValue&#x60; to the end of the field content.  *  &#x60;fieldId&#x60; The ID of the field.  *  &#x60;fieldValue&#x60; The update content.  ##### Update issue field function #####  A post function that updates a simple issue field.      {        \&quot;type\&quot;: \&quot;UpdateIssueFieldFunction\&quot;,        \&quot;configuration\&quot;: {          \&quot;fieldId\&quot;: \&quot;assignee\&quot;,          \&quot;fieldValue\&quot;: \&quot;5f0c277e70b8a90025a00776\&quot;        }      }   *  &#x60;fieldId&#x60; The ID of the field. Allowed field types:           *  &#x60;assignee&#x60;      *  &#x60;description&#x60;      *  &#x60;environment&#x60;      *  &#x60;priority&#x60;      *  &#x60;resolution&#x60;      *  &#x60;summary&#x60;      *  &#x60;timeoriginalestimate&#x60;      *  &#x60;timeestimate&#x60;      *  &#x60;timespent&#x60;  *  &#x60;fieldValue&#x60; The update value.  *  If the &#x60;fieldId&#x60; is &#x60;assignee&#x60;, the &#x60;fieldValue&#x60; should be one of these values:           *  an account ID.      *  &#x60;automatic&#x60;.      *  a blank string, which sets the value to &#x60;unassigned&#x60;.  #### Connect rules ####  Connect rules are conditions, validators, and post functions of a transition that are registered by Connect apps. To create a rule registered by the app, the app must be enabled and the rule&#39;s module must exist.      {        \&quot;type\&quot;: \&quot;appKey__moduleKey\&quot;,        \&quot;configuration\&quot;: {          \&quot;value\&quot;:\&quot;{\\\&quot;isValid\\\&quot;:\\\&quot;true\\\&quot;}\&quot;        }      }   *  &#x60;type&#x60; A Connect rule key in a form of &#x60;appKey__moduleKey&#x60;.  *  &#x60;value&#x60; The stringified JSON configuration of a Connect rule.  #### Forge rules ####  Forge transition rules are not yet supported.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param createWorkflowDetails The workflow details. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Returned if the workflow is created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if one or more statuses is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createWorkflowAsync(CreateWorkflowDetails createWorkflowDetails, final ApiCallback<WorkflowIDs> _callback) throws ApiException {

        okhttp3.Call localVarCall = createWorkflowValidateBeforeCall(createWorkflowDetails, _callback);
        Type localVarReturnType = new TypeToken<WorkflowIDs>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInactiveWorkflow
     * @param entityId The entity ID of the workflow. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the workflow is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInactiveWorkflowCall(String entityId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/{entityId}"
            .replace("{" + "entityId" + "}", localVarApiClient.escapeString(entityId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInactiveWorkflowValidateBeforeCall(String entityId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'entityId' is set
        if (entityId == null) {
            throw new ApiException("Missing the required parameter 'entityId' when calling deleteInactiveWorkflow(Async)");
        }

        return deleteInactiveWorkflowCall(entityId, _callback);

    }

    /**
     * Delete inactive workflow
     * Deletes a workflow.  The workflow cannot be deleted if it is:   *  an active workflow.  *  a system workflow.  *  associated with any workflow scheme.  *  associated with any draft workflow scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param entityId The entity ID of the workflow. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the workflow is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow is not found. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInactiveWorkflow(String entityId) throws ApiException {
        deleteInactiveWorkflowWithHttpInfo(entityId);
    }

    /**
     * Delete inactive workflow
     * Deletes a workflow.  The workflow cannot be deleted if it is:   *  an active workflow.  *  a system workflow.  *  associated with any workflow scheme.  *  associated with any draft workflow scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param entityId The entity ID of the workflow. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the workflow is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow is not found. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInactiveWorkflowWithHttpInfo(String entityId) throws ApiException {
        okhttp3.Call localVarCall = deleteInactiveWorkflowValidateBeforeCall(entityId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete inactive workflow (asynchronously)
     * Deletes a workflow.  The workflow cannot be deleted if it is:   *  an active workflow.  *  a system workflow.  *  associated with any workflow scheme.  *  associated with any draft workflow scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param entityId The entity ID of the workflow. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Returned if the workflow is deleted. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if the request is not valid. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the required permissions. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if the workflow is not found. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInactiveWorkflowAsync(String entityId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInactiveWorkflowValidateBeforeCall(entityId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllWorkflows
     * @param workflowName The name of the workflow to be returned. Only one workflow can be specified. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call getAllWorkflowsCall(String workflowName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (workflowName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workflowName", workflowName));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllWorkflowsValidateBeforeCall(String workflowName, final ApiCallback _callback) throws ApiException {
        return getAllWorkflowsCall(workflowName, _callback);

    }

    /**
     * Get all workflows
     * Returns all workflows in Jira or a workflow. Deprecated, use [Get workflows paginated](#api-rest-api-3-workflow-search-get).  If the &#x60;workflowName&#x60; parameter is specified, the workflow is returned as an object (not in an array). Otherwise, an array of workflow objects is returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param workflowName The name of the workflow to be returned. Only one workflow can be specified. (optional)
     * @return List&lt;DeprecatedWorkflow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public List<DeprecatedWorkflow> getAllWorkflows(String workflowName) throws ApiException {
        ApiResponse<List<DeprecatedWorkflow>> localVarResp = getAllWorkflowsWithHttpInfo(workflowName);
        return localVarResp.getData();
    }

    /**
     * Get all workflows
     * Returns all workflows in Jira or a workflow. Deprecated, use [Get workflows paginated](#api-rest-api-3-workflow-search-get).  If the &#x60;workflowName&#x60; parameter is specified, the workflow is returned as an object (not in an array). Otherwise, an array of workflow objects is returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param workflowName The name of the workflow to be returned. Only one workflow can be specified. (optional)
     * @return ApiResponse&lt;List&lt;DeprecatedWorkflow&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public ApiResponse<List<DeprecatedWorkflow>> getAllWorkflowsWithHttpInfo(String workflowName) throws ApiException {
        okhttp3.Call localVarCall = getAllWorkflowsValidateBeforeCall(workflowName, null);
        Type localVarReturnType = new TypeToken<List<DeprecatedWorkflow>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all workflows (asynchronously)
     * Returns all workflows in Jira or a workflow. Deprecated, use [Get workflows paginated](#api-rest-api-3-workflow-search-get).  If the &#x60;workflowName&#x60; parameter is specified, the workflow is returned as an object (not in an array). Otherwise, an array of workflow objects is returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param workflowName The name of the workflow to be returned. Only one workflow can be specified. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     * @deprecated
     */
    @Deprecated
    public okhttp3.Call getAllWorkflowsAsync(String workflowName, final ApiCallback<List<DeprecatedWorkflow>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllWorkflowsValidateBeforeCall(workflowName, _callback);
        Type localVarReturnType = new TypeToken<List<DeprecatedWorkflow>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWorkflowsPaginated
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param workflowName The name of a workflow to return. To include multiple workflows, provide an ampersand-separated list. For example, &#x60;workflowName&#x3D;name1&amp;workflowName&#x3D;name2&#x60;. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:   *  &#x60;transitions&#x60; For each workflow, returns information about the transitions inside the workflow.  *  &#x60;transitions.rules&#x60; For each workflow transition, returns information about its rules. Transitions are included automatically if this expand is requested.  *  &#x60;transitions.properties&#x60; For each workflow transition, returns information about its properties. Transitions are included automatically if this expand is requested.  *  &#x60;statuses&#x60; For each workflow, returns information about the statuses inside the workflow.  *  &#x60;statuses.properties&#x60; For each workflow status, returns information about its properties. Statuses are included automatically if this expand is requested.  *  &#x60;default&#x60; For each workflow, returns information about whether this is the default workflow.  *  &#x60;schemes&#x60; For each workflow, returns information about the workflow schemes the workflow is assigned to.  *  &#x60;projects&#x60; For each workflow, returns information about the projects the workflow is assigned to, through workflow schemes.  *  &#x60;hasDraftWorkflow&#x60; For each workflow, returns information about whether the workflow has a draft version.  *  &#x60;operations&#x60; For each workflow, returns information about the actions that can be undertaken on the workflow. (optional)
     * @param queryString String used to perform a case-insensitive partial match with workflow name. (optional)
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by workflow name.  *  &#x60;created&#x60; Sorts by create time.  *  &#x60;updated&#x60; Sorts by update time. (optional)
     * @param isActive Filters active and inactive workflows. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWorkflowsPaginatedCall(Long startAt, Integer maxResults, Set<String> workflowName, String expand, String queryString, String orderBy, Boolean isActive, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rest/api/3/workflow/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (startAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startAt", startAt));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (workflowName != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "workflowName", workflowName));
        }

        if (expand != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expand", expand));
        }

        if (queryString != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("queryString", queryString));
        }

        if (orderBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderBy", orderBy));
        }

        if (isActive != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("isActive", isActive));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "OAuth2", "basicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWorkflowsPaginatedValidateBeforeCall(Long startAt, Integer maxResults, Set<String> workflowName, String expand, String queryString, String orderBy, Boolean isActive, final ApiCallback _callback) throws ApiException {
        return getWorkflowsPaginatedCall(startAt, maxResults, workflowName, expand, queryString, orderBy, isActive, _callback);

    }

    /**
     * Get workflows paginated
     * Returns a [paginated](#pagination) list of published classic workflows. When workflow names are specified, details of those workflows are returned. Otherwise, all published classic workflows are returned.  This operation does not return next-gen workflows.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param workflowName The name of a workflow to return. To include multiple workflows, provide an ampersand-separated list. For example, &#x60;workflowName&#x3D;name1&amp;workflowName&#x3D;name2&#x60;. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:   *  &#x60;transitions&#x60; For each workflow, returns information about the transitions inside the workflow.  *  &#x60;transitions.rules&#x60; For each workflow transition, returns information about its rules. Transitions are included automatically if this expand is requested.  *  &#x60;transitions.properties&#x60; For each workflow transition, returns information about its properties. Transitions are included automatically if this expand is requested.  *  &#x60;statuses&#x60; For each workflow, returns information about the statuses inside the workflow.  *  &#x60;statuses.properties&#x60; For each workflow status, returns information about its properties. Statuses are included automatically if this expand is requested.  *  &#x60;default&#x60; For each workflow, returns information about whether this is the default workflow.  *  &#x60;schemes&#x60; For each workflow, returns information about the workflow schemes the workflow is assigned to.  *  &#x60;projects&#x60; For each workflow, returns information about the projects the workflow is assigned to, through workflow schemes.  *  &#x60;hasDraftWorkflow&#x60; For each workflow, returns information about whether the workflow has a draft version.  *  &#x60;operations&#x60; For each workflow, returns information about the actions that can be undertaken on the workflow. (optional)
     * @param queryString String used to perform a case-insensitive partial match with workflow name. (optional)
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by workflow name.  *  &#x60;created&#x60; Sorts by create time.  *  &#x60;updated&#x60; Sorts by update time. (optional)
     * @param isActive Filters active and inactive workflows. (optional)
     * @return PageBeanWorkflow
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     */
    public PageBeanWorkflow getWorkflowsPaginated(Long startAt, Integer maxResults, Set<String> workflowName, String expand, String queryString, String orderBy, Boolean isActive) throws ApiException {
        ApiResponse<PageBeanWorkflow> localVarResp = getWorkflowsPaginatedWithHttpInfo(startAt, maxResults, workflowName, expand, queryString, orderBy, isActive);
        return localVarResp.getData();
    }

    /**
     * Get workflows paginated
     * Returns a [paginated](#pagination) list of published classic workflows. When workflow names are specified, details of those workflows are returned. Otherwise, all published classic workflows are returned.  This operation does not return next-gen workflows.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param workflowName The name of a workflow to return. To include multiple workflows, provide an ampersand-separated list. For example, &#x60;workflowName&#x3D;name1&amp;workflowName&#x3D;name2&#x60;. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:   *  &#x60;transitions&#x60; For each workflow, returns information about the transitions inside the workflow.  *  &#x60;transitions.rules&#x60; For each workflow transition, returns information about its rules. Transitions are included automatically if this expand is requested.  *  &#x60;transitions.properties&#x60; For each workflow transition, returns information about its properties. Transitions are included automatically if this expand is requested.  *  &#x60;statuses&#x60; For each workflow, returns information about the statuses inside the workflow.  *  &#x60;statuses.properties&#x60; For each workflow status, returns information about its properties. Statuses are included automatically if this expand is requested.  *  &#x60;default&#x60; For each workflow, returns information about whether this is the default workflow.  *  &#x60;schemes&#x60; For each workflow, returns information about the workflow schemes the workflow is assigned to.  *  &#x60;projects&#x60; For each workflow, returns information about the projects the workflow is assigned to, through workflow schemes.  *  &#x60;hasDraftWorkflow&#x60; For each workflow, returns information about whether the workflow has a draft version.  *  &#x60;operations&#x60; For each workflow, returns information about the actions that can be undertaken on the workflow. (optional)
     * @param queryString String used to perform a case-insensitive partial match with workflow name. (optional)
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by workflow name.  *  &#x60;created&#x60; Sorts by create time.  *  &#x60;updated&#x60; Sorts by update time. (optional)
     * @param isActive Filters active and inactive workflows. (optional)
     * @return ApiResponse&lt;PageBeanWorkflow&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageBeanWorkflow> getWorkflowsPaginatedWithHttpInfo(Long startAt, Integer maxResults, Set<String> workflowName, String expand, String queryString, String orderBy, Boolean isActive) throws ApiException {
        okhttp3.Call localVarCall = getWorkflowsPaginatedValidateBeforeCall(startAt, maxResults, workflowName, expand, queryString, orderBy, isActive, null);
        Type localVarReturnType = new TypeToken<PageBeanWorkflow>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get workflows paginated (asynchronously)
     * Returns a [paginated](#pagination) list of published classic workflows. When workflow names are specified, details of those workflows are returned. Otherwise, all published classic workflows are returned.  This operation does not return next-gen workflows.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * @param startAt The index of the first item to return in a page of results (page offset). (optional, default to 0)
     * @param maxResults The maximum number of items to return per page. (optional, default to 50)
     * @param workflowName The name of a workflow to return. To include multiple workflows, provide an ampersand-separated list. For example, &#x60;workflowName&#x3D;name1&amp;workflowName&#x3D;name2&#x60;. (optional)
     * @param expand Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:   *  &#x60;transitions&#x60; For each workflow, returns information about the transitions inside the workflow.  *  &#x60;transitions.rules&#x60; For each workflow transition, returns information about its rules. Transitions are included automatically if this expand is requested.  *  &#x60;transitions.properties&#x60; For each workflow transition, returns information about its properties. Transitions are included automatically if this expand is requested.  *  &#x60;statuses&#x60; For each workflow, returns information about the statuses inside the workflow.  *  &#x60;statuses.properties&#x60; For each workflow status, returns information about its properties. Statuses are included automatically if this expand is requested.  *  &#x60;default&#x60; For each workflow, returns information about whether this is the default workflow.  *  &#x60;schemes&#x60; For each workflow, returns information about the workflow schemes the workflow is assigned to.  *  &#x60;projects&#x60; For each workflow, returns information about the projects the workflow is assigned to, through workflow schemes.  *  &#x60;hasDraftWorkflow&#x60; For each workflow, returns information about whether the workflow has a draft version.  *  &#x60;operations&#x60; For each workflow, returns information about the actions that can be undertaken on the workflow. (optional)
     * @param queryString String used to perform a case-insensitive partial match with workflow name. (optional)
     * @param orderBy [Order](#ordering) the results by a field:   *  &#x60;name&#x60; Sorts by workflow name.  *  &#x60;created&#x60; Sorts by create time.  *  &#x60;updated&#x60; Sorts by update time. (optional)
     * @param isActive Filters active and inactive workflows. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Returned if the request is successful. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Returned if the authentication credentials are incorrect or missing. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user does not have the necessary permission. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getWorkflowsPaginatedAsync(Long startAt, Integer maxResults, Set<String> workflowName, String expand, String queryString, String orderBy, Boolean isActive, final ApiCallback<PageBeanWorkflow> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWorkflowsPaginatedValidateBeforeCall(startAt, maxResults, workflowName, expand, queryString, orderBy, isActive, _callback);
        Type localVarReturnType = new TypeToken<PageBeanWorkflow>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
