/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import software.tnb.jira.validation.generated.model.GroupName;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of an application role.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ApplicationRole {
  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_GROUPS = "groups";
  @SerializedName(SERIALIZED_NAME_GROUPS)
  private Set<String> groups = null;

  public static final String SERIALIZED_NAME_GROUP_DETAILS = "groupDetails";
  @SerializedName(SERIALIZED_NAME_GROUP_DETAILS)
  private List<GroupName> groupDetails = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DEFAULT_GROUPS = "defaultGroups";
  @SerializedName(SERIALIZED_NAME_DEFAULT_GROUPS)
  private Set<String> defaultGroups = null;

  public static final String SERIALIZED_NAME_DEFAULT_GROUPS_DETAILS = "defaultGroupsDetails";
  @SerializedName(SERIALIZED_NAME_DEFAULT_GROUPS_DETAILS)
  private List<GroupName> defaultGroupsDetails = null;

  public static final String SERIALIZED_NAME_SELECTED_BY_DEFAULT = "selectedByDefault";
  @SerializedName(SERIALIZED_NAME_SELECTED_BY_DEFAULT)
  private Boolean selectedByDefault;

  public static final String SERIALIZED_NAME_DEFINED = "defined";
  @SerializedName(SERIALIZED_NAME_DEFINED)
  private Boolean defined;

  public static final String SERIALIZED_NAME_NUMBER_OF_SEATS = "numberOfSeats";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_SEATS)
  private Integer numberOfSeats;

  public static final String SERIALIZED_NAME_REMAINING_SEATS = "remainingSeats";
  @SerializedName(SERIALIZED_NAME_REMAINING_SEATS)
  private Integer remainingSeats;

  public static final String SERIALIZED_NAME_USER_COUNT = "userCount";
  @SerializedName(SERIALIZED_NAME_USER_COUNT)
  private Integer userCount;

  public static final String SERIALIZED_NAME_USER_COUNT_DESCRIPTION = "userCountDescription";
  @SerializedName(SERIALIZED_NAME_USER_COUNT_DESCRIPTION)
  private String userCountDescription;

  public static final String SERIALIZED_NAME_HAS_UNLIMITED_SEATS = "hasUnlimitedSeats";
  @SerializedName(SERIALIZED_NAME_HAS_UNLIMITED_SEATS)
  private Boolean hasUnlimitedSeats;

  public static final String SERIALIZED_NAME_PLATFORM = "platform";
  @SerializedName(SERIALIZED_NAME_PLATFORM)
  private Boolean platform;

  public ApplicationRole() {
  }

  public ApplicationRole key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * The key of the application role.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public ApplicationRole groups(Set<String> groups) {
    
    this.groups = groups;
    return this;
  }

  public ApplicationRole addGroupsItem(String groupsItem) {
    if (this.groups == null) {
      this.groups = new LinkedHashSet<>();
    }
    this.groups.add(groupsItem);
    return this;
  }

   /**
   * The groups associated with the application role. As a group&#39;s name can change, use of &#x60;groupDetails&#x60; is recommended to identify a groups.
   * @return groups
  **/
  @jakarta.annotation.Nullable

  public Set<String> getGroups() {
    return groups;
  }


  public void setGroups(Set<String> groups) {
    this.groups = groups;
  }


  public ApplicationRole groupDetails(List<GroupName> groupDetails) {
    
    this.groupDetails = groupDetails;
    return this;
  }

  public ApplicationRole addGroupDetailsItem(GroupName groupDetailsItem) {
    if (this.groupDetails == null) {
      this.groupDetails = new ArrayList<>();
    }
    this.groupDetails.add(groupDetailsItem);
    return this;
  }

   /**
   * The groups associated with the application role.
   * @return groupDetails
  **/
  @jakarta.annotation.Nullable

  public List<GroupName> getGroupDetails() {
    return groupDetails;
  }


  public void setGroupDetails(List<GroupName> groupDetails) {
    this.groupDetails = groupDetails;
  }


  public ApplicationRole name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The display name of the application role.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public ApplicationRole defaultGroups(Set<String> defaultGroups) {
    
    this.defaultGroups = defaultGroups;
    return this;
  }

  public ApplicationRole addDefaultGroupsItem(String defaultGroupsItem) {
    if (this.defaultGroups == null) {
      this.defaultGroups = new LinkedHashSet<>();
    }
    this.defaultGroups.add(defaultGroupsItem);
    return this;
  }

   /**
   * The groups that are granted default access for this application role. As a group&#39;s name can change, use of &#x60;defaultGroupsDetails&#x60; is recommended to identify a groups.
   * @return defaultGroups
  **/
  @jakarta.annotation.Nullable

  public Set<String> getDefaultGroups() {
    return defaultGroups;
  }


  public void setDefaultGroups(Set<String> defaultGroups) {
    this.defaultGroups = defaultGroups;
  }


  public ApplicationRole defaultGroupsDetails(List<GroupName> defaultGroupsDetails) {
    
    this.defaultGroupsDetails = defaultGroupsDetails;
    return this;
  }

  public ApplicationRole addDefaultGroupsDetailsItem(GroupName defaultGroupsDetailsItem) {
    if (this.defaultGroupsDetails == null) {
      this.defaultGroupsDetails = new ArrayList<>();
    }
    this.defaultGroupsDetails.add(defaultGroupsDetailsItem);
    return this;
  }

   /**
   * The groups that are granted default access for this application role.
   * @return defaultGroupsDetails
  **/
  @jakarta.annotation.Nullable

  public List<GroupName> getDefaultGroupsDetails() {
    return defaultGroupsDetails;
  }


  public void setDefaultGroupsDetails(List<GroupName> defaultGroupsDetails) {
    this.defaultGroupsDetails = defaultGroupsDetails;
  }


  public ApplicationRole selectedByDefault(Boolean selectedByDefault) {
    
    this.selectedByDefault = selectedByDefault;
    return this;
  }

   /**
   * Determines whether this application role should be selected by default on user creation.
   * @return selectedByDefault
  **/
  @jakarta.annotation.Nullable

  public Boolean getSelectedByDefault() {
    return selectedByDefault;
  }


  public void setSelectedByDefault(Boolean selectedByDefault) {
    this.selectedByDefault = selectedByDefault;
  }


  public ApplicationRole defined(Boolean defined) {
    
    this.defined = defined;
    return this;
  }

   /**
   * Deprecated.
   * @return defined
  **/
  @jakarta.annotation.Nullable

  public Boolean getDefined() {
    return defined;
  }


  public void setDefined(Boolean defined) {
    this.defined = defined;
  }


  public ApplicationRole numberOfSeats(Integer numberOfSeats) {
    
    this.numberOfSeats = numberOfSeats;
    return this;
  }

   /**
   * The maximum count of users on your license.
   * @return numberOfSeats
  **/
  @jakarta.annotation.Nullable

  public Integer getNumberOfSeats() {
    return numberOfSeats;
  }


  public void setNumberOfSeats(Integer numberOfSeats) {
    this.numberOfSeats = numberOfSeats;
  }


  public ApplicationRole remainingSeats(Integer remainingSeats) {
    
    this.remainingSeats = remainingSeats;
    return this;
  }

   /**
   * The count of users remaining on your license.
   * @return remainingSeats
  **/
  @jakarta.annotation.Nullable

  public Integer getRemainingSeats() {
    return remainingSeats;
  }


  public void setRemainingSeats(Integer remainingSeats) {
    this.remainingSeats = remainingSeats;
  }


  public ApplicationRole userCount(Integer userCount) {
    
    this.userCount = userCount;
    return this;
  }

   /**
   * The number of users counting against your license.
   * @return userCount
  **/
  @jakarta.annotation.Nullable

  public Integer getUserCount() {
    return userCount;
  }


  public void setUserCount(Integer userCount) {
    this.userCount = userCount;
  }


  public ApplicationRole userCountDescription(String userCountDescription) {
    
    this.userCountDescription = userCountDescription;
    return this;
  }

   /**
   * The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.
   * @return userCountDescription
  **/
  @jakarta.annotation.Nullable

  public String getUserCountDescription() {
    return userCountDescription;
  }


  public void setUserCountDescription(String userCountDescription) {
    this.userCountDescription = userCountDescription;
  }


  public ApplicationRole hasUnlimitedSeats(Boolean hasUnlimitedSeats) {
    
    this.hasUnlimitedSeats = hasUnlimitedSeats;
    return this;
  }

   /**
   * Get hasUnlimitedSeats
   * @return hasUnlimitedSeats
  **/
  @jakarta.annotation.Nullable

  public Boolean getHasUnlimitedSeats() {
    return hasUnlimitedSeats;
  }


  public void setHasUnlimitedSeats(Boolean hasUnlimitedSeats) {
    this.hasUnlimitedSeats = hasUnlimitedSeats;
  }


  public ApplicationRole platform(Boolean platform) {
    
    this.platform = platform;
    return this;
  }

   /**
   * Indicates if the application role belongs to Jira platform (&#x60;jira-core&#x60;).
   * @return platform
  **/
  @jakarta.annotation.Nullable

  public Boolean getPlatform() {
    return platform;
  }


  public void setPlatform(Boolean platform) {
    this.platform = platform;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationRole applicationRole = (ApplicationRole) o;
    return Objects.equals(this.key, applicationRole.key) &&
        Objects.equals(this.groups, applicationRole.groups) &&
        Objects.equals(this.groupDetails, applicationRole.groupDetails) &&
        Objects.equals(this.name, applicationRole.name) &&
        Objects.equals(this.defaultGroups, applicationRole.defaultGroups) &&
        Objects.equals(this.defaultGroupsDetails, applicationRole.defaultGroupsDetails) &&
        Objects.equals(this.selectedByDefault, applicationRole.selectedByDefault) &&
        Objects.equals(this.defined, applicationRole.defined) &&
        Objects.equals(this.numberOfSeats, applicationRole.numberOfSeats) &&
        Objects.equals(this.remainingSeats, applicationRole.remainingSeats) &&
        Objects.equals(this.userCount, applicationRole.userCount) &&
        Objects.equals(this.userCountDescription, applicationRole.userCountDescription) &&
        Objects.equals(this.hasUnlimitedSeats, applicationRole.hasUnlimitedSeats) &&
        Objects.equals(this.platform, applicationRole.platform);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, groups, groupDetails, name, defaultGroups, defaultGroupsDetails, selectedByDefault, defined, numberOfSeats, remainingSeats, userCount, userCountDescription, hasUnlimitedSeats, platform);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationRole {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    groupDetails: ").append(toIndentedString(groupDetails)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    defaultGroups: ").append(toIndentedString(defaultGroups)).append("\n");
    sb.append("    defaultGroupsDetails: ").append(toIndentedString(defaultGroupsDetails)).append("\n");
    sb.append("    selectedByDefault: ").append(toIndentedString(selectedByDefault)).append("\n");
    sb.append("    defined: ").append(toIndentedString(defined)).append("\n");
    sb.append("    numberOfSeats: ").append(toIndentedString(numberOfSeats)).append("\n");
    sb.append("    remainingSeats: ").append(toIndentedString(remainingSeats)).append("\n");
    sb.append("    userCount: ").append(toIndentedString(userCount)).append("\n");
    sb.append("    userCountDescription: ").append(toIndentedString(userCountDescription)).append("\n");
    sb.append("    hasUnlimitedSeats: ").append(toIndentedString(hasUnlimitedSeats)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("key");
    openapiFields.add("groups");
    openapiFields.add("groupDetails");
    openapiFields.add("name");
    openapiFields.add("defaultGroups");
    openapiFields.add("defaultGroupsDetails");
    openapiFields.add("selectedByDefault");
    openapiFields.add("defined");
    openapiFields.add("numberOfSeats");
    openapiFields.add("remainingSeats");
    openapiFields.add("userCount");
    openapiFields.add("userCountDescription");
    openapiFields.add("hasUnlimitedSeats");
    openapiFields.add("platform");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ApplicationRole
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ApplicationRole.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ApplicationRole is not found in the empty JSON string", ApplicationRole.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ApplicationRole.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ApplicationRole` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("groups") != null && !jsonObj.get("groups").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get("groups").toString()));
      }
      if (jsonObj.get("groupDetails") != null && !jsonObj.get("groupDetails").isJsonNull()) {
        JsonArray jsonArraygroupDetails = jsonObj.getAsJsonArray("groupDetails");
        if (jsonArraygroupDetails != null) {
          // ensure the json data is an array
          if (!jsonObj.get("groupDetails").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `groupDetails` to be an array in the JSON string but got `%s`", jsonObj.get("groupDetails").toString()));
          }

          // validate the optional field `groupDetails` (array)
          for (int i = 0; i < jsonArraygroupDetails.size(); i++) {
            GroupName.validateJsonObject(jsonArraygroupDetails.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("defaultGroups") != null && !jsonObj.get("defaultGroups").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `defaultGroups` to be an array in the JSON string but got `%s`", jsonObj.get("defaultGroups").toString()));
      }
      if (jsonObj.get("defaultGroupsDetails") != null && !jsonObj.get("defaultGroupsDetails").isJsonNull()) {
        JsonArray jsonArraydefaultGroupsDetails = jsonObj.getAsJsonArray("defaultGroupsDetails");
        if (jsonArraydefaultGroupsDetails != null) {
          // ensure the json data is an array
          if (!jsonObj.get("defaultGroupsDetails").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultGroupsDetails` to be an array in the JSON string but got `%s`", jsonObj.get("defaultGroupsDetails").toString()));
          }

          // validate the optional field `defaultGroupsDetails` (array)
          for (int i = 0; i < jsonArraydefaultGroupsDetails.size(); i++) {
            GroupName.validateJsonObject(jsonArraydefaultGroupsDetails.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("userCountDescription") != null && !jsonObj.get("userCountDescription").isJsonNull()) && !jsonObj.get("userCountDescription").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `userCountDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get("userCountDescription").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ApplicationRole.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ApplicationRole' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ApplicationRole> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ApplicationRole.class));

       return (TypeAdapter<T>) new TypeAdapter<ApplicationRole>() {
           @Override
           public void write(JsonWriter out, ApplicationRole value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ApplicationRole read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ApplicationRole given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ApplicationRole
  * @throws IOException if the JSON string is invalid with respect to ApplicationRole
  */
  public static ApplicationRole fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ApplicationRole.class);
  }

 /**
  * Convert an instance of ApplicationRole to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

