/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import software.tnb.jira.validation.generated.model.BulkProjectPermissionGrants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of global and project permissions granted to the user.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class BulkPermissionGrants {
  public static final String SERIALIZED_NAME_PROJECT_PERMISSIONS = "projectPermissions";
  @SerializedName(SERIALIZED_NAME_PROJECT_PERMISSIONS)
  private Set<BulkProjectPermissionGrants> projectPermissions = new LinkedHashSet<>();

  public static final String SERIALIZED_NAME_GLOBAL_PERMISSIONS = "globalPermissions";
  @SerializedName(SERIALIZED_NAME_GLOBAL_PERMISSIONS)
  private Set<String> globalPermissions = new LinkedHashSet<>();

  public BulkPermissionGrants() {
  }

  public BulkPermissionGrants projectPermissions(Set<BulkProjectPermissionGrants> projectPermissions) {
    
    this.projectPermissions = projectPermissions;
    return this;
  }

  public BulkPermissionGrants addProjectPermissionsItem(BulkProjectPermissionGrants projectPermissionsItem) {
    this.projectPermissions.add(projectPermissionsItem);
    return this;
  }

   /**
   * List of project permissions and the projects and issues those permissions provide access to.
   * @return projectPermissions
  **/
  @jakarta.annotation.Nonnull

  public Set<BulkProjectPermissionGrants> getProjectPermissions() {
    return projectPermissions;
  }


  public void setProjectPermissions(Set<BulkProjectPermissionGrants> projectPermissions) {
    this.projectPermissions = projectPermissions;
  }


  public BulkPermissionGrants globalPermissions(Set<String> globalPermissions) {
    
    this.globalPermissions = globalPermissions;
    return this;
  }

  public BulkPermissionGrants addGlobalPermissionsItem(String globalPermissionsItem) {
    this.globalPermissions.add(globalPermissionsItem);
    return this;
  }

   /**
   * List of permissions granted to the user.
   * @return globalPermissions
  **/
  @jakarta.annotation.Nonnull

  public Set<String> getGlobalPermissions() {
    return globalPermissions;
  }


  public void setGlobalPermissions(Set<String> globalPermissions) {
    this.globalPermissions = globalPermissions;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkPermissionGrants bulkPermissionGrants = (BulkPermissionGrants) o;
    return Objects.equals(this.projectPermissions, bulkPermissionGrants.projectPermissions) &&
        Objects.equals(this.globalPermissions, bulkPermissionGrants.globalPermissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectPermissions, globalPermissions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkPermissionGrants {\n");
    sb.append("    projectPermissions: ").append(toIndentedString(projectPermissions)).append("\n");
    sb.append("    globalPermissions: ").append(toIndentedString(globalPermissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("projectPermissions");
    openapiFields.add("globalPermissions");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("projectPermissions");
    openapiRequiredFields.add("globalPermissions");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to BulkPermissionGrants
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!BulkPermissionGrants.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BulkPermissionGrants is not found in the empty JSON string", BulkPermissionGrants.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!BulkPermissionGrants.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BulkPermissionGrants` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BulkPermissionGrants.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if (!jsonObj.get("projectPermissions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `projectPermissions` to be an array in the JSON string but got `%s`", jsonObj.get("projectPermissions").toString()));
      }

      JsonArray jsonArrayprojectPermissions = jsonObj.getAsJsonArray("projectPermissions");
      // validate the required field `projectPermissions` (array)
      for (int i = 0; i < jsonArrayprojectPermissions.size(); i++) {
        BulkProjectPermissionGrants.validateJsonObject(jsonArrayprojectPermissions.get(i).getAsJsonObject());
      };
      // ensure the required json array is present
      if (jsonObj.get("globalPermissions") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("globalPermissions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `globalPermissions` to be an array in the JSON string but got `%s`", jsonObj.get("globalPermissions").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BulkPermissionGrants.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BulkPermissionGrants' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BulkPermissionGrants> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BulkPermissionGrants.class));

       return (TypeAdapter<T>) new TypeAdapter<BulkPermissionGrants>() {
           @Override
           public void write(JsonWriter out, BulkPermissionGrants value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BulkPermissionGrants read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BulkPermissionGrants given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BulkPermissionGrants
  * @throws IOException if the JSON string is invalid with respect to BulkPermissionGrants
  */
  public static BulkPermissionGrants fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BulkPermissionGrants.class);
  }

 /**
  * Convert an instance of BulkPermissionGrants to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

