/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * List of project permissions and the projects and issues those permissions grant access to.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class BulkProjectPermissionGrants {
  public static final String SERIALIZED_NAME_PERMISSION = "permission";
  @SerializedName(SERIALIZED_NAME_PERMISSION)
  private String permission;

  public static final String SERIALIZED_NAME_ISSUES = "issues";
  @SerializedName(SERIALIZED_NAME_ISSUES)
  private Set<Long> issues = new LinkedHashSet<>();

  public static final String SERIALIZED_NAME_PROJECTS = "projects";
  @SerializedName(SERIALIZED_NAME_PROJECTS)
  private Set<Long> projects = new LinkedHashSet<>();

  public BulkProjectPermissionGrants() {
  }

  public BulkProjectPermissionGrants permission(String permission) {
    
    this.permission = permission;
    return this;
  }

   /**
   * A project permission,
   * @return permission
  **/
  @jakarta.annotation.Nonnull

  public String getPermission() {
    return permission;
  }


  public void setPermission(String permission) {
    this.permission = permission;
  }


  public BulkProjectPermissionGrants issues(Set<Long> issues) {
    
    this.issues = issues;
    return this;
  }

  public BulkProjectPermissionGrants addIssuesItem(Long issuesItem) {
    this.issues.add(issuesItem);
    return this;
  }

   /**
   * IDs of the issues the user has the permission for.
   * @return issues
  **/
  @jakarta.annotation.Nonnull

  public Set<Long> getIssues() {
    return issues;
  }


  public void setIssues(Set<Long> issues) {
    this.issues = issues;
  }


  public BulkProjectPermissionGrants projects(Set<Long> projects) {
    
    this.projects = projects;
    return this;
  }

  public BulkProjectPermissionGrants addProjectsItem(Long projectsItem) {
    this.projects.add(projectsItem);
    return this;
  }

   /**
   * IDs of the projects the user has the permission for.
   * @return projects
  **/
  @jakarta.annotation.Nonnull

  public Set<Long> getProjects() {
    return projects;
  }


  public void setProjects(Set<Long> projects) {
    this.projects = projects;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkProjectPermissionGrants bulkProjectPermissionGrants = (BulkProjectPermissionGrants) o;
    return Objects.equals(this.permission, bulkProjectPermissionGrants.permission) &&
        Objects.equals(this.issues, bulkProjectPermissionGrants.issues) &&
        Objects.equals(this.projects, bulkProjectPermissionGrants.projects);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permission, issues, projects);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkProjectPermissionGrants {\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    issues: ").append(toIndentedString(issues)).append("\n");
    sb.append("    projects: ").append(toIndentedString(projects)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("permission");
    openapiFields.add("issues");
    openapiFields.add("projects");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("permission");
    openapiRequiredFields.add("issues");
    openapiRequiredFields.add("projects");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to BulkProjectPermissionGrants
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!BulkProjectPermissionGrants.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BulkProjectPermissionGrants is not found in the empty JSON string", BulkProjectPermissionGrants.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!BulkProjectPermissionGrants.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BulkProjectPermissionGrants` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BulkProjectPermissionGrants.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("permission").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `permission` to be a primitive type in the JSON string but got `%s`", jsonObj.get("permission").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("issues") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("issues").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issues` to be an array in the JSON string but got `%s`", jsonObj.get("issues").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("projects") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("projects").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `projects` to be an array in the JSON string but got `%s`", jsonObj.get("projects").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BulkProjectPermissionGrants.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BulkProjectPermissionGrants' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BulkProjectPermissionGrants> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BulkProjectPermissionGrants.class));

       return (TypeAdapter<T>) new TypeAdapter<BulkProjectPermissionGrants>() {
           @Override
           public void write(JsonWriter out, BulkProjectPermissionGrants value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BulkProjectPermissionGrants read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BulkProjectPermissionGrants given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BulkProjectPermissionGrants
  * @throws IOException if the JSON string is invalid with respect to BulkProjectPermissionGrants
  */
  public static BulkProjectPermissionGrants fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BulkProjectPermissionGrants.class);
  }

 /**
  * Convert an instance of BulkProjectPermissionGrants to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

