/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of project permissions and associated issues and projects to look up.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class BulkProjectPermissions {
  public static final String SERIALIZED_NAME_ISSUES = "issues";
  @SerializedName(SERIALIZED_NAME_ISSUES)
  private Set<Long> issues = null;

  public static final String SERIALIZED_NAME_PROJECTS = "projects";
  @SerializedName(SERIALIZED_NAME_PROJECTS)
  private Set<Long> projects = null;

  public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
  @SerializedName(SERIALIZED_NAME_PERMISSIONS)
  private Set<String> permissions = new LinkedHashSet<>();

  public BulkProjectPermissions() {
  }

  public BulkProjectPermissions issues(Set<Long> issues) {
    
    this.issues = issues;
    return this;
  }

  public BulkProjectPermissions addIssuesItem(Long issuesItem) {
    if (this.issues == null) {
      this.issues = new LinkedHashSet<>();
    }
    this.issues.add(issuesItem);
    return this;
  }

   /**
   * List of issue IDs.
   * @return issues
  **/
  @jakarta.annotation.Nullable

  public Set<Long> getIssues() {
    return issues;
  }


  public void setIssues(Set<Long> issues) {
    this.issues = issues;
  }


  public BulkProjectPermissions projects(Set<Long> projects) {
    
    this.projects = projects;
    return this;
  }

  public BulkProjectPermissions addProjectsItem(Long projectsItem) {
    if (this.projects == null) {
      this.projects = new LinkedHashSet<>();
    }
    this.projects.add(projectsItem);
    return this;
  }

   /**
   * List of project IDs.
   * @return projects
  **/
  @jakarta.annotation.Nullable

  public Set<Long> getProjects() {
    return projects;
  }


  public void setProjects(Set<Long> projects) {
    this.projects = projects;
  }


  public BulkProjectPermissions permissions(Set<String> permissions) {
    
    this.permissions = permissions;
    return this;
  }

  public BulkProjectPermissions addPermissionsItem(String permissionsItem) {
    this.permissions.add(permissionsItem);
    return this;
  }

   /**
   * List of project permissions.
   * @return permissions
  **/
  @jakarta.annotation.Nonnull

  public Set<String> getPermissions() {
    return permissions;
  }


  public void setPermissions(Set<String> permissions) {
    this.permissions = permissions;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkProjectPermissions bulkProjectPermissions = (BulkProjectPermissions) o;
    return Objects.equals(this.issues, bulkProjectPermissions.issues) &&
        Objects.equals(this.projects, bulkProjectPermissions.projects) &&
        Objects.equals(this.permissions, bulkProjectPermissions.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issues, projects, permissions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkProjectPermissions {\n");
    sb.append("    issues: ").append(toIndentedString(issues)).append("\n");
    sb.append("    projects: ").append(toIndentedString(projects)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("issues");
    openapiFields.add("projects");
    openapiFields.add("permissions");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("permissions");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to BulkProjectPermissions
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!BulkProjectPermissions.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BulkProjectPermissions is not found in the empty JSON string", BulkProjectPermissions.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!BulkProjectPermissions.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BulkProjectPermissions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BulkProjectPermissions.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("issues") != null && !jsonObj.get("issues").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issues` to be an array in the JSON string but got `%s`", jsonObj.get("issues").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("projects") != null && !jsonObj.get("projects").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `projects` to be an array in the JSON string but got `%s`", jsonObj.get("projects").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("permissions") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("permissions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `permissions` to be an array in the JSON string but got `%s`", jsonObj.get("permissions").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BulkProjectPermissions.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BulkProjectPermissions' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BulkProjectPermissions> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BulkProjectPermissions.class));

       return (TypeAdapter<T>) new TypeAdapter<BulkProjectPermissions>() {
           @Override
           public void write(JsonWriter out, BulkProjectPermissions value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BulkProjectPermissions read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BulkProjectPermissions given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BulkProjectPermissions
  * @throws IOException if the JSON string is invalid with respect to BulkProjectPermissions
  */
  public static BulkProjectPermissions fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BulkProjectPermissions.class);
  }

 /**
  * Convert an instance of BulkProjectPermissions to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

