/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.ChangeDetails;
import software.tnb.jira.validation.generated.model.ChangelogAuthor;
import software.tnb.jira.validation.generated.model.ChangelogHistoryMetadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A changelog.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Changelog {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_AUTHOR = "author";
  @SerializedName(SERIALIZED_NAME_AUTHOR)
  private ChangelogAuthor author;

  public static final String SERIALIZED_NAME_CREATED = "created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private String created;

  public static final String SERIALIZED_NAME_ITEMS = "items";
  @SerializedName(SERIALIZED_NAME_ITEMS)
  private List<ChangeDetails> items = null;

  public static final String SERIALIZED_NAME_HISTORY_METADATA = "historyMetadata";
  @SerializedName(SERIALIZED_NAME_HISTORY_METADATA)
  private ChangelogHistoryMetadata historyMetadata;

  public Changelog() {
  }

  
  public Changelog(
     String id, 
     String created, 
     List<ChangeDetails> items
  ) {
    this();
    this.id = id;
    this.created = created;
    this.items = items;
  }

   /**
   * The ID of the changelog.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




  public Changelog author(ChangelogAuthor author) {
    
    this.author = author;
    return this;
  }

   /**
   * Get author
   * @return author
  **/
  @jakarta.annotation.Nullable

  public ChangelogAuthor getAuthor() {
    return author;
  }


  public void setAuthor(ChangelogAuthor author) {
    this.author = author;
  }


   /**
   * The date on which the change took place.
   * @return created
  **/
  @jakarta.annotation.Nullable

  public String getCreated() {
    return created;
  }




   /**
   * The list of items changed.
   * @return items
  **/
  @jakarta.annotation.Nullable

  public List<ChangeDetails> getItems() {
    return items;
  }




  public Changelog historyMetadata(ChangelogHistoryMetadata historyMetadata) {
    
    this.historyMetadata = historyMetadata;
    return this;
  }

   /**
   * Get historyMetadata
   * @return historyMetadata
  **/
  @jakarta.annotation.Nullable

  public ChangelogHistoryMetadata getHistoryMetadata() {
    return historyMetadata;
  }


  public void setHistoryMetadata(ChangelogHistoryMetadata historyMetadata) {
    this.historyMetadata = historyMetadata;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Changelog changelog = (Changelog) o;
    return Objects.equals(this.id, changelog.id) &&
        Objects.equals(this.author, changelog.author) &&
        Objects.equals(this.created, changelog.created) &&
        Objects.equals(this.items, changelog.items) &&
        Objects.equals(this.historyMetadata, changelog.historyMetadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, author, created, items, historyMetadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Changelog {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    historyMetadata: ").append(toIndentedString(historyMetadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("author");
    openapiFields.add("created");
    openapiFields.add("items");
    openapiFields.add("historyMetadata");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Changelog
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Changelog.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Changelog is not found in the empty JSON string", Changelog.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Changelog.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Changelog` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field `author`
      if (jsonObj.get("author") != null && !jsonObj.get("author").isJsonNull()) {
        ChangelogAuthor.validateJsonObject(jsonObj.getAsJsonObject("author"));
      }
      if (jsonObj.get("items") != null && !jsonObj.get("items").isJsonNull()) {
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray("items");
        if (jsonArrayitems != null) {
          // ensure the json data is an array
          if (!jsonObj.get("items").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get("items").toString()));
          }

          // validate the optional field `items` (array)
          for (int i = 0; i < jsonArrayitems.size(); i++) {
            ChangeDetails.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
          };
        }
      }
      // validate the optional field `historyMetadata`
      if (jsonObj.get("historyMetadata") != null && !jsonObj.get("historyMetadata").isJsonNull()) {
        ChangelogHistoryMetadata.validateJsonObject(jsonObj.getAsJsonObject("historyMetadata"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Changelog.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Changelog' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Changelog> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Changelog.class));

       return (TypeAdapter<T>) new TypeAdapter<Changelog>() {
           @Override
           public void write(JsonWriter out, Changelog value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Changelog read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Changelog given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Changelog
  * @throws IOException if the JSON string is invalid with respect to Changelog
  */
  public static Changelog fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Changelog.class);
  }

 /**
  * Convert an instance of Changelog to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

