/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.CommentAuthor;
import software.tnb.jira.validation.generated.model.CommentUpdateAuthor;
import software.tnb.jira.validation.generated.model.CommentVisibility;
import software.tnb.jira.validation.generated.model.EntityProperty;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A comment.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Comment {
  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private String self;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_AUTHOR = "author";
  @SerializedName(SERIALIZED_NAME_AUTHOR)
  private CommentAuthor author;

  public static final String SERIALIZED_NAME_BODY = "body";
  @SerializedName(SERIALIZED_NAME_BODY)
  private Object body = null;

  public static final String SERIALIZED_NAME_RENDERED_BODY = "renderedBody";
  @SerializedName(SERIALIZED_NAME_RENDERED_BODY)
  private String renderedBody;

  public static final String SERIALIZED_NAME_UPDATE_AUTHOR = "updateAuthor";
  @SerializedName(SERIALIZED_NAME_UPDATE_AUTHOR)
  private CommentUpdateAuthor updateAuthor;

  public static final String SERIALIZED_NAME_CREATED = "created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private String created;

  public static final String SERIALIZED_NAME_UPDATED = "updated";
  @SerializedName(SERIALIZED_NAME_UPDATED)
  private String updated;

  public static final String SERIALIZED_NAME_VISIBILITY = "visibility";
  @SerializedName(SERIALIZED_NAME_VISIBILITY)
  private CommentVisibility visibility;

  public static final String SERIALIZED_NAME_JSD_PUBLIC = "jsdPublic";
  @SerializedName(SERIALIZED_NAME_JSD_PUBLIC)
  private Boolean jsdPublic;

  public static final String SERIALIZED_NAME_JSD_AUTHOR_CAN_SEE_REQUEST = "jsdAuthorCanSeeRequest";
  @SerializedName(SERIALIZED_NAME_JSD_AUTHOR_CAN_SEE_REQUEST)
  private Boolean jsdAuthorCanSeeRequest;

  public static final String SERIALIZED_NAME_PROPERTIES = "properties";
  @SerializedName(SERIALIZED_NAME_PROPERTIES)
  private List<EntityProperty> properties = null;

  public Comment() {
  }

  
  public Comment(
     String self, 
     String id, 
     String renderedBody, 
     String created, 
     String updated, 
     Boolean jsdPublic, 
     Boolean jsdAuthorCanSeeRequest
  ) {
    this();
    this.self = self;
    this.id = id;
    this.renderedBody = renderedBody;
    this.created = created;
    this.updated = updated;
    this.jsdPublic = jsdPublic;
    this.jsdAuthorCanSeeRequest = jsdAuthorCanSeeRequest;
  }

   /**
   * The URL of the comment.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public String getSelf() {
    return self;
  }




   /**
   * The ID of the comment.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




  public Comment author(CommentAuthor author) {
    
    this.author = author;
    return this;
  }

   /**
   * Get author
   * @return author
  **/
  @jakarta.annotation.Nullable

  public CommentAuthor getAuthor() {
    return author;
  }


  public void setAuthor(CommentAuthor author) {
    this.author = author;
  }


  public Comment body(Object body) {
    
    this.body = body;
    return this;
  }

   /**
   * The comment text in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/).
   * @return body
  **/
  @jakarta.annotation.Nullable

  public Object getBody() {
    return body;
  }


  public void setBody(Object body) {
    this.body = body;
  }


   /**
   * The rendered version of the comment.
   * @return renderedBody
  **/
  @jakarta.annotation.Nullable

  public String getRenderedBody() {
    return renderedBody;
  }




  public Comment updateAuthor(CommentUpdateAuthor updateAuthor) {
    
    this.updateAuthor = updateAuthor;
    return this;
  }

   /**
   * Get updateAuthor
   * @return updateAuthor
  **/
  @jakarta.annotation.Nullable

  public CommentUpdateAuthor getUpdateAuthor() {
    return updateAuthor;
  }


  public void setUpdateAuthor(CommentUpdateAuthor updateAuthor) {
    this.updateAuthor = updateAuthor;
  }


   /**
   * The date and time at which the comment was created.
   * @return created
  **/
  @jakarta.annotation.Nullable

  public String getCreated() {
    return created;
  }




   /**
   * The date and time at which the comment was updated last.
   * @return updated
  **/
  @jakarta.annotation.Nullable

  public String getUpdated() {
    return updated;
  }




  public Comment visibility(CommentVisibility visibility) {
    
    this.visibility = visibility;
    return this;
  }

   /**
   * Get visibility
   * @return visibility
  **/
  @jakarta.annotation.Nullable

  public CommentVisibility getVisibility() {
    return visibility;
  }


  public void setVisibility(CommentVisibility visibility) {
    this.visibility = visibility;
  }


   /**
   * Whether the comment is visible in Jira Service Desk. Defaults to true when comments are created in the Jira Cloud Platform. This includes when the site doesn&#39;t use Jira Service Desk or the project isn&#39;t a Jira Service Desk project and, therefore, there is no Jira Service Desk for the issue to be visible on. To create a comment with its visibility in Jira Service Desk set to false, use the Jira Service Desk REST API [Create request comment](https://developer.atlassian.com/cloud/jira/service-desk/rest/#api-rest-servicedeskapi-request-issueIdOrKey-comment-post) operation.
   * @return jsdPublic
  **/
  @jakarta.annotation.Nullable

  public Boolean getJsdPublic() {
    return jsdPublic;
  }




   /**
   * Whether the comment was added from an email sent by a person who is not part of the issue. See [Allow external emails to be added as comments on issues](https://support.atlassian.com/jira-service-management-cloud/docs/allow-external-emails-to-be-added-as-comments-on-issues/)for information on setting up this feature.
   * @return jsdAuthorCanSeeRequest
  **/
  @jakarta.annotation.Nullable

  public Boolean getJsdAuthorCanSeeRequest() {
    return jsdAuthorCanSeeRequest;
  }




  public Comment properties(List<EntityProperty> properties) {
    
    this.properties = properties;
    return this;
  }

  public Comment addPropertiesItem(EntityProperty propertiesItem) {
    if (this.properties == null) {
      this.properties = new ArrayList<>();
    }
    this.properties.add(propertiesItem);
    return this;
  }

   /**
   * A list of comment properties. Optional on create and update.
   * @return properties
  **/
  @jakarta.annotation.Nullable

  public List<EntityProperty> getProperties() {
    return properties;
  }


  public void setProperties(List<EntityProperty> properties) {
    this.properties = properties;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the Comment instance itself
   */
  public Comment putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Comment comment = (Comment) o;
    return Objects.equals(this.self, comment.self) &&
        Objects.equals(this.id, comment.id) &&
        Objects.equals(this.author, comment.author) &&
        Objects.equals(this.body, comment.body) &&
        Objects.equals(this.renderedBody, comment.renderedBody) &&
        Objects.equals(this.updateAuthor, comment.updateAuthor) &&
        Objects.equals(this.created, comment.created) &&
        Objects.equals(this.updated, comment.updated) &&
        Objects.equals(this.visibility, comment.visibility) &&
        Objects.equals(this.jsdPublic, comment.jsdPublic) &&
        Objects.equals(this.jsdAuthorCanSeeRequest, comment.jsdAuthorCanSeeRequest) &&
        Objects.equals(this.properties, comment.properties)&&
        Objects.equals(this.additionalProperties, comment.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(self, id, author, body, renderedBody, updateAuthor, created, updated, visibility, jsdPublic, jsdAuthorCanSeeRequest, properties, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Comment {\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    renderedBody: ").append(toIndentedString(renderedBody)).append("\n");
    sb.append("    updateAuthor: ").append(toIndentedString(updateAuthor)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("    jsdPublic: ").append(toIndentedString(jsdPublic)).append("\n");
    sb.append("    jsdAuthorCanSeeRequest: ").append(toIndentedString(jsdAuthorCanSeeRequest)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("self");
    openapiFields.add("id");
    openapiFields.add("author");
    openapiFields.add("body");
    openapiFields.add("renderedBody");
    openapiFields.add("updateAuthor");
    openapiFields.add("created");
    openapiFields.add("updated");
    openapiFields.add("visibility");
    openapiFields.add("jsdPublic");
    openapiFields.add("jsdAuthorCanSeeRequest");
    openapiFields.add("properties");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Comment
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Comment.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Comment is not found in the empty JSON string", Comment.openapiRequiredFields.toString()));
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field `author`
      if (jsonObj.get("author") != null && !jsonObj.get("author").isJsonNull()) {
        CommentAuthor.validateJsonObject(jsonObj.getAsJsonObject("author"));
      }
      if ((jsonObj.get("renderedBody") != null && !jsonObj.get("renderedBody").isJsonNull()) && !jsonObj.get("renderedBody").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `renderedBody` to be a primitive type in the JSON string but got `%s`", jsonObj.get("renderedBody").toString()));
      }
      // validate the optional field `updateAuthor`
      if (jsonObj.get("updateAuthor") != null && !jsonObj.get("updateAuthor").isJsonNull()) {
        CommentUpdateAuthor.validateJsonObject(jsonObj.getAsJsonObject("updateAuthor"));
      }
      // validate the optional field `visibility`
      if (jsonObj.get("visibility") != null && !jsonObj.get("visibility").isJsonNull()) {
        CommentVisibility.validateJsonObject(jsonObj.getAsJsonObject("visibility"));
      }
      if (jsonObj.get("properties") != null && !jsonObj.get("properties").isJsonNull()) {
        JsonArray jsonArrayproperties = jsonObj.getAsJsonArray("properties");
        if (jsonArrayproperties != null) {
          // ensure the json data is an array
          if (!jsonObj.get("properties").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `properties` to be an array in the JSON string but got `%s`", jsonObj.get("properties").toString()));
          }

          // validate the optional field `properties` (array)
          for (int i = 0; i < jsonArrayproperties.size(); i++) {
            EntityProperty.validateJsonObject(jsonArrayproperties.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Comment.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Comment' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Comment> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Comment.class));

       return (TypeAdapter<T>) new TypeAdapter<Comment>() {
           @Override
           public void write(JsonWriter out, Comment value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additional properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public Comment read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             Comment instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Comment given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Comment
  * @throws IOException if the JSON string is invalid with respect to Comment
  */
  public static Comment fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Comment.class);
  }

 /**
  * Convert an instance of Comment to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

