/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A list of custom field details.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ConnectCustomFieldValue {
  /**
   * The type of custom field.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    STRINGISSUEFIELD("StringIssueField"),
    
    NUMBERISSUEFIELD("NumberIssueField"),
    
    RICHTEXTISSUEFIELD("RichTextIssueField"),
    
    SINGLESELECTISSUEFIELD("SingleSelectIssueField"),
    
    MULTISELECTISSUEFIELD("MultiSelectIssueField"),
    
    TEXTISSUEFIELD("TextIssueField");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "_type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_ISSUE_I_D = "issueID";
  @SerializedName(SERIALIZED_NAME_ISSUE_I_D)
  private Integer issueID;

  public static final String SERIALIZED_NAME_FIELD_I_D = "fieldID";
  @SerializedName(SERIALIZED_NAME_FIELD_I_D)
  private Integer fieldID;

  public static final String SERIALIZED_NAME_STRING = "string";
  @SerializedName(SERIALIZED_NAME_STRING)
  private String string;

  public static final String SERIALIZED_NAME_NUMBER = "number";
  @SerializedName(SERIALIZED_NAME_NUMBER)
  private BigDecimal number;

  public static final String SERIALIZED_NAME_RICH_TEXT = "richText";
  @SerializedName(SERIALIZED_NAME_RICH_TEXT)
  private String richText;

  public static final String SERIALIZED_NAME_OPTION_I_D = "optionID";
  @SerializedName(SERIALIZED_NAME_OPTION_I_D)
  private String optionID;

  public static final String SERIALIZED_NAME_TEXT = "text";
  @SerializedName(SERIALIZED_NAME_TEXT)
  private String text;

  public ConnectCustomFieldValue() {
  }

  public ConnectCustomFieldValue type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of custom field.
   * @return type
  **/
  @jakarta.annotation.Nonnull

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ConnectCustomFieldValue issueID(Integer issueID) {
    
    this.issueID = issueID;
    return this;
  }

   /**
   * The issue ID.
   * @return issueID
  **/
  @jakarta.annotation.Nonnull

  public Integer getIssueID() {
    return issueID;
  }


  public void setIssueID(Integer issueID) {
    this.issueID = issueID;
  }


  public ConnectCustomFieldValue fieldID(Integer fieldID) {
    
    this.fieldID = fieldID;
    return this;
  }

   /**
   * The custom field ID.
   * @return fieldID
  **/
  @jakarta.annotation.Nonnull

  public Integer getFieldID() {
    return fieldID;
  }


  public void setFieldID(Integer fieldID) {
    this.fieldID = fieldID;
  }


  public ConnectCustomFieldValue string(String string) {
    
    this.string = string;
    return this;
  }

   /**
   * The value of string type custom field when &#x60;_type&#x60; is &#x60;StringIssueField&#x60;.
   * @return string
  **/
  @jakarta.annotation.Nullable

  public String getString() {
    return string;
  }


  public void setString(String string) {
    this.string = string;
  }


  public ConnectCustomFieldValue number(BigDecimal number) {
    
    this.number = number;
    return this;
  }

   /**
   * The value of number type custom field when &#x60;_type&#x60; is &#x60;NumberIssueField&#x60;.
   * @return number
  **/
  @jakarta.annotation.Nullable

  public BigDecimal getNumber() {
    return number;
  }


  public void setNumber(BigDecimal number) {
    this.number = number;
  }


  public ConnectCustomFieldValue richText(String richText) {
    
    this.richText = richText;
    return this;
  }

   /**
   * The value of richText type custom field when &#x60;_type&#x60; is &#x60;RichTextIssueField&#x60;.
   * @return richText
  **/
  @jakarta.annotation.Nullable

  public String getRichText() {
    return richText;
  }


  public void setRichText(String richText) {
    this.richText = richText;
  }


  public ConnectCustomFieldValue optionID(String optionID) {
    
    this.optionID = optionID;
    return this;
  }

   /**
   * The value of single select and multiselect custom field type when &#x60;_type&#x60; is &#x60;SingleSelectIssueField&#x60; or &#x60;MultiSelectIssueField&#x60;.
   * @return optionID
  **/
  @jakarta.annotation.Nullable

  public String getOptionID() {
    return optionID;
  }


  public void setOptionID(String optionID) {
    this.optionID = optionID;
  }


  public ConnectCustomFieldValue text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * The value of of text custom field type when &#x60;_type&#x60; is &#x60;TextIssueField&#x60;.
   * @return text
  **/
  @jakarta.annotation.Nullable

  public String getText() {
    return text;
  }


  public void setText(String text) {
    this.text = text;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConnectCustomFieldValue connectCustomFieldValue = (ConnectCustomFieldValue) o;
    return Objects.equals(this.type, connectCustomFieldValue.type) &&
        Objects.equals(this.issueID, connectCustomFieldValue.issueID) &&
        Objects.equals(this.fieldID, connectCustomFieldValue.fieldID) &&
        Objects.equals(this.string, connectCustomFieldValue.string) &&
        Objects.equals(this.number, connectCustomFieldValue.number) &&
        Objects.equals(this.richText, connectCustomFieldValue.richText) &&
        Objects.equals(this.optionID, connectCustomFieldValue.optionID) &&
        Objects.equals(this.text, connectCustomFieldValue.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, issueID, fieldID, string, number, richText, optionID, text);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConnectCustomFieldValue {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    issueID: ").append(toIndentedString(issueID)).append("\n");
    sb.append("    fieldID: ").append(toIndentedString(fieldID)).append("\n");
    sb.append("    string: ").append(toIndentedString(string)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    richText: ").append(toIndentedString(richText)).append("\n");
    sb.append("    optionID: ").append(toIndentedString(optionID)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("_type");
    openapiFields.add("issueID");
    openapiFields.add("fieldID");
    openapiFields.add("string");
    openapiFields.add("number");
    openapiFields.add("richText");
    openapiFields.add("optionID");
    openapiFields.add("text");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("_type");
    openapiRequiredFields.add("issueID");
    openapiRequiredFields.add("fieldID");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ConnectCustomFieldValue
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ConnectCustomFieldValue.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ConnectCustomFieldValue is not found in the empty JSON string", ConnectCustomFieldValue.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ConnectCustomFieldValue.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ConnectCustomFieldValue` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ConnectCustomFieldValue.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("_type").toString()));
      }
      if ((jsonObj.get("string") != null && !jsonObj.get("string").isJsonNull()) && !jsonObj.get("string").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `string` to be a primitive type in the JSON string but got `%s`", jsonObj.get("string").toString()));
      }
      if ((jsonObj.get("richText") != null && !jsonObj.get("richText").isJsonNull()) && !jsonObj.get("richText").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `richText` to be a primitive type in the JSON string but got `%s`", jsonObj.get("richText").toString()));
      }
      if ((jsonObj.get("optionID") != null && !jsonObj.get("optionID").isJsonNull()) && !jsonObj.get("optionID").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `optionID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("optionID").toString()));
      }
      if ((jsonObj.get("text") != null && !jsonObj.get("text").isJsonNull()) && !jsonObj.get("text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("text").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ConnectCustomFieldValue.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ConnectCustomFieldValue' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ConnectCustomFieldValue> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ConnectCustomFieldValue.class));

       return (TypeAdapter<T>) new TypeAdapter<ConnectCustomFieldValue>() {
           @Override
           public void write(JsonWriter out, ConnectCustomFieldValue value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ConnectCustomFieldValue read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ConnectCustomFieldValue given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ConnectCustomFieldValue
  * @throws IOException if the JSON string is invalid with respect to ConnectCustomFieldValue
  */
  public static ConnectCustomFieldValue fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ConnectCustomFieldValue.class);
  }

 /**
  * Convert an instance of ConnectCustomFieldValue to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

