/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about the project.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class CreateProjectDetails {
  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_LEAD = "lead";
  @SerializedName(SERIALIZED_NAME_LEAD)
  private String lead;

  public static final String SERIALIZED_NAME_LEAD_ACCOUNT_ID = "leadAccountId";
  @SerializedName(SERIALIZED_NAME_LEAD_ACCOUNT_ID)
  private String leadAccountId;

  public static final String SERIALIZED_NAME_URL = "url";
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  /**
   * The default assignee when creating issues for this project.
   */
  @JsonAdapter(AssigneeTypeEnum.Adapter.class)
  public enum AssigneeTypeEnum {
    PROJECT_LEAD("PROJECT_LEAD"),
    
    UNASSIGNED("UNASSIGNED");

    private String value;

    AssigneeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AssigneeTypeEnum fromValue(String value) {
      for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AssigneeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AssigneeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AssigneeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AssigneeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ASSIGNEE_TYPE = "assigneeType";
  @SerializedName(SERIALIZED_NAME_ASSIGNEE_TYPE)
  private AssigneeTypeEnum assigneeType;

  public static final String SERIALIZED_NAME_AVATAR_ID = "avatarId";
  @SerializedName(SERIALIZED_NAME_AVATAR_ID)
  private Long avatarId;

  public static final String SERIALIZED_NAME_ISSUE_SECURITY_SCHEME = "issueSecurityScheme";
  @SerializedName(SERIALIZED_NAME_ISSUE_SECURITY_SCHEME)
  private Long issueSecurityScheme;

  public static final String SERIALIZED_NAME_PERMISSION_SCHEME = "permissionScheme";
  @SerializedName(SERIALIZED_NAME_PERMISSION_SCHEME)
  private Long permissionScheme;

  public static final String SERIALIZED_NAME_NOTIFICATION_SCHEME = "notificationScheme";
  @SerializedName(SERIALIZED_NAME_NOTIFICATION_SCHEME)
  private Long notificationScheme;

  public static final String SERIALIZED_NAME_CATEGORY_ID = "categoryId";
  @SerializedName(SERIALIZED_NAME_CATEGORY_ID)
  private Long categoryId;

  /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don&#39;t specify the project template you have to specify the project type.
   */
  @JsonAdapter(ProjectTypeKeyEnum.Adapter.class)
  public enum ProjectTypeKeyEnum {
    SOFTWARE("software"),
    
    SERVICE_DESK("service_desk"),
    
    BUSINESS("business");

    private String value;

    ProjectTypeKeyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ProjectTypeKeyEnum fromValue(String value) {
      for (ProjectTypeKeyEnum b : ProjectTypeKeyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ProjectTypeKeyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ProjectTypeKeyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ProjectTypeKeyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ProjectTypeKeyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PROJECT_TYPE_KEY = "projectTypeKey";
  @SerializedName(SERIALIZED_NAME_PROJECT_TYPE_KEY)
  private ProjectTypeKeyEnum projectTypeKey;

  /**
   * A predefined configuration for a project. The type of the &#x60;projectTemplateKey&#x60; must match with the type of the &#x60;projectTypeKey&#x60;.
   */
  @JsonAdapter(ProjectTemplateKeyEnum.Adapter.class)
  public enum ProjectTemplateKeyEnum {
    PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_AGILITY_KANBAN("com.pyxis.greenhopper.jira:gh-simplified-agility-kanban"),
    
    PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_AGILITY_SCRUM("com.pyxis.greenhopper.jira:gh-simplified-agility-scrum"),
    
    PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_BASIC("com.pyxis.greenhopper.jira:gh-simplified-basic"),
    
    PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_KANBAN_CLASSIC("com.pyxis.greenhopper.jira:gh-simplified-kanban-classic"),
    
    PYXIS_GREENHOPPER_JIRA_GH_SIMPLIFIED_SCRUM_CLASSIC("com.pyxis.greenhopper.jira:gh-simplified-scrum-classic"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_IT_SERVICE_MANAGEMENT("com.atlassian.servicedesk:simplified-it-service-management"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_GENERAL_SERVICE_DESK("com.atlassian.servicedesk:simplified-general-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_GENERAL_SERVICE_DESK_IT("com.atlassian.servicedesk:simplified-general-service-desk-it"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_GENERAL_SERVICE_DESK_BUSINESS("com.atlassian.servicedesk:simplified-general-service-desk-business"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_INTERNAL_SERVICE_DESK("com.atlassian.servicedesk:simplified-internal-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_EXTERNAL_SERVICE_DESK("com.atlassian.servicedesk:simplified-external-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_HR_SERVICE_DESK("com.atlassian.servicedesk:simplified-hr-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_FACILITIES_SERVICE_DESK("com.atlassian.servicedesk:simplified-facilities-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_LEGAL_SERVICE_DESK("com.atlassian.servicedesk:simplified-legal-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_MARKETING_SERVICE_DESK("com.atlassian.servicedesk:simplified-marketing-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_FINANCE_SERVICE_DESK("com.atlassian.servicedesk:simplified-finance-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_ANALYTICS_SERVICE_DESK("com.atlassian.servicedesk:simplified-analytics-service-desk"),
    
    ATLASSIAN_SERVICEDESK_SIMPLIFIED_HALP_SERVICE_DESK("com.atlassian.servicedesk:simplified-halp-service-desk"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_CONTENT_MANAGEMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-content-management"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_DOCUMENT_APPROVAL("com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_LEAD_TRACKING("com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_PROCESS_CONTROL("com.atlassian.jira-core-project-templates:jira-core-simplified-process-control"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_PROCUREMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-procurement"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_PROJECT_MANAGEMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-project-management"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_RECRUITMENT("com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment"),
    
    ATLASSIAN_JIRA_CORE_PROJECT_TEMPLATES_JIRA_CORE_SIMPLIFIED_TASK_("com.atlassian.jira-core-project-templates:jira-core-simplified-task-");

    private String value;

    ProjectTemplateKeyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ProjectTemplateKeyEnum fromValue(String value) {
      for (ProjectTemplateKeyEnum b : ProjectTemplateKeyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ProjectTemplateKeyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ProjectTemplateKeyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ProjectTemplateKeyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ProjectTemplateKeyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PROJECT_TEMPLATE_KEY = "projectTemplateKey";
  @SerializedName(SERIALIZED_NAME_PROJECT_TEMPLATE_KEY)
  private ProjectTemplateKeyEnum projectTemplateKey;

  public static final String SERIALIZED_NAME_WORKFLOW_SCHEME = "workflowScheme";
  @SerializedName(SERIALIZED_NAME_WORKFLOW_SCHEME)
  private Long workflowScheme;

  public static final String SERIALIZED_NAME_ISSUE_TYPE_SCREEN_SCHEME = "issueTypeScreenScheme";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPE_SCREEN_SCHEME)
  private Long issueTypeScreenScheme;

  public static final String SERIALIZED_NAME_ISSUE_TYPE_SCHEME = "issueTypeScheme";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPE_SCHEME)
  private Long issueTypeScheme;

  public static final String SERIALIZED_NAME_FIELD_CONFIGURATION_SCHEME = "fieldConfigurationScheme";
  @SerializedName(SERIALIZED_NAME_FIELD_CONFIGURATION_SCHEME)
  private Long fieldConfigurationScheme;

  public CreateProjectDetails() {
  }

  public CreateProjectDetails key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.
   * @return key
  **/
  @jakarta.annotation.Nonnull

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public CreateProjectDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the project.
   * @return name
  **/
  @jakarta.annotation.Nonnull

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public CreateProjectDetails description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A brief description of the project.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public CreateProjectDetails lead(String lead) {
    
    this.lead = lead;
    return this;
  }

   /**
   * This parameter is deprecated because of privacy changes. Use &#x60;leadAccountId&#x60; instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Either &#x60;lead&#x60; or &#x60;leadAccountId&#x60; must be set when creating a project. Cannot be provided with &#x60;leadAccountId&#x60;.
   * @return lead
  **/
  @jakarta.annotation.Nullable

  public String getLead() {
    return lead;
  }


  public void setLead(String lead) {
    this.lead = lead;
  }


  public CreateProjectDetails leadAccountId(String leadAccountId) {
    
    this.leadAccountId = leadAccountId;
    return this;
  }

   /**
   * The account ID of the project lead. Either &#x60;lead&#x60; or &#x60;leadAccountId&#x60; must be set when creating a project. Cannot be provided with &#x60;lead&#x60;.
   * @return leadAccountId
  **/
  @jakarta.annotation.Nullable

  public String getLeadAccountId() {
    return leadAccountId;
  }


  public void setLeadAccountId(String leadAccountId) {
    this.leadAccountId = leadAccountId;
  }


  public CreateProjectDetails url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * A link to information about this project, such as project documentation
   * @return url
  **/
  @jakarta.annotation.Nullable

  public String getUrl() {
    return url;
  }


  public void setUrl(String url) {
    this.url = url;
  }


  public CreateProjectDetails assigneeType(AssigneeTypeEnum assigneeType) {
    
    this.assigneeType = assigneeType;
    return this;
  }

   /**
   * The default assignee when creating issues for this project.
   * @return assigneeType
  **/
  @jakarta.annotation.Nullable

  public AssigneeTypeEnum getAssigneeType() {
    return assigneeType;
  }


  public void setAssigneeType(AssigneeTypeEnum assigneeType) {
    this.assigneeType = assigneeType;
  }


  public CreateProjectDetails avatarId(Long avatarId) {
    
    this.avatarId = avatarId;
    return this;
  }

   /**
   * An integer value for the project&#39;s avatar.
   * @return avatarId
  **/
  @jakarta.annotation.Nullable

  public Long getAvatarId() {
    return avatarId;
  }


  public void setAvatarId(Long avatarId) {
    this.avatarId = avatarId;
  }


  public CreateProjectDetails issueSecurityScheme(Long issueSecurityScheme) {
    
    this.issueSecurityScheme = issueSecurityScheme;
    return this;
  }

   /**
   * The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.
   * @return issueSecurityScheme
  **/
  @jakarta.annotation.Nullable

  public Long getIssueSecurityScheme() {
    return issueSecurityScheme;
  }


  public void setIssueSecurityScheme(Long issueSecurityScheme) {
    this.issueSecurityScheme = issueSecurityScheme;
  }


  public CreateProjectDetails permissionScheme(Long permissionScheme) {
    
    this.permissionScheme = permissionScheme;
    return this;
  }

   /**
   * The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.
   * @return permissionScheme
  **/
  @jakarta.annotation.Nullable

  public Long getPermissionScheme() {
    return permissionScheme;
  }


  public void setPermissionScheme(Long permissionScheme) {
    this.permissionScheme = permissionScheme;
  }


  public CreateProjectDetails notificationScheme(Long notificationScheme) {
    
    this.notificationScheme = notificationScheme;
    return this;
  }

   /**
   * The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.
   * @return notificationScheme
  **/
  @jakarta.annotation.Nullable

  public Long getNotificationScheme() {
    return notificationScheme;
  }


  public void setNotificationScheme(Long notificationScheme) {
    this.notificationScheme = notificationScheme;
  }


  public CreateProjectDetails categoryId(Long categoryId) {
    
    this.categoryId = categoryId;
    return this;
  }

   /**
   * The ID of the project&#39;s category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation.
   * @return categoryId
  **/
  @jakarta.annotation.Nullable

  public Long getCategoryId() {
    return categoryId;
  }


  public void setCategoryId(Long categoryId) {
    this.categoryId = categoryId;
  }


  public CreateProjectDetails projectTypeKey(ProjectTypeKeyEnum projectTypeKey) {
    
    this.projectTypeKey = projectTypeKey;
    return this;
  }

   /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don&#39;t specify the project template you have to specify the project type.
   * @return projectTypeKey
  **/
  @jakarta.annotation.Nullable

  public ProjectTypeKeyEnum getProjectTypeKey() {
    return projectTypeKey;
  }


  public void setProjectTypeKey(ProjectTypeKeyEnum projectTypeKey) {
    this.projectTypeKey = projectTypeKey;
  }


  public CreateProjectDetails projectTemplateKey(ProjectTemplateKeyEnum projectTemplateKey) {
    
    this.projectTemplateKey = projectTemplateKey;
    return this;
  }

   /**
   * A predefined configuration for a project. The type of the &#x60;projectTemplateKey&#x60; must match with the type of the &#x60;projectTypeKey&#x60;.
   * @return projectTemplateKey
  **/
  @jakarta.annotation.Nullable

  public ProjectTemplateKeyEnum getProjectTemplateKey() {
    return projectTemplateKey;
  }


  public void setProjectTemplateKey(ProjectTemplateKeyEnum projectTemplateKey) {
    this.projectTemplateKey = projectTemplateKey;
  }


  public CreateProjectDetails workflowScheme(Long workflowScheme) {
    
    this.workflowScheme = workflowScheme;
    return this;
  }

   /**
   * The ID of the workflow scheme for the project. Use the [Get all workflow schemes](#api-rest-api-3-workflowscheme-get) operation to get a list of workflow scheme IDs. If you specify the workflow scheme you cannot specify the project template key.
   * @return workflowScheme
  **/
  @jakarta.annotation.Nullable

  public Long getWorkflowScheme() {
    return workflowScheme;
  }


  public void setWorkflowScheme(Long workflowScheme) {
    this.workflowScheme = workflowScheme;
  }


  public CreateProjectDetails issueTypeScreenScheme(Long issueTypeScreenScheme) {
    
    this.issueTypeScreenScheme = issueTypeScreenScheme;
    return this;
  }

   /**
   * The ID of the issue type screen scheme for the project. Use the [Get all issue type screen schemes](#api-rest-api-3-issuetypescreenscheme-get) operation to get a list of issue type screen scheme IDs. If you specify the issue type screen scheme you cannot specify the project template key.
   * @return issueTypeScreenScheme
  **/
  @jakarta.annotation.Nullable

  public Long getIssueTypeScreenScheme() {
    return issueTypeScreenScheme;
  }


  public void setIssueTypeScreenScheme(Long issueTypeScreenScheme) {
    this.issueTypeScreenScheme = issueTypeScreenScheme;
  }


  public CreateProjectDetails issueTypeScheme(Long issueTypeScheme) {
    
    this.issueTypeScheme = issueTypeScheme;
    return this;
  }

   /**
   * The ID of the issue type scheme for the project. Use the [Get all issue type schemes](#api-rest-api-3-issuetypescheme-get) operation to get a list of issue type scheme IDs. If you specify the issue type scheme you cannot specify the project template key.
   * @return issueTypeScheme
  **/
  @jakarta.annotation.Nullable

  public Long getIssueTypeScheme() {
    return issueTypeScheme;
  }


  public void setIssueTypeScheme(Long issueTypeScheme) {
    this.issueTypeScheme = issueTypeScheme;
  }


  public CreateProjectDetails fieldConfigurationScheme(Long fieldConfigurationScheme) {
    
    this.fieldConfigurationScheme = fieldConfigurationScheme;
    return this;
  }

   /**
   * The ID of the field configuration scheme for the project. Use the [Get all field configuration schemes](#api-rest-api-3-fieldconfigurationscheme-get) operation to get a list of field configuration scheme IDs. If you specify the field configuration scheme you cannot specify the project template key.
   * @return fieldConfigurationScheme
  **/
  @jakarta.annotation.Nullable

  public Long getFieldConfigurationScheme() {
    return fieldConfigurationScheme;
  }


  public void setFieldConfigurationScheme(Long fieldConfigurationScheme) {
    this.fieldConfigurationScheme = fieldConfigurationScheme;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateProjectDetails createProjectDetails = (CreateProjectDetails) o;
    return Objects.equals(this.key, createProjectDetails.key) &&
        Objects.equals(this.name, createProjectDetails.name) &&
        Objects.equals(this.description, createProjectDetails.description) &&
        Objects.equals(this.lead, createProjectDetails.lead) &&
        Objects.equals(this.leadAccountId, createProjectDetails.leadAccountId) &&
        Objects.equals(this.url, createProjectDetails.url) &&
        Objects.equals(this.assigneeType, createProjectDetails.assigneeType) &&
        Objects.equals(this.avatarId, createProjectDetails.avatarId) &&
        Objects.equals(this.issueSecurityScheme, createProjectDetails.issueSecurityScheme) &&
        Objects.equals(this.permissionScheme, createProjectDetails.permissionScheme) &&
        Objects.equals(this.notificationScheme, createProjectDetails.notificationScheme) &&
        Objects.equals(this.categoryId, createProjectDetails.categoryId) &&
        Objects.equals(this.projectTypeKey, createProjectDetails.projectTypeKey) &&
        Objects.equals(this.projectTemplateKey, createProjectDetails.projectTemplateKey) &&
        Objects.equals(this.workflowScheme, createProjectDetails.workflowScheme) &&
        Objects.equals(this.issueTypeScreenScheme, createProjectDetails.issueTypeScreenScheme) &&
        Objects.equals(this.issueTypeScheme, createProjectDetails.issueTypeScheme) &&
        Objects.equals(this.fieldConfigurationScheme, createProjectDetails.fieldConfigurationScheme);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, description, lead, leadAccountId, url, assigneeType, avatarId, issueSecurityScheme, permissionScheme, notificationScheme, categoryId, projectTypeKey, projectTemplateKey, workflowScheme, issueTypeScreenScheme, issueTypeScheme, fieldConfigurationScheme);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateProjectDetails {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    lead: ").append(toIndentedString(lead)).append("\n");
    sb.append("    leadAccountId: ").append(toIndentedString(leadAccountId)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    assigneeType: ").append(toIndentedString(assigneeType)).append("\n");
    sb.append("    avatarId: ").append(toIndentedString(avatarId)).append("\n");
    sb.append("    issueSecurityScheme: ").append(toIndentedString(issueSecurityScheme)).append("\n");
    sb.append("    permissionScheme: ").append(toIndentedString(permissionScheme)).append("\n");
    sb.append("    notificationScheme: ").append(toIndentedString(notificationScheme)).append("\n");
    sb.append("    categoryId: ").append(toIndentedString(categoryId)).append("\n");
    sb.append("    projectTypeKey: ").append(toIndentedString(projectTypeKey)).append("\n");
    sb.append("    projectTemplateKey: ").append(toIndentedString(projectTemplateKey)).append("\n");
    sb.append("    workflowScheme: ").append(toIndentedString(workflowScheme)).append("\n");
    sb.append("    issueTypeScreenScheme: ").append(toIndentedString(issueTypeScreenScheme)).append("\n");
    sb.append("    issueTypeScheme: ").append(toIndentedString(issueTypeScheme)).append("\n");
    sb.append("    fieldConfigurationScheme: ").append(toIndentedString(fieldConfigurationScheme)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("key");
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("lead");
    openapiFields.add("leadAccountId");
    openapiFields.add("url");
    openapiFields.add("assigneeType");
    openapiFields.add("avatarId");
    openapiFields.add("issueSecurityScheme");
    openapiFields.add("permissionScheme");
    openapiFields.add("notificationScheme");
    openapiFields.add("categoryId");
    openapiFields.add("projectTypeKey");
    openapiFields.add("projectTemplateKey");
    openapiFields.add("workflowScheme");
    openapiFields.add("issueTypeScreenScheme");
    openapiFields.add("issueTypeScheme");
    openapiFields.add("fieldConfigurationScheme");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("key");
    openapiRequiredFields.add("name");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CreateProjectDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!CreateProjectDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateProjectDetails is not found in the empty JSON string", CreateProjectDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CreateProjectDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateProjectDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CreateProjectDetails.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("lead") != null && !jsonObj.get("lead").isJsonNull()) && !jsonObj.get("lead").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lead` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lead").toString()));
      }
      if ((jsonObj.get("leadAccountId") != null && !jsonObj.get("leadAccountId").isJsonNull()) && !jsonObj.get("leadAccountId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `leadAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("leadAccountId").toString()));
      }
      if ((jsonObj.get("url") != null && !jsonObj.get("url").isJsonNull()) && !jsonObj.get("url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
      if ((jsonObj.get("assigneeType") != null && !jsonObj.get("assigneeType").isJsonNull()) && !jsonObj.get("assigneeType").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `assigneeType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("assigneeType").toString()));
      }
      if ((jsonObj.get("projectTypeKey") != null && !jsonObj.get("projectTypeKey").isJsonNull()) && !jsonObj.get("projectTypeKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `projectTypeKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("projectTypeKey").toString()));
      }
      if ((jsonObj.get("projectTemplateKey") != null && !jsonObj.get("projectTemplateKey").isJsonNull()) && !jsonObj.get("projectTemplateKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `projectTemplateKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("projectTemplateKey").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateProjectDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateProjectDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateProjectDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateProjectDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateProjectDetails>() {
           @Override
           public void write(JsonWriter out, CreateProjectDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateProjectDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateProjectDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateProjectDetails
  * @throws IOException if the JSON string is invalid with respect to CreateProjectDetails
  */
  public static CreateProjectDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateProjectDetails.class);
  }

 /**
  * Convert an instance of CreateProjectDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

