/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import software.tnb.jira.validation.generated.model.CreateWorkflowStatusDetails;
import software.tnb.jira.validation.generated.model.CreateWorkflowTransitionDetails;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The details of a workflow.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class CreateWorkflowDetails {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_TRANSITIONS = "transitions";
  @SerializedName(SERIALIZED_NAME_TRANSITIONS)
  private List<CreateWorkflowTransitionDetails> transitions = new ArrayList<>();

  public static final String SERIALIZED_NAME_STATUSES = "statuses";
  @SerializedName(SERIALIZED_NAME_STATUSES)
  private Set<CreateWorkflowStatusDetails> statuses = new LinkedHashSet<>();

  public CreateWorkflowDetails() {
  }

  public CreateWorkflowDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the workflow. The name must be unique. The maximum length is 255 characters. Characters can be separated by a whitespace but the name cannot start or end with a whitespace.
   * @return name
  **/
  @jakarta.annotation.Nonnull

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public CreateWorkflowDetails description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the workflow. The maximum length is 1000 characters.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public CreateWorkflowDetails transitions(List<CreateWorkflowTransitionDetails> transitions) {
    
    this.transitions = transitions;
    return this;
  }

  public CreateWorkflowDetails addTransitionsItem(CreateWorkflowTransitionDetails transitionsItem) {
    this.transitions.add(transitionsItem);
    return this;
  }

   /**
   * The transitions of the workflow. For the request to be valid, these transitions must:   *  include one *initial* transition.  *  not use the same name for a *global* and *directed* transition.  *  have a unique name for each *global* transition.  *  have a unique &#39;to&#39; status for each *global* transition.  *  have unique names for each transition from a status.  *  not have a &#39;from&#39; status on *initial* and *global* transitions.  *  have a &#39;from&#39; status on *directed* transitions.  All the transition statuses must be included in &#x60;statuses&#x60;.
   * @return transitions
  **/
  @jakarta.annotation.Nonnull

  public List<CreateWorkflowTransitionDetails> getTransitions() {
    return transitions;
  }


  public void setTransitions(List<CreateWorkflowTransitionDetails> transitions) {
    this.transitions = transitions;
  }


  public CreateWorkflowDetails statuses(Set<CreateWorkflowStatusDetails> statuses) {
    
    this.statuses = statuses;
    return this;
  }

  public CreateWorkflowDetails addStatusesItem(CreateWorkflowStatusDetails statusesItem) {
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * The statuses of the workflow. Any status that does not include a transition is added to the workflow without a transition.
   * @return statuses
  **/
  @jakarta.annotation.Nonnull

  public Set<CreateWorkflowStatusDetails> getStatuses() {
    return statuses;
  }


  public void setStatuses(Set<CreateWorkflowStatusDetails> statuses) {
    this.statuses = statuses;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateWorkflowDetails createWorkflowDetails = (CreateWorkflowDetails) o;
    return Objects.equals(this.name, createWorkflowDetails.name) &&
        Objects.equals(this.description, createWorkflowDetails.description) &&
        Objects.equals(this.transitions, createWorkflowDetails.transitions) &&
        Objects.equals(this.statuses, createWorkflowDetails.statuses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, transitions, statuses);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateWorkflowDetails {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("transitions");
    openapiFields.add("statuses");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("transitions");
    openapiRequiredFields.add("statuses");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CreateWorkflowDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!CreateWorkflowDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateWorkflowDetails is not found in the empty JSON string", CreateWorkflowDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CreateWorkflowDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateWorkflowDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CreateWorkflowDetails.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // ensure the json data is an array
      if (!jsonObj.get("transitions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `transitions` to be an array in the JSON string but got `%s`", jsonObj.get("transitions").toString()));
      }

      JsonArray jsonArraytransitions = jsonObj.getAsJsonArray("transitions");
      // validate the required field `transitions` (array)
      for (int i = 0; i < jsonArraytransitions.size(); i++) {
        CreateWorkflowTransitionDetails.validateJsonObject(jsonArraytransitions.get(i).getAsJsonObject());
      };
      // ensure the json data is an array
      if (!jsonObj.get("statuses").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `statuses` to be an array in the JSON string but got `%s`", jsonObj.get("statuses").toString()));
      }

      JsonArray jsonArraystatuses = jsonObj.getAsJsonArray("statuses");
      // validate the required field `statuses` (array)
      for (int i = 0; i < jsonArraystatuses.size(); i++) {
        CreateWorkflowStatusDetails.validateJsonObject(jsonArraystatuses.get(i).getAsJsonObject());
      };
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateWorkflowDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateWorkflowDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateWorkflowDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateWorkflowDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateWorkflowDetails>() {
           @Override
           public void write(JsonWriter out, CreateWorkflowDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateWorkflowDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateWorkflowDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateWorkflowDetails
  * @throws IOException if the JSON string is invalid with respect to CreateWorkflowDetails
  */
  public static CreateWorkflowDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateWorkflowDetails.class);
  }

 /**
  * Convert an instance of CreateWorkflowDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

