/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.DashboardOwner;
import software.tnb.jira.validation.generated.model.SharePermission;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of a dashboard.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Dashboard {
  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_IS_FAVOURITE = "isFavourite";
  @SerializedName(SERIALIZED_NAME_IS_FAVOURITE)
  private Boolean isFavourite;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OWNER = "owner";
  @SerializedName(SERIALIZED_NAME_OWNER)
  private DashboardOwner owner;

  public static final String SERIALIZED_NAME_POPULARITY = "popularity";
  @SerializedName(SERIALIZED_NAME_POPULARITY)
  private Long popularity;

  public static final String SERIALIZED_NAME_RANK = "rank";
  @SerializedName(SERIALIZED_NAME_RANK)
  private Integer rank;

  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_SHARE_PERMISSIONS = "sharePermissions";
  @SerializedName(SERIALIZED_NAME_SHARE_PERMISSIONS)
  private List<SharePermission> sharePermissions = null;

  public static final String SERIALIZED_NAME_EDIT_PERMISSIONS = "editPermissions";
  @SerializedName(SERIALIZED_NAME_EDIT_PERMISSIONS)
  private List<SharePermission> editPermissions = null;

  public static final String SERIALIZED_NAME_AUTOMATIC_REFRESH_MS = "automaticRefreshMs";
  @SerializedName(SERIALIZED_NAME_AUTOMATIC_REFRESH_MS)
  private Integer automaticRefreshMs;

  public static final String SERIALIZED_NAME_VIEW = "view";
  @SerializedName(SERIALIZED_NAME_VIEW)
  private String view;

  public static final String SERIALIZED_NAME_IS_WRITABLE = "isWritable";
  @SerializedName(SERIALIZED_NAME_IS_WRITABLE)
  private Boolean isWritable;

  public static final String SERIALIZED_NAME_SYSTEM_DASHBOARD = "systemDashboard";
  @SerializedName(SERIALIZED_NAME_SYSTEM_DASHBOARD)
  private Boolean systemDashboard;

  public Dashboard() {
  }

  
  public Dashboard(
     String id, 
     Boolean isFavourite, 
     String name, 
     Long popularity, 
     Integer rank, 
     URI self, 
     List<SharePermission> sharePermissions, 
     List<SharePermission> editPermissions, 
     Integer automaticRefreshMs, 
     String view, 
     Boolean isWritable, 
     Boolean systemDashboard
  ) {
    this();
    this.id = id;
    this.isFavourite = isFavourite;
    this.name = name;
    this.popularity = popularity;
    this.rank = rank;
    this.self = self;
    this.sharePermissions = sharePermissions;
    this.editPermissions = editPermissions;
    this.automaticRefreshMs = automaticRefreshMs;
    this.view = view;
    this.isWritable = isWritable;
    this.systemDashboard = systemDashboard;
  }

  public Dashboard description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


   /**
   * The ID of the dashboard.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




   /**
   * Whether the dashboard is selected as a favorite by the user.
   * @return isFavourite
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsFavourite() {
    return isFavourite;
  }




   /**
   * The name of the dashboard.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }




  public Dashboard owner(DashboardOwner owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @jakarta.annotation.Nullable

  public DashboardOwner getOwner() {
    return owner;
  }


  public void setOwner(DashboardOwner owner) {
    this.owner = owner;
  }


   /**
   * The number of users who have this dashboard as a favorite.
   * @return popularity
  **/
  @jakarta.annotation.Nullable

  public Long getPopularity() {
    return popularity;
  }




   /**
   * The rank of this dashboard.
   * @return rank
  **/
  @jakarta.annotation.Nullable

  public Integer getRank() {
    return rank;
  }




   /**
   * The URL of these dashboard details.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




   /**
   * The details of any view share permissions for the dashboard.
   * @return sharePermissions
  **/
  @jakarta.annotation.Nullable

  public List<SharePermission> getSharePermissions() {
    return sharePermissions;
  }




   /**
   * The details of any edit share permissions for the dashboard.
   * @return editPermissions
  **/
  @jakarta.annotation.Nullable

  public List<SharePermission> getEditPermissions() {
    return editPermissions;
  }




   /**
   * The automatic refresh interval for the dashboard in milliseconds.
   * @return automaticRefreshMs
  **/
  @jakarta.annotation.Nullable

  public Integer getAutomaticRefreshMs() {
    return automaticRefreshMs;
  }




   /**
   * The URL of the dashboard.
   * @return view
  **/
  @jakarta.annotation.Nullable

  public String getView() {
    return view;
  }




   /**
   * Whether the current user has permission to edit the dashboard.
   * @return isWritable
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsWritable() {
    return isWritable;
  }




   /**
   * Whether the current dashboard is system dashboard.
   * @return systemDashboard
  **/
  @jakarta.annotation.Nullable

  public Boolean getSystemDashboard() {
    return systemDashboard;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Dashboard dashboard = (Dashboard) o;
    return Objects.equals(this.description, dashboard.description) &&
        Objects.equals(this.id, dashboard.id) &&
        Objects.equals(this.isFavourite, dashboard.isFavourite) &&
        Objects.equals(this.name, dashboard.name) &&
        Objects.equals(this.owner, dashboard.owner) &&
        Objects.equals(this.popularity, dashboard.popularity) &&
        Objects.equals(this.rank, dashboard.rank) &&
        Objects.equals(this.self, dashboard.self) &&
        Objects.equals(this.sharePermissions, dashboard.sharePermissions) &&
        Objects.equals(this.editPermissions, dashboard.editPermissions) &&
        Objects.equals(this.automaticRefreshMs, dashboard.automaticRefreshMs) &&
        Objects.equals(this.view, dashboard.view) &&
        Objects.equals(this.isWritable, dashboard.isWritable) &&
        Objects.equals(this.systemDashboard, dashboard.systemDashboard);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, id, isFavourite, name, owner, popularity, rank, self, sharePermissions, editPermissions, automaticRefreshMs, view, isWritable, systemDashboard);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Dashboard {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    isFavourite: ").append(toIndentedString(isFavourite)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    popularity: ").append(toIndentedString(popularity)).append("\n");
    sb.append("    rank: ").append(toIndentedString(rank)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    sharePermissions: ").append(toIndentedString(sharePermissions)).append("\n");
    sb.append("    editPermissions: ").append(toIndentedString(editPermissions)).append("\n");
    sb.append("    automaticRefreshMs: ").append(toIndentedString(automaticRefreshMs)).append("\n");
    sb.append("    view: ").append(toIndentedString(view)).append("\n");
    sb.append("    isWritable: ").append(toIndentedString(isWritable)).append("\n");
    sb.append("    systemDashboard: ").append(toIndentedString(systemDashboard)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("description");
    openapiFields.add("id");
    openapiFields.add("isFavourite");
    openapiFields.add("name");
    openapiFields.add("owner");
    openapiFields.add("popularity");
    openapiFields.add("rank");
    openapiFields.add("self");
    openapiFields.add("sharePermissions");
    openapiFields.add("editPermissions");
    openapiFields.add("automaticRefreshMs");
    openapiFields.add("view");
    openapiFields.add("isWritable");
    openapiFields.add("systemDashboard");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Dashboard
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Dashboard.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Dashboard is not found in the empty JSON string", Dashboard.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Dashboard.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Dashboard` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `owner`
      if (jsonObj.get("owner") != null && !jsonObj.get("owner").isJsonNull()) {
        DashboardOwner.validateJsonObject(jsonObj.getAsJsonObject("owner"));
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if (jsonObj.get("sharePermissions") != null && !jsonObj.get("sharePermissions").isJsonNull()) {
        JsonArray jsonArraysharePermissions = jsonObj.getAsJsonArray("sharePermissions");
        if (jsonArraysharePermissions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("sharePermissions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sharePermissions` to be an array in the JSON string but got `%s`", jsonObj.get("sharePermissions").toString()));
          }

          // validate the optional field `sharePermissions` (array)
          for (int i = 0; i < jsonArraysharePermissions.size(); i++) {
            SharePermission.validateJsonObject(jsonArraysharePermissions.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("editPermissions") != null && !jsonObj.get("editPermissions").isJsonNull()) {
        JsonArray jsonArrayeditPermissions = jsonObj.getAsJsonArray("editPermissions");
        if (jsonArrayeditPermissions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("editPermissions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `editPermissions` to be an array in the JSON string but got `%s`", jsonObj.get("editPermissions").toString()));
          }

          // validate the optional field `editPermissions` (array)
          for (int i = 0; i < jsonArrayeditPermissions.size(); i++) {
            SharePermission.validateJsonObject(jsonArrayeditPermissions.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("view") != null && !jsonObj.get("view").isJsonNull()) && !jsonObj.get("view").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `view` to be a primitive type in the JSON string but got `%s`", jsonObj.get("view").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Dashboard.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Dashboard' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Dashboard> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Dashboard.class));

       return (TypeAdapter<T>) new TypeAdapter<Dashboard>() {
           @Override
           public void write(JsonWriter out, Dashboard value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Dashboard read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Dashboard given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Dashboard
  * @throws IOException if the JSON string is invalid with respect to Dashboard
  */
  public static Dashboard fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Dashboard.class);
  }

 /**
  * Convert an instance of Dashboard to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

