/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import software.tnb.jira.validation.generated.model.DashboardGadgetSettingsPosition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of the settings for a dashboard gadget.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class DashboardGadgetSettings {
  public static final String SERIALIZED_NAME_MODULE_KEY = "moduleKey";
  @SerializedName(SERIALIZED_NAME_MODULE_KEY)
  private String moduleKey;

  public static final String SERIALIZED_NAME_URI = "uri";
  @SerializedName(SERIALIZED_NAME_URI)
  private String uri;

  public static final String SERIALIZED_NAME_COLOR = "color";
  @SerializedName(SERIALIZED_NAME_COLOR)
  private String color;

  public static final String SERIALIZED_NAME_POSITION = "position";
  @SerializedName(SERIALIZED_NAME_POSITION)
  private DashboardGadgetSettingsPosition position;

  public static final String SERIALIZED_NAME_TITLE = "title";
  @SerializedName(SERIALIZED_NAME_TITLE)
  private String title;

  public static final String SERIALIZED_NAME_IGNORE_URI_AND_MODULE_KEY_VALIDATION = "ignoreUriAndModuleKeyValidation";
  @SerializedName(SERIALIZED_NAME_IGNORE_URI_AND_MODULE_KEY_VALIDATION)
  private Boolean ignoreUriAndModuleKeyValidation;

  public DashboardGadgetSettings() {
  }

  public DashboardGadgetSettings moduleKey(String moduleKey) {
    
    this.moduleKey = moduleKey;
    return this;
  }

   /**
   * The module key of the gadget type. Can&#39;t be provided with &#x60;uri&#x60;.
   * @return moduleKey
  **/
  @jakarta.annotation.Nullable

  public String getModuleKey() {
    return moduleKey;
  }


  public void setModuleKey(String moduleKey) {
    this.moduleKey = moduleKey;
  }


  public DashboardGadgetSettings uri(String uri) {
    
    this.uri = uri;
    return this;
  }

   /**
   * The URI of the gadget type. Can&#39;t be provided with &#x60;moduleKey&#x60;.
   * @return uri
  **/
  @jakarta.annotation.Nullable

  public String getUri() {
    return uri;
  }


  public void setUri(String uri) {
    this.uri = uri;
  }


  public DashboardGadgetSettings color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * The color of the gadget. Should be one of &#x60;blue&#x60;, &#x60;red&#x60;, &#x60;yellow&#x60;, &#x60;green&#x60;, &#x60;cyan&#x60;, &#x60;purple&#x60;, &#x60;gray&#x60;, or &#x60;white&#x60;.
   * @return color
  **/
  @jakarta.annotation.Nullable

  public String getColor() {
    return color;
  }


  public void setColor(String color) {
    this.color = color;
  }


  public DashboardGadgetSettings position(DashboardGadgetSettingsPosition position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @jakarta.annotation.Nullable

  public DashboardGadgetSettingsPosition getPosition() {
    return position;
  }


  public void setPosition(DashboardGadgetSettingsPosition position) {
    this.position = position;
  }


  public DashboardGadgetSettings title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * The title of the gadget.
   * @return title
  **/
  @jakarta.annotation.Nullable

  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }


  public DashboardGadgetSettings ignoreUriAndModuleKeyValidation(Boolean ignoreUriAndModuleKeyValidation) {
    
    this.ignoreUriAndModuleKeyValidation = ignoreUriAndModuleKeyValidation;
    return this;
  }

   /**
   * Whether to ignore the validation of module key and URI. For example, when a gadget is created that is a part of an application that isn&#39;t installed.
   * @return ignoreUriAndModuleKeyValidation
  **/
  @jakarta.annotation.Nullable

  public Boolean getIgnoreUriAndModuleKeyValidation() {
    return ignoreUriAndModuleKeyValidation;
  }


  public void setIgnoreUriAndModuleKeyValidation(Boolean ignoreUriAndModuleKeyValidation) {
    this.ignoreUriAndModuleKeyValidation = ignoreUriAndModuleKeyValidation;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DashboardGadgetSettings dashboardGadgetSettings = (DashboardGadgetSettings) o;
    return Objects.equals(this.moduleKey, dashboardGadgetSettings.moduleKey) &&
        Objects.equals(this.uri, dashboardGadgetSettings.uri) &&
        Objects.equals(this.color, dashboardGadgetSettings.color) &&
        Objects.equals(this.position, dashboardGadgetSettings.position) &&
        Objects.equals(this.title, dashboardGadgetSettings.title) &&
        Objects.equals(this.ignoreUriAndModuleKeyValidation, dashboardGadgetSettings.ignoreUriAndModuleKeyValidation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(moduleKey, uri, color, position, title, ignoreUriAndModuleKeyValidation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DashboardGadgetSettings {\n");
    sb.append("    moduleKey: ").append(toIndentedString(moduleKey)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    ignoreUriAndModuleKeyValidation: ").append(toIndentedString(ignoreUriAndModuleKeyValidation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("moduleKey");
    openapiFields.add("uri");
    openapiFields.add("color");
    openapiFields.add("position");
    openapiFields.add("title");
    openapiFields.add("ignoreUriAndModuleKeyValidation");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to DashboardGadgetSettings
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!DashboardGadgetSettings.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in DashboardGadgetSettings is not found in the empty JSON string", DashboardGadgetSettings.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!DashboardGadgetSettings.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DashboardGadgetSettings` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("moduleKey") != null && !jsonObj.get("moduleKey").isJsonNull()) && !jsonObj.get("moduleKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `moduleKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("moduleKey").toString()));
      }
      if ((jsonObj.get("uri") != null && !jsonObj.get("uri").isJsonNull()) && !jsonObj.get("uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uri").toString()));
      }
      if ((jsonObj.get("color") != null && !jsonObj.get("color").isJsonNull()) && !jsonObj.get("color").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `color` to be a primitive type in the JSON string but got `%s`", jsonObj.get("color").toString()));
      }
      // validate the optional field `position`
      if (jsonObj.get("position") != null && !jsonObj.get("position").isJsonNull()) {
        DashboardGadgetSettingsPosition.validateJsonObject(jsonObj.getAsJsonObject("position"));
      }
      if ((jsonObj.get("title") != null && !jsonObj.get("title").isJsonNull()) && !jsonObj.get("title").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get("title").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DashboardGadgetSettings.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DashboardGadgetSettings' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DashboardGadgetSettings> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DashboardGadgetSettings.class));

       return (TypeAdapter<T>) new TypeAdapter<DashboardGadgetSettings>() {
           @Override
           public void write(JsonWriter out, DashboardGadgetSettings value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DashboardGadgetSettings read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DashboardGadgetSettings given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DashboardGadgetSettings
  * @throws IOException if the JSON string is invalid with respect to DashboardGadgetSettings
  */
  public static DashboardGadgetSettings fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DashboardGadgetSettings.class);
  }

 /**
  * Convert an instance of DashboardGadgetSettings to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

