/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import software.tnb.jira.validation.generated.model.DeprecatedWorkflowScope;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about a workflow.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class DeprecatedWorkflow {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_DATE = "lastModifiedDate";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_DATE)
  private String lastModifiedDate;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_USER = "lastModifiedUser";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_USER)
  private String lastModifiedUser;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_USER_ACCOUNT_ID = "lastModifiedUserAccountId";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_USER_ACCOUNT_ID)
  private String lastModifiedUserAccountId;

  public static final String SERIALIZED_NAME_STEPS = "steps";
  @SerializedName(SERIALIZED_NAME_STEPS)
  private Integer steps;

  public static final String SERIALIZED_NAME_SCOPE = "scope";
  @SerializedName(SERIALIZED_NAME_SCOPE)
  private DeprecatedWorkflowScope scope;

  public static final String SERIALIZED_NAME_DEFAULT = "default";
  @SerializedName(SERIALIZED_NAME_DEFAULT)
  private Boolean _default;

  public DeprecatedWorkflow() {
  }

  
  public DeprecatedWorkflow(
     String name, 
     String description, 
     String lastModifiedDate, 
     String lastModifiedUser, 
     String lastModifiedUserAccountId, 
     Integer steps
  ) {
    this();
    this.name = name;
    this.description = description;
    this.lastModifiedDate = lastModifiedDate;
    this.lastModifiedUser = lastModifiedUser;
    this.lastModifiedUserAccountId = lastModifiedUserAccountId;
    this.steps = steps;
  }

   /**
   * The name of the workflow.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }




   /**
   * The description of the workflow.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }




   /**
   * The datetime the workflow was last modified.
   * @return lastModifiedDate
  **/
  @jakarta.annotation.Nullable

  public String getLastModifiedDate() {
    return lastModifiedDate;
  }




   /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   * @return lastModifiedUser
  **/
  @jakarta.annotation.Nullable

  public String getLastModifiedUser() {
    return lastModifiedUser;
  }




   /**
   * The account ID of the user that last modified the workflow.
   * @return lastModifiedUserAccountId
  **/
  @jakarta.annotation.Nullable

  public String getLastModifiedUserAccountId() {
    return lastModifiedUserAccountId;
  }




   /**
   * The number of steps included in the workflow.
   * @return steps
  **/
  @jakarta.annotation.Nullable

  public Integer getSteps() {
    return steps;
  }




  public DeprecatedWorkflow scope(DeprecatedWorkflowScope scope) {
    
    this.scope = scope;
    return this;
  }

   /**
   * Get scope
   * @return scope
  **/
  @jakarta.annotation.Nullable

  public DeprecatedWorkflowScope getScope() {
    return scope;
  }


  public void setScope(DeprecatedWorkflowScope scope) {
    this.scope = scope;
  }


  public DeprecatedWorkflow _default(Boolean _default) {
    
    this._default = _default;
    return this;
  }

   /**
   * Get _default
   * @return _default
  **/
  @jakarta.annotation.Nullable

  public Boolean getDefault() {
    return _default;
  }


  public void setDefault(Boolean _default) {
    this._default = _default;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeprecatedWorkflow deprecatedWorkflow = (DeprecatedWorkflow) o;
    return Objects.equals(this.name, deprecatedWorkflow.name) &&
        Objects.equals(this.description, deprecatedWorkflow.description) &&
        Objects.equals(this.lastModifiedDate, deprecatedWorkflow.lastModifiedDate) &&
        Objects.equals(this.lastModifiedUser, deprecatedWorkflow.lastModifiedUser) &&
        Objects.equals(this.lastModifiedUserAccountId, deprecatedWorkflow.lastModifiedUserAccountId) &&
        Objects.equals(this.steps, deprecatedWorkflow.steps) &&
        Objects.equals(this.scope, deprecatedWorkflow.scope) &&
        Objects.equals(this._default, deprecatedWorkflow._default);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, lastModifiedDate, lastModifiedUser, lastModifiedUserAccountId, steps, scope, _default);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeprecatedWorkflow {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    lastModifiedDate: ").append(toIndentedString(lastModifiedDate)).append("\n");
    sb.append("    lastModifiedUser: ").append(toIndentedString(lastModifiedUser)).append("\n");
    sb.append("    lastModifiedUserAccountId: ").append(toIndentedString(lastModifiedUserAccountId)).append("\n");
    sb.append("    steps: ").append(toIndentedString(steps)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("lastModifiedDate");
    openapiFields.add("lastModifiedUser");
    openapiFields.add("lastModifiedUserAccountId");
    openapiFields.add("steps");
    openapiFields.add("scope");
    openapiFields.add("default");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to DeprecatedWorkflow
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!DeprecatedWorkflow.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in DeprecatedWorkflow is not found in the empty JSON string", DeprecatedWorkflow.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!DeprecatedWorkflow.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DeprecatedWorkflow` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("lastModifiedDate") != null && !jsonObj.get("lastModifiedDate").isJsonNull()) && !jsonObj.get("lastModifiedDate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lastModifiedDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lastModifiedDate").toString()));
      }
      if ((jsonObj.get("lastModifiedUser") != null && !jsonObj.get("lastModifiedUser").isJsonNull()) && !jsonObj.get("lastModifiedUser").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lastModifiedUser` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lastModifiedUser").toString()));
      }
      if ((jsonObj.get("lastModifiedUserAccountId") != null && !jsonObj.get("lastModifiedUserAccountId").isJsonNull()) && !jsonObj.get("lastModifiedUserAccountId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `lastModifiedUserAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("lastModifiedUserAccountId").toString()));
      }
      // validate the optional field `scope`
      if (jsonObj.get("scope") != null && !jsonObj.get("scope").isJsonNull()) {
        DeprecatedWorkflowScope.validateJsonObject(jsonObj.getAsJsonObject("scope"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DeprecatedWorkflow.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DeprecatedWorkflow' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DeprecatedWorkflow> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DeprecatedWorkflow.class));

       return (TypeAdapter<T>) new TypeAdapter<DeprecatedWorkflow>() {
           @Override
           public void write(JsonWriter out, DeprecatedWorkflow value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DeprecatedWorkflow read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DeprecatedWorkflow given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DeprecatedWorkflow
  * @throws IOException if the JSON string is invalid with respect to DeprecatedWorkflow
  */
  public static DeprecatedWorkflow fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DeprecatedWorkflow.class);
  }

 /**
  * Convert an instance of DeprecatedWorkflow to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

