/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import software.tnb.jira.validation.generated.model.FieldLastUsed;
import software.tnb.jira.validation.generated.model.JsonTypeBean;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of a field.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Field {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_SCHEMA = "schema";
  @SerializedName(SERIALIZED_NAME_SCHEMA)
  private JsonTypeBean schema;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_IS_LOCKED = "isLocked";
  @SerializedName(SERIALIZED_NAME_IS_LOCKED)
  private Boolean isLocked;

  public static final String SERIALIZED_NAME_IS_UNSCREENABLE = "isUnscreenable";
  @SerializedName(SERIALIZED_NAME_IS_UNSCREENABLE)
  private Boolean isUnscreenable;

  public static final String SERIALIZED_NAME_SEARCHER_KEY = "searcherKey";
  @SerializedName(SERIALIZED_NAME_SEARCHER_KEY)
  private String searcherKey;

  public static final String SERIALIZED_NAME_SCREENS_COUNT = "screensCount";
  @SerializedName(SERIALIZED_NAME_SCREENS_COUNT)
  private Long screensCount;

  public static final String SERIALIZED_NAME_CONTEXTS_COUNT = "contextsCount";
  @SerializedName(SERIALIZED_NAME_CONTEXTS_COUNT)
  private Long contextsCount;

  public static final String SERIALIZED_NAME_PROJECTS_COUNT = "projectsCount";
  @SerializedName(SERIALIZED_NAME_PROJECTS_COUNT)
  private Long projectsCount;

  public static final String SERIALIZED_NAME_LAST_USED = "lastUsed";
  @SerializedName(SERIALIZED_NAME_LAST_USED)
  private FieldLastUsed lastUsed;

  public Field() {
  }

  public Field id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the field.
   * @return id
  **/
  @jakarta.annotation.Nonnull

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public Field name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the field.
   * @return name
  **/
  @jakarta.annotation.Nonnull

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public Field schema(JsonTypeBean schema) {
    
    this.schema = schema;
    return this;
  }

   /**
   * Get schema
   * @return schema
  **/
  @jakarta.annotation.Nonnull

  public JsonTypeBean getSchema() {
    return schema;
  }


  public void setSchema(JsonTypeBean schema) {
    this.schema = schema;
  }


  public Field description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the field.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public Field key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * The key of the field.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public Field isLocked(Boolean isLocked) {
    
    this.isLocked = isLocked;
    return this;
  }

   /**
   * Whether the field is locked.
   * @return isLocked
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsLocked() {
    return isLocked;
  }


  public void setIsLocked(Boolean isLocked) {
    this.isLocked = isLocked;
  }


  public Field isUnscreenable(Boolean isUnscreenable) {
    
    this.isUnscreenable = isUnscreenable;
    return this;
  }

   /**
   * Whether the field is shown on screen or not.
   * @return isUnscreenable
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsUnscreenable() {
    return isUnscreenable;
  }


  public void setIsUnscreenable(Boolean isUnscreenable) {
    this.isUnscreenable = isUnscreenable;
  }


  public Field searcherKey(String searcherKey) {
    
    this.searcherKey = searcherKey;
    return this;
  }

   /**
   * The searcher key of the field. Returned for custom fields.
   * @return searcherKey
  **/
  @jakarta.annotation.Nullable

  public String getSearcherKey() {
    return searcherKey;
  }


  public void setSearcherKey(String searcherKey) {
    this.searcherKey = searcherKey;
  }


  public Field screensCount(Long screensCount) {
    
    this.screensCount = screensCount;
    return this;
  }

   /**
   * Number of screens where the field is used.
   * @return screensCount
  **/
  @jakarta.annotation.Nullable

  public Long getScreensCount() {
    return screensCount;
  }


  public void setScreensCount(Long screensCount) {
    this.screensCount = screensCount;
  }


  public Field contextsCount(Long contextsCount) {
    
    this.contextsCount = contextsCount;
    return this;
  }

   /**
   * Number of contexts where the field is used.
   * @return contextsCount
  **/
  @jakarta.annotation.Nullable

  public Long getContextsCount() {
    return contextsCount;
  }


  public void setContextsCount(Long contextsCount) {
    this.contextsCount = contextsCount;
  }


  public Field projectsCount(Long projectsCount) {
    
    this.projectsCount = projectsCount;
    return this;
  }

   /**
   * Number of projects where the field is used.
   * @return projectsCount
  **/
  @jakarta.annotation.Nullable

  public Long getProjectsCount() {
    return projectsCount;
  }


  public void setProjectsCount(Long projectsCount) {
    this.projectsCount = projectsCount;
  }


  public Field lastUsed(FieldLastUsed lastUsed) {
    
    this.lastUsed = lastUsed;
    return this;
  }

   /**
   * Get lastUsed
   * @return lastUsed
  **/
  @jakarta.annotation.Nullable

  public FieldLastUsed getLastUsed() {
    return lastUsed;
  }


  public void setLastUsed(FieldLastUsed lastUsed) {
    this.lastUsed = lastUsed;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Field field = (Field) o;
    return Objects.equals(this.id, field.id) &&
        Objects.equals(this.name, field.name) &&
        Objects.equals(this.schema, field.schema) &&
        Objects.equals(this.description, field.description) &&
        Objects.equals(this.key, field.key) &&
        Objects.equals(this.isLocked, field.isLocked) &&
        Objects.equals(this.isUnscreenable, field.isUnscreenable) &&
        Objects.equals(this.searcherKey, field.searcherKey) &&
        Objects.equals(this.screensCount, field.screensCount) &&
        Objects.equals(this.contextsCount, field.contextsCount) &&
        Objects.equals(this.projectsCount, field.projectsCount) &&
        Objects.equals(this.lastUsed, field.lastUsed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, schema, description, key, isLocked, isUnscreenable, searcherKey, screensCount, contextsCount, projectsCount, lastUsed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Field {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    isLocked: ").append(toIndentedString(isLocked)).append("\n");
    sb.append("    isUnscreenable: ").append(toIndentedString(isUnscreenable)).append("\n");
    sb.append("    searcherKey: ").append(toIndentedString(searcherKey)).append("\n");
    sb.append("    screensCount: ").append(toIndentedString(screensCount)).append("\n");
    sb.append("    contextsCount: ").append(toIndentedString(contextsCount)).append("\n");
    sb.append("    projectsCount: ").append(toIndentedString(projectsCount)).append("\n");
    sb.append("    lastUsed: ").append(toIndentedString(lastUsed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("name");
    openapiFields.add("schema");
    openapiFields.add("description");
    openapiFields.add("key");
    openapiFields.add("isLocked");
    openapiFields.add("isUnscreenable");
    openapiFields.add("searcherKey");
    openapiFields.add("screensCount");
    openapiFields.add("contextsCount");
    openapiFields.add("projectsCount");
    openapiFields.add("lastUsed");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("schema");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Field
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Field.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Field is not found in the empty JSON string", Field.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Field.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Field` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Field.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the required field `schema`
      JsonTypeBean.validateJsonObject(jsonObj.getAsJsonObject("schema"));
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if ((jsonObj.get("searcherKey") != null && !jsonObj.get("searcherKey").isJsonNull()) && !jsonObj.get("searcherKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `searcherKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("searcherKey").toString()));
      }
      // validate the optional field `lastUsed`
      if (jsonObj.get("lastUsed") != null && !jsonObj.get("lastUsed").isJsonNull()) {
        FieldLastUsed.validateJsonObject(jsonObj.getAsJsonObject("lastUsed"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Field.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Field' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Field> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Field.class));

       return (TypeAdapter<T>) new TypeAdapter<Field>() {
           @Override
           public void write(JsonWriter out, Field value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Field read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Field given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Field
  * @throws IOException if the JSON string is invalid with respect to Field
  */
  public static Field fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Field.class);
  }

 /**
  * Convert an instance of Field to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

