/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import software.tnb.jira.validation.generated.model.FieldDetailsSchema;
import software.tnb.jira.validation.generated.model.FieldDetailsScope;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about a field.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class FieldDetails {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_CUSTOM = "custom";
  @SerializedName(SERIALIZED_NAME_CUSTOM)
  private Boolean custom;

  public static final String SERIALIZED_NAME_ORDERABLE = "orderable";
  @SerializedName(SERIALIZED_NAME_ORDERABLE)
  private Boolean orderable;

  public static final String SERIALIZED_NAME_NAVIGABLE = "navigable";
  @SerializedName(SERIALIZED_NAME_NAVIGABLE)
  private Boolean navigable;

  public static final String SERIALIZED_NAME_SEARCHABLE = "searchable";
  @SerializedName(SERIALIZED_NAME_SEARCHABLE)
  private Boolean searchable;

  public static final String SERIALIZED_NAME_CLAUSE_NAMES = "clauseNames";
  @SerializedName(SERIALIZED_NAME_CLAUSE_NAMES)
  private Set<String> clauseNames = null;

  public static final String SERIALIZED_NAME_SCOPE = "scope";
  @SerializedName(SERIALIZED_NAME_SCOPE)
  private FieldDetailsScope scope;

  public static final String SERIALIZED_NAME_SCHEMA = "schema";
  @SerializedName(SERIALIZED_NAME_SCHEMA)
  private FieldDetailsSchema schema;

  public FieldDetails() {
  }

  public FieldDetails id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the field.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public FieldDetails key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * The key of the field.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public FieldDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the field.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public FieldDetails custom(Boolean custom) {
    
    this.custom = custom;
    return this;
  }

   /**
   * Whether the field is a custom field.
   * @return custom
  **/
  @jakarta.annotation.Nullable

  public Boolean getCustom() {
    return custom;
  }


  public void setCustom(Boolean custom) {
    this.custom = custom;
  }


  public FieldDetails orderable(Boolean orderable) {
    
    this.orderable = orderable;
    return this;
  }

   /**
   * Whether the content of the field can be used to order lists.
   * @return orderable
  **/
  @jakarta.annotation.Nullable

  public Boolean getOrderable() {
    return orderable;
  }


  public void setOrderable(Boolean orderable) {
    this.orderable = orderable;
  }


  public FieldDetails navigable(Boolean navigable) {
    
    this.navigable = navigable;
    return this;
  }

   /**
   * Whether the field can be used as a column on the issue navigator.
   * @return navigable
  **/
  @jakarta.annotation.Nullable

  public Boolean getNavigable() {
    return navigable;
  }


  public void setNavigable(Boolean navigable) {
    this.navigable = navigable;
  }


  public FieldDetails searchable(Boolean searchable) {
    
    this.searchable = searchable;
    return this;
  }

   /**
   * Whether the content of the field can be searched.
   * @return searchable
  **/
  @jakarta.annotation.Nullable

  public Boolean getSearchable() {
    return searchable;
  }


  public void setSearchable(Boolean searchable) {
    this.searchable = searchable;
  }


  public FieldDetails clauseNames(Set<String> clauseNames) {
    
    this.clauseNames = clauseNames;
    return this;
  }

  public FieldDetails addClauseNamesItem(String clauseNamesItem) {
    if (this.clauseNames == null) {
      this.clauseNames = new LinkedHashSet<>();
    }
    this.clauseNames.add(clauseNamesItem);
    return this;
  }

   /**
   * The names that can be used to reference the field in an advanced search. For more information, see [Advanced searching - fields reference](https://confluence.atlassian.com/x/gwORLQ).
   * @return clauseNames
  **/
  @jakarta.annotation.Nullable

  public Set<String> getClauseNames() {
    return clauseNames;
  }


  public void setClauseNames(Set<String> clauseNames) {
    this.clauseNames = clauseNames;
  }


  public FieldDetails scope(FieldDetailsScope scope) {
    
    this.scope = scope;
    return this;
  }

   /**
   * Get scope
   * @return scope
  **/
  @jakarta.annotation.Nullable

  public FieldDetailsScope getScope() {
    return scope;
  }


  public void setScope(FieldDetailsScope scope) {
    this.scope = scope;
  }


  public FieldDetails schema(FieldDetailsSchema schema) {
    
    this.schema = schema;
    return this;
  }

   /**
   * Get schema
   * @return schema
  **/
  @jakarta.annotation.Nullable

  public FieldDetailsSchema getSchema() {
    return schema;
  }


  public void setSchema(FieldDetailsSchema schema) {
    this.schema = schema;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FieldDetails fieldDetails = (FieldDetails) o;
    return Objects.equals(this.id, fieldDetails.id) &&
        Objects.equals(this.key, fieldDetails.key) &&
        Objects.equals(this.name, fieldDetails.name) &&
        Objects.equals(this.custom, fieldDetails.custom) &&
        Objects.equals(this.orderable, fieldDetails.orderable) &&
        Objects.equals(this.navigable, fieldDetails.navigable) &&
        Objects.equals(this.searchable, fieldDetails.searchable) &&
        Objects.equals(this.clauseNames, fieldDetails.clauseNames) &&
        Objects.equals(this.scope, fieldDetails.scope) &&
        Objects.equals(this.schema, fieldDetails.schema);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, name, custom, orderable, navigable, searchable, clauseNames, scope, schema);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FieldDetails {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    custom: ").append(toIndentedString(custom)).append("\n");
    sb.append("    orderable: ").append(toIndentedString(orderable)).append("\n");
    sb.append("    navigable: ").append(toIndentedString(navigable)).append("\n");
    sb.append("    searchable: ").append(toIndentedString(searchable)).append("\n");
    sb.append("    clauseNames: ").append(toIndentedString(clauseNames)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("key");
    openapiFields.add("name");
    openapiFields.add("custom");
    openapiFields.add("orderable");
    openapiFields.add("navigable");
    openapiFields.add("searchable");
    openapiFields.add("clauseNames");
    openapiFields.add("scope");
    openapiFields.add("schema");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FieldDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!FieldDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in FieldDetails is not found in the empty JSON string", FieldDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!FieldDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FieldDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("clauseNames") != null && !jsonObj.get("clauseNames").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `clauseNames` to be an array in the JSON string but got `%s`", jsonObj.get("clauseNames").toString()));
      }
      // validate the optional field `scope`
      if (jsonObj.get("scope") != null && !jsonObj.get("scope").isJsonNull()) {
        FieldDetailsScope.validateJsonObject(jsonObj.getAsJsonObject("scope"));
      }
      // validate the optional field `schema`
      if (jsonObj.get("schema") != null && !jsonObj.get("schema").isJsonNull()) {
        FieldDetailsSchema.validateJsonObject(jsonObj.getAsJsonObject("schema"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FieldDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FieldDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FieldDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FieldDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<FieldDetails>() {
           @Override
           public void write(JsonWriter out, FieldDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FieldDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FieldDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FieldDetails
  * @throws IOException if the JSON string is invalid with respect to FieldDetails
  */
  public static FieldDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FieldDetails.class);
  }

 /**
  * Convert an instance of FieldDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

