/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.tnb.jira.validation.generated.model.FieldMetadataSchema;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The metadata describing an issue field.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class FieldMetadata {
  public static final String SERIALIZED_NAME_REQUIRED = "required";
  @SerializedName(SERIALIZED_NAME_REQUIRED)
  private Boolean required;

  public static final String SERIALIZED_NAME_SCHEMA = "schema";
  @SerializedName(SERIALIZED_NAME_SCHEMA)
  private FieldMetadataSchema schema;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_AUTO_COMPLETE_URL = "autoCompleteUrl";
  @SerializedName(SERIALIZED_NAME_AUTO_COMPLETE_URL)
  private String autoCompleteUrl;

  public static final String SERIALIZED_NAME_HAS_DEFAULT_VALUE = "hasDefaultValue";
  @SerializedName(SERIALIZED_NAME_HAS_DEFAULT_VALUE)
  private Boolean hasDefaultValue;

  public static final String SERIALIZED_NAME_OPERATIONS = "operations";
  @SerializedName(SERIALIZED_NAME_OPERATIONS)
  private List<String> operations = new ArrayList<>();

  public static final String SERIALIZED_NAME_ALLOWED_VALUES = "allowedValues";
  @SerializedName(SERIALIZED_NAME_ALLOWED_VALUES)
  private List<Object> allowedValues = null;

  public static final String SERIALIZED_NAME_DEFAULT_VALUE = "defaultValue";
  @SerializedName(SERIALIZED_NAME_DEFAULT_VALUE)
  private Object defaultValue = null;

  public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
  @SerializedName(SERIALIZED_NAME_CONFIGURATION)
  private Map<String, Object> _configuration = null;

  public FieldMetadata() {
  }

  
  public FieldMetadata(
     Boolean required, 
     String name, 
     String key, 
     String autoCompleteUrl, 
     Boolean hasDefaultValue, 
     List<String> operations, 
     List<Object> allowedValues, 
     Object defaultValue, 
     Map<String, Object> _configuration
  ) {
    this();
    this.required = required;
    this.name = name;
    this.key = key;
    this.autoCompleteUrl = autoCompleteUrl;
    this.hasDefaultValue = hasDefaultValue;
    this.operations = operations;
    this.allowedValues = allowedValues;
    this.defaultValue = defaultValue;
    this._configuration = _configuration;
  }

   /**
   * Whether the field is required.
   * @return required
  **/
  @jakarta.annotation.Nonnull

  public Boolean getRequired() {
    return required;
  }




  public FieldMetadata schema(FieldMetadataSchema schema) {
    
    this.schema = schema;
    return this;
  }

   /**
   * Get schema
   * @return schema
  **/
  @jakarta.annotation.Nonnull

  public FieldMetadataSchema getSchema() {
    return schema;
  }


  public void setSchema(FieldMetadataSchema schema) {
    this.schema = schema;
  }


   /**
   * The name of the field.
   * @return name
  **/
  @jakarta.annotation.Nonnull

  public String getName() {
    return name;
  }




   /**
   * The key of the field.
   * @return key
  **/
  @jakarta.annotation.Nonnull

  public String getKey() {
    return key;
  }




   /**
   * The URL that can be used to automatically complete the field.
   * @return autoCompleteUrl
  **/
  @jakarta.annotation.Nullable

  public String getAutoCompleteUrl() {
    return autoCompleteUrl;
  }




   /**
   * Whether the field has a default value.
   * @return hasDefaultValue
  **/
  @jakarta.annotation.Nullable

  public Boolean getHasDefaultValue() {
    return hasDefaultValue;
  }




   /**
   * The list of operations that can be performed on the field.
   * @return operations
  **/
  @jakarta.annotation.Nonnull

  public List<String> getOperations() {
    return operations;
  }




   /**
   * The list of values allowed in the field.
   * @return allowedValues
  **/
  @jakarta.annotation.Nullable

  public List<Object> getAllowedValues() {
    return allowedValues;
  }




   /**
   * The default value of the field.
   * @return defaultValue
  **/
  @jakarta.annotation.Nullable

  public Object getDefaultValue() {
    return defaultValue;
  }




   /**
   * The configuration properties.
   * @return _configuration
  **/
  @jakarta.annotation.Nullable

  public Map<String, Object> getConfiguration() {
    return _configuration;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FieldMetadata fieldMetadata = (FieldMetadata) o;
    return Objects.equals(this.required, fieldMetadata.required) &&
        Objects.equals(this.schema, fieldMetadata.schema) &&
        Objects.equals(this.name, fieldMetadata.name) &&
        Objects.equals(this.key, fieldMetadata.key) &&
        Objects.equals(this.autoCompleteUrl, fieldMetadata.autoCompleteUrl) &&
        Objects.equals(this.hasDefaultValue, fieldMetadata.hasDefaultValue) &&
        Objects.equals(this.operations, fieldMetadata.operations) &&
        Objects.equals(this.allowedValues, fieldMetadata.allowedValues) &&
        Objects.equals(this.defaultValue, fieldMetadata.defaultValue) &&
        Objects.equals(this._configuration, fieldMetadata._configuration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(required, schema, name, key, autoCompleteUrl, hasDefaultValue, operations, allowedValues, defaultValue, _configuration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FieldMetadata {\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    autoCompleteUrl: ").append(toIndentedString(autoCompleteUrl)).append("\n");
    sb.append("    hasDefaultValue: ").append(toIndentedString(hasDefaultValue)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    allowedValues: ").append(toIndentedString(allowedValues)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("required");
    openapiFields.add("schema");
    openapiFields.add("name");
    openapiFields.add("key");
    openapiFields.add("autoCompleteUrl");
    openapiFields.add("hasDefaultValue");
    openapiFields.add("operations");
    openapiFields.add("allowedValues");
    openapiFields.add("defaultValue");
    openapiFields.add("configuration");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("required");
    openapiRequiredFields.add("schema");
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("key");
    openapiRequiredFields.add("operations");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FieldMetadata
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!FieldMetadata.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in FieldMetadata is not found in the empty JSON string", FieldMetadata.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!FieldMetadata.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FieldMetadata` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : FieldMetadata.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the required field `schema`
      FieldMetadataSchema.validateJsonObject(jsonObj.getAsJsonObject("schema"));
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (!jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if ((jsonObj.get("autoCompleteUrl") != null && !jsonObj.get("autoCompleteUrl").isJsonNull()) && !jsonObj.get("autoCompleteUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `autoCompleteUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("autoCompleteUrl").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("operations") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("operations").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `operations` to be an array in the JSON string but got `%s`", jsonObj.get("operations").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("allowedValues") != null && !jsonObj.get("allowedValues").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `allowedValues` to be an array in the JSON string but got `%s`", jsonObj.get("allowedValues").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FieldMetadata.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FieldMetadata' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FieldMetadata> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FieldMetadata.class));

       return (TypeAdapter<T>) new TypeAdapter<FieldMetadata>() {
           @Override
           public void write(JsonWriter out, FieldMetadata value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FieldMetadata read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FieldMetadata given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FieldMetadata
  * @throws IOException if the JSON string is invalid with respect to FieldMetadata
  */
  public static FieldMetadata fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FieldMetadata.class);
  }

 /**
  * Convert an instance of FieldMetadata to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

