/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.FilterDetailsOwner;
import software.tnb.jira.validation.generated.model.FilterSubscription;
import software.tnb.jira.validation.generated.model.SharePermission;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of a filter.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class FilterDetails {
  public static final String SERIALIZED_NAME_EXPAND = "expand";
  @SerializedName(SERIALIZED_NAME_EXPAND)
  private String expand;

  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_OWNER = "owner";
  @SerializedName(SERIALIZED_NAME_OWNER)
  private FilterDetailsOwner owner;

  public static final String SERIALIZED_NAME_JQL = "jql";
  @SerializedName(SERIALIZED_NAME_JQL)
  private String jql;

  public static final String SERIALIZED_NAME_VIEW_URL = "viewUrl";
  @SerializedName(SERIALIZED_NAME_VIEW_URL)
  private URI viewUrl;

  public static final String SERIALIZED_NAME_SEARCH_URL = "searchUrl";
  @SerializedName(SERIALIZED_NAME_SEARCH_URL)
  private URI searchUrl;

  public static final String SERIALIZED_NAME_FAVOURITE = "favourite";
  @SerializedName(SERIALIZED_NAME_FAVOURITE)
  private Boolean favourite;

  public static final String SERIALIZED_NAME_FAVOURITED_COUNT = "favouritedCount";
  @SerializedName(SERIALIZED_NAME_FAVOURITED_COUNT)
  private Long favouritedCount;

  public static final String SERIALIZED_NAME_SHARE_PERMISSIONS = "sharePermissions";
  @SerializedName(SERIALIZED_NAME_SHARE_PERMISSIONS)
  private List<SharePermission> sharePermissions = null;

  public static final String SERIALIZED_NAME_EDIT_PERMISSIONS = "editPermissions";
  @SerializedName(SERIALIZED_NAME_EDIT_PERMISSIONS)
  private List<SharePermission> editPermissions = null;

  public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
  @SerializedName(SERIALIZED_NAME_SUBSCRIPTIONS)
  private List<FilterSubscription> subscriptions = null;

  public FilterDetails() {
  }

  
  public FilterDetails(
     String expand, 
     URI self, 
     String id, 
     String jql, 
     URI viewUrl, 
     URI searchUrl, 
     Boolean favourite, 
     Long favouritedCount, 
     List<FilterSubscription> subscriptions
  ) {
    this();
    this.expand = expand;
    this.self = self;
    this.id = id;
    this.jql = jql;
    this.viewUrl = viewUrl;
    this.searchUrl = searchUrl;
    this.favourite = favourite;
    this.favouritedCount = favouritedCount;
    this.subscriptions = subscriptions;
  }

   /**
   * Expand options that include additional filter details in the response.
   * @return expand
  **/
  @jakarta.annotation.Nullable

  public String getExpand() {
    return expand;
  }




   /**
   * The URL of the filter.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




   /**
   * The unique identifier for the filter.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




  public FilterDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the filter.
   * @return name
  **/
  @jakarta.annotation.Nonnull

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public FilterDetails description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the filter.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public FilterDetails owner(FilterDetailsOwner owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @jakarta.annotation.Nullable

  public FilterDetailsOwner getOwner() {
    return owner;
  }


  public void setOwner(FilterDetailsOwner owner) {
    this.owner = owner;
  }


   /**
   * The JQL query for the filter. For example, *project &#x3D; SSP AND issuetype &#x3D; Bug*.
   * @return jql
  **/
  @jakarta.annotation.Nullable

  public String getJql() {
    return jql;
  }




   /**
   * A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter&#x3D;10100*.
   * @return viewUrl
  **/
  @jakarta.annotation.Nullable

  public URI getViewUrl() {
    return viewUrl;
  }




   /**
   * A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-3-filter-search-get) operation with the filter&#39;s JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/3/search?jql&#x3D;project+%3D+SSP+AND+issuetype+%3D+Bug*.
   * @return searchUrl
  **/
  @jakarta.annotation.Nullable

  public URI getSearchUrl() {
    return searchUrl;
  }




   /**
   * Whether the filter is selected as a favorite by any users, not including the filter owner.
   * @return favourite
  **/
  @jakarta.annotation.Nullable

  public Boolean getFavourite() {
    return favourite;
  }




   /**
   * The count of how many users have selected this filter as a favorite, including the filter owner.
   * @return favouritedCount
  **/
  @jakarta.annotation.Nullable

  public Long getFavouritedCount() {
    return favouritedCount;
  }




  public FilterDetails sharePermissions(List<SharePermission> sharePermissions) {
    
    this.sharePermissions = sharePermissions;
    return this;
  }

  public FilterDetails addSharePermissionsItem(SharePermission sharePermissionsItem) {
    if (this.sharePermissions == null) {
      this.sharePermissions = new ArrayList<>();
    }
    this.sharePermissions.add(sharePermissionsItem);
    return this;
  }

   /**
   * The groups and projects that the filter is shared with. This can be specified when updating a filter, but not when creating a filter.
   * @return sharePermissions
  **/
  @jakarta.annotation.Nullable

  public List<SharePermission> getSharePermissions() {
    return sharePermissions;
  }


  public void setSharePermissions(List<SharePermission> sharePermissions) {
    this.sharePermissions = sharePermissions;
  }


  public FilterDetails editPermissions(List<SharePermission> editPermissions) {
    
    this.editPermissions = editPermissions;
    return this;
  }

  public FilterDetails addEditPermissionsItem(SharePermission editPermissionsItem) {
    if (this.editPermissions == null) {
      this.editPermissions = new ArrayList<>();
    }
    this.editPermissions.add(editPermissionsItem);
    return this;
  }

   /**
   * The groups and projects that can edit the filter. This can be specified when updating a filter, but not when creating a filter.
   * @return editPermissions
  **/
  @jakarta.annotation.Nullable

  public List<SharePermission> getEditPermissions() {
    return editPermissions;
  }


  public void setEditPermissions(List<SharePermission> editPermissions) {
    this.editPermissions = editPermissions;
  }


   /**
   * The users that are subscribed to the filter.
   * @return subscriptions
  **/
  @jakarta.annotation.Nullable

  public List<FilterSubscription> getSubscriptions() {
    return subscriptions;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterDetails filterDetails = (FilterDetails) o;
    return Objects.equals(this.expand, filterDetails.expand) &&
        Objects.equals(this.self, filterDetails.self) &&
        Objects.equals(this.id, filterDetails.id) &&
        Objects.equals(this.name, filterDetails.name) &&
        Objects.equals(this.description, filterDetails.description) &&
        Objects.equals(this.owner, filterDetails.owner) &&
        Objects.equals(this.jql, filterDetails.jql) &&
        Objects.equals(this.viewUrl, filterDetails.viewUrl) &&
        Objects.equals(this.searchUrl, filterDetails.searchUrl) &&
        Objects.equals(this.favourite, filterDetails.favourite) &&
        Objects.equals(this.favouritedCount, filterDetails.favouritedCount) &&
        Objects.equals(this.sharePermissions, filterDetails.sharePermissions) &&
        Objects.equals(this.editPermissions, filterDetails.editPermissions) &&
        Objects.equals(this.subscriptions, filterDetails.subscriptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expand, self, id, name, description, owner, jql, viewUrl, searchUrl, favourite, favouritedCount, sharePermissions, editPermissions, subscriptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterDetails {\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    jql: ").append(toIndentedString(jql)).append("\n");
    sb.append("    viewUrl: ").append(toIndentedString(viewUrl)).append("\n");
    sb.append("    searchUrl: ").append(toIndentedString(searchUrl)).append("\n");
    sb.append("    favourite: ").append(toIndentedString(favourite)).append("\n");
    sb.append("    favouritedCount: ").append(toIndentedString(favouritedCount)).append("\n");
    sb.append("    sharePermissions: ").append(toIndentedString(sharePermissions)).append("\n");
    sb.append("    editPermissions: ").append(toIndentedString(editPermissions)).append("\n");
    sb.append("    subscriptions: ").append(toIndentedString(subscriptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("expand");
    openapiFields.add("self");
    openapiFields.add("id");
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("owner");
    openapiFields.add("jql");
    openapiFields.add("viewUrl");
    openapiFields.add("searchUrl");
    openapiFields.add("favourite");
    openapiFields.add("favouritedCount");
    openapiFields.add("sharePermissions");
    openapiFields.add("editPermissions");
    openapiFields.add("subscriptions");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("name");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FilterDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!FilterDetails.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in FilterDetails is not found in the empty JSON string", FilterDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!FilterDetails.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FilterDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : FilterDetails.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if ((jsonObj.get("expand") != null && !jsonObj.get("expand").isJsonNull()) && !jsonObj.get("expand").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `expand` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expand").toString()));
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field `owner`
      if (jsonObj.get("owner") != null && !jsonObj.get("owner").isJsonNull()) {
        FilterDetailsOwner.validateJsonObject(jsonObj.getAsJsonObject("owner"));
      }
      if ((jsonObj.get("jql") != null && !jsonObj.get("jql").isJsonNull()) && !jsonObj.get("jql").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `jql` to be a primitive type in the JSON string but got `%s`", jsonObj.get("jql").toString()));
      }
      if ((jsonObj.get("viewUrl") != null && !jsonObj.get("viewUrl").isJsonNull()) && !jsonObj.get("viewUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `viewUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("viewUrl").toString()));
      }
      if ((jsonObj.get("searchUrl") != null && !jsonObj.get("searchUrl").isJsonNull()) && !jsonObj.get("searchUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `searchUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("searchUrl").toString()));
      }
      if (jsonObj.get("sharePermissions") != null && !jsonObj.get("sharePermissions").isJsonNull()) {
        JsonArray jsonArraysharePermissions = jsonObj.getAsJsonArray("sharePermissions");
        if (jsonArraysharePermissions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("sharePermissions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sharePermissions` to be an array in the JSON string but got `%s`", jsonObj.get("sharePermissions").toString()));
          }

          // validate the optional field `sharePermissions` (array)
          for (int i = 0; i < jsonArraysharePermissions.size(); i++) {
            SharePermission.validateJsonObject(jsonArraysharePermissions.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("editPermissions") != null && !jsonObj.get("editPermissions").isJsonNull()) {
        JsonArray jsonArrayeditPermissions = jsonObj.getAsJsonArray("editPermissions");
        if (jsonArrayeditPermissions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("editPermissions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `editPermissions` to be an array in the JSON string but got `%s`", jsonObj.get("editPermissions").toString()));
          }

          // validate the optional field `editPermissions` (array)
          for (int i = 0; i < jsonArrayeditPermissions.size(); i++) {
            SharePermission.validateJsonObject(jsonArrayeditPermissions.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("subscriptions") != null && !jsonObj.get("subscriptions").isJsonNull()) {
        JsonArray jsonArraysubscriptions = jsonObj.getAsJsonArray("subscriptions");
        if (jsonArraysubscriptions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("subscriptions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `subscriptions` to be an array in the JSON string but got `%s`", jsonObj.get("subscriptions").toString()));
          }

          // validate the optional field `subscriptions` (array)
          for (int i = 0; i < jsonArraysubscriptions.size(); i++) {
            FilterSubscription.validateJsonObject(jsonArraysubscriptions.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FilterDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FilterDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FilterDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FilterDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<FilterDetails>() {
           @Override
           public void write(JsonWriter out, FilterDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FilterDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FilterDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FilterDetails
  * @throws IOException if the JSON string is invalid with respect to FilterDetails
  */
  public static FilterDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FilterDetails.class);
  }

 /**
  * Convert an instance of FilterDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

