/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.FilterSubscription;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A paginated list of the users that are subscribed to the filter.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class FilterSubscriptions {
  public static final String SERIALIZED_NAME_SIZE = "size";
  @SerializedName(SERIALIZED_NAME_SIZE)
  private Integer size;

  public static final String SERIALIZED_NAME_ITEMS = "items";
  @SerializedName(SERIALIZED_NAME_ITEMS)
  private List<FilterSubscription> items = null;

  public static final String SERIALIZED_NAME_MAX_RESULTS = "max-results";
  @SerializedName(SERIALIZED_NAME_MAX_RESULTS)
  private Integer maxResults;

  public static final String SERIALIZED_NAME_START_INDEX = "start-index";
  @SerializedName(SERIALIZED_NAME_START_INDEX)
  private Integer startIndex;

  public static final String SERIALIZED_NAME_END_INDEX = "end-index";
  @SerializedName(SERIALIZED_NAME_END_INDEX)
  private Integer endIndex;

  public FilterSubscriptions() {
  }

  
  public FilterSubscriptions(
     Integer size, 
     List<FilterSubscription> items, 
     Integer maxResults, 
     Integer startIndex, 
     Integer endIndex
  ) {
    this();
    this.size = size;
    this.items = items;
    this.maxResults = maxResults;
    this.startIndex = startIndex;
    this.endIndex = endIndex;
  }

   /**
   * The number of items on the page.
   * @return size
  **/
  @jakarta.annotation.Nullable

  public Integer getSize() {
    return size;
  }




   /**
   * The list of items.
   * @return items
  **/
  @jakarta.annotation.Nullable

  public List<FilterSubscription> getItems() {
    return items;
  }




   /**
   * The maximum number of results that could be on the page.
   * @return maxResults
  **/
  @jakarta.annotation.Nullable

  public Integer getMaxResults() {
    return maxResults;
  }




   /**
   * The index of the first item returned on the page.
   * @return startIndex
  **/
  @jakarta.annotation.Nullable

  public Integer getStartIndex() {
    return startIndex;
  }




   /**
   * The index of the last item returned on the page.
   * @return endIndex
  **/
  @jakarta.annotation.Nullable

  public Integer getEndIndex() {
    return endIndex;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterSubscriptions filterSubscriptions = (FilterSubscriptions) o;
    return Objects.equals(this.size, filterSubscriptions.size) &&
        Objects.equals(this.items, filterSubscriptions.items) &&
        Objects.equals(this.maxResults, filterSubscriptions.maxResults) &&
        Objects.equals(this.startIndex, filterSubscriptions.startIndex) &&
        Objects.equals(this.endIndex, filterSubscriptions.endIndex);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, items, maxResults, startIndex, endIndex);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterSubscriptions {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    maxResults: ").append(toIndentedString(maxResults)).append("\n");
    sb.append("    startIndex: ").append(toIndentedString(startIndex)).append("\n");
    sb.append("    endIndex: ").append(toIndentedString(endIndex)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("size");
    openapiFields.add("items");
    openapiFields.add("max-results");
    openapiFields.add("start-index");
    openapiFields.add("end-index");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FilterSubscriptions
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!FilterSubscriptions.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in FilterSubscriptions is not found in the empty JSON string", FilterSubscriptions.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!FilterSubscriptions.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FilterSubscriptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("items") != null && !jsonObj.get("items").isJsonNull()) {
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray("items");
        if (jsonArrayitems != null) {
          // ensure the json data is an array
          if (!jsonObj.get("items").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get("items").toString()));
          }

          // validate the optional field `items` (array)
          for (int i = 0; i < jsonArrayitems.size(); i++) {
            FilterSubscription.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FilterSubscriptions.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FilterSubscriptions' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FilterSubscriptions> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FilterSubscriptions.class));

       return (TypeAdapter<T>) new TypeAdapter<FilterSubscriptions>() {
           @Override
           public void write(JsonWriter out, FilterSubscriptions value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FilterSubscriptions read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FilterSubscriptions given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FilterSubscriptions
  * @throws IOException if the JSON string is invalid with respect to FilterSubscriptions
  */
  public static FilterSubscriptions fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FilterSubscriptions.class);
  }

 /**
  * Convert an instance of FilterSubscriptions to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

