/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import software.tnb.jira.validation.generated.model.HistoryMetadataActor;
import software.tnb.jira.validation.generated.model.HistoryMetadataCause;
import software.tnb.jira.validation.generated.model.HistoryMetadataGenerator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of issue history metadata.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class HistoryMetadata {
  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DESCRIPTION_KEY = "descriptionKey";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION_KEY)
  private String descriptionKey;

  public static final String SERIALIZED_NAME_ACTIVITY_DESCRIPTION = "activityDescription";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_DESCRIPTION)
  private String activityDescription;

  public static final String SERIALIZED_NAME_ACTIVITY_DESCRIPTION_KEY = "activityDescriptionKey";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_DESCRIPTION_KEY)
  private String activityDescriptionKey;

  public static final String SERIALIZED_NAME_EMAIL_DESCRIPTION = "emailDescription";
  @SerializedName(SERIALIZED_NAME_EMAIL_DESCRIPTION)
  private String emailDescription;

  public static final String SERIALIZED_NAME_EMAIL_DESCRIPTION_KEY = "emailDescriptionKey";
  @SerializedName(SERIALIZED_NAME_EMAIL_DESCRIPTION_KEY)
  private String emailDescriptionKey;

  public static final String SERIALIZED_NAME_ACTOR = "actor";
  @SerializedName(SERIALIZED_NAME_ACTOR)
  private HistoryMetadataActor actor;

  public static final String SERIALIZED_NAME_GENERATOR = "generator";
  @SerializedName(SERIALIZED_NAME_GENERATOR)
  private HistoryMetadataGenerator generator;

  public static final String SERIALIZED_NAME_CAUSE = "cause";
  @SerializedName(SERIALIZED_NAME_CAUSE)
  private HistoryMetadataCause cause;

  public static final String SERIALIZED_NAME_EXTRA_DATA = "extraData";
  @SerializedName(SERIALIZED_NAME_EXTRA_DATA)
  private Map<String, String> extraData = null;

  public HistoryMetadata() {
  }

  public HistoryMetadata type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the history record.
   * @return type
  **/
  @jakarta.annotation.Nullable

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public HistoryMetadata description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the history record.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public HistoryMetadata descriptionKey(String descriptionKey) {
    
    this.descriptionKey = descriptionKey;
    return this;
  }

   /**
   * The description key of the history record.
   * @return descriptionKey
  **/
  @jakarta.annotation.Nullable

  public String getDescriptionKey() {
    return descriptionKey;
  }


  public void setDescriptionKey(String descriptionKey) {
    this.descriptionKey = descriptionKey;
  }


  public HistoryMetadata activityDescription(String activityDescription) {
    
    this.activityDescription = activityDescription;
    return this;
  }

   /**
   * The activity described in the history record.
   * @return activityDescription
  **/
  @jakarta.annotation.Nullable

  public String getActivityDescription() {
    return activityDescription;
  }


  public void setActivityDescription(String activityDescription) {
    this.activityDescription = activityDescription;
  }


  public HistoryMetadata activityDescriptionKey(String activityDescriptionKey) {
    
    this.activityDescriptionKey = activityDescriptionKey;
    return this;
  }

   /**
   * The key of the activity described in the history record.
   * @return activityDescriptionKey
  **/
  @jakarta.annotation.Nullable

  public String getActivityDescriptionKey() {
    return activityDescriptionKey;
  }


  public void setActivityDescriptionKey(String activityDescriptionKey) {
    this.activityDescriptionKey = activityDescriptionKey;
  }


  public HistoryMetadata emailDescription(String emailDescription) {
    
    this.emailDescription = emailDescription;
    return this;
  }

   /**
   * The description of the email address associated the history record.
   * @return emailDescription
  **/
  @jakarta.annotation.Nullable

  public String getEmailDescription() {
    return emailDescription;
  }


  public void setEmailDescription(String emailDescription) {
    this.emailDescription = emailDescription;
  }


  public HistoryMetadata emailDescriptionKey(String emailDescriptionKey) {
    
    this.emailDescriptionKey = emailDescriptionKey;
    return this;
  }

   /**
   * The description key of the email address associated the history record.
   * @return emailDescriptionKey
  **/
  @jakarta.annotation.Nullable

  public String getEmailDescriptionKey() {
    return emailDescriptionKey;
  }


  public void setEmailDescriptionKey(String emailDescriptionKey) {
    this.emailDescriptionKey = emailDescriptionKey;
  }


  public HistoryMetadata actor(HistoryMetadataActor actor) {
    
    this.actor = actor;
    return this;
  }

   /**
   * Get actor
   * @return actor
  **/
  @jakarta.annotation.Nullable

  public HistoryMetadataActor getActor() {
    return actor;
  }


  public void setActor(HistoryMetadataActor actor) {
    this.actor = actor;
  }


  public HistoryMetadata generator(HistoryMetadataGenerator generator) {
    
    this.generator = generator;
    return this;
  }

   /**
   * Get generator
   * @return generator
  **/
  @jakarta.annotation.Nullable

  public HistoryMetadataGenerator getGenerator() {
    return generator;
  }


  public void setGenerator(HistoryMetadataGenerator generator) {
    this.generator = generator;
  }


  public HistoryMetadata cause(HistoryMetadataCause cause) {
    
    this.cause = cause;
    return this;
  }

   /**
   * Get cause
   * @return cause
  **/
  @jakarta.annotation.Nullable

  public HistoryMetadataCause getCause() {
    return cause;
  }


  public void setCause(HistoryMetadataCause cause) {
    this.cause = cause;
  }


  public HistoryMetadata extraData(Map<String, String> extraData) {
    
    this.extraData = extraData;
    return this;
  }

  public HistoryMetadata putExtraDataItem(String key, String extraDataItem) {
    if (this.extraData == null) {
      this.extraData = new HashMap<>();
    }
    this.extraData.put(key, extraDataItem);
    return this;
  }

   /**
   * Additional arbitrary information about the history record.
   * @return extraData
  **/
  @jakarta.annotation.Nullable

  public Map<String, String> getExtraData() {
    return extraData;
  }


  public void setExtraData(Map<String, String> extraData) {
    this.extraData = extraData;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the HistoryMetadata instance itself
   */
  public HistoryMetadata putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryMetadata historyMetadata = (HistoryMetadata) o;
    return Objects.equals(this.type, historyMetadata.type) &&
        Objects.equals(this.description, historyMetadata.description) &&
        Objects.equals(this.descriptionKey, historyMetadata.descriptionKey) &&
        Objects.equals(this.activityDescription, historyMetadata.activityDescription) &&
        Objects.equals(this.activityDescriptionKey, historyMetadata.activityDescriptionKey) &&
        Objects.equals(this.emailDescription, historyMetadata.emailDescription) &&
        Objects.equals(this.emailDescriptionKey, historyMetadata.emailDescriptionKey) &&
        Objects.equals(this.actor, historyMetadata.actor) &&
        Objects.equals(this.generator, historyMetadata.generator) &&
        Objects.equals(this.cause, historyMetadata.cause) &&
        Objects.equals(this.extraData, historyMetadata.extraData)&&
        Objects.equals(this.additionalProperties, historyMetadata.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, description, descriptionKey, activityDescription, activityDescriptionKey, emailDescription, emailDescriptionKey, actor, generator, cause, extraData, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryMetadata {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    descriptionKey: ").append(toIndentedString(descriptionKey)).append("\n");
    sb.append("    activityDescription: ").append(toIndentedString(activityDescription)).append("\n");
    sb.append("    activityDescriptionKey: ").append(toIndentedString(activityDescriptionKey)).append("\n");
    sb.append("    emailDescription: ").append(toIndentedString(emailDescription)).append("\n");
    sb.append("    emailDescriptionKey: ").append(toIndentedString(emailDescriptionKey)).append("\n");
    sb.append("    actor: ").append(toIndentedString(actor)).append("\n");
    sb.append("    generator: ").append(toIndentedString(generator)).append("\n");
    sb.append("    cause: ").append(toIndentedString(cause)).append("\n");
    sb.append("    extraData: ").append(toIndentedString(extraData)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("type");
    openapiFields.add("description");
    openapiFields.add("descriptionKey");
    openapiFields.add("activityDescription");
    openapiFields.add("activityDescriptionKey");
    openapiFields.add("emailDescription");
    openapiFields.add("emailDescriptionKey");
    openapiFields.add("actor");
    openapiFields.add("generator");
    openapiFields.add("cause");
    openapiFields.add("extraData");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to HistoryMetadata
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!HistoryMetadata.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in HistoryMetadata is not found in the empty JSON string", HistoryMetadata.openapiRequiredFields.toString()));
        }
      }
      if ((jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("descriptionKey") != null && !jsonObj.get("descriptionKey").isJsonNull()) && !jsonObj.get("descriptionKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `descriptionKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("descriptionKey").toString()));
      }
      if ((jsonObj.get("activityDescription") != null && !jsonObj.get("activityDescription").isJsonNull()) && !jsonObj.get("activityDescription").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `activityDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get("activityDescription").toString()));
      }
      if ((jsonObj.get("activityDescriptionKey") != null && !jsonObj.get("activityDescriptionKey").isJsonNull()) && !jsonObj.get("activityDescriptionKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `activityDescriptionKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("activityDescriptionKey").toString()));
      }
      if ((jsonObj.get("emailDescription") != null && !jsonObj.get("emailDescription").isJsonNull()) && !jsonObj.get("emailDescription").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `emailDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get("emailDescription").toString()));
      }
      if ((jsonObj.get("emailDescriptionKey") != null && !jsonObj.get("emailDescriptionKey").isJsonNull()) && !jsonObj.get("emailDescriptionKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `emailDescriptionKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("emailDescriptionKey").toString()));
      }
      // validate the optional field `actor`
      if (jsonObj.get("actor") != null && !jsonObj.get("actor").isJsonNull()) {
        HistoryMetadataActor.validateJsonObject(jsonObj.getAsJsonObject("actor"));
      }
      // validate the optional field `generator`
      if (jsonObj.get("generator") != null && !jsonObj.get("generator").isJsonNull()) {
        HistoryMetadataGenerator.validateJsonObject(jsonObj.getAsJsonObject("generator"));
      }
      // validate the optional field `cause`
      if (jsonObj.get("cause") != null && !jsonObj.get("cause").isJsonNull()) {
        HistoryMetadataCause.validateJsonObject(jsonObj.getAsJsonObject("cause"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!HistoryMetadata.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'HistoryMetadata' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<HistoryMetadata> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(HistoryMetadata.class));

       return (TypeAdapter<T>) new TypeAdapter<HistoryMetadata>() {
           @Override
           public void write(JsonWriter out, HistoryMetadata value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additional properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public HistoryMetadata read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             HistoryMetadata instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of HistoryMetadata given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of HistoryMetadata
  * @throws IOException if the JSON string is invalid with respect to HistoryMetadata
  */
  public static HistoryMetadata fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, HistoryMetadata.class);
  }

 /**
  * Convert an instance of HistoryMetadata to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

