/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.tnb.jira.validation.generated.model.IncludedFields;
import software.tnb.jira.validation.generated.model.IssueBeanChangelog;
import software.tnb.jira.validation.generated.model.IssueBeanEditmeta;
import software.tnb.jira.validation.generated.model.IssueBeanOperations;
import software.tnb.jira.validation.generated.model.IssueTransition;
import software.tnb.jira.validation.generated.model.JsonTypeBean;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about an issue.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class IssueBean {
  public static final String SERIALIZED_NAME_EXPAND = "expand";
  @SerializedName(SERIALIZED_NAME_EXPAND)
  private String expand;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_RENDERED_FIELDS = "renderedFields";
  @SerializedName(SERIALIZED_NAME_RENDERED_FIELDS)
  private Map<String, Object> renderedFields = null;

  public static final String SERIALIZED_NAME_PROPERTIES = "properties";
  @SerializedName(SERIALIZED_NAME_PROPERTIES)
  private Map<String, Object> properties = null;

  public static final String SERIALIZED_NAME_NAMES = "names";
  @SerializedName(SERIALIZED_NAME_NAMES)
  private Map<String, String> names = null;

  public static final String SERIALIZED_NAME_SCHEMA = "schema";
  @SerializedName(SERIALIZED_NAME_SCHEMA)
  private Map<String, JsonTypeBean> schema = null;

  public static final String SERIALIZED_NAME_TRANSITIONS = "transitions";
  @SerializedName(SERIALIZED_NAME_TRANSITIONS)
  private List<IssueTransition> transitions = null;

  public static final String SERIALIZED_NAME_OPERATIONS = "operations";
  @SerializedName(SERIALIZED_NAME_OPERATIONS)
  private IssueBeanOperations operations;

  public static final String SERIALIZED_NAME_EDITMETA = "editmeta";
  @SerializedName(SERIALIZED_NAME_EDITMETA)
  private IssueBeanEditmeta editmeta;

  public static final String SERIALIZED_NAME_CHANGELOG = "changelog";
  @SerializedName(SERIALIZED_NAME_CHANGELOG)
  private IssueBeanChangelog changelog;

  public static final String SERIALIZED_NAME_VERSIONED_REPRESENTATIONS = "versionedRepresentations";
  @SerializedName(SERIALIZED_NAME_VERSIONED_REPRESENTATIONS)
  private Map<String, Map<String, Object>> versionedRepresentations = null;

  public static final String SERIALIZED_NAME_FIELDS_TO_INCLUDE = "fieldsToInclude";
  @SerializedName(SERIALIZED_NAME_FIELDS_TO_INCLUDE)
  private IncludedFields fieldsToInclude;

  public static final String SERIALIZED_NAME_FIELDS = "fields";
  @SerializedName(SERIALIZED_NAME_FIELDS)
  private Map<String, Object> fields = null;

  public IssueBean() {
  }

  
  public IssueBean(
     String expand, 
     String id, 
     URI self, 
     String key, 
     Map<String, Object> renderedFields, 
     Map<String, Object> properties, 
     Map<String, String> names, 
     Map<String, JsonTypeBean> schema, 
     List<IssueTransition> transitions, 
     Map<String, Map<String, Object>> versionedRepresentations
  ) {
    this();
    this.expand = expand;
    this.id = id;
    this.self = self;
    this.key = key;
    this.renderedFields = renderedFields;
    this.properties = properties;
    this.names = names;
    this.schema = schema;
    this.transitions = transitions;
    this.versionedRepresentations = versionedRepresentations;
  }

   /**
   * Expand options that include additional issue details in the response.
   * @return expand
  **/
  @jakarta.annotation.Nullable

  public String getExpand() {
    return expand;
  }




   /**
   * The ID of the issue.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }




   /**
   * The URL of the issue details.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




   /**
   * The key of the issue.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }




   /**
   * The rendered value of each field present on the issue.
   * @return renderedFields
  **/
  @jakarta.annotation.Nullable

  public Map<String, Object> getRenderedFields() {
    return renderedFields;
  }




   /**
   * Details of the issue properties identified in the request.
   * @return properties
  **/
  @jakarta.annotation.Nullable

  public Map<String, Object> getProperties() {
    return properties;
  }




   /**
   * The ID and name of each field present on the issue.
   * @return names
  **/
  @jakarta.annotation.Nullable

  public Map<String, String> getNames() {
    return names;
  }




   /**
   * The schema describing each field present on the issue.
   * @return schema
  **/
  @jakarta.annotation.Nullable

  public Map<String, JsonTypeBean> getSchema() {
    return schema;
  }




   /**
   * The transitions that can be performed on the issue.
   * @return transitions
  **/
  @jakarta.annotation.Nullable

  public List<IssueTransition> getTransitions() {
    return transitions;
  }




  public IssueBean operations(IssueBeanOperations operations) {
    
    this.operations = operations;
    return this;
  }

   /**
   * Get operations
   * @return operations
  **/
  @jakarta.annotation.Nullable

  public IssueBeanOperations getOperations() {
    return operations;
  }


  public void setOperations(IssueBeanOperations operations) {
    this.operations = operations;
  }


  public IssueBean editmeta(IssueBeanEditmeta editmeta) {
    
    this.editmeta = editmeta;
    return this;
  }

   /**
   * Get editmeta
   * @return editmeta
  **/
  @jakarta.annotation.Nullable

  public IssueBeanEditmeta getEditmeta() {
    return editmeta;
  }


  public void setEditmeta(IssueBeanEditmeta editmeta) {
    this.editmeta = editmeta;
  }


  public IssueBean changelog(IssueBeanChangelog changelog) {
    
    this.changelog = changelog;
    return this;
  }

   /**
   * Get changelog
   * @return changelog
  **/
  @jakarta.annotation.Nullable

  public IssueBeanChangelog getChangelog() {
    return changelog;
  }


  public void setChangelog(IssueBeanChangelog changelog) {
    this.changelog = changelog;
  }


   /**
   * The versions of each field on the issue.
   * @return versionedRepresentations
  **/
  @jakarta.annotation.Nullable

  public Map<String, Map<String, Object>> getVersionedRepresentations() {
    return versionedRepresentations;
  }




  public IssueBean fieldsToInclude(IncludedFields fieldsToInclude) {
    
    this.fieldsToInclude = fieldsToInclude;
    return this;
  }

   /**
   * Get fieldsToInclude
   * @return fieldsToInclude
  **/
  @jakarta.annotation.Nullable

  public IncludedFields getFieldsToInclude() {
    return fieldsToInclude;
  }


  public void setFieldsToInclude(IncludedFields fieldsToInclude) {
    this.fieldsToInclude = fieldsToInclude;
  }


  public IssueBean fields(Map<String, Object> fields) {
    
    this.fields = fields;
    return this;
  }

  public IssueBean putFieldsItem(String key, Object fieldsItem) {
    if (this.fields == null) {
      this.fields = new HashMap<>();
    }
    this.fields.put(key, fieldsItem);
    return this;
  }

   /**
   * Get fields
   * @return fields
  **/
  @jakarta.annotation.Nullable

  public Map<String, Object> getFields() {
    return fields;
  }


  public void setFields(Map<String, Object> fields) {
    this.fields = fields;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueBean issueBean = (IssueBean) o;
    return Objects.equals(this.expand, issueBean.expand) &&
        Objects.equals(this.id, issueBean.id) &&
        Objects.equals(this.self, issueBean.self) &&
        Objects.equals(this.key, issueBean.key) &&
        Objects.equals(this.renderedFields, issueBean.renderedFields) &&
        Objects.equals(this.properties, issueBean.properties) &&
        Objects.equals(this.names, issueBean.names) &&
        Objects.equals(this.schema, issueBean.schema) &&
        Objects.equals(this.transitions, issueBean.transitions) &&
        Objects.equals(this.operations, issueBean.operations) &&
        Objects.equals(this.editmeta, issueBean.editmeta) &&
        Objects.equals(this.changelog, issueBean.changelog) &&
        Objects.equals(this.versionedRepresentations, issueBean.versionedRepresentations) &&
        Objects.equals(this.fieldsToInclude, issueBean.fieldsToInclude) &&
        Objects.equals(this.fields, issueBean.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expand, id, self, key, renderedFields, properties, names, schema, transitions, operations, editmeta, changelog, versionedRepresentations, fieldsToInclude, fields);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueBean {\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    renderedFields: ").append(toIndentedString(renderedFields)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    names: ").append(toIndentedString(names)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    editmeta: ").append(toIndentedString(editmeta)).append("\n");
    sb.append("    changelog: ").append(toIndentedString(changelog)).append("\n");
    sb.append("    versionedRepresentations: ").append(toIndentedString(versionedRepresentations)).append("\n");
    sb.append("    fieldsToInclude: ").append(toIndentedString(fieldsToInclude)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("expand");
    openapiFields.add("id");
    openapiFields.add("self");
    openapiFields.add("key");
    openapiFields.add("renderedFields");
    openapiFields.add("properties");
    openapiFields.add("names");
    openapiFields.add("schema");
    openapiFields.add("transitions");
    openapiFields.add("operations");
    openapiFields.add("editmeta");
    openapiFields.add("changelog");
    openapiFields.add("versionedRepresentations");
    openapiFields.add("fieldsToInclude");
    openapiFields.add("fields");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to IssueBean
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!IssueBean.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IssueBean is not found in the empty JSON string", IssueBean.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!IssueBean.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssueBean` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("expand") != null && !jsonObj.get("expand").isJsonNull()) && !jsonObj.get("expand").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `expand` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expand").toString()));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("transitions") != null && !jsonObj.get("transitions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `transitions` to be an array in the JSON string but got `%s`", jsonObj.get("transitions").toString()));
      }
      // validate the optional field `operations`
      if (jsonObj.get("operations") != null && !jsonObj.get("operations").isJsonNull()) {
        IssueBeanOperations.validateJsonObject(jsonObj.getAsJsonObject("operations"));
      }
      // validate the optional field `editmeta`
      if (jsonObj.get("editmeta") != null && !jsonObj.get("editmeta").isJsonNull()) {
        IssueBeanEditmeta.validateJsonObject(jsonObj.getAsJsonObject("editmeta"));
      }
      // validate the optional field `changelog`
      if (jsonObj.get("changelog") != null && !jsonObj.get("changelog").isJsonNull()) {
        IssueBeanChangelog.validateJsonObject(jsonObj.getAsJsonObject("changelog"));
      }
      // validate the optional field `fieldsToInclude`
      if (jsonObj.get("fieldsToInclude") != null && !jsonObj.get("fieldsToInclude").isJsonNull()) {
        IncludedFields.validateJsonObject(jsonObj.getAsJsonObject("fieldsToInclude"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IssueBean.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IssueBean' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IssueBean> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IssueBean.class));

       return (TypeAdapter<T>) new TypeAdapter<IssueBean>() {
           @Override
           public void write(JsonWriter out, IssueBean value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IssueBean read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IssueBean given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IssueBean
  * @throws IOException if the JSON string is invalid with respect to IssueBean
  */
  public static IssueBean fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IssueBean.class);
  }

 /**
  * Convert an instance of IssueBean to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

