/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import software.tnb.jira.validation.generated.model.IssueFieldOptionScopeBeanGlobal;
import software.tnb.jira.validation.generated.model.ProjectScopeBean;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * IssueFieldOptionScopeBean
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class IssueFieldOptionScopeBean {
  public static final String SERIALIZED_NAME_PROJECTS = "projects";
  @SerializedName(SERIALIZED_NAME_PROJECTS)
  private Set<Long> projects = null;

  public static final String SERIALIZED_NAME_PROJECTS2 = "projects2";
  @SerializedName(SERIALIZED_NAME_PROJECTS2)
  private Set<ProjectScopeBean> projects2 = null;

  public static final String SERIALIZED_NAME_GLOBAL = "global";
  @SerializedName(SERIALIZED_NAME_GLOBAL)
  private IssueFieldOptionScopeBeanGlobal global;

  public IssueFieldOptionScopeBean() {
  }

  public IssueFieldOptionScopeBean projects(Set<Long> projects) {
    
    this.projects = projects;
    return this;
  }

  public IssueFieldOptionScopeBean addProjectsItem(Long projectsItem) {
    if (this.projects == null) {
      this.projects = new LinkedHashSet<>();
    }
    this.projects.add(projectsItem);
    return this;
  }

   /**
   * DEPRECATED
   * @return projects
  **/
  @jakarta.annotation.Nullable

  public Set<Long> getProjects() {
    return projects;
  }


  public void setProjects(Set<Long> projects) {
    this.projects = projects;
  }


  public IssueFieldOptionScopeBean projects2(Set<ProjectScopeBean> projects2) {
    
    this.projects2 = projects2;
    return this;
  }

  public IssueFieldOptionScopeBean addProjects2Item(ProjectScopeBean projects2Item) {
    if (this.projects2 == null) {
      this.projects2 = new LinkedHashSet<>();
    }
    this.projects2.add(projects2Item);
    return this;
  }

   /**
   * Defines the projects in which the option is available and the behavior of the option within each project. Specify one object per project. The behavior of the option in a project context overrides the behavior in the global context.
   * @return projects2
  **/
  @jakarta.annotation.Nullable

  public Set<ProjectScopeBean> getProjects2() {
    return projects2;
  }


  public void setProjects2(Set<ProjectScopeBean> projects2) {
    this.projects2 = projects2;
  }


  public IssueFieldOptionScopeBean global(IssueFieldOptionScopeBeanGlobal global) {
    
    this.global = global;
    return this;
  }

   /**
   * Get global
   * @return global
  **/
  @jakarta.annotation.Nullable

  public IssueFieldOptionScopeBeanGlobal getGlobal() {
    return global;
  }


  public void setGlobal(IssueFieldOptionScopeBeanGlobal global) {
    this.global = global;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueFieldOptionScopeBean issueFieldOptionScopeBean = (IssueFieldOptionScopeBean) o;
    return Objects.equals(this.projects, issueFieldOptionScopeBean.projects) &&
        Objects.equals(this.projects2, issueFieldOptionScopeBean.projects2) &&
        Objects.equals(this.global, issueFieldOptionScopeBean.global);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projects, projects2, global);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueFieldOptionScopeBean {\n");
    sb.append("    projects: ").append(toIndentedString(projects)).append("\n");
    sb.append("    projects2: ").append(toIndentedString(projects2)).append("\n");
    sb.append("    global: ").append(toIndentedString(global)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("projects");
    openapiFields.add("projects2");
    openapiFields.add("global");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to IssueFieldOptionScopeBean
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!IssueFieldOptionScopeBean.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IssueFieldOptionScopeBean is not found in the empty JSON string", IssueFieldOptionScopeBean.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!IssueFieldOptionScopeBean.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssueFieldOptionScopeBean` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("projects") != null && !jsonObj.get("projects").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `projects` to be an array in the JSON string but got `%s`", jsonObj.get("projects").toString()));
      }
      if (jsonObj.get("projects2") != null && !jsonObj.get("projects2").isJsonNull()) {
        JsonArray jsonArrayprojects2 = jsonObj.getAsJsonArray("projects2");
        if (jsonArrayprojects2 != null) {
          // ensure the json data is an array
          if (!jsonObj.get("projects2").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `projects2` to be an array in the JSON string but got `%s`", jsonObj.get("projects2").toString()));
          }

          // validate the optional field `projects2` (array)
          for (int i = 0; i < jsonArrayprojects2.size(); i++) {
            ProjectScopeBean.validateJsonObject(jsonArrayprojects2.get(i).getAsJsonObject());
          };
        }
      }
      // validate the optional field `global`
      if (jsonObj.get("global") != null && !jsonObj.get("global").isJsonNull()) {
        IssueFieldOptionScopeBeanGlobal.validateJsonObject(jsonObj.getAsJsonObject("global"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IssueFieldOptionScopeBean.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IssueFieldOptionScopeBean' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IssueFieldOptionScopeBean> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IssueFieldOptionScopeBean.class));

       return (TypeAdapter<T>) new TypeAdapter<IssueFieldOptionScopeBean>() {
           @Override
           public void write(JsonWriter out, IssueFieldOptionScopeBean value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IssueFieldOptionScopeBean read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IssueFieldOptionScopeBean given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IssueFieldOptionScopeBean
  * @throws IOException if the JSON string is invalid with respect to IssueFieldOptionScopeBean
  */
  public static IssueFieldOptionScopeBean fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IssueFieldOptionScopeBean.class);
  }

 /**
  * Convert an instance of IssueFieldOptionScopeBean to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

