/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The IDs of the screen schemes for the issue type IDs.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class IssueTypeScreenSchemeMapping {
  public static final String SERIALIZED_NAME_ISSUE_TYPE_ID = "issueTypeId";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPE_ID)
  private String issueTypeId;

  public static final String SERIALIZED_NAME_SCREEN_SCHEME_ID = "screenSchemeId";
  @SerializedName(SERIALIZED_NAME_SCREEN_SCHEME_ID)
  private String screenSchemeId;

  public IssueTypeScreenSchemeMapping() {
  }

  public IssueTypeScreenSchemeMapping issueTypeId(String issueTypeId) {
    
    this.issueTypeId = issueTypeId;
    return this;
  }

   /**
   * The ID of the issue type or *default*. Only issue types used in classic projects are accepted. An entry for *default* must be provided and defines the mapping for all issue types without a screen scheme.
   * @return issueTypeId
  **/
  @jakarta.annotation.Nonnull

  public String getIssueTypeId() {
    return issueTypeId;
  }


  public void setIssueTypeId(String issueTypeId) {
    this.issueTypeId = issueTypeId;
  }


  public IssueTypeScreenSchemeMapping screenSchemeId(String screenSchemeId) {
    
    this.screenSchemeId = screenSchemeId;
    return this;
  }

   /**
   * The ID of the screen scheme. Only screen schemes used in classic projects are accepted.
   * @return screenSchemeId
  **/
  @jakarta.annotation.Nonnull

  public String getScreenSchemeId() {
    return screenSchemeId;
  }


  public void setScreenSchemeId(String screenSchemeId) {
    this.screenSchemeId = screenSchemeId;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueTypeScreenSchemeMapping issueTypeScreenSchemeMapping = (IssueTypeScreenSchemeMapping) o;
    return Objects.equals(this.issueTypeId, issueTypeScreenSchemeMapping.issueTypeId) &&
        Objects.equals(this.screenSchemeId, issueTypeScreenSchemeMapping.screenSchemeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issueTypeId, screenSchemeId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueTypeScreenSchemeMapping {\n");
    sb.append("    issueTypeId: ").append(toIndentedString(issueTypeId)).append("\n");
    sb.append("    screenSchemeId: ").append(toIndentedString(screenSchemeId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("issueTypeId");
    openapiFields.add("screenSchemeId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("issueTypeId");
    openapiRequiredFields.add("screenSchemeId");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to IssueTypeScreenSchemeMapping
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!IssueTypeScreenSchemeMapping.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IssueTypeScreenSchemeMapping is not found in the empty JSON string", IssueTypeScreenSchemeMapping.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!IssueTypeScreenSchemeMapping.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssueTypeScreenSchemeMapping` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : IssueTypeScreenSchemeMapping.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("issueTypeId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueTypeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issueTypeId").toString()));
      }
      if (!jsonObj.get("screenSchemeId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `screenSchemeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("screenSchemeId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IssueTypeScreenSchemeMapping.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IssueTypeScreenSchemeMapping' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IssueTypeScreenSchemeMapping> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IssueTypeScreenSchemeMapping.class));

       return (TypeAdapter<T>) new TypeAdapter<IssueTypeScreenSchemeMapping>() {
           @Override
           public void write(JsonWriter out, IssueTypeScreenSchemeMapping value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IssueTypeScreenSchemeMapping read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IssueTypeScreenSchemeMapping given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IssueTypeScreenSchemeMapping
  * @throws IOException if the JSON string is invalid with respect to IssueTypeScreenSchemeMapping
  */
  public static IssueTypeScreenSchemeMapping fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IssueTypeScreenSchemeMapping.class);
  }

 /**
  * Convert an instance of IssueTypeScreenSchemeMapping to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

