/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about the mapping between issue types and a workflow.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class IssueTypesWorkflowMapping {
  public static final String SERIALIZED_NAME_WORKFLOW = "workflow";
  @SerializedName(SERIALIZED_NAME_WORKFLOW)
  private String workflow;

  public static final String SERIALIZED_NAME_ISSUE_TYPES = "issueTypes";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPES)
  private List<String> issueTypes = null;

  public static final String SERIALIZED_NAME_DEFAULT_MAPPING = "defaultMapping";
  @SerializedName(SERIALIZED_NAME_DEFAULT_MAPPING)
  private Boolean defaultMapping;

  public static final String SERIALIZED_NAME_UPDATE_DRAFT_IF_NEEDED = "updateDraftIfNeeded";
  @SerializedName(SERIALIZED_NAME_UPDATE_DRAFT_IF_NEEDED)
  private Boolean updateDraftIfNeeded;

  public IssueTypesWorkflowMapping() {
  }

  public IssueTypesWorkflowMapping workflow(String workflow) {
    
    this.workflow = workflow;
    return this;
  }

   /**
   * The name of the workflow. Optional if updating the workflow-issue types mapping.
   * @return workflow
  **/
  @jakarta.annotation.Nullable

  public String getWorkflow() {
    return workflow;
  }


  public void setWorkflow(String workflow) {
    this.workflow = workflow;
  }


  public IssueTypesWorkflowMapping issueTypes(List<String> issueTypes) {
    
    this.issueTypes = issueTypes;
    return this;
  }

  public IssueTypesWorkflowMapping addIssueTypesItem(String issueTypesItem) {
    if (this.issueTypes == null) {
      this.issueTypes = new ArrayList<>();
    }
    this.issueTypes.add(issueTypesItem);
    return this;
  }

   /**
   * The list of issue type IDs.
   * @return issueTypes
  **/
  @jakarta.annotation.Nullable

  public List<String> getIssueTypes() {
    return issueTypes;
  }


  public void setIssueTypes(List<String> issueTypes) {
    this.issueTypes = issueTypes;
  }


  public IssueTypesWorkflowMapping defaultMapping(Boolean defaultMapping) {
    
    this.defaultMapping = defaultMapping;
    return this;
  }

   /**
   * Whether the workflow is the default workflow for the workflow scheme.
   * @return defaultMapping
  **/
  @jakarta.annotation.Nullable

  public Boolean getDefaultMapping() {
    return defaultMapping;
  }


  public void setDefaultMapping(Boolean defaultMapping) {
    this.defaultMapping = defaultMapping;
  }


  public IssueTypesWorkflowMapping updateDraftIfNeeded(Boolean updateDraftIfNeeded) {
    
    this.updateDraftIfNeeded = updateDraftIfNeeded;
    return this;
  }

   /**
   * Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new workflow-issue types mapping. Defaults to &#x60;false&#x60;.
   * @return updateDraftIfNeeded
  **/
  @jakarta.annotation.Nullable

  public Boolean getUpdateDraftIfNeeded() {
    return updateDraftIfNeeded;
  }


  public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
    this.updateDraftIfNeeded = updateDraftIfNeeded;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueTypesWorkflowMapping issueTypesWorkflowMapping = (IssueTypesWorkflowMapping) o;
    return Objects.equals(this.workflow, issueTypesWorkflowMapping.workflow) &&
        Objects.equals(this.issueTypes, issueTypesWorkflowMapping.issueTypes) &&
        Objects.equals(this.defaultMapping, issueTypesWorkflowMapping.defaultMapping) &&
        Objects.equals(this.updateDraftIfNeeded, issueTypesWorkflowMapping.updateDraftIfNeeded);
  }

  @Override
  public int hashCode() {
    return Objects.hash(workflow, issueTypes, defaultMapping, updateDraftIfNeeded);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueTypesWorkflowMapping {\n");
    sb.append("    workflow: ").append(toIndentedString(workflow)).append("\n");
    sb.append("    issueTypes: ").append(toIndentedString(issueTypes)).append("\n");
    sb.append("    defaultMapping: ").append(toIndentedString(defaultMapping)).append("\n");
    sb.append("    updateDraftIfNeeded: ").append(toIndentedString(updateDraftIfNeeded)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("workflow");
    openapiFields.add("issueTypes");
    openapiFields.add("defaultMapping");
    openapiFields.add("updateDraftIfNeeded");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to IssueTypesWorkflowMapping
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!IssueTypesWorkflowMapping.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IssueTypesWorkflowMapping is not found in the empty JSON string", IssueTypesWorkflowMapping.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!IssueTypesWorkflowMapping.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssueTypesWorkflowMapping` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("workflow") != null && !jsonObj.get("workflow").isJsonNull()) && !jsonObj.get("workflow").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `workflow` to be a primitive type in the JSON string but got `%s`", jsonObj.get("workflow").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("issueTypes") != null && !jsonObj.get("issueTypes").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueTypes` to be an array in the JSON string but got `%s`", jsonObj.get("issueTypes").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IssueTypesWorkflowMapping.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IssueTypesWorkflowMapping' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IssueTypesWorkflowMapping> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IssueTypesWorkflowMapping.class));

       return (TypeAdapter<T>) new TypeAdapter<IssueTypesWorkflowMapping>() {
           @Override
           public void write(JsonWriter out, IssueTypesWorkflowMapping value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IssueTypesWorkflowMapping read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IssueTypesWorkflowMapping given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IssueTypesWorkflowMapping
  * @throws IOException if the JSON string is invalid with respect to IssueTypesWorkflowMapping
  */
  public static IssueTypesWorkflowMapping fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IssueTypesWorkflowMapping.class);
  }

 /**
  * Convert an instance of IssueTypesWorkflowMapping to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

