/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import software.tnb.jira.validation.generated.model.FieldMetadata;
import software.tnb.jira.validation.generated.model.IssueTransitionTo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of a transition. Required when performing a transition, optional when creating or editing an issue.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class IssueUpdateDetailsTransition {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_TO = "to";
  @SerializedName(SERIALIZED_NAME_TO)
  private IssueTransitionTo to;

  public static final String SERIALIZED_NAME_HAS_SCREEN = "hasScreen";
  @SerializedName(SERIALIZED_NAME_HAS_SCREEN)
  private Boolean hasScreen;

  public static final String SERIALIZED_NAME_IS_GLOBAL = "isGlobal";
  @SerializedName(SERIALIZED_NAME_IS_GLOBAL)
  private Boolean isGlobal;

  public static final String SERIALIZED_NAME_IS_INITIAL = "isInitial";
  @SerializedName(SERIALIZED_NAME_IS_INITIAL)
  private Boolean isInitial;

  public static final String SERIALIZED_NAME_IS_AVAILABLE = "isAvailable";
  @SerializedName(SERIALIZED_NAME_IS_AVAILABLE)
  private Boolean isAvailable;

  public static final String SERIALIZED_NAME_IS_CONDITIONAL = "isConditional";
  @SerializedName(SERIALIZED_NAME_IS_CONDITIONAL)
  private Boolean isConditional;

  public static final String SERIALIZED_NAME_FIELDS = "fields";
  @SerializedName(SERIALIZED_NAME_FIELDS)
  private Map<String, FieldMetadata> fields = null;

  public static final String SERIALIZED_NAME_EXPAND = "expand";
  @SerializedName(SERIALIZED_NAME_EXPAND)
  private String expand;

  public static final String SERIALIZED_NAME_LOOPED = "looped";
  @SerializedName(SERIALIZED_NAME_LOOPED)
  private Boolean looped;

  public IssueUpdateDetailsTransition() {
  }

  
  public IssueUpdateDetailsTransition(
     String name, 
     Boolean hasScreen, 
     Boolean isGlobal, 
     Boolean isInitial, 
     Boolean isAvailable, 
     Boolean isConditional, 
     Map<String, FieldMetadata> fields, 
     String expand
  ) {
    this();
    this.name = name;
    this.hasScreen = hasScreen;
    this.isGlobal = isGlobal;
    this.isInitial = isInitial;
    this.isAvailable = isAvailable;
    this.isConditional = isConditional;
    this.fields = fields;
    this.expand = expand;
  }

  public IssueUpdateDetailsTransition id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the issue transition. Required when specifying a transition to undertake.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


   /**
   * The name of the issue transition.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }




  public IssueUpdateDetailsTransition to(IssueTransitionTo to) {
    
    this.to = to;
    return this;
  }

   /**
   * Get to
   * @return to
  **/
  @jakarta.annotation.Nullable

  public IssueTransitionTo getTo() {
    return to;
  }


  public void setTo(IssueTransitionTo to) {
    this.to = to;
  }


   /**
   * Whether there is a screen associated with the issue transition.
   * @return hasScreen
  **/
  @jakarta.annotation.Nullable

  public Boolean getHasScreen() {
    return hasScreen;
  }




   /**
   * Whether the issue transition is global, that is, the transition is applied to issues regardless of their status.
   * @return isGlobal
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsGlobal() {
    return isGlobal;
  }




   /**
   * Whether this is the initial issue transition for the workflow.
   * @return isInitial
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsInitial() {
    return isInitial;
  }




   /**
   * Whether the transition is available to be performed.
   * @return isAvailable
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsAvailable() {
    return isAvailable;
  }




   /**
   * Whether the issue has to meet criteria before the issue transition is applied.
   * @return isConditional
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsConditional() {
    return isConditional;
  }




   /**
   * Details of the fields associated with the issue transition screen. Use this information to populate &#x60;fields&#x60; and &#x60;update&#x60; in a transition request.
   * @return fields
  **/
  @jakarta.annotation.Nullable

  public Map<String, FieldMetadata> getFields() {
    return fields;
  }




   /**
   * Expand options that include additional transition details in the response.
   * @return expand
  **/
  @jakarta.annotation.Nullable

  public String getExpand() {
    return expand;
  }




  public IssueUpdateDetailsTransition looped(Boolean looped) {
    
    this.looped = looped;
    return this;
  }

   /**
   * Get looped
   * @return looped
  **/
  @jakarta.annotation.Nullable

  public Boolean getLooped() {
    return looped;
  }


  public void setLooped(Boolean looped) {
    this.looped = looped;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueUpdateDetailsTransition issueUpdateDetailsTransition = (IssueUpdateDetailsTransition) o;
    return Objects.equals(this.id, issueUpdateDetailsTransition.id) &&
        Objects.equals(this.name, issueUpdateDetailsTransition.name) &&
        Objects.equals(this.to, issueUpdateDetailsTransition.to) &&
        Objects.equals(this.hasScreen, issueUpdateDetailsTransition.hasScreen) &&
        Objects.equals(this.isGlobal, issueUpdateDetailsTransition.isGlobal) &&
        Objects.equals(this.isInitial, issueUpdateDetailsTransition.isInitial) &&
        Objects.equals(this.isAvailable, issueUpdateDetailsTransition.isAvailable) &&
        Objects.equals(this.isConditional, issueUpdateDetailsTransition.isConditional) &&
        Objects.equals(this.fields, issueUpdateDetailsTransition.fields) &&
        Objects.equals(this.expand, issueUpdateDetailsTransition.expand) &&
        Objects.equals(this.looped, issueUpdateDetailsTransition.looped);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, to, hasScreen, isGlobal, isInitial, isAvailable, isConditional, fields, expand, looped);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueUpdateDetailsTransition {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    hasScreen: ").append(toIndentedString(hasScreen)).append("\n");
    sb.append("    isGlobal: ").append(toIndentedString(isGlobal)).append("\n");
    sb.append("    isInitial: ").append(toIndentedString(isInitial)).append("\n");
    sb.append("    isAvailable: ").append(toIndentedString(isAvailable)).append("\n");
    sb.append("    isConditional: ").append(toIndentedString(isConditional)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    looped: ").append(toIndentedString(looped)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("name");
    openapiFields.add("to");
    openapiFields.add("hasScreen");
    openapiFields.add("isGlobal");
    openapiFields.add("isInitial");
    openapiFields.add("isAvailable");
    openapiFields.add("isConditional");
    openapiFields.add("fields");
    openapiFields.add("expand");
    openapiFields.add("looped");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to IssueUpdateDetailsTransition
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!IssueUpdateDetailsTransition.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IssueUpdateDetailsTransition is not found in the empty JSON string", IssueUpdateDetailsTransition.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!IssueUpdateDetailsTransition.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssueUpdateDetailsTransition` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `to`
      if (jsonObj.get("to") != null && !jsonObj.get("to").isJsonNull()) {
        IssueTransitionTo.validateJsonObject(jsonObj.getAsJsonObject("to"));
      }
      if ((jsonObj.get("expand") != null && !jsonObj.get("expand").isJsonNull()) && !jsonObj.get("expand").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `expand` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expand").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IssueUpdateDetailsTransition.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IssueUpdateDetailsTransition' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IssueUpdateDetailsTransition> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IssueUpdateDetailsTransition.class));

       return (TypeAdapter<T>) new TypeAdapter<IssueUpdateDetailsTransition>() {
           @Override
           public void write(JsonWriter out, IssueUpdateDetailsTransition value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IssueUpdateDetailsTransition read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IssueUpdateDetailsTransition given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IssueUpdateDetailsTransition
  * @throws IOException if the JSON string is invalid with respect to IssueUpdateDetailsTransition
  */
  public static IssueUpdateDetailsTransition fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IssueUpdateDetailsTransition.class);
  }

 /**
  * Convert an instance of IssueUpdateDetailsTransition to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

