/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * List of issues and JQL queries.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class IssuesAndJQLQueries {
  public static final String SERIALIZED_NAME_JQLS = "jqls";
  @SerializedName(SERIALIZED_NAME_JQLS)
  private List<String> jqls = new ArrayList<>();

  public static final String SERIALIZED_NAME_ISSUE_IDS = "issueIds";
  @SerializedName(SERIALIZED_NAME_ISSUE_IDS)
  private Set<Long> issueIds = new LinkedHashSet<>();

  public IssuesAndJQLQueries() {
  }

  public IssuesAndJQLQueries jqls(List<String> jqls) {
    
    this.jqls = jqls;
    return this;
  }

  public IssuesAndJQLQueries addJqlsItem(String jqlsItem) {
    this.jqls.add(jqlsItem);
    return this;
  }

   /**
   * A list of JQL queries.
   * @return jqls
  **/
  @jakarta.annotation.Nonnull

  public List<String> getJqls() {
    return jqls;
  }


  public void setJqls(List<String> jqls) {
    this.jqls = jqls;
  }


  public IssuesAndJQLQueries issueIds(Set<Long> issueIds) {
    
    this.issueIds = issueIds;
    return this;
  }

  public IssuesAndJQLQueries addIssueIdsItem(Long issueIdsItem) {
    this.issueIds.add(issueIdsItem);
    return this;
  }

   /**
   * A list of issue IDs.
   * @return issueIds
  **/
  @jakarta.annotation.Nonnull

  public Set<Long> getIssueIds() {
    return issueIds;
  }


  public void setIssueIds(Set<Long> issueIds) {
    this.issueIds = issueIds;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssuesAndJQLQueries issuesAndJQLQueries = (IssuesAndJQLQueries) o;
    return Objects.equals(this.jqls, issuesAndJQLQueries.jqls) &&
        Objects.equals(this.issueIds, issuesAndJQLQueries.issueIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jqls, issueIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssuesAndJQLQueries {\n");
    sb.append("    jqls: ").append(toIndentedString(jqls)).append("\n");
    sb.append("    issueIds: ").append(toIndentedString(issueIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("jqls");
    openapiFields.add("issueIds");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("jqls");
    openapiRequiredFields.add("issueIds");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to IssuesAndJQLQueries
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!IssuesAndJQLQueries.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in IssuesAndJQLQueries is not found in the empty JSON string", IssuesAndJQLQueries.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!IssuesAndJQLQueries.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IssuesAndJQLQueries` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : IssuesAndJQLQueries.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the required json array is present
      if (jsonObj.get("jqls") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("jqls").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `jqls` to be an array in the JSON string but got `%s`", jsonObj.get("jqls").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("issueIds") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("issueIds").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueIds` to be an array in the JSON string but got `%s`", jsonObj.get("issueIds").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!IssuesAndJQLQueries.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'IssuesAndJQLQueries' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<IssuesAndJQLQueries> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(IssuesAndJQLQueries.class));

       return (TypeAdapter<T>) new TypeAdapter<IssuesAndJQLQueries>() {
           @Override
           public void write(JsonWriter out, IssuesAndJQLQueries value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public IssuesAndJQLQueries read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of IssuesAndJQLQueries given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of IssuesAndJQLQueries
  * @throws IOException if the JSON string is invalid with respect to IssuesAndJQLQueries
  */
  public static IssuesAndJQLQueries fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, IssuesAndJQLQueries.class);
  }

 /**
  * Convert an instance of IssuesAndJQLQueries to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

