/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A custom field and its new value with a list of issue to update.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class MultipleCustomFieldValuesUpdate {
  public static final String SERIALIZED_NAME_CUSTOM_FIELD = "customField";
  @SerializedName(SERIALIZED_NAME_CUSTOM_FIELD)
  private String customField;

  public static final String SERIALIZED_NAME_ISSUE_IDS = "issueIds";
  @SerializedName(SERIALIZED_NAME_ISSUE_IDS)
  private List<Long> issueIds = new ArrayList<>();

  public static final String SERIALIZED_NAME_VALUE = "value";
  @SerializedName(SERIALIZED_NAME_VALUE)
  private Object value = null;

  public MultipleCustomFieldValuesUpdate() {
  }

  public MultipleCustomFieldValuesUpdate customField(String customField) {
    
    this.customField = customField;
    return this;
  }

   /**
   * The ID or key of the custom field. For example, &#x60;customfield_10010&#x60;.
   * @return customField
  **/
  @jakarta.annotation.Nonnull

  public String getCustomField() {
    return customField;
  }


  public void setCustomField(String customField) {
    this.customField = customField;
  }


  public MultipleCustomFieldValuesUpdate issueIds(List<Long> issueIds) {
    
    this.issueIds = issueIds;
    return this;
  }

  public MultipleCustomFieldValuesUpdate addIssueIdsItem(Long issueIdsItem) {
    this.issueIds.add(issueIdsItem);
    return this;
  }

   /**
   * The list of issue IDs.
   * @return issueIds
  **/
  @jakarta.annotation.Nonnull

  public List<Long> getIssueIds() {
    return issueIds;
  }


  public void setIssueIds(List<Long> issueIds) {
    this.issueIds = issueIds;
  }


  public MultipleCustomFieldValuesUpdate value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#data-types) as follows:   *  &#x60;string&#x60; the value must be a string.  *  &#x60;number&#x60; the value must be a number.  *  &#x60;datetime&#x60; the value must be a string that represents a date in the ISO format or the simplified extended ISO format. For example, &#x60;\&quot;2023-01-18T12:00:00-03:00\&quot;&#x60; or &#x60;\&quot;2023-01-18T12:00:00.000Z\&quot;&#x60;. However, the milliseconds part is ignored.  *  &#x60;user&#x60; the value must be an object that contains the &#x60;accountId&#x60; field.  *  &#x60;group&#x60; the value must be an object that contains the group &#x60;name&#x60; or &#x60;groupId&#x60; field. Because group names can change, we recommend using &#x60;groupId&#x60;.  A list of appropriate values must be provided if the field is of the &#x60;list&#x60; [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#collection-types).
   * @return value
  **/
  @jakarta.annotation.Nullable

  public Object getValue() {
    return value;
  }


  public void setValue(Object value) {
    this.value = value;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultipleCustomFieldValuesUpdate multipleCustomFieldValuesUpdate = (MultipleCustomFieldValuesUpdate) o;
    return Objects.equals(this.customField, multipleCustomFieldValuesUpdate.customField) &&
        Objects.equals(this.issueIds, multipleCustomFieldValuesUpdate.issueIds) &&
        Objects.equals(this.value, multipleCustomFieldValuesUpdate.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customField, issueIds, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultipleCustomFieldValuesUpdate {\n");
    sb.append("    customField: ").append(toIndentedString(customField)).append("\n");
    sb.append("    issueIds: ").append(toIndentedString(issueIds)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("customField");
    openapiFields.add("issueIds");
    openapiFields.add("value");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("customField");
    openapiRequiredFields.add("issueIds");
    openapiRequiredFields.add("value");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to MultipleCustomFieldValuesUpdate
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!MultipleCustomFieldValuesUpdate.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in MultipleCustomFieldValuesUpdate is not found in the empty JSON string", MultipleCustomFieldValuesUpdate.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!MultipleCustomFieldValuesUpdate.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MultipleCustomFieldValuesUpdate` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : MultipleCustomFieldValuesUpdate.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("customField").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `customField` to be a primitive type in the JSON string but got `%s`", jsonObj.get("customField").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("issueIds") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("issueIds").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueIds` to be an array in the JSON string but got `%s`", jsonObj.get("issueIds").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MultipleCustomFieldValuesUpdate.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MultipleCustomFieldValuesUpdate' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MultipleCustomFieldValuesUpdate> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MultipleCustomFieldValuesUpdate.class));

       return (TypeAdapter<T>) new TypeAdapter<MultipleCustomFieldValuesUpdate>() {
           @Override
           public void write(JsonWriter out, MultipleCustomFieldValuesUpdate value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public MultipleCustomFieldValuesUpdate read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MultipleCustomFieldValuesUpdate given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MultipleCustomFieldValuesUpdate
  * @throws IOException if the JSON string is invalid with respect to MultipleCustomFieldValuesUpdate
  */
  public static MultipleCustomFieldValuesUpdate fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MultipleCustomFieldValuesUpdate.class);
  }

 /**
  * Convert an instance of MultipleCustomFieldValuesUpdate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

