/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.GroupName;
import software.tnb.jira.validation.generated.model.UserDetails;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The recipients of the email notification for the issue.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class NotificationTo {
  public static final String SERIALIZED_NAME_REPORTER = "reporter";
  @SerializedName(SERIALIZED_NAME_REPORTER)
  private Boolean reporter;

  public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
  @SerializedName(SERIALIZED_NAME_ASSIGNEE)
  private Boolean assignee;

  public static final String SERIALIZED_NAME_WATCHERS = "watchers";
  @SerializedName(SERIALIZED_NAME_WATCHERS)
  private Boolean watchers;

  public static final String SERIALIZED_NAME_VOTERS = "voters";
  @SerializedName(SERIALIZED_NAME_VOTERS)
  private Boolean voters;

  public static final String SERIALIZED_NAME_USERS = "users";
  @SerializedName(SERIALIZED_NAME_USERS)
  private List<UserDetails> users = null;

  public static final String SERIALIZED_NAME_GROUPS = "groups";
  @SerializedName(SERIALIZED_NAME_GROUPS)
  private List<GroupName> groups = null;

  public static final String SERIALIZED_NAME_GROUP_IDS = "groupIds";
  @SerializedName(SERIALIZED_NAME_GROUP_IDS)
  private List<String> groupIds = null;

  public NotificationTo() {
  }

  public NotificationTo reporter(Boolean reporter) {
    
    this.reporter = reporter;
    return this;
  }

   /**
   * Whether the notification should be sent to the issue&#39;s reporter.
   * @return reporter
  **/
  @jakarta.annotation.Nullable

  public Boolean getReporter() {
    return reporter;
  }


  public void setReporter(Boolean reporter) {
    this.reporter = reporter;
  }


  public NotificationTo assignee(Boolean assignee) {
    
    this.assignee = assignee;
    return this;
  }

   /**
   * Whether the notification should be sent to the issue&#39;s assignees.
   * @return assignee
  **/
  @jakarta.annotation.Nullable

  public Boolean getAssignee() {
    return assignee;
  }


  public void setAssignee(Boolean assignee) {
    this.assignee = assignee;
  }


  public NotificationTo watchers(Boolean watchers) {
    
    this.watchers = watchers;
    return this;
  }

   /**
   * Whether the notification should be sent to the issue&#39;s watchers.
   * @return watchers
  **/
  @jakarta.annotation.Nullable

  public Boolean getWatchers() {
    return watchers;
  }


  public void setWatchers(Boolean watchers) {
    this.watchers = watchers;
  }


  public NotificationTo voters(Boolean voters) {
    
    this.voters = voters;
    return this;
  }

   /**
   * Whether the notification should be sent to the issue&#39;s voters.
   * @return voters
  **/
  @jakarta.annotation.Nullable

  public Boolean getVoters() {
    return voters;
  }


  public void setVoters(Boolean voters) {
    this.voters = voters;
  }


  public NotificationTo users(List<UserDetails> users) {
    
    this.users = users;
    return this;
  }

  public NotificationTo addUsersItem(UserDetails usersItem) {
    if (this.users == null) {
      this.users = new ArrayList<>();
    }
    this.users.add(usersItem);
    return this;
  }

   /**
   * List of users to receive the notification.
   * @return users
  **/
  @jakarta.annotation.Nullable

  public List<UserDetails> getUsers() {
    return users;
  }


  public void setUsers(List<UserDetails> users) {
    this.users = users;
  }


  public NotificationTo groups(List<GroupName> groups) {
    
    this.groups = groups;
    return this;
  }

  public NotificationTo addGroupsItem(GroupName groupsItem) {
    if (this.groups == null) {
      this.groups = new ArrayList<>();
    }
    this.groups.add(groupsItem);
    return this;
  }

   /**
   * List of groups to receive the notification.
   * @return groups
  **/
  @jakarta.annotation.Nullable

  public List<GroupName> getGroups() {
    return groups;
  }


  public void setGroups(List<GroupName> groups) {
    this.groups = groups;
  }


  public NotificationTo groupIds(List<String> groupIds) {
    
    this.groupIds = groupIds;
    return this;
  }

  public NotificationTo addGroupIdsItem(String groupIdsItem) {
    if (this.groupIds == null) {
      this.groupIds = new ArrayList<>();
    }
    this.groupIds.add(groupIdsItem);
    return this;
  }

   /**
   * List of groupIds to receive the notification.
   * @return groupIds
  **/
  @jakarta.annotation.Nullable

  public List<String> getGroupIds() {
    return groupIds;
  }


  public void setGroupIds(List<String> groupIds) {
    this.groupIds = groupIds;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NotificationTo notificationTo = (NotificationTo) o;
    return Objects.equals(this.reporter, notificationTo.reporter) &&
        Objects.equals(this.assignee, notificationTo.assignee) &&
        Objects.equals(this.watchers, notificationTo.watchers) &&
        Objects.equals(this.voters, notificationTo.voters) &&
        Objects.equals(this.users, notificationTo.users) &&
        Objects.equals(this.groups, notificationTo.groups) &&
        Objects.equals(this.groupIds, notificationTo.groupIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reporter, assignee, watchers, voters, users, groups, groupIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NotificationTo {\n");
    sb.append("    reporter: ").append(toIndentedString(reporter)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    watchers: ").append(toIndentedString(watchers)).append("\n");
    sb.append("    voters: ").append(toIndentedString(voters)).append("\n");
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    groupIds: ").append(toIndentedString(groupIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("reporter");
    openapiFields.add("assignee");
    openapiFields.add("watchers");
    openapiFields.add("voters");
    openapiFields.add("users");
    openapiFields.add("groups");
    openapiFields.add("groupIds");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to NotificationTo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!NotificationTo.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in NotificationTo is not found in the empty JSON string", NotificationTo.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!NotificationTo.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NotificationTo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("users") != null && !jsonObj.get("users").isJsonNull()) {
        JsonArray jsonArrayusers = jsonObj.getAsJsonArray("users");
        if (jsonArrayusers != null) {
          // ensure the json data is an array
          if (!jsonObj.get("users").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `users` to be an array in the JSON string but got `%s`", jsonObj.get("users").toString()));
          }

          // validate the optional field `users` (array)
          for (int i = 0; i < jsonArrayusers.size(); i++) {
            UserDetails.validateJsonObject(jsonArrayusers.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("groups") != null && !jsonObj.get("groups").isJsonNull()) {
        JsonArray jsonArraygroups = jsonObj.getAsJsonArray("groups");
        if (jsonArraygroups != null) {
          // ensure the json data is an array
          if (!jsonObj.get("groups").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get("groups").toString()));
          }

          // validate the optional field `groups` (array)
          for (int i = 0; i < jsonArraygroups.size(); i++) {
            GroupName.validateJsonObject(jsonArraygroups.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("groupIds") != null && !jsonObj.get("groupIds").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `groupIds` to be an array in the JSON string but got `%s`", jsonObj.get("groupIds").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!NotificationTo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'NotificationTo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<NotificationTo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(NotificationTo.class));

       return (TypeAdapter<T>) new TypeAdapter<NotificationTo>() {
           @Override
           public void write(JsonWriter out, NotificationTo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public NotificationTo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of NotificationTo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of NotificationTo
  * @throws IOException if the JSON string is invalid with respect to NotificationTo
  */
  public static NotificationTo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, NotificationTo.class);
  }

 /**
  * Convert an instance of NotificationTo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

