/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.JiraStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * PageOfStatuses
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class PageOfStatuses {
  public static final String SERIALIZED_NAME_START_AT = "startAt";
  @SerializedName(SERIALIZED_NAME_START_AT)
  private Long startAt;

  public static final String SERIALIZED_NAME_TOTAL = "total";
  @SerializedName(SERIALIZED_NAME_TOTAL)
  private Long total;

  public static final String SERIALIZED_NAME_IS_LAST = "isLast";
  @SerializedName(SERIALIZED_NAME_IS_LAST)
  private Boolean isLast;

  public static final String SERIALIZED_NAME_MAX_RESULTS = "maxResults";
  @SerializedName(SERIALIZED_NAME_MAX_RESULTS)
  private Integer maxResults;

  public static final String SERIALIZED_NAME_VALUES = "values";
  @SerializedName(SERIALIZED_NAME_VALUES)
  private List<JiraStatus> values = null;

  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private String self;

  public static final String SERIALIZED_NAME_NEXT_PAGE = "nextPage";
  @SerializedName(SERIALIZED_NAME_NEXT_PAGE)
  private String nextPage;

  public PageOfStatuses() {
  }

  public PageOfStatuses startAt(Long startAt) {
    
    this.startAt = startAt;
    return this;
  }

   /**
   * The index of the first item returned on the page.
   * @return startAt
  **/
  @jakarta.annotation.Nullable

  public Long getStartAt() {
    return startAt;
  }


  public void setStartAt(Long startAt) {
    this.startAt = startAt;
  }


  public PageOfStatuses total(Long total) {
    
    this.total = total;
    return this;
  }

   /**
   * Number of items that satisfy the search.
   * @return total
  **/
  @jakarta.annotation.Nullable

  public Long getTotal() {
    return total;
  }


  public void setTotal(Long total) {
    this.total = total;
  }


  public PageOfStatuses isLast(Boolean isLast) {
    
    this.isLast = isLast;
    return this;
  }

   /**
   * Whether this is the last page.
   * @return isLast
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsLast() {
    return isLast;
  }


  public void setIsLast(Boolean isLast) {
    this.isLast = isLast;
  }


  public PageOfStatuses maxResults(Integer maxResults) {
    
    this.maxResults = maxResults;
    return this;
  }

   /**
   * The maximum number of items that could be returned.
   * @return maxResults
  **/
  @jakarta.annotation.Nullable

  public Integer getMaxResults() {
    return maxResults;
  }


  public void setMaxResults(Integer maxResults) {
    this.maxResults = maxResults;
  }


  public PageOfStatuses values(List<JiraStatus> values) {
    
    this.values = values;
    return this;
  }

  public PageOfStatuses addValuesItem(JiraStatus valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

   /**
   * The list of items.
   * @return values
  **/
  @jakarta.annotation.Nullable

  public List<JiraStatus> getValues() {
    return values;
  }


  public void setValues(List<JiraStatus> values) {
    this.values = values;
  }


  public PageOfStatuses self(String self) {
    
    this.self = self;
    return this;
  }

   /**
   * The URL of this page.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public String getSelf() {
    return self;
  }


  public void setSelf(String self) {
    this.self = self;
  }


  public PageOfStatuses nextPage(String nextPage) {
    
    this.nextPage = nextPage;
    return this;
  }

   /**
   * The URL of the next page of results, if any.
   * @return nextPage
  **/
  @jakarta.annotation.Nullable

  public String getNextPage() {
    return nextPage;
  }


  public void setNextPage(String nextPage) {
    this.nextPage = nextPage;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageOfStatuses pageOfStatuses = (PageOfStatuses) o;
    return Objects.equals(this.startAt, pageOfStatuses.startAt) &&
        Objects.equals(this.total, pageOfStatuses.total) &&
        Objects.equals(this.isLast, pageOfStatuses.isLast) &&
        Objects.equals(this.maxResults, pageOfStatuses.maxResults) &&
        Objects.equals(this.values, pageOfStatuses.values) &&
        Objects.equals(this.self, pageOfStatuses.self) &&
        Objects.equals(this.nextPage, pageOfStatuses.nextPage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startAt, total, isLast, maxResults, values, self, nextPage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageOfStatuses {\n");
    sb.append("    startAt: ").append(toIndentedString(startAt)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    isLast: ").append(toIndentedString(isLast)).append("\n");
    sb.append("    maxResults: ").append(toIndentedString(maxResults)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    nextPage: ").append(toIndentedString(nextPage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("startAt");
    openapiFields.add("total");
    openapiFields.add("isLast");
    openapiFields.add("maxResults");
    openapiFields.add("values");
    openapiFields.add("self");
    openapiFields.add("nextPage");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PageOfStatuses
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!PageOfStatuses.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PageOfStatuses is not found in the empty JSON string", PageOfStatuses.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PageOfStatuses.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PageOfStatuses` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("values") != null && !jsonObj.get("values").isJsonNull()) {
        JsonArray jsonArrayvalues = jsonObj.getAsJsonArray("values");
        if (jsonArrayvalues != null) {
          // ensure the json data is an array
          if (!jsonObj.get("values").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `values` to be an array in the JSON string but got `%s`", jsonObj.get("values").toString()));
          }

          // validate the optional field `values` (array)
          for (int i = 0; i < jsonArrayvalues.size(); i++) {
            JiraStatus.validateJsonObject(jsonArrayvalues.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("nextPage") != null && !jsonObj.get("nextPage").isJsonNull()) && !jsonObj.get("nextPage").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `nextPage` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nextPage").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PageOfStatuses.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PageOfStatuses' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PageOfStatuses> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PageOfStatuses.class));

       return (TypeAdapter<T>) new TypeAdapter<PageOfStatuses>() {
           @Override
           public void write(JsonWriter out, PageOfStatuses value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PageOfStatuses read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PageOfStatuses given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PageOfStatuses
  * @throws IOException if the JSON string is invalid with respect to PageOfStatuses
  */
  public static PageOfStatuses fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PageOfStatuses.class);
  }

 /**
  * Convert an instance of PageOfStatuses to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

