/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import software.tnb.jira.validation.generated.model.ParsedJqlQueryStructure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of a parsed JQL query.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ParsedJqlQuery {
  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private String query;

  public static final String SERIALIZED_NAME_STRUCTURE = "structure";
  @SerializedName(SERIALIZED_NAME_STRUCTURE)
  private ParsedJqlQueryStructure structure;

  public static final String SERIALIZED_NAME_ERRORS = "errors";
  @SerializedName(SERIALIZED_NAME_ERRORS)
  private Set<String> errors = null;

  public ParsedJqlQuery() {
  }

  public ParsedJqlQuery query(String query) {
    
    this.query = query;
    return this;
  }

   /**
   * The JQL query that was parsed and validated.
   * @return query
  **/
  @jakarta.annotation.Nonnull

  public String getQuery() {
    return query;
  }


  public void setQuery(String query) {
    this.query = query;
  }


  public ParsedJqlQuery structure(ParsedJqlQueryStructure structure) {
    
    this.structure = structure;
    return this;
  }

   /**
   * Get structure
   * @return structure
  **/
  @jakarta.annotation.Nullable

  public ParsedJqlQueryStructure getStructure() {
    return structure;
  }


  public void setStructure(ParsedJqlQueryStructure structure) {
    this.structure = structure;
  }


  public ParsedJqlQuery errors(Set<String> errors) {
    
    this.errors = errors;
    return this;
  }

  public ParsedJqlQuery addErrorsItem(String errorsItem) {
    if (this.errors == null) {
      this.errors = new LinkedHashSet<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * The list of syntax or validation errors.
   * @return errors
  **/
  @jakarta.annotation.Nullable

  public Set<String> getErrors() {
    return errors;
  }


  public void setErrors(Set<String> errors) {
    this.errors = errors;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ParsedJqlQuery parsedJqlQuery = (ParsedJqlQuery) o;
    return Objects.equals(this.query, parsedJqlQuery.query) &&
        Objects.equals(this.structure, parsedJqlQuery.structure) &&
        Objects.equals(this.errors, parsedJqlQuery.errors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(query, structure, errors);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParsedJqlQuery {\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    structure: ").append(toIndentedString(structure)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("query");
    openapiFields.add("structure");
    openapiFields.add("errors");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("query");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ParsedJqlQuery
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ParsedJqlQuery.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ParsedJqlQuery is not found in the empty JSON string", ParsedJqlQuery.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ParsedJqlQuery.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ParsedJqlQuery` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ParsedJqlQuery.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("query").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `query` to be a primitive type in the JSON string but got `%s`", jsonObj.get("query").toString()));
      }
      // validate the optional field `structure`
      if (jsonObj.get("structure") != null && !jsonObj.get("structure").isJsonNull()) {
        ParsedJqlQueryStructure.validateJsonObject(jsonObj.getAsJsonObject("structure"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("errors") != null && !jsonObj.get("errors").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get("errors").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ParsedJqlQuery.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ParsedJqlQuery' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ParsedJqlQuery> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ParsedJqlQuery.class));

       return (TypeAdapter<T>) new TypeAdapter<ParsedJqlQuery>() {
           @Override
           public void write(JsonWriter out, ParsedJqlQuery value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ParsedJqlQuery read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ParsedJqlQuery given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ParsedJqlQuery
  * @throws IOException if the JSON string is invalid with respect to ParsedJqlQuery
  */
  public static ParsedJqlQuery fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ParsedJqlQuery.class);
  }

 /**
  * Convert an instance of ParsedJqlQuery to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

