/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import software.tnb.jira.validation.generated.model.IssueTypeDetails;
import software.tnb.jira.validation.generated.model.ProjectArchivedBy;
import software.tnb.jira.validation.generated.model.ProjectComponent;
import software.tnb.jira.validation.generated.model.ProjectDeletedBy;
import software.tnb.jira.validation.generated.model.ProjectDetailsAvatarUrls;
import software.tnb.jira.validation.generated.model.ProjectInsight;
import software.tnb.jira.validation.generated.model.ProjectIssueTypeHierarchy;
import software.tnb.jira.validation.generated.model.ProjectLandingPageInfo;
import software.tnb.jira.validation.generated.model.ProjectLead;
import software.tnb.jira.validation.generated.model.ProjectPermissions;
import software.tnb.jira.validation.generated.model.ProjectProjectCategory;
import software.tnb.jira.validation.generated.model.Version;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about a project.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class Project {
  public static final String SERIALIZED_NAME_EXPAND = "expand";
  @SerializedName(SERIALIZED_NAME_EXPAND)
  private String expand;

  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_LEAD = "lead";
  @SerializedName(SERIALIZED_NAME_LEAD)
  private ProjectLead lead;

  public static final String SERIALIZED_NAME_COMPONENTS = "components";
  @SerializedName(SERIALIZED_NAME_COMPONENTS)
  private List<ProjectComponent> components = null;

  public static final String SERIALIZED_NAME_ISSUE_TYPES = "issueTypes";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPES)
  private List<IssueTypeDetails> issueTypes = null;

  public static final String SERIALIZED_NAME_URL = "url";
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public static final String SERIALIZED_NAME_EMAIL = "email";
  @SerializedName(SERIALIZED_NAME_EMAIL)
  private String email;

  /**
   * The default assignee when creating issues for this project.
   */
  @JsonAdapter(AssigneeTypeEnum.Adapter.class)
  public enum AssigneeTypeEnum {
    PROJECT_LEAD("PROJECT_LEAD"),
    
    UNASSIGNED("UNASSIGNED");

    private String value;

    AssigneeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AssigneeTypeEnum fromValue(String value) {
      for (AssigneeTypeEnum b : AssigneeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AssigneeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AssigneeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AssigneeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AssigneeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ASSIGNEE_TYPE = "assigneeType";
  @SerializedName(SERIALIZED_NAME_ASSIGNEE_TYPE)
  private AssigneeTypeEnum assigneeType;

  public static final String SERIALIZED_NAME_VERSIONS = "versions";
  @SerializedName(SERIALIZED_NAME_VERSIONS)
  private List<Version> versions = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ROLES = "roles";
  @SerializedName(SERIALIZED_NAME_ROLES)
  private Map<String, URI> roles = null;

  public static final String SERIALIZED_NAME_AVATAR_URLS = "avatarUrls";
  @SerializedName(SERIALIZED_NAME_AVATAR_URLS)
  private ProjectDetailsAvatarUrls avatarUrls;

  public static final String SERIALIZED_NAME_PROJECT_CATEGORY = "projectCategory";
  @SerializedName(SERIALIZED_NAME_PROJECT_CATEGORY)
  private ProjectProjectCategory projectCategory;

  /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.
   */
  @JsonAdapter(ProjectTypeKeyEnum.Adapter.class)
  public enum ProjectTypeKeyEnum {
    SOFTWARE("software"),
    
    SERVICE_DESK("service_desk"),
    
    BUSINESS("business");

    private String value;

    ProjectTypeKeyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ProjectTypeKeyEnum fromValue(String value) {
      for (ProjectTypeKeyEnum b : ProjectTypeKeyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ProjectTypeKeyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ProjectTypeKeyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ProjectTypeKeyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ProjectTypeKeyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PROJECT_TYPE_KEY = "projectTypeKey";
  @SerializedName(SERIALIZED_NAME_PROJECT_TYPE_KEY)
  private ProjectTypeKeyEnum projectTypeKey;

  public static final String SERIALIZED_NAME_SIMPLIFIED = "simplified";
  @SerializedName(SERIALIZED_NAME_SIMPLIFIED)
  private Boolean simplified;

  /**
   * The type of the project.
   */
  @JsonAdapter(StyleEnum.Adapter.class)
  public enum StyleEnum {
    CLASSIC("classic"),
    
    NEXT_GEN("next-gen");

    private String value;

    StyleEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StyleEnum fromValue(String value) {
      for (StyleEnum b : StyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StyleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StyleEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StyleEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StyleEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STYLE = "style";
  @SerializedName(SERIALIZED_NAME_STYLE)
  private StyleEnum style;

  public static final String SERIALIZED_NAME_FAVOURITE = "favourite";
  @SerializedName(SERIALIZED_NAME_FAVOURITE)
  private Boolean favourite;

  public static final String SERIALIZED_NAME_IS_PRIVATE = "isPrivate";
  @SerializedName(SERIALIZED_NAME_IS_PRIVATE)
  private Boolean isPrivate;

  public static final String SERIALIZED_NAME_ISSUE_TYPE_HIERARCHY = "issueTypeHierarchy";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPE_HIERARCHY)
  private ProjectIssueTypeHierarchy issueTypeHierarchy;

  public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
  @SerializedName(SERIALIZED_NAME_PERMISSIONS)
  private ProjectPermissions permissions;

  public static final String SERIALIZED_NAME_PROPERTIES = "properties";
  @SerializedName(SERIALIZED_NAME_PROPERTIES)
  private Map<String, Object> properties = null;

  public static final String SERIALIZED_NAME_UUID = "uuid";
  @SerializedName(SERIALIZED_NAME_UUID)
  private UUID uuid;

  public static final String SERIALIZED_NAME_INSIGHT = "insight";
  @SerializedName(SERIALIZED_NAME_INSIGHT)
  private ProjectInsight insight;

  public static final String SERIALIZED_NAME_DELETED = "deleted";
  @SerializedName(SERIALIZED_NAME_DELETED)
  private Boolean deleted;

  public static final String SERIALIZED_NAME_RETENTION_TILL_DATE = "retentionTillDate";
  @SerializedName(SERIALIZED_NAME_RETENTION_TILL_DATE)
  private String retentionTillDate;

  public static final String SERIALIZED_NAME_DELETED_DATE = "deletedDate";
  @SerializedName(SERIALIZED_NAME_DELETED_DATE)
  private String deletedDate;

  public static final String SERIALIZED_NAME_DELETED_BY = "deletedBy";
  @SerializedName(SERIALIZED_NAME_DELETED_BY)
  private ProjectDeletedBy deletedBy;

  public static final String SERIALIZED_NAME_ARCHIVED = "archived";
  @SerializedName(SERIALIZED_NAME_ARCHIVED)
  private Boolean archived;

  public static final String SERIALIZED_NAME_ARCHIVED_DATE = "archivedDate";
  @SerializedName(SERIALIZED_NAME_ARCHIVED_DATE)
  private String archivedDate;

  public static final String SERIALIZED_NAME_ARCHIVED_BY = "archivedBy";
  @SerializedName(SERIALIZED_NAME_ARCHIVED_BY)
  private ProjectArchivedBy archivedBy;

  public static final String SERIALIZED_NAME_LANDING_PAGE_INFO = "landingPageInfo";
  @SerializedName(SERIALIZED_NAME_LANDING_PAGE_INFO)
  private ProjectLandingPageInfo landingPageInfo;

  public Project() {
  }

  
  public Project(
     String expand, 
     URI self, 
     String key, 
     String description, 
     List<ProjectComponent> components, 
     List<IssueTypeDetails> issueTypes, 
     String url, 
     AssigneeTypeEnum assigneeType, 
     List<Version> versions, 
     String name, 
     Map<String, URI> roles, 
     ProjectTypeKeyEnum projectTypeKey, 
     Boolean simplified, 
     StyleEnum style, 
     Boolean isPrivate, 
     Map<String, Object> properties, 
     UUID uuid, 
     Boolean deleted, 
     String retentionTillDate, 
     String deletedDate, 
     Boolean archived, 
     String archivedDate
  ) {
    this();
    this.expand = expand;
    this.self = self;
    this.key = key;
    this.description = description;
    this.components = components;
    this.issueTypes = issueTypes;
    this.url = url;
    this.assigneeType = assigneeType;
    this.versions = versions;
    this.name = name;
    this.roles = roles;
    this.projectTypeKey = projectTypeKey;
    this.simplified = simplified;
    this.style = style;
    this.isPrivate = isPrivate;
    this.properties = properties;
    this.uuid = uuid;
    this.deleted = deleted;
    this.retentionTillDate = retentionTillDate;
    this.deletedDate = deletedDate;
    this.archived = archived;
    this.archivedDate = archivedDate;
  }

   /**
   * Expand options that include additional project details in the response.
   * @return expand
  **/
  @jakarta.annotation.Nullable

  public String getExpand() {
    return expand;
  }




   /**
   * The URL of the project details.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




  public Project id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the project.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


   /**
   * The key of the project.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }




   /**
   * A brief description of the project.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }




  public Project lead(ProjectLead lead) {
    
    this.lead = lead;
    return this;
  }

   /**
   * Get lead
   * @return lead
  **/
  @jakarta.annotation.Nullable

  public ProjectLead getLead() {
    return lead;
  }


  public void setLead(ProjectLead lead) {
    this.lead = lead;
  }


   /**
   * List of the components contained in the project.
   * @return components
  **/
  @jakarta.annotation.Nullable

  public List<ProjectComponent> getComponents() {
    return components;
  }




   /**
   * List of the issue types available in the project.
   * @return issueTypes
  **/
  @jakarta.annotation.Nullable

  public List<IssueTypeDetails> getIssueTypes() {
    return issueTypes;
  }




   /**
   * A link to information about this project, such as project documentation.
   * @return url
  **/
  @jakarta.annotation.Nullable

  public String getUrl() {
    return url;
  }




  public Project email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * An email address associated with the project.
   * @return email
  **/
  @jakarta.annotation.Nullable

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


   /**
   * The default assignee when creating issues for this project.
   * @return assigneeType
  **/
  @jakarta.annotation.Nullable

  public AssigneeTypeEnum getAssigneeType() {
    return assigneeType;
  }




   /**
   * The versions defined in the project. For more information, see [Create version](#api-rest-api-3-version-post).
   * @return versions
  **/
  @jakarta.annotation.Nullable

  public List<Version> getVersions() {
    return versions;
  }




   /**
   * The name of the project.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }




   /**
   * The name and self URL for each role defined in the project. For more information, see [Create project role](#api-rest-api-3-role-post).
   * @return roles
  **/
  @jakarta.annotation.Nullable

  public Map<String, URI> getRoles() {
    return roles;
  }




  public Project avatarUrls(ProjectDetailsAvatarUrls avatarUrls) {
    
    this.avatarUrls = avatarUrls;
    return this;
  }

   /**
   * Get avatarUrls
   * @return avatarUrls
  **/
  @jakarta.annotation.Nullable

  public ProjectDetailsAvatarUrls getAvatarUrls() {
    return avatarUrls;
  }


  public void setAvatarUrls(ProjectDetailsAvatarUrls avatarUrls) {
    this.avatarUrls = avatarUrls;
  }


  public Project projectCategory(ProjectProjectCategory projectCategory) {
    
    this.projectCategory = projectCategory;
    return this;
  }

   /**
   * Get projectCategory
   * @return projectCategory
  **/
  @jakarta.annotation.Nullable

  public ProjectProjectCategory getProjectCategory() {
    return projectCategory;
  }


  public void setProjectCategory(ProjectProjectCategory projectCategory) {
    this.projectCategory = projectCategory;
  }


   /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.
   * @return projectTypeKey
  **/
  @jakarta.annotation.Nullable

  public ProjectTypeKeyEnum getProjectTypeKey() {
    return projectTypeKey;
  }




   /**
   * Whether the project is simplified.
   * @return simplified
  **/
  @jakarta.annotation.Nullable

  public Boolean getSimplified() {
    return simplified;
  }




   /**
   * The type of the project.
   * @return style
  **/
  @jakarta.annotation.Nullable

  public StyleEnum getStyle() {
    return style;
  }




  public Project favourite(Boolean favourite) {
    
    this.favourite = favourite;
    return this;
  }

   /**
   * Whether the project is selected as a favorite.
   * @return favourite
  **/
  @jakarta.annotation.Nullable

  public Boolean getFavourite() {
    return favourite;
  }


  public void setFavourite(Boolean favourite) {
    this.favourite = favourite;
  }


   /**
   * Whether the project is private.
   * @return isPrivate
  **/
  @jakarta.annotation.Nullable

  public Boolean getIsPrivate() {
    return isPrivate;
  }




  public Project issueTypeHierarchy(ProjectIssueTypeHierarchy issueTypeHierarchy) {
    
    this.issueTypeHierarchy = issueTypeHierarchy;
    return this;
  }

   /**
   * Get issueTypeHierarchy
   * @return issueTypeHierarchy
  **/
  @jakarta.annotation.Nullable

  public ProjectIssueTypeHierarchy getIssueTypeHierarchy() {
    return issueTypeHierarchy;
  }


  public void setIssueTypeHierarchy(ProjectIssueTypeHierarchy issueTypeHierarchy) {
    this.issueTypeHierarchy = issueTypeHierarchy;
  }


  public Project permissions(ProjectPermissions permissions) {
    
    this.permissions = permissions;
    return this;
  }

   /**
   * Get permissions
   * @return permissions
  **/
  @jakarta.annotation.Nullable

  public ProjectPermissions getPermissions() {
    return permissions;
  }


  public void setPermissions(ProjectPermissions permissions) {
    this.permissions = permissions;
  }


   /**
   * Map of project properties
   * @return properties
  **/
  @jakarta.annotation.Nullable

  public Map<String, Object> getProperties() {
    return properties;
  }




   /**
   * Unique ID for next-gen projects.
   * @return uuid
  **/
  @jakarta.annotation.Nullable

  public UUID getUuid() {
    return uuid;
  }




  public Project insight(ProjectInsight insight) {
    
    this.insight = insight;
    return this;
  }

   /**
   * Get insight
   * @return insight
  **/
  @jakarta.annotation.Nullable

  public ProjectInsight getInsight() {
    return insight;
  }


  public void setInsight(ProjectInsight insight) {
    this.insight = insight;
  }


   /**
   * Whether the project is marked as deleted.
   * @return deleted
  **/
  @jakarta.annotation.Nullable

  public Boolean getDeleted() {
    return deleted;
  }




   /**
   * The date when the project is deleted permanently.
   * @return retentionTillDate
  **/
  @jakarta.annotation.Nullable

  public String getRetentionTillDate() {
    return retentionTillDate;
  }




   /**
   * The date when the project was marked as deleted.
   * @return deletedDate
  **/
  @jakarta.annotation.Nullable

  public String getDeletedDate() {
    return deletedDate;
  }




  public Project deletedBy(ProjectDeletedBy deletedBy) {
    
    this.deletedBy = deletedBy;
    return this;
  }

   /**
   * Get deletedBy
   * @return deletedBy
  **/
  @jakarta.annotation.Nullable

  public ProjectDeletedBy getDeletedBy() {
    return deletedBy;
  }


  public void setDeletedBy(ProjectDeletedBy deletedBy) {
    this.deletedBy = deletedBy;
  }


   /**
   * Whether the project is archived.
   * @return archived
  **/
  @jakarta.annotation.Nullable

  public Boolean getArchived() {
    return archived;
  }




   /**
   * The date when the project was archived.
   * @return archivedDate
  **/
  @jakarta.annotation.Nullable

  public String getArchivedDate() {
    return archivedDate;
  }




  public Project archivedBy(ProjectArchivedBy archivedBy) {
    
    this.archivedBy = archivedBy;
    return this;
  }

   /**
   * Get archivedBy
   * @return archivedBy
  **/
  @jakarta.annotation.Nullable

  public ProjectArchivedBy getArchivedBy() {
    return archivedBy;
  }


  public void setArchivedBy(ProjectArchivedBy archivedBy) {
    this.archivedBy = archivedBy;
  }


  public Project landingPageInfo(ProjectLandingPageInfo landingPageInfo) {
    
    this.landingPageInfo = landingPageInfo;
    return this;
  }

   /**
   * Get landingPageInfo
   * @return landingPageInfo
  **/
  @jakarta.annotation.Nullable

  public ProjectLandingPageInfo getLandingPageInfo() {
    return landingPageInfo;
  }


  public void setLandingPageInfo(ProjectLandingPageInfo landingPageInfo) {
    this.landingPageInfo = landingPageInfo;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Project project = (Project) o;
    return Objects.equals(this.expand, project.expand) &&
        Objects.equals(this.self, project.self) &&
        Objects.equals(this.id, project.id) &&
        Objects.equals(this.key, project.key) &&
        Objects.equals(this.description, project.description) &&
        Objects.equals(this.lead, project.lead) &&
        Objects.equals(this.components, project.components) &&
        Objects.equals(this.issueTypes, project.issueTypes) &&
        Objects.equals(this.url, project.url) &&
        Objects.equals(this.email, project.email) &&
        Objects.equals(this.assigneeType, project.assigneeType) &&
        Objects.equals(this.versions, project.versions) &&
        Objects.equals(this.name, project.name) &&
        Objects.equals(this.roles, project.roles) &&
        Objects.equals(this.avatarUrls, project.avatarUrls) &&
        Objects.equals(this.projectCategory, project.projectCategory) &&
        Objects.equals(this.projectTypeKey, project.projectTypeKey) &&
        Objects.equals(this.simplified, project.simplified) &&
        Objects.equals(this.style, project.style) &&
        Objects.equals(this.favourite, project.favourite) &&
        Objects.equals(this.isPrivate, project.isPrivate) &&
        Objects.equals(this.issueTypeHierarchy, project.issueTypeHierarchy) &&
        Objects.equals(this.permissions, project.permissions) &&
        Objects.equals(this.properties, project.properties) &&
        Objects.equals(this.uuid, project.uuid) &&
        Objects.equals(this.insight, project.insight) &&
        Objects.equals(this.deleted, project.deleted) &&
        Objects.equals(this.retentionTillDate, project.retentionTillDate) &&
        Objects.equals(this.deletedDate, project.deletedDate) &&
        Objects.equals(this.deletedBy, project.deletedBy) &&
        Objects.equals(this.archived, project.archived) &&
        Objects.equals(this.archivedDate, project.archivedDate) &&
        Objects.equals(this.archivedBy, project.archivedBy) &&
        Objects.equals(this.landingPageInfo, project.landingPageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expand, self, id, key, description, lead, components, issueTypes, url, email, assigneeType, versions, name, roles, avatarUrls, projectCategory, projectTypeKey, simplified, style, favourite, isPrivate, issueTypeHierarchy, permissions, properties, uuid, insight, deleted, retentionTillDate, deletedDate, deletedBy, archived, archivedDate, archivedBy, landingPageInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Project {\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    lead: ").append(toIndentedString(lead)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    issueTypes: ").append(toIndentedString(issueTypes)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    assigneeType: ").append(toIndentedString(assigneeType)).append("\n");
    sb.append("    versions: ").append(toIndentedString(versions)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    avatarUrls: ").append(toIndentedString(avatarUrls)).append("\n");
    sb.append("    projectCategory: ").append(toIndentedString(projectCategory)).append("\n");
    sb.append("    projectTypeKey: ").append(toIndentedString(projectTypeKey)).append("\n");
    sb.append("    simplified: ").append(toIndentedString(simplified)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    favourite: ").append(toIndentedString(favourite)).append("\n");
    sb.append("    isPrivate: ").append(toIndentedString(isPrivate)).append("\n");
    sb.append("    issueTypeHierarchy: ").append(toIndentedString(issueTypeHierarchy)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    insight: ").append(toIndentedString(insight)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    retentionTillDate: ").append(toIndentedString(retentionTillDate)).append("\n");
    sb.append("    deletedDate: ").append(toIndentedString(deletedDate)).append("\n");
    sb.append("    deletedBy: ").append(toIndentedString(deletedBy)).append("\n");
    sb.append("    archived: ").append(toIndentedString(archived)).append("\n");
    sb.append("    archivedDate: ").append(toIndentedString(archivedDate)).append("\n");
    sb.append("    archivedBy: ").append(toIndentedString(archivedBy)).append("\n");
    sb.append("    landingPageInfo: ").append(toIndentedString(landingPageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("expand");
    openapiFields.add("self");
    openapiFields.add("id");
    openapiFields.add("key");
    openapiFields.add("description");
    openapiFields.add("lead");
    openapiFields.add("components");
    openapiFields.add("issueTypes");
    openapiFields.add("url");
    openapiFields.add("email");
    openapiFields.add("assigneeType");
    openapiFields.add("versions");
    openapiFields.add("name");
    openapiFields.add("roles");
    openapiFields.add("avatarUrls");
    openapiFields.add("projectCategory");
    openapiFields.add("projectTypeKey");
    openapiFields.add("simplified");
    openapiFields.add("style");
    openapiFields.add("favourite");
    openapiFields.add("isPrivate");
    openapiFields.add("issueTypeHierarchy");
    openapiFields.add("permissions");
    openapiFields.add("properties");
    openapiFields.add("uuid");
    openapiFields.add("insight");
    openapiFields.add("deleted");
    openapiFields.add("retentionTillDate");
    openapiFields.add("deletedDate");
    openapiFields.add("deletedBy");
    openapiFields.add("archived");
    openapiFields.add("archivedDate");
    openapiFields.add("archivedBy");
    openapiFields.add("landingPageInfo");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Project
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!Project.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Project is not found in the empty JSON string", Project.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Project.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Project` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("expand") != null && !jsonObj.get("expand").isJsonNull()) && !jsonObj.get("expand").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `expand` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expand").toString()));
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field `lead`
      if (jsonObj.get("lead") != null && !jsonObj.get("lead").isJsonNull()) {
        ProjectLead.validateJsonObject(jsonObj.getAsJsonObject("lead"));
      }
      if (jsonObj.get("components") != null && !jsonObj.get("components").isJsonNull()) {
        JsonArray jsonArraycomponents = jsonObj.getAsJsonArray("components");
        if (jsonArraycomponents != null) {
          // ensure the json data is an array
          if (!jsonObj.get("components").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `components` to be an array in the JSON string but got `%s`", jsonObj.get("components").toString()));
          }

          // validate the optional field `components` (array)
          for (int i = 0; i < jsonArraycomponents.size(); i++) {
            ProjectComponent.validateJsonObject(jsonArraycomponents.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("issueTypes") != null && !jsonObj.get("issueTypes").isJsonNull()) {
        JsonArray jsonArrayissueTypes = jsonObj.getAsJsonArray("issueTypes");
        if (jsonArrayissueTypes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("issueTypes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `issueTypes` to be an array in the JSON string but got `%s`", jsonObj.get("issueTypes").toString()));
          }

          // validate the optional field `issueTypes` (array)
          for (int i = 0; i < jsonArrayissueTypes.size(); i++) {
            IssueTypeDetails.validateJsonObject(jsonArrayissueTypes.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("url") != null && !jsonObj.get("url").isJsonNull()) && !jsonObj.get("url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
      if ((jsonObj.get("email") != null && !jsonObj.get("email").isJsonNull()) && !jsonObj.get("email").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("email").toString()));
      }
      if ((jsonObj.get("assigneeType") != null && !jsonObj.get("assigneeType").isJsonNull()) && !jsonObj.get("assigneeType").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `assigneeType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("assigneeType").toString()));
      }
      if (jsonObj.get("versions") != null && !jsonObj.get("versions").isJsonNull()) {
        JsonArray jsonArrayversions = jsonObj.getAsJsonArray("versions");
        if (jsonArrayversions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("versions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `versions` to be an array in the JSON string but got `%s`", jsonObj.get("versions").toString()));
          }

          // validate the optional field `versions` (array)
          for (int i = 0; i < jsonArrayversions.size(); i++) {
            Version.validateJsonObject(jsonArrayversions.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `avatarUrls`
      if (jsonObj.get("avatarUrls") != null && !jsonObj.get("avatarUrls").isJsonNull()) {
        ProjectDetailsAvatarUrls.validateJsonObject(jsonObj.getAsJsonObject("avatarUrls"));
      }
      // validate the optional field `projectCategory`
      if (jsonObj.get("projectCategory") != null && !jsonObj.get("projectCategory").isJsonNull()) {
        ProjectProjectCategory.validateJsonObject(jsonObj.getAsJsonObject("projectCategory"));
      }
      if ((jsonObj.get("projectTypeKey") != null && !jsonObj.get("projectTypeKey").isJsonNull()) && !jsonObj.get("projectTypeKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `projectTypeKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("projectTypeKey").toString()));
      }
      if ((jsonObj.get("style") != null && !jsonObj.get("style").isJsonNull()) && !jsonObj.get("style").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `style` to be a primitive type in the JSON string but got `%s`", jsonObj.get("style").toString()));
      }
      // validate the optional field `issueTypeHierarchy`
      if (jsonObj.get("issueTypeHierarchy") != null && !jsonObj.get("issueTypeHierarchy").isJsonNull()) {
        ProjectIssueTypeHierarchy.validateJsonObject(jsonObj.getAsJsonObject("issueTypeHierarchy"));
      }
      // validate the optional field `permissions`
      if (jsonObj.get("permissions") != null && !jsonObj.get("permissions").isJsonNull()) {
        ProjectPermissions.validateJsonObject(jsonObj.getAsJsonObject("permissions"));
      }
      if ((jsonObj.get("uuid") != null && !jsonObj.get("uuid").isJsonNull()) && !jsonObj.get("uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uuid").toString()));
      }
      // validate the optional field `insight`
      if (jsonObj.get("insight") != null && !jsonObj.get("insight").isJsonNull()) {
        ProjectInsight.validateJsonObject(jsonObj.getAsJsonObject("insight"));
      }
      // validate the optional field `deletedBy`
      if (jsonObj.get("deletedBy") != null && !jsonObj.get("deletedBy").isJsonNull()) {
        ProjectDeletedBy.validateJsonObject(jsonObj.getAsJsonObject("deletedBy"));
      }
      // validate the optional field `archivedBy`
      if (jsonObj.get("archivedBy") != null && !jsonObj.get("archivedBy").isJsonNull()) {
        ProjectArchivedBy.validateJsonObject(jsonObj.getAsJsonObject("archivedBy"));
      }
      // validate the optional field `landingPageInfo`
      if (jsonObj.get("landingPageInfo") != null && !jsonObj.get("landingPageInfo").isJsonNull()) {
        ProjectLandingPageInfo.validateJsonObject(jsonObj.getAsJsonObject("landingPageInfo"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Project.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Project' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Project> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Project.class));

       return (TypeAdapter<T>) new TypeAdapter<Project>() {
           @Override
           public void write(JsonWriter out, Project value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Project read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Project given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Project
  * @throws IOException if the JSON string is invalid with respect to Project
  */
  public static Project fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Project.class);
  }

 /**
  * Convert an instance of Project to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

