/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.SimplifiedHierarchyLevel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The issue type hierarchy for the project.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ProjectIssueTypeHierarchy {
  public static final String SERIALIZED_NAME_BASE_LEVEL_ID = "baseLevelId";
  @SerializedName(SERIALIZED_NAME_BASE_LEVEL_ID)
  private Long baseLevelId;

  public static final String SERIALIZED_NAME_LEVELS = "levels";
  @SerializedName(SERIALIZED_NAME_LEVELS)
  private List<SimplifiedHierarchyLevel> levels = null;

  public ProjectIssueTypeHierarchy() {
  }

  
  public ProjectIssueTypeHierarchy(
     List<SimplifiedHierarchyLevel> levels
  ) {
    this();
    this.levels = levels;
  }

  public ProjectIssueTypeHierarchy baseLevelId(Long baseLevelId) {
    
    this.baseLevelId = baseLevelId;
    return this;
  }

   /**
   * The ID of the base level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return baseLevelId
  **/
  @jakarta.annotation.Nullable

  public Long getBaseLevelId() {
    return baseLevelId;
  }


  public void setBaseLevelId(Long baseLevelId) {
    this.baseLevelId = baseLevelId;
  }


   /**
   * Details about the hierarchy level.
   * @return levels
  **/
  @jakarta.annotation.Nullable

  public List<SimplifiedHierarchyLevel> getLevels() {
    return levels;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectIssueTypeHierarchy projectIssueTypeHierarchy = (ProjectIssueTypeHierarchy) o;
    return Objects.equals(this.baseLevelId, projectIssueTypeHierarchy.baseLevelId) &&
        Objects.equals(this.levels, projectIssueTypeHierarchy.levels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(baseLevelId, levels);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectIssueTypeHierarchy {\n");
    sb.append("    baseLevelId: ").append(toIndentedString(baseLevelId)).append("\n");
    sb.append("    levels: ").append(toIndentedString(levels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("baseLevelId");
    openapiFields.add("levels");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ProjectIssueTypeHierarchy
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ProjectIssueTypeHierarchy.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ProjectIssueTypeHierarchy is not found in the empty JSON string", ProjectIssueTypeHierarchy.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ProjectIssueTypeHierarchy.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ProjectIssueTypeHierarchy` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("levels") != null && !jsonObj.get("levels").isJsonNull()) {
        JsonArray jsonArraylevels = jsonObj.getAsJsonArray("levels");
        if (jsonArraylevels != null) {
          // ensure the json data is an array
          if (!jsonObj.get("levels").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `levels` to be an array in the JSON string but got `%s`", jsonObj.get("levels").toString()));
          }

          // validate the optional field `levels` (array)
          for (int i = 0; i < jsonArraylevels.size(); i++) {
            SimplifiedHierarchyLevel.validateJsonObject(jsonArraylevels.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ProjectIssueTypeHierarchy.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ProjectIssueTypeHierarchy' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ProjectIssueTypeHierarchy> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ProjectIssueTypeHierarchy.class));

       return (TypeAdapter<T>) new TypeAdapter<ProjectIssueTypeHierarchy>() {
           @Override
           public void write(JsonWriter out, ProjectIssueTypeHierarchy value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ProjectIssueTypeHierarchy read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ProjectIssueTypeHierarchy given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ProjectIssueTypeHierarchy
  * @throws IOException if the JSON string is invalid with respect to ProjectIssueTypeHierarchy
  */
  public static ProjectIssueTypeHierarchy fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ProjectIssueTypeHierarchy.class);
  }

 /**
  * Convert an instance of ProjectIssueTypeHierarchy to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

