/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import software.tnb.jira.validation.generated.model.ProjectId;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Projects and issue types where the status is used. Only available if the &#x60;usages&#x60; expand is requested.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ProjectIssueTypes {
  public static final String SERIALIZED_NAME_PROJECT = "project";
  @SerializedName(SERIALIZED_NAME_PROJECT)
  private ProjectId project;

  public static final String SERIALIZED_NAME_ISSUE_TYPES = "issueTypes";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPES)
  private Set<String> issueTypes = null;

  public ProjectIssueTypes() {
  }

  public ProjectIssueTypes project(ProjectId project) {
    
    this.project = project;
    return this;
  }

   /**
   * Get project
   * @return project
  **/
  @jakarta.annotation.Nullable

  public ProjectId getProject() {
    return project;
  }


  public void setProject(ProjectId project) {
    this.project = project;
  }


  public ProjectIssueTypes issueTypes(Set<String> issueTypes) {
    
    this.issueTypes = issueTypes;
    return this;
  }

  public ProjectIssueTypes addIssueTypesItem(String issueTypesItem) {
    if (this.issueTypes == null) {
      this.issueTypes = new LinkedHashSet<>();
    }
    this.issueTypes.add(issueTypesItem);
    return this;
  }

   /**
   * IDs of the issue types
   * @return issueTypes
  **/
  @jakarta.annotation.Nullable

  public Set<String> getIssueTypes() {
    return issueTypes;
  }


  public void setIssueTypes(Set<String> issueTypes) {
    this.issueTypes = issueTypes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectIssueTypes projectIssueTypes = (ProjectIssueTypes) o;
    return Objects.equals(this.project, projectIssueTypes.project) &&
        Objects.equals(this.issueTypes, projectIssueTypes.issueTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(project, issueTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectIssueTypes {\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    issueTypes: ").append(toIndentedString(issueTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("project");
    openapiFields.add("issueTypes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ProjectIssueTypes
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ProjectIssueTypes.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ProjectIssueTypes is not found in the empty JSON string", ProjectIssueTypes.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ProjectIssueTypes.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ProjectIssueTypes` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // validate the optional field `project`
      if (jsonObj.get("project") != null && !jsonObj.get("project").isJsonNull()) {
        ProjectId.validateJsonObject(jsonObj.getAsJsonObject("project"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("issueTypes") != null && !jsonObj.get("issueTypes").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `issueTypes` to be an array in the JSON string but got `%s`", jsonObj.get("issueTypes").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ProjectIssueTypes.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ProjectIssueTypes' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ProjectIssueTypes> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ProjectIssueTypes.class));

       return (TypeAdapter<T>) new TypeAdapter<ProjectIssueTypes>() {
           @Override
           public void write(JsonWriter out, ProjectIssueTypes value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ProjectIssueTypes read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ProjectIssueTypes given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ProjectIssueTypes
  * @throws IOException if the JSON string is invalid with respect to ProjectIssueTypes
  */
  public static ProjectIssueTypes fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ProjectIssueTypes.class);
  }

 /**
  * Convert an instance of ProjectIssueTypes to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

