/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import software.tnb.jira.validation.generated.model.IssueTypeInfo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of an issue type hierarchy level.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ProjectIssueTypesHierarchyLevel {
  public static final String SERIALIZED_NAME_ENTITY_ID = "entityId";
  @SerializedName(SERIALIZED_NAME_ENTITY_ID)
  private UUID entityId;

  public static final String SERIALIZED_NAME_LEVEL = "level";
  @SerializedName(SERIALIZED_NAME_LEVEL)
  private Integer level;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ISSUE_TYPES = "issueTypes";
  @SerializedName(SERIALIZED_NAME_ISSUE_TYPES)
  private List<IssueTypeInfo> issueTypes = null;

  public ProjectIssueTypesHierarchyLevel() {
  }

  
  public ProjectIssueTypesHierarchyLevel(
     UUID entityId, 
     Integer level, 
     String name, 
     List<IssueTypeInfo> issueTypes
  ) {
    this();
    this.entityId = entityId;
    this.level = level;
    this.name = name;
    this.issueTypes = issueTypes;
  }

   /**
   * The ID of the issue type hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   * @return entityId
  **/
  @jakarta.annotation.Nullable

  public UUID getEntityId() {
    return entityId;
  }




   /**
   * The level of the issue type hierarchy level.
   * @return level
  **/
  @jakarta.annotation.Nullable

  public Integer getLevel() {
    return level;
  }




   /**
   * The name of the issue type hierarchy level.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }




   /**
   * The list of issue types in the hierarchy level.
   * @return issueTypes
  **/
  @jakarta.annotation.Nullable

  public List<IssueTypeInfo> getIssueTypes() {
    return issueTypes;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectIssueTypesHierarchyLevel projectIssueTypesHierarchyLevel = (ProjectIssueTypesHierarchyLevel) o;
    return Objects.equals(this.entityId, projectIssueTypesHierarchyLevel.entityId) &&
        Objects.equals(this.level, projectIssueTypesHierarchyLevel.level) &&
        Objects.equals(this.name, projectIssueTypesHierarchyLevel.name) &&
        Objects.equals(this.issueTypes, projectIssueTypesHierarchyLevel.issueTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entityId, level, name, issueTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectIssueTypesHierarchyLevel {\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    issueTypes: ").append(toIndentedString(issueTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("entityId");
    openapiFields.add("level");
    openapiFields.add("name");
    openapiFields.add("issueTypes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ProjectIssueTypesHierarchyLevel
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ProjectIssueTypesHierarchyLevel.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ProjectIssueTypesHierarchyLevel is not found in the empty JSON string", ProjectIssueTypesHierarchyLevel.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ProjectIssueTypesHierarchyLevel.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ProjectIssueTypesHierarchyLevel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("entityId") != null && !jsonObj.get("entityId").isJsonNull()) && !jsonObj.get("entityId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `entityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entityId").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("issueTypes") != null && !jsonObj.get("issueTypes").isJsonNull()) {
        JsonArray jsonArrayissueTypes = jsonObj.getAsJsonArray("issueTypes");
        if (jsonArrayissueTypes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("issueTypes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `issueTypes` to be an array in the JSON string but got `%s`", jsonObj.get("issueTypes").toString()));
          }

          // validate the optional field `issueTypes` (array)
          for (int i = 0; i < jsonArrayissueTypes.size(); i++) {
            IssueTypeInfo.validateJsonObject(jsonArrayissueTypes.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ProjectIssueTypesHierarchyLevel.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ProjectIssueTypesHierarchyLevel' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ProjectIssueTypesHierarchyLevel> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ProjectIssueTypesHierarchyLevel.class));

       return (TypeAdapter<T>) new TypeAdapter<ProjectIssueTypesHierarchyLevel>() {
           @Override
           public void write(JsonWriter out, ProjectIssueTypesHierarchyLevel value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ProjectIssueTypesHierarchyLevel read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ProjectIssueTypesHierarchyLevel given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ProjectIssueTypesHierarchyLevel
  * @throws IOException if the JSON string is invalid with respect to ProjectIssueTypesHierarchyLevel
  */
  public static ProjectIssueTypesHierarchyLevel fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ProjectIssueTypesHierarchyLevel.class);
  }

 /**
  * Convert an instance of ProjectIssueTypesHierarchyLevel to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

