/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about a project type.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class ProjectType {
  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_FORMATTED_KEY = "formattedKey";
  @SerializedName(SERIALIZED_NAME_FORMATTED_KEY)
  private String formattedKey;

  public static final String SERIALIZED_NAME_DESCRIPTION_I18N_KEY = "descriptionI18nKey";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION_I18N_KEY)
  private String descriptionI18nKey;

  public static final String SERIALIZED_NAME_ICON = "icon";
  @SerializedName(SERIALIZED_NAME_ICON)
  private String icon;

  public static final String SERIALIZED_NAME_COLOR = "color";
  @SerializedName(SERIALIZED_NAME_COLOR)
  private String color;

  public ProjectType() {
  }

  
  public ProjectType(
     String key, 
     String formattedKey, 
     String descriptionI18nKey, 
     String icon, 
     String color
  ) {
    this();
    this.key = key;
    this.formattedKey = formattedKey;
    this.descriptionI18nKey = descriptionI18nKey;
    this.icon = icon;
    this.color = color;
  }

   /**
   * The key of the project type.
   * @return key
  **/
  @jakarta.annotation.Nullable

  public String getKey() {
    return key;
  }




   /**
   * The formatted key of the project type.
   * @return formattedKey
  **/
  @jakarta.annotation.Nullable

  public String getFormattedKey() {
    return formattedKey;
  }




   /**
   * The key of the project type&#39;s description.
   * @return descriptionI18nKey
  **/
  @jakarta.annotation.Nullable

  public String getDescriptionI18nKey() {
    return descriptionI18nKey;
  }




   /**
   * The icon of the project type.
   * @return icon
  **/
  @jakarta.annotation.Nullable

  public String getIcon() {
    return icon;
  }




   /**
   * The color of the project type.
   * @return color
  **/
  @jakarta.annotation.Nullable

  public String getColor() {
    return color;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectType projectType = (ProjectType) o;
    return Objects.equals(this.key, projectType.key) &&
        Objects.equals(this.formattedKey, projectType.formattedKey) &&
        Objects.equals(this.descriptionI18nKey, projectType.descriptionI18nKey) &&
        Objects.equals(this.icon, projectType.icon) &&
        Objects.equals(this.color, projectType.color);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, formattedKey, descriptionI18nKey, icon, color);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectType {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    formattedKey: ").append(toIndentedString(formattedKey)).append("\n");
    sb.append("    descriptionI18nKey: ").append(toIndentedString(descriptionI18nKey)).append("\n");
    sb.append("    icon: ").append(toIndentedString(icon)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("key");
    openapiFields.add("formattedKey");
    openapiFields.add("descriptionI18nKey");
    openapiFields.add("icon");
    openapiFields.add("color");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ProjectType
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ProjectType.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ProjectType is not found in the empty JSON string", ProjectType.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ProjectType.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ProjectType` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("key") != null && !jsonObj.get("key").isJsonNull()) && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if ((jsonObj.get("formattedKey") != null && !jsonObj.get("formattedKey").isJsonNull()) && !jsonObj.get("formattedKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `formattedKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("formattedKey").toString()));
      }
      if ((jsonObj.get("descriptionI18nKey") != null && !jsonObj.get("descriptionI18nKey").isJsonNull()) && !jsonObj.get("descriptionI18nKey").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `descriptionI18nKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get("descriptionI18nKey").toString()));
      }
      if ((jsonObj.get("icon") != null && !jsonObj.get("icon").isJsonNull()) && !jsonObj.get("icon").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `icon` to be a primitive type in the JSON string but got `%s`", jsonObj.get("icon").toString()));
      }
      if ((jsonObj.get("color") != null && !jsonObj.get("color").isJsonNull()) && !jsonObj.get("color").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `color` to be a primitive type in the JSON string but got `%s`", jsonObj.get("color").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ProjectType.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ProjectType' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ProjectType> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ProjectType.class));

       return (TypeAdapter<T>) new TypeAdapter<ProjectType>() {
           @Override
           public void write(JsonWriter out, ProjectType value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ProjectType read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ProjectType given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ProjectType
  * @throws IOException if the JSON string is invalid with respect to ProjectType
  */
  public static ProjectType fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ProjectType.class);
  }

 /**
  * Convert an instance of ProjectType to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

