/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import software.tnb.jira.validation.generated.model.RemoteIssueLinkApplication;
import software.tnb.jira.validation.generated.model.RemoteIssueLinkObject;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details of an issue remote link.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class RemoteIssueLink {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_GLOBAL_ID = "globalId";
  @SerializedName(SERIALIZED_NAME_GLOBAL_ID)
  private String globalId;

  public static final String SERIALIZED_NAME_APPLICATION = "application";
  @SerializedName(SERIALIZED_NAME_APPLICATION)
  private RemoteIssueLinkApplication application;

  public static final String SERIALIZED_NAME_RELATIONSHIP = "relationship";
  @SerializedName(SERIALIZED_NAME_RELATIONSHIP)
  private String relationship;

  public static final String SERIALIZED_NAME_OBJECT = "object";
  @SerializedName(SERIALIZED_NAME_OBJECT)
  private RemoteIssueLinkObject _object;

  public RemoteIssueLink() {
  }

  public RemoteIssueLink id(Long id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the link.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }


  public RemoteIssueLink self(URI self) {
    
    this.self = self;
    return this;
  }

   /**
   * The URL of the link.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }


  public void setSelf(URI self) {
    this.self = self;
  }


  public RemoteIssueLink globalId(String globalId) {
    
    this.globalId = globalId;
    return this;
  }

   /**
   * The global ID of the link, such as the ID of the item on the remote system.
   * @return globalId
  **/
  @jakarta.annotation.Nullable

  public String getGlobalId() {
    return globalId;
  }


  public void setGlobalId(String globalId) {
    this.globalId = globalId;
  }


  public RemoteIssueLink application(RemoteIssueLinkApplication application) {
    
    this.application = application;
    return this;
  }

   /**
   * Get application
   * @return application
  **/
  @jakarta.annotation.Nullable

  public RemoteIssueLinkApplication getApplication() {
    return application;
  }


  public void setApplication(RemoteIssueLinkApplication application) {
    this.application = application;
  }


  public RemoteIssueLink relationship(String relationship) {
    
    this.relationship = relationship;
    return this;
  }

   /**
   * Description of the relationship between the issue and the linked item.
   * @return relationship
  **/
  @jakarta.annotation.Nullable

  public String getRelationship() {
    return relationship;
  }


  public void setRelationship(String relationship) {
    this.relationship = relationship;
  }


  public RemoteIssueLink _object(RemoteIssueLinkObject _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  public RemoteIssueLinkObject getObject() {
    return _object;
  }


  public void setObject(RemoteIssueLinkObject _object) {
    this._object = _object;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RemoteIssueLink remoteIssueLink = (RemoteIssueLink) o;
    return Objects.equals(this.id, remoteIssueLink.id) &&
        Objects.equals(this.self, remoteIssueLink.self) &&
        Objects.equals(this.globalId, remoteIssueLink.globalId) &&
        Objects.equals(this.application, remoteIssueLink.application) &&
        Objects.equals(this.relationship, remoteIssueLink.relationship) &&
        Objects.equals(this._object, remoteIssueLink._object);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, self, globalId, application, relationship, _object);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RemoteIssueLink {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    globalId: ").append(toIndentedString(globalId)).append("\n");
    sb.append("    application: ").append(toIndentedString(application)).append("\n");
    sb.append("    relationship: ").append(toIndentedString(relationship)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("self");
    openapiFields.add("globalId");
    openapiFields.add("application");
    openapiFields.add("relationship");
    openapiFields.add("object");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RemoteIssueLink
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!RemoteIssueLink.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in RemoteIssueLink is not found in the empty JSON string", RemoteIssueLink.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!RemoteIssueLink.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RemoteIssueLink` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("globalId") != null && !jsonObj.get("globalId").isJsonNull()) && !jsonObj.get("globalId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `globalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("globalId").toString()));
      }
      // validate the optional field `application`
      if (jsonObj.get("application") != null && !jsonObj.get("application").isJsonNull()) {
        RemoteIssueLinkApplication.validateJsonObject(jsonObj.getAsJsonObject("application"));
      }
      if ((jsonObj.get("relationship") != null && !jsonObj.get("relationship").isJsonNull()) && !jsonObj.get("relationship").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `relationship` to be a primitive type in the JSON string but got `%s`", jsonObj.get("relationship").toString()));
      }
      // validate the optional field `object`
      if (jsonObj.get("object") != null && !jsonObj.get("object").isJsonNull()) {
        RemoteIssueLinkObject.validateJsonObject(jsonObj.getAsJsonObject("object"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RemoteIssueLink.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RemoteIssueLink' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RemoteIssueLink> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RemoteIssueLink.class));

       return (TypeAdapter<T>) new TypeAdapter<RemoteIssueLink>() {
           @Override
           public void write(JsonWriter out, RemoteIssueLink value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RemoteIssueLink read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RemoteIssueLink given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RemoteIssueLink
  * @throws IOException if the JSON string is invalid with respect to RemoteIssueLink
  */
  public static RemoteIssueLink fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RemoteIssueLink.class);
  }

 /**
  * Convert an instance of RemoteIssueLink to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

