/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * A collection of errors related to unchanged issues. The collection size is limited, which means not all errors may be returned.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class RemoveOptionFromIssuesResultErrors {
  public static final String SERIALIZED_NAME_ERRORS = "errors";
  @SerializedName(SERIALIZED_NAME_ERRORS)
  private Map<String, String> errors = null;

  public static final String SERIALIZED_NAME_ERROR_MESSAGES = "errorMessages";
  @SerializedName(SERIALIZED_NAME_ERROR_MESSAGES)
  private List<String> errorMessages = null;

  public static final String SERIALIZED_NAME_HTTP_STATUS_CODE = "httpStatusCode";
  @SerializedName(SERIALIZED_NAME_HTTP_STATUS_CODE)
  private Integer httpStatusCode;

  public RemoveOptionFromIssuesResultErrors() {
  }

  public RemoveOptionFromIssuesResultErrors errors(Map<String, String> errors) {
    
    this.errors = errors;
    return this;
  }

  public RemoveOptionFromIssuesResultErrors putErrorsItem(String key, String errorsItem) {
    if (this.errors == null) {
      this.errors = new HashMap<>();
    }
    this.errors.put(key, errorsItem);
    return this;
  }

   /**
   * The list of errors by parameter returned by the operation. For example,\&quot;projectKey\&quot;: \&quot;Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters.\&quot;
   * @return errors
  **/
  @jakarta.annotation.Nullable

  public Map<String, String> getErrors() {
    return errors;
  }


  public void setErrors(Map<String, String> errors) {
    this.errors = errors;
  }


  public RemoveOptionFromIssuesResultErrors errorMessages(List<String> errorMessages) {
    
    this.errorMessages = errorMessages;
    return this;
  }

  public RemoveOptionFromIssuesResultErrors addErrorMessagesItem(String errorMessagesItem) {
    if (this.errorMessages == null) {
      this.errorMessages = new ArrayList<>();
    }
    this.errorMessages.add(errorMessagesItem);
    return this;
  }

   /**
   * The list of error messages produced by this operation. For example, \&quot;input parameter &#39;key&#39; must be provided\&quot;
   * @return errorMessages
  **/
  @jakarta.annotation.Nullable

  public List<String> getErrorMessages() {
    return errorMessages;
  }


  public void setErrorMessages(List<String> errorMessages) {
    this.errorMessages = errorMessages;
  }


  public RemoveOptionFromIssuesResultErrors httpStatusCode(Integer httpStatusCode) {
    
    this.httpStatusCode = httpStatusCode;
    return this;
  }

   /**
   * Get httpStatusCode
   * @return httpStatusCode
  **/
  @jakarta.annotation.Nullable

  public Integer getHttpStatusCode() {
    return httpStatusCode;
  }


  public void setHttpStatusCode(Integer httpStatusCode) {
    this.httpStatusCode = httpStatusCode;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RemoveOptionFromIssuesResultErrors removeOptionFromIssuesResultErrors = (RemoveOptionFromIssuesResultErrors) o;
    return Objects.equals(this.errors, removeOptionFromIssuesResultErrors.errors) &&
        Objects.equals(this.errorMessages, removeOptionFromIssuesResultErrors.errorMessages) &&
        Objects.equals(this.httpStatusCode, removeOptionFromIssuesResultErrors.httpStatusCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errors, errorMessages, httpStatusCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RemoveOptionFromIssuesResultErrors {\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    errorMessages: ").append(toIndentedString(errorMessages)).append("\n");
    sb.append("    httpStatusCode: ").append(toIndentedString(httpStatusCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("errors");
    openapiFields.add("errorMessages");
    openapiFields.add("httpStatusCode");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RemoveOptionFromIssuesResultErrors
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!RemoveOptionFromIssuesResultErrors.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in RemoveOptionFromIssuesResultErrors is not found in the empty JSON string", RemoveOptionFromIssuesResultErrors.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!RemoveOptionFromIssuesResultErrors.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RemoveOptionFromIssuesResultErrors` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("errorMessages") != null && !jsonObj.get("errorMessages").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `errorMessages` to be an array in the JSON string but got `%s`", jsonObj.get("errorMessages").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RemoveOptionFromIssuesResultErrors.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RemoveOptionFromIssuesResultErrors' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RemoveOptionFromIssuesResultErrors> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RemoveOptionFromIssuesResultErrors.class));

       return (TypeAdapter<T>) new TypeAdapter<RemoveOptionFromIssuesResultErrors>() {
           @Override
           public void write(JsonWriter out, RemoveOptionFromIssuesResultErrors value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RemoveOptionFromIssuesResultErrors read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RemoveOptionFromIssuesResultErrors given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RemoveOptionFromIssuesResultErrors
  * @throws IOException if the JSON string is invalid with respect to RemoveOptionFromIssuesResultErrors
  */
  public static RemoveOptionFromIssuesResultErrors fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RemoveOptionFromIssuesResultErrors.class);
  }

 /**
  * Convert an instance of RemoveOptionFromIssuesResultErrors to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

