/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import software.tnb.jira.validation.generated.model.ProjectRoleGroup;
import software.tnb.jira.validation.generated.model.ProjectRoleUser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * Details about a user assigned to a project role.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class RoleActor {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_DISPLAY_NAME = "displayName";
  @SerializedName(SERIALIZED_NAME_DISPLAY_NAME)
  private String displayName;

  /**
   * The type of role actor.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    GROUP_ROLE_ACTOR("atlassian-group-role-actor"),
    
    USER_ROLE_ACTOR("atlassian-user-role-actor");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_AVATAR_URL = "avatarUrl";
  @SerializedName(SERIALIZED_NAME_AVATAR_URL)
  private URI avatarUrl;

  public static final String SERIALIZED_NAME_ACTOR_USER = "actorUser";
  @SerializedName(SERIALIZED_NAME_ACTOR_USER)
  private ProjectRoleUser actorUser;

  public static final String SERIALIZED_NAME_ACTOR_GROUP = "actorGroup";
  @SerializedName(SERIALIZED_NAME_ACTOR_GROUP)
  private ProjectRoleGroup actorGroup;

  public RoleActor() {
  }

  
  public RoleActor(
     Long id, 
     String displayName, 
     TypeEnum type, 
     String name, 
     URI avatarUrl, 
     ProjectRoleUser actorUser, 
     ProjectRoleGroup actorGroup
  ) {
    this();
    this.id = id;
    this.displayName = displayName;
    this.type = type;
    this.name = name;
    this.avatarUrl = avatarUrl;
    this.actorUser = actorUser;
    this.actorGroup = actorGroup;
  }

   /**
   * The ID of the role actor.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public Long getId() {
    return id;
  }




   /**
   * The display name of the role actor. For users, depending on the user’s privacy setting, this may return an alternative value for the user&#39;s name.
   * @return displayName
  **/
  @jakarta.annotation.Nullable

  public String getDisplayName() {
    return displayName;
  }




   /**
   * The type of role actor.
   * @return type
  **/
  @jakarta.annotation.Nullable

  public TypeEnum getType() {
    return type;
  }




   /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }




   /**
   * The avatar of the role actor.
   * @return avatarUrl
  **/
  @jakarta.annotation.Nullable

  public URI getAvatarUrl() {
    return avatarUrl;
  }




   /**
   * Get actorUser
   * @return actorUser
  **/
  @jakarta.annotation.Nullable

  public ProjectRoleUser getActorUser() {
    return actorUser;
  }




   /**
   * Get actorGroup
   * @return actorGroup
  **/
  @jakarta.annotation.Nullable

  public ProjectRoleGroup getActorGroup() {
    return actorGroup;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoleActor roleActor = (RoleActor) o;
    return Objects.equals(this.id, roleActor.id) &&
        Objects.equals(this.displayName, roleActor.displayName) &&
        Objects.equals(this.type, roleActor.type) &&
        Objects.equals(this.name, roleActor.name) &&
        Objects.equals(this.avatarUrl, roleActor.avatarUrl) &&
        Objects.equals(this.actorUser, roleActor.actorUser) &&
        Objects.equals(this.actorGroup, roleActor.actorGroup);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, displayName, type, name, avatarUrl, actorUser, actorGroup);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoleActor {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    avatarUrl: ").append(toIndentedString(avatarUrl)).append("\n");
    sb.append("    actorUser: ").append(toIndentedString(actorUser)).append("\n");
    sb.append("    actorGroup: ").append(toIndentedString(actorGroup)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("displayName");
    openapiFields.add("type");
    openapiFields.add("name");
    openapiFields.add("avatarUrl");
    openapiFields.add("actorUser");
    openapiFields.add("actorGroup");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RoleActor
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!RoleActor.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in RoleActor is not found in the empty JSON string", RoleActor.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!RoleActor.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RoleActor` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("displayName") != null && !jsonObj.get("displayName").isJsonNull()) && !jsonObj.get("displayName").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `displayName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("displayName").toString()));
      }
      if ((jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("avatarUrl") != null && !jsonObj.get("avatarUrl").isJsonNull()) && !jsonObj.get("avatarUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `avatarUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("avatarUrl").toString()));
      }
      // validate the optional field `actorUser`
      if (jsonObj.get("actorUser") != null && !jsonObj.get("actorUser").isJsonNull()) {
        ProjectRoleUser.validateJsonObject(jsonObj.getAsJsonObject("actorUser"));
      }
      // validate the optional field `actorGroup`
      if (jsonObj.get("actorGroup") != null && !jsonObj.get("actorGroup").isJsonNull()) {
        ProjectRoleGroup.validateJsonObject(jsonObj.getAsJsonObject("actorGroup"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RoleActor.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RoleActor' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RoleActor> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RoleActor.class));

       return (TypeAdapter<T>) new TypeAdapter<RoleActor>() {
           @Override
           public void write(JsonWriter out, RoleActor value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RoleActor read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RoleActor given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RoleActor
  * @throws IOException if the JSON string is invalid with respect to RoleActor
  */
  public static RoleActor fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RoleActor.class);
  }

 /**
  * Convert an instance of RoleActor to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

