/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * SearchRequestBean
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class SearchRequestBean {
  public static final String SERIALIZED_NAME_JQL = "jql";
  @SerializedName(SERIALIZED_NAME_JQL)
  private String jql;

  public static final String SERIALIZED_NAME_START_AT = "startAt";
  @SerializedName(SERIALIZED_NAME_START_AT)
  private Integer startAt;

  public static final String SERIALIZED_NAME_MAX_RESULTS = "maxResults";
  @SerializedName(SERIALIZED_NAME_MAX_RESULTS)
  private Integer maxResults = 50;

  public static final String SERIALIZED_NAME_FIELDS = "fields";
  @SerializedName(SERIALIZED_NAME_FIELDS)
  private List<String> fields = null;

  /**
   * Determines how to validate the JQL query and treat the validation results. Supported values:   *  &#x60;strict&#x60; Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).  *  &#x60;warn&#x60; Returns all errors as warnings.  *  &#x60;none&#x60; No validation is performed.  *  &#x60;true&#x60; *Deprecated* A legacy synonym for &#x60;strict&#x60;.  *  &#x60;false&#x60; *Deprecated* A legacy synonym for &#x60;warn&#x60;.  The default is &#x60;strict&#x60;.  Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the &#x60;validateQuery&#x60; value.
   */
  @JsonAdapter(ValidateQueryEnum.Adapter.class)
  public enum ValidateQueryEnum {
    STRICT("strict"),
    
    WARN("warn"),
    
    NONE("none"),
    
    TRUE("true"),
    
    FALSE("false");

    private String value;

    ValidateQueryEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ValidateQueryEnum fromValue(String value) {
      for (ValidateQueryEnum b : ValidateQueryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ValidateQueryEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ValidateQueryEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ValidateQueryEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ValidateQueryEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_VALIDATE_QUERY = "validateQuery";
  @SerializedName(SERIALIZED_NAME_VALIDATE_QUERY)
  private ValidateQueryEnum validateQuery;

  public static final String SERIALIZED_NAME_EXPAND = "expand";
  @SerializedName(SERIALIZED_NAME_EXPAND)
  private List<String> expand = null;

  public static final String SERIALIZED_NAME_PROPERTIES = "properties";
  @SerializedName(SERIALIZED_NAME_PROPERTIES)
  private List<String> properties = null;

  public static final String SERIALIZED_NAME_FIELDS_BY_KEYS = "fieldsByKeys";
  @SerializedName(SERIALIZED_NAME_FIELDS_BY_KEYS)
  private Boolean fieldsByKeys;

  public SearchRequestBean() {
  }

  public SearchRequestBean jql(String jql) {
    
    this.jql = jql;
    return this;
  }

   /**
   * A [JQL](https://confluence.atlassian.com/x/egORLQ) expression.
   * @return jql
  **/
  @jakarta.annotation.Nullable

  public String getJql() {
    return jql;
  }


  public void setJql(String jql) {
    this.jql = jql;
  }


  public SearchRequestBean startAt(Integer startAt) {
    
    this.startAt = startAt;
    return this;
  }

   /**
   * The index of the first item to return in the page of results (page offset). The base index is &#x60;0&#x60;.
   * @return startAt
  **/
  @jakarta.annotation.Nullable

  public Integer getStartAt() {
    return startAt;
  }


  public void setStartAt(Integer startAt) {
    this.startAt = startAt;
  }


  public SearchRequestBean maxResults(Integer maxResults) {
    
    this.maxResults = maxResults;
    return this;
  }

   /**
   * The maximum number of items to return per page.
   * @return maxResults
  **/
  @jakarta.annotation.Nullable

  public Integer getMaxResults() {
    return maxResults;
  }


  public void setMaxResults(Integer maxResults) {
    this.maxResults = maxResults;
  }


  public SearchRequestBean fields(List<String> fields) {
    
    this.fields = fields;
    return this;
  }

  public SearchRequestBean addFieldsItem(String fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:   *  &#x60;*all&#x60; Returns all fields.  *  &#x60;*navigable&#x60; Returns navigable fields.  *  Any issue field, prefixed with a minus to exclude.  The default is &#x60;*navigable&#x60;.  Examples:   *  &#x60;summary,comment&#x60; Returns the summary and comments fields only.  *  &#x60;-description&#x60; Returns all navigable (default) fields except description.  *  &#x60;*all,-comment&#x60; Returns all fields except comments.  Multiple &#x60;fields&#x60; parameters can be included in a request.  Note: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.
   * @return fields
  **/
  @jakarta.annotation.Nullable

  public List<String> getFields() {
    return fields;
  }


  public void setFields(List<String> fields) {
    this.fields = fields;
  }


  public SearchRequestBean validateQuery(ValidateQueryEnum validateQuery) {
    
    this.validateQuery = validateQuery;
    return this;
  }

   /**
   * Determines how to validate the JQL query and treat the validation results. Supported values:   *  &#x60;strict&#x60; Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).  *  &#x60;warn&#x60; Returns all errors as warnings.  *  &#x60;none&#x60; No validation is performed.  *  &#x60;true&#x60; *Deprecated* A legacy synonym for &#x60;strict&#x60;.  *  &#x60;false&#x60; *Deprecated* A legacy synonym for &#x60;warn&#x60;.  The default is &#x60;strict&#x60;.  Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the &#x60;validateQuery&#x60; value.
   * @return validateQuery
  **/
  @jakarta.annotation.Nullable

  public ValidateQueryEnum getValidateQuery() {
    return validateQuery;
  }


  public void setValidateQuery(ValidateQueryEnum validateQuery) {
    this.validateQuery = validateQuery;
  }


  public SearchRequestBean expand(List<String> expand) {
    
    this.expand = expand;
    return this;
  }

  public SearchRequestBean addExpandItem(String expandItem) {
    if (this.expand == null) {
      this.expand = new ArrayList<>();
    }
    this.expand.add(expandItem);
    return this;
  }

   /**
   * Use [expand](em&gt;#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where &#x60;expand&#x60; is specified, &#x60;expand&#x60; is defined as a list of values. The expand options are:   *  &#x60;renderedFields&#x60; Returns field values rendered in HTML format.  *  &#x60;names&#x60; Returns the display name of each field.  *  &#x60;schema&#x60; Returns the schema describing a field type.  *  &#x60;transitions&#x60; Returns all possible transitions for the issue.  *  &#x60;operations&#x60; Returns all possible operations for the issue.  *  &#x60;editmeta&#x60; Returns information about how each field can be edited.  *  &#x60;changelog&#x60; Returns a list of recent updates to an issue, sorted by date, starting from the most recent.  *  &#x60;versionedRepresentations&#x60; Instead of &#x60;fields&#x60;, returns &#x60;versionedRepresentations&#x60; a JSON array containing each version of a field&#39;s value, with the highest numbered item representing the most recent version.
   * @return expand
  **/
  @jakarta.annotation.Nullable

  public List<String> getExpand() {
    return expand;
  }


  public void setExpand(List<String> expand) {
    this.expand = expand;
  }


  public SearchRequestBean properties(List<String> properties) {
    
    this.properties = properties;
    return this;
  }

  public SearchRequestBean addPropertiesItem(String propertiesItem) {
    if (this.properties == null) {
      this.properties = new ArrayList<>();
    }
    this.properties.add(propertiesItem);
    return this;
  }

   /**
   * A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.
   * @return properties
  **/
  @jakarta.annotation.Nullable

  public List<String> getProperties() {
    return properties;
  }


  public void setProperties(List<String> properties) {
    this.properties = properties;
  }


  public SearchRequestBean fieldsByKeys(Boolean fieldsByKeys) {
    
    this.fieldsByKeys = fieldsByKeys;
    return this;
  }

   /**
   * Reference fields by their key (rather than ID). The default is &#x60;false&#x60;.
   * @return fieldsByKeys
  **/
  @jakarta.annotation.Nullable

  public Boolean getFieldsByKeys() {
    return fieldsByKeys;
  }


  public void setFieldsByKeys(Boolean fieldsByKeys) {
    this.fieldsByKeys = fieldsByKeys;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchRequestBean searchRequestBean = (SearchRequestBean) o;
    return Objects.equals(this.jql, searchRequestBean.jql) &&
        Objects.equals(this.startAt, searchRequestBean.startAt) &&
        Objects.equals(this.maxResults, searchRequestBean.maxResults) &&
        Objects.equals(this.fields, searchRequestBean.fields) &&
        Objects.equals(this.validateQuery, searchRequestBean.validateQuery) &&
        Objects.equals(this.expand, searchRequestBean.expand) &&
        Objects.equals(this.properties, searchRequestBean.properties) &&
        Objects.equals(this.fieldsByKeys, searchRequestBean.fieldsByKeys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jql, startAt, maxResults, fields, validateQuery, expand, properties, fieldsByKeys);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchRequestBean {\n");
    sb.append("    jql: ").append(toIndentedString(jql)).append("\n");
    sb.append("    startAt: ").append(toIndentedString(startAt)).append("\n");
    sb.append("    maxResults: ").append(toIndentedString(maxResults)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    validateQuery: ").append(toIndentedString(validateQuery)).append("\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    fieldsByKeys: ").append(toIndentedString(fieldsByKeys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("jql");
    openapiFields.add("startAt");
    openapiFields.add("maxResults");
    openapiFields.add("fields");
    openapiFields.add("validateQuery");
    openapiFields.add("expand");
    openapiFields.add("properties");
    openapiFields.add("fieldsByKeys");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to SearchRequestBean
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!SearchRequestBean.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in SearchRequestBean is not found in the empty JSON string", SearchRequestBean.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!SearchRequestBean.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SearchRequestBean` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("jql") != null && !jsonObj.get("jql").isJsonNull()) && !jsonObj.get("jql").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `jql` to be a primitive type in the JSON string but got `%s`", jsonObj.get("jql").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("fields") != null && !jsonObj.get("fields").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `fields` to be an array in the JSON string but got `%s`", jsonObj.get("fields").toString()));
      }
      if ((jsonObj.get("validateQuery") != null && !jsonObj.get("validateQuery").isJsonNull()) && !jsonObj.get("validateQuery").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `validateQuery` to be a primitive type in the JSON string but got `%s`", jsonObj.get("validateQuery").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("expand") != null && !jsonObj.get("expand").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `expand` to be an array in the JSON string but got `%s`", jsonObj.get("expand").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("properties") != null && !jsonObj.get("properties").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `properties` to be an array in the JSON string but got `%s`", jsonObj.get("properties").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SearchRequestBean.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SearchRequestBean' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SearchRequestBean> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SearchRequestBean.class));

       return (TypeAdapter<T>) new TypeAdapter<SearchRequestBean>() {
           @Override
           public void write(JsonWriter out, SearchRequestBean value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SearchRequestBean read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of SearchRequestBean given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SearchRequestBean
  * @throws IOException if the JSON string is invalid with respect to SearchRequestBean
  */
  public static SearchRequestBean fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SearchRequestBean.class);
  }

 /**
  * Convert an instance of SearchRequestBean to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

