/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.tnb.jira.validation.generated.model.IssueBean;
import software.tnb.jira.validation.generated.model.JsonTypeBean;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The result of a JQL search.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class SearchResults {
  public static final String SERIALIZED_NAME_EXPAND = "expand";
  @SerializedName(SERIALIZED_NAME_EXPAND)
  private String expand;

  public static final String SERIALIZED_NAME_START_AT = "startAt";
  @SerializedName(SERIALIZED_NAME_START_AT)
  private Integer startAt;

  public static final String SERIALIZED_NAME_MAX_RESULTS = "maxResults";
  @SerializedName(SERIALIZED_NAME_MAX_RESULTS)
  private Integer maxResults;

  public static final String SERIALIZED_NAME_TOTAL = "total";
  @SerializedName(SERIALIZED_NAME_TOTAL)
  private Integer total;

  public static final String SERIALIZED_NAME_ISSUES = "issues";
  @SerializedName(SERIALIZED_NAME_ISSUES)
  private List<IssueBean> issues = null;

  public static final String SERIALIZED_NAME_WARNING_MESSAGES = "warningMessages";
  @SerializedName(SERIALIZED_NAME_WARNING_MESSAGES)
  private List<String> warningMessages = null;

  public static final String SERIALIZED_NAME_NAMES = "names";
  @SerializedName(SERIALIZED_NAME_NAMES)
  private Map<String, String> names = null;

  public static final String SERIALIZED_NAME_SCHEMA = "schema";
  @SerializedName(SERIALIZED_NAME_SCHEMA)
  private Map<String, JsonTypeBean> schema = null;

  public SearchResults() {
  }

  
  public SearchResults(
     String expand, 
     Integer startAt, 
     Integer maxResults, 
     Integer total, 
     List<IssueBean> issues, 
     List<String> warningMessages, 
     Map<String, String> names, 
     Map<String, JsonTypeBean> schema
  ) {
    this();
    this.expand = expand;
    this.startAt = startAt;
    this.maxResults = maxResults;
    this.total = total;
    this.issues = issues;
    this.warningMessages = warningMessages;
    this.names = names;
    this.schema = schema;
  }

   /**
   * Expand options that include additional search result details in the response.
   * @return expand
  **/
  @jakarta.annotation.Nullable

  public String getExpand() {
    return expand;
  }




   /**
   * The index of the first item returned on the page.
   * @return startAt
  **/
  @jakarta.annotation.Nullable

  public Integer getStartAt() {
    return startAt;
  }




   /**
   * The maximum number of results that could be on the page.
   * @return maxResults
  **/
  @jakarta.annotation.Nullable

  public Integer getMaxResults() {
    return maxResults;
  }




   /**
   * The number of results on the page.
   * @return total
  **/
  @jakarta.annotation.Nullable

  public Integer getTotal() {
    return total;
  }




   /**
   * The list of issues found by the search.
   * @return issues
  **/
  @jakarta.annotation.Nullable

  public List<IssueBean> getIssues() {
    return issues;
  }




   /**
   * Any warnings related to the JQL query.
   * @return warningMessages
  **/
  @jakarta.annotation.Nullable

  public List<String> getWarningMessages() {
    return warningMessages;
  }




   /**
   * The ID and name of each field in the search results.
   * @return names
  **/
  @jakarta.annotation.Nullable

  public Map<String, String> getNames() {
    return names;
  }




   /**
   * The schema describing the field types in the search results.
   * @return schema
  **/
  @jakarta.annotation.Nullable

  public Map<String, JsonTypeBean> getSchema() {
    return schema;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchResults searchResults = (SearchResults) o;
    return Objects.equals(this.expand, searchResults.expand) &&
        Objects.equals(this.startAt, searchResults.startAt) &&
        Objects.equals(this.maxResults, searchResults.maxResults) &&
        Objects.equals(this.total, searchResults.total) &&
        Objects.equals(this.issues, searchResults.issues) &&
        Objects.equals(this.warningMessages, searchResults.warningMessages) &&
        Objects.equals(this.names, searchResults.names) &&
        Objects.equals(this.schema, searchResults.schema);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expand, startAt, maxResults, total, issues, warningMessages, names, schema);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchResults {\n");
    sb.append("    expand: ").append(toIndentedString(expand)).append("\n");
    sb.append("    startAt: ").append(toIndentedString(startAt)).append("\n");
    sb.append("    maxResults: ").append(toIndentedString(maxResults)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    issues: ").append(toIndentedString(issues)).append("\n");
    sb.append("    warningMessages: ").append(toIndentedString(warningMessages)).append("\n");
    sb.append("    names: ").append(toIndentedString(names)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("expand");
    openapiFields.add("startAt");
    openapiFields.add("maxResults");
    openapiFields.add("total");
    openapiFields.add("issues");
    openapiFields.add("warningMessages");
    openapiFields.add("names");
    openapiFields.add("schema");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to SearchResults
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!SearchResults.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in SearchResults is not found in the empty JSON string", SearchResults.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!SearchResults.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SearchResults` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("expand") != null && !jsonObj.get("expand").isJsonNull()) && !jsonObj.get("expand").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `expand` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expand").toString()));
      }
      if (jsonObj.get("issues") != null && !jsonObj.get("issues").isJsonNull()) {
        JsonArray jsonArrayissues = jsonObj.getAsJsonArray("issues");
        if (jsonArrayissues != null) {
          // ensure the json data is an array
          if (!jsonObj.get("issues").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `issues` to be an array in the JSON string but got `%s`", jsonObj.get("issues").toString()));
          }

          // validate the optional field `issues` (array)
          for (int i = 0; i < jsonArrayissues.size(); i++) {
            IssueBean.validateJsonObject(jsonArrayissues.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("warningMessages") != null && !jsonObj.get("warningMessages").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `warningMessages` to be an array in the JSON string but got `%s`", jsonObj.get("warningMessages").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SearchResults.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SearchResults' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SearchResults> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SearchResults.class));

       return (TypeAdapter<T>) new TypeAdapter<SearchResults>() {
           @Override
           public void write(JsonWriter out, SearchResults value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SearchResults read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of SearchResults given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SearchResults
  * @throws IOException if the JSON string is invalid with respect to SearchResults
  */
  public static SearchResults fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SearchResults.class);
  }

 /**
  * Convert an instance of SearchResults to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

