/*
 * The Jira Cloud platform REST API
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.tnb.jira.validation.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import software.tnb.jira.validation.generated.model.ProjectRoleScope;
import software.tnb.jira.validation.generated.model.RoleActor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import software.tnb.jira.validation.generated.JSON;

/**
 * The project role that the filter is shared with.   For a request, specify the &#x60;id&#x60; for the role. You must also specify the &#x60;project&#x60; object and &#x60;id&#x60; for the project that the role is in.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-14T07:43:28.015665Z[Etc/UTC]")
public class SharePermissionRole {
  public static final String SERIALIZED_NAME_SELF = "self";
  @SerializedName(SERIALIZED_NAME_SELF)
  private URI self;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ACTORS = "actors";
  @SerializedName(SERIALIZED_NAME_ACTORS)
  private List<RoleActor> actors = null;

  public static final String SERIALIZED_NAME_SCOPE = "scope";
  @SerializedName(SERIALIZED_NAME_SCOPE)
  private ProjectRoleScope scope;

  public static final String SERIALIZED_NAME_TRANSLATED_NAME = "translatedName";
  @SerializedName(SERIALIZED_NAME_TRANSLATED_NAME)
  private String translatedName;

  public static final String SERIALIZED_NAME_CURRENT_USER_ROLE = "currentUserRole";
  @SerializedName(SERIALIZED_NAME_CURRENT_USER_ROLE)
  private Boolean currentUserRole;

  public static final String SERIALIZED_NAME_ADMIN = "admin";
  @SerializedName(SERIALIZED_NAME_ADMIN)
  private Boolean admin;

  public static final String SERIALIZED_NAME_ROLE_CONFIGURABLE = "roleConfigurable";
  @SerializedName(SERIALIZED_NAME_ROLE_CONFIGURABLE)
  private Boolean roleConfigurable;

  public static final String SERIALIZED_NAME_DEFAULT = "default";
  @SerializedName(SERIALIZED_NAME_DEFAULT)
  private Boolean _default;

  public SharePermissionRole() {
  }

  
  public SharePermissionRole(
     URI self, 
     Long id, 
     String description, 
     List<RoleActor> actors, 
     Boolean admin, 
     Boolean roleConfigurable, 
     Boolean _default
  ) {
    this();
    this.self = self;
    this.id = id;
    this.description = description;
    this.actors = actors;
    this.admin = admin;
    this.roleConfigurable = roleConfigurable;
    this._default = _default;
  }

   /**
   * The URL the project role details.
   * @return self
  **/
  @jakarta.annotation.Nullable

  public URI getSelf() {
    return self;
  }




  public SharePermissionRole name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the project role.
   * @return name
  **/
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


   /**
   * The ID of the project role.
   * @return id
  **/
  @jakarta.annotation.Nullable

  public Long getId() {
    return id;
  }




   /**
   * The description of the project role.
   * @return description
  **/
  @jakarta.annotation.Nullable

  public String getDescription() {
    return description;
  }




   /**
   * The list of users who act in this role.
   * @return actors
  **/
  @jakarta.annotation.Nullable

  public List<RoleActor> getActors() {
    return actors;
  }




  public SharePermissionRole scope(ProjectRoleScope scope) {
    
    this.scope = scope;
    return this;
  }

   /**
   * Get scope
   * @return scope
  **/
  @jakarta.annotation.Nullable

  public ProjectRoleScope getScope() {
    return scope;
  }


  public void setScope(ProjectRoleScope scope) {
    this.scope = scope;
  }


  public SharePermissionRole translatedName(String translatedName) {
    
    this.translatedName = translatedName;
    return this;
  }

   /**
   * The translated name of the project role.
   * @return translatedName
  **/
  @jakarta.annotation.Nullable

  public String getTranslatedName() {
    return translatedName;
  }


  public void setTranslatedName(String translatedName) {
    this.translatedName = translatedName;
  }


  public SharePermissionRole currentUserRole(Boolean currentUserRole) {
    
    this.currentUserRole = currentUserRole;
    return this;
  }

   /**
   * Whether the calling user is part of this role.
   * @return currentUserRole
  **/
  @jakarta.annotation.Nullable

  public Boolean getCurrentUserRole() {
    return currentUserRole;
  }


  public void setCurrentUserRole(Boolean currentUserRole) {
    this.currentUserRole = currentUserRole;
  }


   /**
   * Whether this role is the admin role for the project.
   * @return admin
  **/
  @jakarta.annotation.Nullable

  public Boolean getAdmin() {
    return admin;
  }




   /**
   * Whether the roles are configurable for this project.
   * @return roleConfigurable
  **/
  @jakarta.annotation.Nullable

  public Boolean getRoleConfigurable() {
    return roleConfigurable;
  }




   /**
   * Whether this role is the default role for the project
   * @return _default
  **/
  @jakarta.annotation.Nullable

  public Boolean getDefault() {
    return _default;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SharePermissionRole sharePermissionRole = (SharePermissionRole) o;
    return Objects.equals(this.self, sharePermissionRole.self) &&
        Objects.equals(this.name, sharePermissionRole.name) &&
        Objects.equals(this.id, sharePermissionRole.id) &&
        Objects.equals(this.description, sharePermissionRole.description) &&
        Objects.equals(this.actors, sharePermissionRole.actors) &&
        Objects.equals(this.scope, sharePermissionRole.scope) &&
        Objects.equals(this.translatedName, sharePermissionRole.translatedName) &&
        Objects.equals(this.currentUserRole, sharePermissionRole.currentUserRole) &&
        Objects.equals(this.admin, sharePermissionRole.admin) &&
        Objects.equals(this.roleConfigurable, sharePermissionRole.roleConfigurable) &&
        Objects.equals(this._default, sharePermissionRole._default);
  }

  @Override
  public int hashCode() {
    return Objects.hash(self, name, id, description, actors, scope, translatedName, currentUserRole, admin, roleConfigurable, _default);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SharePermissionRole {\n");
    sb.append("    self: ").append(toIndentedString(self)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    actors: ").append(toIndentedString(actors)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    translatedName: ").append(toIndentedString(translatedName)).append("\n");
    sb.append("    currentUserRole: ").append(toIndentedString(currentUserRole)).append("\n");
    sb.append("    admin: ").append(toIndentedString(admin)).append("\n");
    sb.append("    roleConfigurable: ").append(toIndentedString(roleConfigurable)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("self");
    openapiFields.add("name");
    openapiFields.add("id");
    openapiFields.add("description");
    openapiFields.add("actors");
    openapiFields.add("scope");
    openapiFields.add("translatedName");
    openapiFields.add("currentUserRole");
    openapiFields.add("admin");
    openapiFields.add("roleConfigurable");
    openapiFields.add("default");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to SharePermissionRole
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!SharePermissionRole.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in SharePermissionRole is not found in the empty JSON string", SharePermissionRole.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!SharePermissionRole.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SharePermissionRole` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("self") != null && !jsonObj.get("self").isJsonNull()) && !jsonObj.get("self").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `self` to be a primitive type in the JSON string but got `%s`", jsonObj.get("self").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("actors") != null && !jsonObj.get("actors").isJsonNull()) {
        JsonArray jsonArrayactors = jsonObj.getAsJsonArray("actors");
        if (jsonArrayactors != null) {
          // ensure the json data is an array
          if (!jsonObj.get("actors").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `actors` to be an array in the JSON string but got `%s`", jsonObj.get("actors").toString()));
          }

          // validate the optional field `actors` (array)
          for (int i = 0; i < jsonArrayactors.size(); i++) {
            RoleActor.validateJsonObject(jsonArrayactors.get(i).getAsJsonObject());
          };
        }
      }
      // validate the optional field `scope`
      if (jsonObj.get("scope") != null && !jsonObj.get("scope").isJsonNull()) {
        ProjectRoleScope.validateJsonObject(jsonObj.getAsJsonObject("scope"));
      }
      if ((jsonObj.get("translatedName") != null && !jsonObj.get("translatedName").isJsonNull()) && !jsonObj.get("translatedName").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `translatedName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("translatedName").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SharePermissionRole.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SharePermissionRole' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SharePermissionRole> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SharePermissionRole.class));

       return (TypeAdapter<T>) new TypeAdapter<SharePermissionRole>() {
           @Override
           public void write(JsonWriter out, SharePermissionRole value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SharePermissionRole read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of SharePermissionRole given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SharePermissionRole
  * @throws IOException if the JSON string is invalid with respect to SharePermissionRole
  */
  public static SharePermissionRole fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SharePermissionRole.class);
  }

 /**
  * Convert an instance of SharePermissionRole to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

